/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.service.impl;

import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.material.entity.PurchaseMaterialSource;
import com.els.modules.material.mapper.PurchaseMaterialSourceMapper;
import com.els.modules.material.service.PurchaseMaterialSourceService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PurchaseMaterialSourceAdapter
implements AuditOptCallBackService {
    @Resource
    PurchaseMaterialSourceMapper purchaseMaterialSourceMapper;
    @Resource
    PurchaseMaterialSourceService purchaseMaterialSourceService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateSource(inputParamVO, outputParamVO);
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseMaterialSource source = new PurchaseMaterialSource();
        source.setId(inputParamVO.getBusinessId());
        source.setAuditStatus(outputParamVO.getAuditStatus());
        source.setFlowId(outputParamVO.getProcessRootId());
        int count = this.purchaseMaterialSourceMapper.updateById((Object)source);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateSource(inputParamVO, outputParamVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateSource(inputParamVO, outputParamVO);
    }

    private void updateSource(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseMaterialSource source = new PurchaseMaterialSource();
        source.setId(inputParamVO.getBusinessId());
        source.setAuditStatus(outputParamVO.getAuditStatus());
        source.setFlowId(outputParamVO.getProcessRootId());
        int count = this.purchaseMaterialSourceMapper.updateById((Object)source);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }
}

