/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseOpenServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.ListColumnQueryBuilder;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.material.api.enumerate.MaterialSourceStatusEnum;
import com.els.modules.material.entity.PurchaseMaterialSource;
import com.els.modules.material.mapper.PurchaseMaterialSourceMapper;
import com.els.modules.material.service.PurchaseMaterialSourceService;
import com.els.modules.price.enumerate.MaterialCreateSourceTypeEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseMaterialSourceServiceImpl
extends BaseOpenServiceImpl<PurchaseMaterialSourceMapper, PurchaseMaterialSource, PurchaseMaterialSource>
implements PurchaseMaterialSourceService {
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseMaterialSourceMapper purchaseMaterialSourceMapper;
    @Autowired
    private InterfaceUtil interfaceUtil;

    @Override
    public void savePurchaseMaterialSource(PurchaseMaterialSource purchaseMaterialSource) {
        if (StringUtils.isBlank((CharSequence)purchaseMaterialSource.getSourceId())) {
            purchaseMaterialSource.setSourceId(this.invokeBaseRpcService.getNextCode("materialSourceNumber", (Object)purchaseMaterialSource));
        }
        if (null != purchaseMaterialSource.getExpiryDate() && null != purchaseMaterialSource.getEffectiveDate() && purchaseMaterialSource.getEffectiveDate().after(purchaseMaterialSource.getExpiryDate())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jXvKKIxOMUjXyWKI_d6139835", (String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5931\u6548\u65e5\u671f"));
        }
        purchaseMaterialSource.setSourceType(MaterialCreateSourceTypeEnum.SRM.getValue());
        if (CharSequenceUtil.isEmpty((CharSequence)purchaseMaterialSource.getNeedAudit())) {
            purchaseMaterialSource.setNeedAudit("1");
        }
        purchaseMaterialSource.setStatus(MaterialSourceStatusEnum.NEW.getValue());
        if ("1".equals(purchaseMaterialSource.getNeedAudit())) {
            purchaseMaterialSource.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseMaterialSource.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        if (null != purchaseMaterialSource.getEffectiveDate() && null != purchaseMaterialSource.getExpiryDate()) {
            this.check(purchaseMaterialSource);
        }
        ((PurchaseMaterialSourceMapper)this.baseMapper).insert((Object)purchaseMaterialSource);
    }

    private void check(PurchaseMaterialSource materialSource) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{PurchaseMaterialSource::getSourceId, PurchaseMaterialSource::getEffectiveDate, PurchaseMaterialSource::getExpiryDate});
        ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getMaterialNumber, (Object)materialSource.getMaterialNumber());
        ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getFactory, (Object)materialSource.getFactory());
        ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getCompany, (Object)materialSource.getCompany());
        ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getPurchaseOrg, (Object)materialSource.getPurchaseOrg());
        ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getToElsAccount, (Object)materialSource.getToElsAccount());
        wrapper.and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.or(a -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)a.le(PurchaseMaterialSource::getEffectiveDate, (Object)materialSource.getEffectiveDate())).ge(PurchaseMaterialSource::getExpiryDate, (Object)materialSource.getExpiryDate());
            })).or(b -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)b.ge(PurchaseMaterialSource::getEffectiveDate, (Object)materialSource.getEffectiveDate())).le(PurchaseMaterialSource::getExpiryDate, (Object)materialSource.getExpiryDate());
            })).or(b -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)b.le(PurchaseMaterialSource::getEffectiveDate, (Object)materialSource.getEffectiveDate())).le(PurchaseMaterialSource::getExpiryDate, (Object)materialSource.getExpiryDate())).ge(PurchaseMaterialSource::getExpiryDate, (Object)materialSource.getEffectiveDate());
            })).or(b -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)b.ge(PurchaseMaterialSource::getEffectiveDate, (Object)materialSource.getEffectiveDate())).ge(PurchaseMaterialSource::getExpiryDate, (Object)materialSource.getExpiryDate())).le(PurchaseMaterialSource::getEffectiveDate, (Object)materialSource.getExpiryDate());
            });
        });
        wrapper.ne(ObjectUtil.isNotNull((Object)materialSource.getId()), BaseEntity::getId, (Object)materialSource.getId());
        wrapper.in(PurchaseMaterialSource::getStatus, (Collection)Lists.newArrayList((Object[])new String[]{MaterialSourceStatusEnum.NORMAL.getValue(), MaterialSourceStatusEnum.FROZEN.getValue(), MaterialSourceStatusEnum.EFFECTIVE.getValue()}));
        List list = this.list((Wrapper)wrapper);
        if (!list.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5b58\u5728\u6709\u6548\u65f6\u95f4\u6bb5\u91cd\u53e0\u7684\u8d27\u6e90\u6e05\u5355:") + list.stream().map(PurchaseMaterialSource::getSourceId).collect(Collectors.joining(",")));
        }
    }

    @Override
    public void updatePurchaseMaterialSource(PurchaseMaterialSource purchaseMaterialSource) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialSource.getMaterialSourceType()), (String)I18nUtil.translate((String)"i18n_alert_SjAclS_2dcdb97f", (String)"\u8d27\u6e90\u7c7b\u578b\u5fc5\u586b"));
        if ("1".equals(purchaseMaterialSource.getMaterialSourceType())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialSource.getMaterialNumber()), (String)I18nUtil.translate((String)"i18n_alert_SjAcLSLKWVSMSLAy_89390dcf", (String)"\u8d27\u6e90\u7c7b\u578b\u4e3a\u7269\u6599\u65f6\uff0c\u8bf7\u586b\u5199\u7269\u6599\u7f16\u53f7"));
        } else if ("2".equals(purchaseMaterialSource.getMaterialSourceType())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialSource.getMaterialGroup()), (String)I18nUtil.translate((String)"i18n_alert_SjAcLSLVKWVSMSLVlS_857af31e", (String)"\u8d27\u6e90\u7c7b\u578b\u4e3a\u7269\u6599\u7ec4\u65f6\uff0c\u8bf7\u586b\u5199\u7269\u6599\u7ec4\u5fc5\u586b"));
        }
        if ("1".equals(purchaseMaterialSource.getExclusionMark())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialSource.getMaterialNumber()), (String)I18nUtil.translate((String)"i18n_alert_VSMTPAGjSLAy_bf5095dd", (String)"\u8bf7\u586b\u5199\u9700\u8981\u6392\u9664\u7684\u7269\u6599\u7f16\u53f7"));
        }
        if (null != purchaseMaterialSource.getExpiryDate() && null != purchaseMaterialSource.getEffectiveDate() && purchaseMaterialSource.getEffectiveDate().after(purchaseMaterialSource.getExpiryDate())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jXvKKIxOMUjXyWKI_d6139835", (String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5931\u6548\u65e5\u671f"));
        }
        if (CharSequenceUtil.isEmpty((CharSequence)purchaseMaterialSource.getNeedAudit())) {
            purchaseMaterialSource.setNeedAudit("1");
        }
        purchaseMaterialSource.setStatus(MaterialSourceStatusEnum.NEW.getValue());
        if ("1".equals(purchaseMaterialSource.getNeedAudit())) {
            purchaseMaterialSource.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseMaterialSource.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.check(purchaseMaterialSource);
        int count = ((PurchaseMaterialSourceMapper)this.baseMapper).updateById((Object)purchaseMaterialSource);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void publishPurchaseMaterialSource(PurchaseMaterialSource purchaseMaterialSource) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialSource.getMaterialSourceType()), (String)I18nUtil.translate((String)"i18n_alert_SjAclS_2dcdb97f", (String)"\u8d27\u6e90\u7c7b\u578b\u5fc5\u586b"));
        if ("1".equals(purchaseMaterialSource.getMaterialSourceType())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialSource.getMaterialNumber()), (String)I18nUtil.translate((String)"i18n_alert_SjAcLSLKWVSMSLAy_89390dcf", (String)"\u8d27\u6e90\u7c7b\u578b\u4e3a\u7269\u6599\u65f6\uff0c\u8bf7\u586b\u5199\u7269\u6599\u7f16\u53f7"));
        } else if ("2".equals(purchaseMaterialSource.getMaterialSourceType())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialSource.getMaterialGroup()), (String)I18nUtil.translate((String)"i18n_alert_SjAcLSLVKWVSMSLVlS_857af31e", (String)"\u8d27\u6e90\u7c7b\u578b\u4e3a\u7269\u6599\u7ec4\u65f6\uff0c\u8bf7\u586b\u5199\u7269\u6599\u7ec4\u5fc5\u586b"));
        }
        if ("1".equals(purchaseMaterialSource.getExclusionMark())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialSource.getMaterialNumber()), (String)I18nUtil.translate((String)"i18n_alert_VSMTPAGjSLAy_bf5095dd", (String)"\u8bf7\u586b\u5199\u9700\u8981\u6392\u9664\u7684\u7269\u6599\u7f16\u53f7"));
        }
        if (null != purchaseMaterialSource.getExpiryDate() && null != purchaseMaterialSource.getEffectiveDate() && purchaseMaterialSource.getEffectiveDate().after(purchaseMaterialSource.getExpiryDate())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jXvKKIxOMUjXyWKI_d6139835", (String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5931\u6548\u65e5\u671f"));
        }
        if ("1".equals(purchaseMaterialSource.getNeedAudit())) {
            if (CharSequenceUtil.isEmpty((CharSequence)purchaseMaterialSource.getFlowId()) || !AuditStatusEnum.AUDIT_FINISH.getValue().equals(purchaseMaterialSource.getAuditStatus())) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5ba1\u6279\u901a\u8fc7\u4e4b\u540e\u624d\u80fd\u53d1\u5e03"));
            }
        } else {
            purchaseMaterialSource.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.checkStatus(purchaseMaterialSource);
        this.check(purchaseMaterialSource);
        int count = ((PurchaseMaterialSourceMapper)this.baseMapper).updateById((Object)purchaseMaterialSource);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void publishPurchaseMaterialSourceById(String id) {
        PurchaseMaterialSource purchaseMaterialSource = (PurchaseMaterialSource)((Object)this.getById((Serializable)((Object)id)));
        if ("1".equals(purchaseMaterialSource.getNeedAudit())) {
            if (CharSequenceUtil.isEmpty((CharSequence)purchaseMaterialSource.getFlowId()) || !AuditStatusEnum.AUDIT_FINISH.getValue().equals(purchaseMaterialSource.getAuditStatus())) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5ba1\u6279\u901a\u8fc7\u4e4b\u540e\u624d\u80fd\u53d1\u5e03"));
            }
        } else {
            purchaseMaterialSource.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.checkStatus(purchaseMaterialSource);
        this.check(purchaseMaterialSource);
        int count = ((PurchaseMaterialSourceMapper)this.baseMapper).updateById((Object)purchaseMaterialSource);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void checkStatus(PurchaseMaterialSource purchaseMaterialSource) {
        purchaseMaterialSource.setStatus(MaterialSourceStatusEnum.NORMAL.getValue());
        DateTime date = DateUtil.date();
        if (null != purchaseMaterialSource.getEffectiveDate() && purchaseMaterialSource.getEffectiveDate().before((Date)date)) {
            purchaseMaterialSource.setStatus(MaterialSourceStatusEnum.EFFECTIVE.getValue());
        }
        if (null != purchaseMaterialSource.getExpiryDate() && purchaseMaterialSource.getExpiryDate().before((Date)date)) {
            purchaseMaterialSource.setStatus(MaterialSourceStatusEnum.INVALID.getValue());
        }
    }

    @Override
    public void changeSourceStatusForJob() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        DateTime date = DateUtil.date();
        param.put("nowDate", date);
        List<PurchaseMaterialSource> records = ((PurchaseMaterialSourceMapper)this.baseMapper).selectWithoutElsAccountToChangeStatus(param);
        ArrayList<PurchaseMaterialSource> updateRecords = new ArrayList<PurchaseMaterialSource>(records.size() / 2);
        for (PurchaseMaterialSource item : records) {
            if (null != item.getEffectiveDate() && item.getEffectiveDate().before((Date)date)) {
                item.setStatus(MaterialSourceStatusEnum.EFFECTIVE.getValue());
            }
            if (null != item.getExpiryDate() && item.getExpiryDate().before((Date)date)) {
                item.setStatus(MaterialSourceStatusEnum.INVALID.getValue());
            }
            updateRecords.add(item);
        }
        this.updateBatchById(updateRecords);
    }

    @Override
    public void frozenPurchaseMaterialSource(String id) {
        PurchaseMaterialSource purchaseMaterialSource = (PurchaseMaterialSource)((Object)this.purchaseMaterialSourceMapper.selectById((Serializable)((Object)id)));
        purchaseMaterialSource.setStatus(MaterialSourceStatusEnum.FROZEN.getValue());
        int count = this.purchaseMaterialSourceMapper.updateById((Object)purchaseMaterialSource);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void thawPurchaseMaterialSource(String id) {
        PurchaseMaterialSource purchaseMaterialSource = (PurchaseMaterialSource)((Object)this.purchaseMaterialSourceMapper.selectById((Serializable)((Object)id)));
        this.checkStatus(purchaseMaterialSource);
        int count = this.purchaseMaterialSourceMapper.updateById((Object)purchaseMaterialSource);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void cancelPurchaseMaterialSource(String id) {
        PurchaseMaterialSource purchaseMaterialSource = (PurchaseMaterialSource)((Object)this.purchaseMaterialSourceMapper.selectById((Serializable)((Object)id)));
        purchaseMaterialSource.setStatus(MaterialSourceStatusEnum.CANCEL.getValue());
        purchaseMaterialSource.setExpiryDate(Calendar.getInstance().getTime());
        int count = this.purchaseMaterialSourceMapper.updateById((Object)purchaseMaterialSource);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void delPurchaseMaterialSource(String id) {
        ((PurchaseMaterialSourceMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseMaterialSource(List<String> idList) {
        ((PurchaseMaterialSourceMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void addBatch(List<PurchaseMaterialSource> sourceList) {
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("materialSource");
        for (PurchaseMaterialSource source : sourceList) {
            source.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            source.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            source.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion().toString());
            source.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
        }
        this.saveBatch(sourceList);
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getMaterialSource", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List materialSourceList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchaseMaterialSource source : materialSourceList) {
            this.pushDataToErp(source);
        }
    }

    private void pushDataToErp(PurchaseMaterialSource source) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "pushMaterialSource", (Object)source);
    }
}

