/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.validator.SrmLength;
import com.els.config.mybatis.TenantContext;
import com.els.modules.price.entity.SaleInformationRecordsRequestHead;
import com.els.modules.price.entity.SaleInformationRecordsRequestItem;
import com.els.modules.price.enumerate.PriceRequestSendStatusEnum;
import com.els.modules.price.enumerate.PriceRequestStatusEnum;
import com.els.modules.price.service.SaleInformationRecordsRequestHeadService;
import com.els.modules.price.service.SaleInformationRecordsRequestItemService;
import com.els.modules.price.vo.SaleInformationRecordsRequestHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/price/saleInformationRecordsRequest"})
@Api(tags={"\u4ef7\u683c\u7533\u8bf7\u5934"})
public class SaleInformationRecordsRequestHeadController
extends BaseController<SaleInformationRecordsRequestHead, SaleInformationRecordsRequestHeadService> {
    private static final Logger log = LoggerFactory.getLogger(SaleInformationRecordsRequestHeadController.class);
    @Autowired
    private SaleInformationRecordsRequestHeadService saleInformationRecordsRequestHeadService;
    @Autowired
    private SaleInformationRecordsRequestItemService saleInformationRecordsRequestItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"informationRecordsRequest#SaleInformationRecordsRequest:list"})
    public Result<?> queryPageList(SaleInformationRecordsRequestHead saleInformationRecordsRequestHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleInformationRecordsRequestHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleInformationRecordsRequestHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    private void baseDataBuild(SaleInformationRecordsRequestHead head) {
        if ("0".equals(head.getNeedAudit())) {
            head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            head.setNeedAudit("1");
            head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        head.setBusAccount(TenantContext.getTenant());
        head.setAutoPublish(CharSequenceUtil.emptyToDefault((CharSequence)head.getAutoPublish(), (String)"0"));
        head.setNeedPurchaseConfirm(CharSequenceUtil.emptyToDefault((CharSequence)head.getNeedPurchaseConfirm(), (String)"0"));
        head.setPartGeneratedPrice(CharSequenceUtil.emptyToDefault((CharSequence)head.getPartGeneratedPrice(), (String)"0"));
        head.setStatus(PriceRequestStatusEnum.NEW.getValue());
        head.setPublishStatus(PriceRequestSendStatusEnum.NO_PUBLISH.getValue());
    }

    @SrmValidated
    @AutoLog(busModule="\u4ef7\u683c\u7533\u8bf7\u5934", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody SaleInformationRecordsRequestHeadVO saleInformationRecordsRequestHeadPage) {
        SaleInformationRecordsRequestHead saleInformationRecordsRequestHead = new SaleInformationRecordsRequestHead();
        BeanUtils.copyProperties((Object)((Object)saleInformationRecordsRequestHeadPage), (Object)((Object)saleInformationRecordsRequestHead));
        this.baseDataBuild(saleInformationRecordsRequestHead);
        this.saleInformationRecordsRequestHeadService.saveMain(saleInformationRecordsRequestHead, saleInformationRecordsRequestHeadPage.getInformationRecordsRequestItemList(), saleInformationRecordsRequestHeadPage.getAttachmentList());
        return Result.ok((Object)((Object)saleInformationRecordsRequestHead));
    }

    @SrmValidated
    @AutoLog(busModule="\u4ef7\u683c\u7533\u8bf7\u5934", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody SaleInformationRecordsRequestHeadVO saleInformationRecordsRequestHeadPage) {
        SaleInformationRecordsRequestHead byId = (SaleInformationRecordsRequestHead)((Object)this.saleInformationRecordsRequestHeadService.getById((Serializable)((Object)saleInformationRecordsRequestHeadPage.getId())));
        if (PriceRequestStatusEnum.NEW.getValue().equals(byId.getStatus()) && AuditStatusEnum.AUDIT_FINISH.getValue().equals(byId.getAuditStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        SaleInformationRecordsRequestHead saleInformationRecordsRequestHead = new SaleInformationRecordsRequestHead();
        BeanUtils.copyProperties((Object)((Object)saleInformationRecordsRequestHeadPage), (Object)((Object)saleInformationRecordsRequestHead));
        this.baseDataBuild(saleInformationRecordsRequestHeadPage);
        this.saleInformationRecordsRequestHeadService.updateMain(saleInformationRecordsRequestHead, saleInformationRecordsRequestHeadPage.getInformationRecordsRequestItemList(), saleInformationRecordsRequestHeadPage.getAttachmentList());
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(busModule="\u4ef7\u683c\u7533\u8bf7\u5934", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    public Result<?> publish(@RequestBody SaleInformationRecordsRequestHeadVO headVO) {
        if (CollectionUtil.isEmpty(headVO.getInformationRecordsRequestItemList())) {
            SaleInformationRecordsRequestHead head = (SaleInformationRecordsRequestHead)((Object)this.saleInformationRecordsRequestHeadService.getById((Serializable)((Object)headVO.getId())));
            List<SaleInformationRecordsRequestItem> itemList = this.saleInformationRecordsRequestItemService.selectByMainId(headVO.getId());
            List attachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(headVO.getId());
            this.saleInformationRecordsRequestHeadService.publish(head, itemList, attachmentList);
        } else {
            SaleInformationRecordsRequestHead purchaseInformationRecordsRequestHead = new SaleInformationRecordsRequestHead();
            BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)purchaseInformationRecordsRequestHead));
            this.baseDataBuild(purchaseInformationRecordsRequestHead);
            this.saleInformationRecordsRequestHeadService.publish(purchaseInformationRecordsRequestHead, headVO.getInformationRecordsRequestItemList(), headVO.getAttachmentList());
        }
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(busModule="\u4ef7\u683c\u7533\u8bf7\u5934", value="\u786e\u8ba4")
    @ApiOperation(value="\u786e\u8ba4", notes="\u786e\u8ba4")
    @PostMapping(value={"/confirmed/{headId}"})
    @RequiresPermissions(value={"informationRecordsRequest#SaleInformationRecordsRequest:confirmed"})
    public Result<?> confirmed(@PathVariable(value="headId") String headId, @SrmLength(max=400, scopeTitle="\u610f\u89c1", scopeI18key="i18n_alert_II_c4a92") @RequestParam(value="remark") String remark) {
        this.saleInformationRecordsRequestHeadService.confirmed(headId, remark);
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(busModule="\u4ef7\u683c\u7533\u8bf7\u5934", value="\u786e\u8ba4")
    @ApiOperation(value="\u62d2\u7edd", notes="\u62d2\u7edd")
    @PostMapping(value={"/rejected/{headId}"})
    @RequiresPermissions(value={"informationRecordsRequest#SaleInformationRecordsRequest:rejected"})
    public Result<?> rejected(@PathVariable(value="headId") String headId, @SrmLength(max=400, scopeTitle="\u610f\u89c1", scopeI18key="i18n_alert_II_c4a92") @RequestParam(value="remark") String remark) {
        this.saleInformationRecordsRequestHeadService.rejected(headId, remark);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u4ef7\u683c\u7533\u8bf7\u5934", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"informationRecordsRequest#SaleInformationRecordsRequest:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.saleInformationRecordsRequestHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u4ef7\u683c\u7533\u8bf7\u5934", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"informationRecordsRequest#SaleInformationRecordsRequest:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.saleInformationRecordsRequestHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"informationRecordsRequest#SaleInformationRecordsRequest:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleInformationRecordsRequestHead saleInformationRecordsRequestHead = (SaleInformationRecordsRequestHead)((Object)this.saleInformationRecordsRequestHeadService.getById((Serializable)((Object)id)));
        SaleInformationRecordsRequestHeadVO saleInformationRecordsRequestHeadVO = new SaleInformationRecordsRequestHeadVO();
        BeanUtils.copyProperties((Object)((Object)saleInformationRecordsRequestHead), (Object)((Object)saleInformationRecordsRequestHeadVO));
        List<SaleInformationRecordsRequestItem> saleInformationRecordsRequestItemList = this.saleInformationRecordsRequestItemService.selectByMainId(id);
        saleInformationRecordsRequestHeadVO.setInformationRecordsRequestItemList(saleInformationRecordsRequestItemList);
        List attachmentDTOList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        saleInformationRecordsRequestHeadVO.setAttachmentList(attachmentDTOList);
        return Result.ok((Object)((Object)saleInformationRecordsRequestHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u4ef7\u683c\u7533\u8bf7\u5934id\u67e5\u8be2\u4ef7\u683c\u7533\u8bf7\u884c", notes="\u901a\u8fc7\u4ef7\u683c\u7533\u8bf7\u5934id\u67e5\u8be2\u4ef7\u683c\u7533\u8bf7\u884c")
    @GetMapping(value={"/querySaleInformationRecordsRequestItemByMainId"})
    @RequiresPermissions(value={"informationRecordsRequest#SaleInformationRecordsRequest:queryById"})
    public Result<?> querySaleInformationRecordsRequestItemListByMainId(@RequestParam(name="id") String id) {
        List<SaleInformationRecordsRequestItem> saleInformationRecordsRequestItemList = this.saleInformationRecordsRequestItemService.selectByMainId(id);
        return Result.ok(saleInformationRecordsRequestItemList);
    }
}

