/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.price.api.enumerate.PriceRecordTypeEnum;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.entity.PurchaseInformationRecordsRequestHead;
import com.els.modules.price.entity.PurchaseInformationRecordsRequestItem;
import com.els.modules.price.entity.SaleInformationRecordsRequestHead;
import com.els.modules.price.entity.SaleInformationRecordsRequestItem;
import com.els.modules.price.enumerate.PriceRequestOptTypeEnum;
import com.els.modules.price.enumerate.PriceRequestSendStatusEnum;
import com.els.modules.price.enumerate.PriceRequestStatusEnum;
import com.els.modules.price.enumerate.PriceSourceTypeEnum;
import com.els.modules.price.enumerate.PriceStatusEnum;
import com.els.modules.price.mapper.PurchaseInformationRecordsRequestHeadMapper;
import com.els.modules.price.mapper.PurchaseInformationRecordsRequestItemMapper;
import com.els.modules.price.mapper.SaleInformationRecordsRequestHeadMapper;
import com.els.modules.price.mapper.SaleInformationRecordsRequestItemMapper;
import com.els.modules.price.service.PurchaseInformationRecordsRequestItemService;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import com.els.modules.price.service.SaleInformationRecordsRequestHeadService;
import com.els.modules.price.service.SaleInformationRecordsRequestItemService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class SaleInformationRecordsRequestHeadServiceImpl
extends BaseServiceImpl<SaleInformationRecordsRequestHeadMapper, SaleInformationRecordsRequestHead>
implements SaleInformationRecordsRequestHeadService {
    @Autowired
    private SaleInformationRecordsRequestHeadMapper saleInformationRecordsRequestHeadMapper;
    @Autowired
    private SaleInformationRecordsRequestItemMapper saleInformationRecordsRequestItemMapper;
    @Autowired
    private PurchaseInformationRecordsRequestHeadMapper purchaseInformationRecordsRequestHeadMapper;
    @Autowired
    private PurchaseInformationRecordsRequestItemMapper purchaseInformationRecordsRequestItemMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(SaleInformationRecordsRequestHead head, List<SaleInformationRecordsRequestItem> itemList, List<SaleAttachmentDTO> attachmentDTOList) {
        head.setRequestNumber(this.invokeBaseRpcService.getNextCode("informationRecordsRequest", (Object)head));
        this.saleInformationRecordsRequestHeadMapper.insert((Object)head);
        super.setHeadDefaultValue((BaseEntity)head);
        this.insertData(head, itemList, attachmentDTOList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(SaleInformationRecordsRequestHead head, List<SaleInformationRecordsRequestItem> itemList, List<SaleAttachmentDTO> attachmentDTOList) {
        int count = this.saleInformationRecordsRequestHeadMapper.updateById((Object)head);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        this.saleInformationRecordsRequestItemMapper.deleteByMainId(head.getId());
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(head.getId());
        this.insertData(head, itemList, attachmentDTOList);
    }

    private void insertData(SaleInformationRecordsRequestHead saleInformationRecordsRequestHead, List<SaleInformationRecordsRequestItem> saleInformationRecordsRequestItemList) {
        if (!CollectionUtils.isEmpty(saleInformationRecordsRequestItemList)) {
            for (SaleInformationRecordsRequestItem entity : saleInformationRecordsRequestItemList) {
                entity.setHeadId(saleInformationRecordsRequestHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleInformationRecordsRequestHead);
            }
            if (!saleInformationRecordsRequestItemList.isEmpty()) {
                this.saleInformationRecordsRequestItemMapper.insertBatchSomeColumn(saleInformationRecordsRequestItemList);
            }
        }
    }

    private void insertData(SaleInformationRecordsRequestHead head, List<SaleInformationRecordsRequestItem> itemList, List<SaleAttachmentDTO> attachmentDTOList) {
        if (!CollectionUtils.isEmpty(itemList)) {
            int index = 1;
            for (SaleInformationRecordsRequestItem entity : itemList) {
                entity.setHeadId(head.getId());
                entity.setChangeToPrice("0");
                entity.setItemNumber(Integer.toString(index));
                ++index;
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)head);
            }
            if (!itemList.isEmpty()) {
                ((SaleInformationRecordsRequestItemService)SpringContextUtils.getBean(SaleInformationRecordsRequestItemService.class)).saveBatch(itemList);
            }
        }
        if (CollectionUtil.isNotEmpty(attachmentDTOList)) {
            for (SaleAttachmentDTO entity : attachmentDTOList) {
                entity.setId(null);
                entity.setHeadId(head.getId());
                entity.setElsAccount(head.getElsAccount());
                entity.setCreateBy(head.getCreateBy());
                entity.setCreateTime(head.getCreateTime());
                entity.setUpdateBy(head.getUpdateBy());
                entity.setUpdateTime(head.getUpdateTime());
                entity.setDeleted(CommonConstant.DEL_FLAG_0);
            }
        }
        if (CollectionUtil.isNotEmpty(attachmentDTOList)) {
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(attachmentDTOList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void publish(SaleInformationRecordsRequestHead head, List<SaleInformationRecordsRequestItem> itemList, List<SaleAttachmentDTO> attachmentDTOList) {
        if (!"1".equals(head.getNeedPurchaseConfirm())) {
            this.checkPrice(head, itemList, true);
            head.setStatus(PriceRequestStatusEnum.WAIT_TO_CREATE_PRICE.getValue());
            head.setPublishStatus(PriceRequestSendStatusEnum.HAD_PUBLISH.getValue());
            ((SaleInformationRecordsRequestHeadMapper)this.baseMapper).updateById((Object)head);
            return;
        }
        if (CollectionUtil.isEmpty(itemList)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_umUVtRRcWF_a82b50e7", (String)"\u4ef7\u683c\u7533\u8bf7\u5355\u7f3a\u5c11\u884c\u6570\u636e"));
        }
        for (int i = 0; i < itemList.size(); ++i) {
            if (CharSequenceUtil.equals((CharSequence)head.getToElsAccount(), (CharSequence)itemList.get(i).getToElsAccount())) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_umUVc_89ed4963", (String)"\u4ef7\u683c\u7533\u8bf7\u884c") + (i + 1) + I18nUtil.translate((String)"i18n_alert_ICWWWeynumUVesnxIR_24a0bf2e", (String)"\u5bf9\u65b9ELS\u8d26\u53f7\u548c\u4ef7\u683c\u7533\u8bf7\u5934\u4e2d\u7684\u4e0d\u4e00\u81f4"));
        }
        this.checkPrice(head, itemList, true);
        if ("1".equals(head.getNeedPurchaseConfirm())) {
            head.setStatus(PriceRequestStatusEnum.TO_BE_CONFIRMED.getValue());
        } else {
            head.setStatus(PriceRequestStatusEnum.WAIT_TO_CREATE_PRICE.getValue());
        }
        head.setPublishStatus(PriceRequestSendStatusEnum.HAD_PUBLISH.getValue());
        PurchaseInformationRecordsRequestHead saleRequestHead = (PurchaseInformationRecordsRequestHead)((Object)Convert.convert(PurchaseInformationRecordsRequestHead.class, (Object)((Object)head)));
        saleRequestHead.setElsAccount(head.getToElsAccount());
        saleRequestHead.setToElsAccount(saleRequestHead.getElsAccount());
        this.saleInformationRecordsRequestItemMapper.deleteByMainId(head.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(head.getId());
        this.insertData(head, itemList, attachmentDTOList);
        PurchaseInformationRecordsRequestHead dbSaleRequestHead = this.purchaseInformationRecordsRequestHeadMapper.selectWithoutElsAccountToRelationId(head.getId());
        if (dbSaleRequestHead == null) {
            saleRequestHead.setId(IdWorker.getIdStr());
            saleRequestHead.setRelationId(head.getId());
            head.setRelationId(saleRequestHead.getId());
        } else {
            saleRequestHead.setRelationId(head.getId());
            saleRequestHead.setId(dbSaleRequestHead.getId());
            saleRequestHead.setDataVersion(dbSaleRequestHead.getDataVersion());
            head.setRelationId(dbSaleRequestHead.getId());
        }
        head.setConfirmRemark("");
        int count = ((SaleInformationRecordsRequestHeadMapper)this.baseMapper).updateById((Object)head);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        if (null == dbSaleRequestHead) {
            this.purchaseInformationRecordsRequestHeadMapper.insert((Object)saleRequestHead);
        } else {
            count = this.purchaseInformationRecordsRequestHeadMapper.updateById((Object)saleRequestHead);
            if (count == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
            }
        }
        this.purchaseInformationRecordsRequestItemMapper.deleteByMainId(saleRequestHead.getId());
        if (CollectionUtil.isNotEmpty(itemList)) {
            ArrayList<PurchaseInformationRecordsRequestItem> saleItemList = new ArrayList<PurchaseInformationRecordsRequestItem>();
            for (SaleInformationRecordsRequestItem item : itemList) {
                PurchaseInformationRecordsRequestItem saleItem = (PurchaseInformationRecordsRequestItem)((Object)Convert.convert(PurchaseInformationRecordsRequestItem.class, (Object)((Object)item)));
                saleItem.setId(IdWorker.getIdStr());
                saleItem.setRelationId(item.getId());
                saleItem.setElsAccount(head.getToElsAccount());
                saleItem.setHeadId(saleRequestHead.getId());
                item.setRelationId(saleItem.getId());
                saleItemList.add(saleItem);
            }
            if (CollectionUtil.isNotEmpty(saleItemList)) {
                ((PurchaseInformationRecordsRequestItemService)SpringContextUtils.getBean(PurchaseInformationRecordsRequestItemService.class)).saveBatch(saleItemList);
            }
            if (CollectionUtil.isNotEmpty(itemList)) {
                ((SaleInformationRecordsRequestItemService)SpringContextUtils.getBean(SaleInformationRecordsRequestItemService.class)).updateBatchById(itemList);
            }
        }
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(saleRequestHead.getId());
        if (CollectionUtil.isNotEmpty(attachmentDTOList)) {
            ArrayList<PurchaseAttachmentDTO> saleAttachmentArrayList = new ArrayList<PurchaseAttachmentDTO>();
            for (SaleAttachmentDTO purchaseAttachment : attachmentDTOList) {
                purchaseAttachment.setRelationId(IdWorker.getIdStr());
                PurchaseAttachmentDTO saleAttachment = new PurchaseAttachmentDTO();
                BeanUtil.copyProperties((Object)purchaseAttachment, (Object)saleAttachment, (String[])new String[0]);
                saleAttachment.setId(purchaseAttachment.getRelationId());
                saleAttachment.setRelationId(purchaseAttachment.getId());
                saleAttachment.setElsAccount(head.getToElsAccount());
                saleAttachment.setSendStatus("1");
                saleAttachment.setHeadId(saleRequestHead.getId());
                purchaseAttachment.setSendStatus("1");
                saleAttachmentArrayList.add(saleAttachment);
            }
            if (CollectionUtil.isNotEmpty(attachmentDTOList)) {
                this.invokeBaseRpcService.updateSaleAttachmentBatchById(attachmentDTOList);
            }
            if (CollectionUtil.isNotEmpty(saleAttachmentArrayList)) {
                this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(saleAttachmentArrayList);
            }
        }
        String urlParam = "id=" + head.getRelationId() + "&templateName=" + head.getTemplateName() + "&templateNumber=" + head.getTemplateNumber() + "&templateAccount=" + head.getTemplateAccount() + "&templateVersion=" + head.getTemplateVersion();
        super.sendMsg(head.getBusAccount(), head.getToElsAccount(), (Object)head, urlParam, "informationRecordsRequest", "publish");
    }

    private List<PurchaseInformationRecords> checkPrice(SaleInformationRecordsRequestHead head, List<SaleInformationRecordsRequestItem> itemList, boolean onCheck) {
        if (CollectionUtils.isEmpty(itemList)) {
            return Lists.newArrayList();
        }
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("price");
        com.els.common.util.Assert.isNotNull((Object)templateList, (String)I18nUtil.translate((String)"", (String)"\u8bf7\u5148\u914d\u7f6e\u4ef7\u683c\u4e3b\u6570\u636e\u4e1a\u52a1\u6a21\u677f"));
        TemplateHeadDTO templateHeadDTO = (TemplateHeadDTO)templateList.get(0);
        List<String> oldRecordIds = itemList.stream().filter(x -> CharSequenceUtil.isNotEmpty((CharSequence)x.getInfoRecordId())).map(BaseEntity::getId).distinct().collect(Collectors.toList());
        Map<String, PurchaseInformationRecords> recordsMap = this.loadOldPriceRecords(oldRecordIds);
        PurchaseInformationRecordsService service = (PurchaseInformationRecordsService)SpringContextUtils.getBean(PurchaseInformationRecordsService.class);
        ArrayList<PurchaseInformationRecords> recordsList = new ArrayList<PurchaseInformationRecords>(itemList.size());
        for (int index = 0; index < itemList.size(); ++index) {
            PurchaseInformationRecords oldRecord;
            SaleInformationRecordsRequestItem item = itemList.get(index);
            PurchaseInformationRecords records = (PurchaseInformationRecords)((Object)Convert.convert(PurchaseInformationRecords.class, (Object)((Object)item)));
            records.setSourceType(PriceSourceTypeEnum.PRICE_REQUEST.getValue());
            records.setRequestPriceId(item.getId());
            records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
            records.setId(null);
            records.setCreateTime(null);
            records.setCreateBy(null);
            records.setUpdateBy(null);
            records.setUpdateTime(null);
            records.setTemplateAccount(CharSequenceUtil.emptyToDefault((CharSequence)templateHeadDTO.getElsAccount(), (String)TenantContext.getTenant()));
            records.setTemplateNumber(templateHeadDTO.getTemplateNumber());
            records.setTemplateName(templateHeadDTO.getTemplateName());
            records.setTemplateVersion(templateHeadDTO.getTemplateVersion());
            records.setSourceItemNumber(item.getItemNumber());
            records.setSourceNumber(head.getRequestNumber());
            records.setSourceType(PriceSourceTypeEnum.PRICE_REQUEST.getValue());
            records.setMaterialId(item.getMaterialId());
            records.setSourceItemId(item.getId());
            records.setSourceId(head.getId());
            records.setRecordType(CharSequenceUtil.emptyToDefault((CharSequence)records.getRecordType(), (String)PriceRecordTypeEnum.STANDARD.getValue()));
            if (CharSequenceUtil.isNotEmpty((CharSequence)item.getInfoRecordId()) && null != (oldRecord = recordsMap.get(item.getInfoRecordId()))) {
                records.setTemplateAccount(oldRecord.getTemplateAccount());
                records.setTemplateNumber(oldRecord.getTemplateNumber());
                records.setTemplateName(oldRecord.getTemplateName());
                records.setTemplateVersion(oldRecord.getTemplateVersion());
            }
            records.setBusAccount(CharSequenceUtil.emptyToDefault((CharSequence)head.getBusAccount(), (String)TenantContext.getTenant()));
            if (PriceRequestOptTypeEnum.CHANGE.getValue().equals(item.getRequestOptType())) {
                records.setEffectiveDate(item.getRequestEffectiveDate());
                records.setExpiryDate(item.getRequestExpiryDate());
                records.setNetPrice(item.getRequestNetPrice());
                records.setPrice(item.getRequestPrice());
                records.setLadderPriceJson(CharSequenceUtil.emptyToDefault((CharSequence)item.getRequestLadderPriceJson(), (String)item.getLadderPriceJson()));
            } else if (PriceRequestOptTypeEnum.EXTENSION.getValue().equals(item.getRequestOptType())) {
                records.setPurchaseOrg(item.getRequestPurchaseOrg());
                records.setFactory(CharSequenceUtil.emptyToDefault((CharSequence)item.getRequestPurchaseFactory(), (String)item.getFactory()));
            }
            if (null != records.getPrice() && records.getPrice().compareTo(BigDecimal.ZERO) < 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVc_483a8da2", (String)("\u91c7\u8d2d\u7533\u8bf7\u884c[" + (index + 1) + "]")) + I18nUtil.translate((String)"i18n_alert_xfuxOXU0_feacb714", (String)"\u542b\u7a0e\u4ef7\u4e0d\u80fd\u5c0f\u4e8e0\uff01"));
            }
            if (null != records.getExpiryDate() && null != records.getEffectiveDate() && records.getExpiryDate().before(records.getEffectiveDate())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVc_483a8da2", (String)("\u91c7\u8d2d\u7533\u8bf7\u884c[" + (index + 1) + "]")) + I18nUtil.translate((String)"i18n_alert_umtHjXyRBAxOQUumtHjXAKBA_95550107", (String)"\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u8d77\u59cb\u65e5\u671f"));
            }
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)records.getPriceType()), (String)(I18nUtil.translate((String)"", (String)("\u91c7\u8d2d\u7533\u8bf7\u884c[" + (index + 1) + "]")) + I18nUtil.translate((String)"i18n_alert_umAclS_b641dd5b", (String)"\u4ef7\u683c\u7c7b\u578b\u5fc5\u586b")));
            if ("1".equals(records.getRecordType()) && CharSequenceUtil.isEmpty((CharSequence)records.getMaterialNumber())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVc_483a8da2", (String)("\u91c7\u8d2d\u7533\u8bf7\u884c[" + (index + 1) + "]")) + I18nUtil.translate((String)"i18n_alert_umAcLSLKWSLAylS_a87995e2", (String)"\u4ef7\u683c\u7c7b\u578b\u4e3a\u7269\u6599\u65f6\uff0c\u7269\u6599\u7f16\u53f7\u5fc5\u586b"));
            }
            if ("2".equals(records.getRecordType()) && CharSequenceUtil.isEmpty((CharSequence)records.getMaterialGroup())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVc_483a8da2", (String)("\u91c7\u8d2d\u7533\u8bf7\u884c[" + (index + 1) + "]")) + I18nUtil.translate((String)"i18n_alert_umAcLSLVKWSLVlS_dce240f5", (String)"\u4ef7\u683c\u7c7b\u578b\u4e3a\u7269\u6599\u7ec4\u65f6\uff0c\u7269\u6599\u7ec4\u5fc5\u586b"));
            }
            if (CharSequenceUtil.isEmpty((CharSequence)records.getFactory()) && CharSequenceUtil.isEmpty((CharSequence)records.getPurchaseOrg())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVc_483a8da2", (String)("\u91c7\u8d2d\u7533\u8bf7\u884c[" + (index + 1) + "]")) + I18nUtil.translate((String)"i18n_alert_RHnnRVRlTSMIm_f3c63546", (String)"\u5de5\u5382\u548c\u91c7\u8d2d\u7ec4\u7ec7\u5fc5\u987b\u586b\u5199\u4e00\u4e2a"));
            }
            service.calculatePrice(records);
            records.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
            service.checkStatus(records);
            recordsList.add(records);
        }
        for (PurchaseInformationRecords records : recordsList) {
            try {
                service.cutOffPriceDate(records, onCheck);
                if (onCheck) continue;
                service.save((Object)records);
            }
            catch (Exception e) {
                if (onCheck || !"1".equals(head.getPartGeneratedPrice())) {
                    throw e;
                }
                if (e.getCause() instanceof ELSBootException) {
                    this.log.warn(e.getMessage());
                    records.setId(null);
                    records.setRequestPriceErrorMsg(e.getMessage());
                    continue;
                }
                throw e;
            }
        }
        return recordsList;
    }

    private Map<String, PurchaseInformationRecords> loadOldPriceRecords(List<String> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{BaseEntity::getId, PurchaseInformationRecords::getTemplateAccount, PurchaseInformationRecords::getTemplateName, PurchaseInformationRecords::getBusAccount, PurchaseInformationRecords::getTemplateVersion, PurchaseInformationRecords::getTemplateNumber});
        wrapper.in(BaseEntity::getId, ids);
        List list = ((PurchaseInformationRecordsService)SpringContextUtils.getBean(PurchaseInformationRecordsService.class)).list((Wrapper)wrapper);
        return list.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.saleInformationRecordsRequestItemMapper.deleteByMainId(id);
        this.saleInformationRecordsRequestHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleInformationRecordsRequestItemMapper.deleteByMainId(serializable.toString());
            this.saleInformationRecordsRequestHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void confirmed(String headId, String remark) {
        this.confirmedOrRejected(headId, remark, PriceRequestStatusEnum.WAIT_TO_CREATE_PRICE.getValue());
    }

    public void confirmedOrRejected(String headId, String remark, String status) {
        SaleInformationRecordsRequestHead oldRequestHead = (SaleInformationRecordsRequestHead)((Object)((SaleInformationRecordsRequestHeadMapper)this.baseMapper).selectById((Serializable)((Object)headId)));
        if (null == oldRequestHead) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WFxMK_c3d350df", (String)"\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        if (!"1".equals(oldRequestHead.getNeedSaleConfirm())) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5f53\u524d\u5355\u636e\u4e0d\u9700\u8981\u4f9b\u5e94\u5546\u786e\u8ba4"));
        }
        if (!PriceRequestStatusEnum.TO_BE_CONFIRMED.getValue().equals(oldRequestHead.getStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        SaleInformationRecordsRequestHead requestHead = new SaleInformationRecordsRequestHead();
        requestHead.setId(headId);
        requestHead.setStatus(status);
        requestHead.setConfirmRemark(remark);
        int count = ((SaleInformationRecordsRequestHeadMapper)this.baseMapper).updateById((Object)requestHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        PurchaseInformationRecordsRequestHead head = new PurchaseInformationRecordsRequestHead();
        head.setId(oldRequestHead.getRelationId());
        head.setStatus(status);
        head.setConfirmRemark(remark);
        this.purchaseInformationRecordsRequestHeadMapper.updateById((Object)head);
        String urlParam = "id=" + oldRequestHead.getRelationId() + "&templateName=" + oldRequestHead.getTemplateName() + "&templateNumber=" + oldRequestHead.getTemplateNumber() + "&templateAccount=" + oldRequestHead.getTemplateAccount() + "&templateVersion=" + oldRequestHead.getTemplateVersion();
        if ("3".equals(status)) {
            super.sendMsg(oldRequestHead.getToElsAccount(), oldRequestHead.getBusAccount(), (Object)oldRequestHead, urlParam, "informationRecordsRequest", "refund");
        } else {
            super.sendMsg(oldRequestHead.getToElsAccount(), oldRequestHead.getBusAccount(), (Object)oldRequestHead, urlParam, "informationRecordsRequest", "confirm");
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void rejected(String headId, String remark) {
        this.confirmedOrRejected(headId, remark, PriceRequestStatusEnum.REJECTED.getValue());
    }
}

