/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.delivery.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.delivery.entity.PurchaseCaseConvertRuleHead;
import com.els.modules.delivery.enumerate.ConvertRuleStatusEnum;
import com.els.modules.delivery.service.PurchaseCaseConvertRuleHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7bb1\u5355\u6298\u7b97\u89c4\u5219"})
@RestController
@RequestMapping(value={"/delivery/purchaseCaseConvertRuleHead"})
public class PurchaseCaseConvertRuleHeadController
extends BaseController<PurchaseCaseConvertRuleHead, PurchaseCaseConvertRuleHeadService> {
    private static final String LOCK_KEY = "srm_convert_rule_";
    private static final Long LOCK_EXPIRE_TIME = 120000L;
    @Autowired
    private PurchaseCaseConvertRuleHeadService purchaseCaseConvertRuleHeadService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private RedisUtil redisUtil;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PurchaseCaseConvertRuleHead purchaseCaseConvertRuleHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseCaseConvertRuleHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseCaseConvertRuleHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u7bb1\u5355\u6298\u7b97\u89c4\u5219-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody PurchaseCaseConvertRuleHead purchaseCaseConvertRuleHead) {
        purchaseCaseConvertRuleHead.setStatus(ConvertRuleStatusEnum.NEW.getValue());
        this.purchaseCaseConvertRuleHeadService.savePurchaseCaseConvertRuleHead(purchaseCaseConvertRuleHead);
        return Result.ok((Object)((Object)purchaseCaseConvertRuleHead));
    }

    @AutoLog(value="\u7bb1\u5355\u6298\u7b97\u89c4\u5219-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody PurchaseCaseConvertRuleHead purchaseCaseConvertRuleHead) {
        this.purchaseCaseConvertRuleHeadService.updatePurchaseCaseConvertRuleHead(purchaseCaseConvertRuleHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u7bb1\u5355\u6298\u7b97\u89c4\u5219-\u901a\u8fc7id\u51bb\u7ed3")
    @ApiOperation(value="\u901a\u8fc7id\u51bb\u7ed3", notes="\u901a\u8fc7id\u51bb\u7ed3")
    @GetMapping(value={"/frozen"})
    public Result<?> frozen(@RequestParam(name="id") String id) {
        this.purchaseCaseConvertRuleHeadService.frozenCaseConvertRuleHead(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u7bb1\u5355\u6298\u7b97\u89c4\u5219-\u901a\u8fc7id\u89e3\u51bb")
    @ApiOperation(value="\u901a\u8fc7id\u89e3\u51bb", notes="\u901a\u8fc7id\u89e3\u51bb")
    @GetMapping(value={"/thaw"})
    public Result<?> thaw(@RequestParam(name="id") String id) {
        this.purchaseCaseConvertRuleHeadService.thawCaseConvertRuleHead(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u7bb1\u5355\u6298\u7b97\u89c4\u5219-\u7248\u672c\u53d8\u66f4")
    @ApiOperation(value="\u7248\u672c\u53d8\u66f4", notes="\u7248\u672c\u53d8\u66f4")
    @PostMapping(value={"/upgradeVersion"})
    public Result<?> upgradeVersion(@RequestBody PurchaseCaseConvertRuleHead convertRuleHead) {
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, convertRuleHead.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5f53\u524d\u5355\u636e\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u6682\u65f6\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c"));
        }
        try {
            this.purchaseCaseConvertRuleHeadService.upgradeConvertRuleVersion(convertRuleHead);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, convertRuleHead.getId());
        }
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u7bb1\u5355\u6298\u7b97\u89c4\u5219-\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    public Result<?> publish(@RequestBody PurchaseCaseConvertRuleHead convertRuleHead) {
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, convertRuleHead.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5f53\u524d\u5355\u636e\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u6682\u65f6\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c"));
        }
        try {
            Assert.hasText((String)convertRuleHead.getTemplateNumber(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempNum", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.notNull((Object)convertRuleHead.getTemplateVersion(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempVersion", (String)"\u6a21\u677f\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a"));
            if (StrUtil.isBlank((CharSequence)convertRuleHead.getConvertRuleNumber())) {
                convertRuleHead.setConvertRuleNumber(this.invokeBaseRpcService.getNextCode("convertRuleNumber", (Object)convertRuleHead));
            }
            String elsAccount = this.getTenantId();
            convertRuleHead.setElsAccount(elsAccount);
            convertRuleHead.setBusAccount(elsAccount);
            this.purchaseCaseConvertRuleHeadService.publish(convertRuleHead);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, convertRuleHead.getId());
        }
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u7bb1\u5355\u6298\u7b97\u89c4\u5219-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseCaseConvertRuleHeadService.delPurchaseCaseConvertRuleHead(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u7bb1\u5355\u6298\u7b97\u89c4\u5219-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.purchaseCaseConvertRuleHeadService.delBatchPurchaseCaseConvertRuleHead(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseCaseConvertRuleHead purchaseCaseConvertRuleHead = (PurchaseCaseConvertRuleHead)((Object)this.purchaseCaseConvertRuleHeadService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)purchaseCaseConvertRuleHead));
    }

    @ApiOperation(value="\u72b6\u6001\u9875\u7b7e", notes="\u72b6\u6001\u9875\u7b7e")
    @GetMapping(value={"/counts"})
    public Result<?> queryTabsCount(PurchaseCaseConvertRuleHead convertRuleHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)convertRuleHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"status");
        List list = ((PurchaseCaseConvertRuleHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseCaseConvertRuleHead::getStatus, PurchaseCaseConvertRuleHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "status", null, all));
        List convertRuleStatus = this.invokeBaseRpcService.queryDictItemsByCode("convertRuleStatus", TenantContext.getTenant());
        for (DictDTO status : convertRuleStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "status", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

