/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.account.api.impl.open;

import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.service.SimpleOpenApiRpcService;
import com.els.rpc.service.InvokeAccountRpcService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="getSsoTokenServiceImpl")
public class GetSsoTokenServiceImpl
implements SimpleOpenApiRpcService {
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private RedisUtil redisUtil;

    public JSONObject invoke(JSONObject param) {
        String subAccount;
        String elsAccount = TenantContext.getTenant();
        ElsSubAccountDTO elsSubAccount = this.invokeAccountRpcService.getAccount(elsAccount, subAccount = param.getString("subAccount"));
        if (elsSubAccount == null) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"subAccount \u4e0d\u5b58\u5728\uff01"));
        }
        JSONObject result = new JSONObject();
        result.put("token", (Object)this.saveToken(elsSubAccount));
        return result;
    }

    private String saveToken(ElsSubAccountDTO account) {
        String token = JwtUtil.sign((String)(account.getElsAccount() + "_" + account.getSubAccount()), (String)account.getPassword());
        this.redisUtil.set("sys:token:" + token, (Object)token);
        this.redisUtil.expire("sys:token:" + token, 1800L);
        return token;
    }
}

