/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.exchange.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseOpenServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.exchange.entity.BpExchangeRate;
import com.els.modules.exchange.entity.BpExchangeRateHis;
import com.els.modules.exchange.mapper.BpExchangeRateHisMapper;
import com.els.modules.exchange.mapper.BpExchangeRateMapper;
import com.els.modules.exchange.service.BpExchangeRateHisService;
import com.els.modules.exchange.service.BpExchangeRateService;
import com.els.modules.exchange.vo.BpExchangeRateVO;
import com.els.modules.extend.api.common.enumerate.RafflesInterfaceEnum;
import com.els.modules.extend.api.common.utils.IFSInterfaceUtils;
import com.els.modules.extend.api.dto.ifs.request.IFSRequestBaseDTO;
import com.els.modules.extend.api.dto.ifs.request.IFSRequestBaseHeadDTO;
import com.els.modules.extend.api.dto.ifs.request.item.IFSRequestGetCurrencyDTO;
import com.els.modules.extend.api.dto.ifs.result.IFSResultBaseDTO;
import com.els.modules.extend.api.dto.ifs.result.IFSResultBaseHeadDTO;
import com.els.modules.extend.api.dto.ifs.result.item.IFSGetCurrencyResultDTO;
import com.els.modules.material.api.dto.ExchangeRateDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BpExchangeRateServiceImpl
extends BaseOpenServiceImpl<BpExchangeRateMapper, BpExchangeRate, BpExchangeRate>
implements BpExchangeRateService {
    @Resource
    private BpExchangeRateHisMapper bpExchangeRateHisMapper;
    @Resource
    private BpExchangeRateMapper bpExchangeRateMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    InterfaceUtil interfaceUtil;

    @Override
    public void saveBpExchangeRate(BpExchangeRate bpExchangeRate) {
        if (bpExchangeRate.getTargetCurrency().equals(bpExchangeRate.getOriginalCurrency())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_trSlnIBSlxOde_3f38e8fd", (String)"\u57fa\u51c6\u8d27\u5e01\u548c\u76ee\u6807\u8d27\u5e01\u4e0d\u80fd\u76f8\u540c"));
        }
        this.check(bpExchangeRate);
        bpExchangeRate.setExchangeNumber(this.invokeBaseRpcService.getNextCode("srmExchangeRate", (Object)bpExchangeRate));
        bpExchangeRate.setExchangeSource("0");
        ((BpExchangeRateMapper)this.baseMapper).insert((Object)bpExchangeRate);
    }

    private void check(BpExchangeRate bpExchangeRate) {
        if (null == bpExchangeRate.getExpireTime()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_bXBAxOLVW_f027d72e", (String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (null == bpExchangeRate.getEffectiveTime()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_KXBAxOLVW_e0d38940", (String)"\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (null != bpExchangeRate.getExpireTime() && null != bpExchangeRate.getEffectiveTime() && bpExchangeRate.getExpireTime().before(bpExchangeRate.getEffectiveTime())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_KXBAxOQUbXBA_ab254c9", (String)"\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u751f\u6548\u65e5\u671f"));
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(BpExchangeRate::getExchangeUse, (Object)bpExchangeRate.getExchangeUse());
        queryWrapper.eq(BpExchangeRate::getOriginalCurrency, (Object)bpExchangeRate.getOriginalCurrency());
        queryWrapper.eq(BpExchangeRate::getTargetCurrency, (Object)bpExchangeRate.getTargetCurrency());
        queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.or(a -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)a.le(BpExchangeRate::getEffectiveTime, (Object)bpExchangeRate.getEffectiveTime())).ge(BpExchangeRate::getExpireTime, (Object)bpExchangeRate.getExpireTime());
            })).or(b -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)b.ge(BpExchangeRate::getEffectiveTime, (Object)bpExchangeRate.getEffectiveTime())).le(BpExchangeRate::getExpireTime, (Object)bpExchangeRate.getExpireTime());
            })).or(b -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)b.le(BpExchangeRate::getEffectiveTime, (Object)bpExchangeRate.getEffectiveTime())).le(BpExchangeRate::getExpireTime, (Object)bpExchangeRate.getExpireTime())).ge(BpExchangeRate::getExpireTime, (Object)bpExchangeRate.getEffectiveTime());
            })).or(b -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)b.ge(BpExchangeRate::getEffectiveTime, (Object)bpExchangeRate.getEffectiveTime())).ge(BpExchangeRate::getExpireTime, (Object)bpExchangeRate.getExpireTime())).le(BpExchangeRate::getEffectiveTime, (Object)bpExchangeRate.getExpireTime());
            });
        });
        queryWrapper.ne(ObjectUtil.isNotNull((Object)bpExchangeRate.getId()), BaseEntity::getId, (Object)bpExchangeRate.getId());
        List list = this.list((Wrapper)queryWrapper);
        if (!list.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jXKICIMKdeMIjPWtrSlWIBSljWFWShKmSu_3c13edbf", (String)"\u6709\u6548\u65f6\u95f4\u5185\u5df2\u5b58\u5728\u76f8\u540c\u6c47\u7387\u7528\u9014\u3001\u57fa\u51c6\u8d27\u5e01\u3001\u76ee\u6807\u8d27\u5e01\u7684\u6570\u636e\uff0c\u65e0\u6cd5\u518d\u6b21\u6dfb\u52a0"));
        }
    }

    @Override
    public void updateBpExchangeRate(BpExchangeRate bpExchangeRate) {
        if (bpExchangeRate.getTargetCurrency().equals(bpExchangeRate.getOriginalCurrency())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_trSlnIBSlxOde_3f38e8fd", (String)"\u57fa\u51c6\u8d27\u5e01\u548c\u76ee\u6807\u8d27\u5e01\u4e0d\u80fd\u76f8\u540c"));
        }
        BpExchangeRate dbbpExchangeRate = (BpExchangeRate)((Object)((BpExchangeRateMapper)this.baseMapper).selectById((Serializable)((Object)bpExchangeRate.getId())));
        if (dbbpExchangeRate != null) {
            if (StringUtils.isBlank((CharSequence)bpExchangeRate.getExchangeUse())) {
                bpExchangeRate.setExchangeUse("0");
            }
            if (StringUtils.isBlank((CharSequence)bpExchangeRate.getExchangeSource())) {
                bpExchangeRate.setExchangeSource("0");
            }
            if (StringUtils.isBlank((CharSequence)bpExchangeRate.getExchangeNumber())) {
                bpExchangeRate.setExchangeNumber(this.invokeBaseRpcService.getNextCode("srmExchangeRate", (Object)bpExchangeRate));
            }
            if (!(bpExchangeRate.equals((Object)dbbpExchangeRate) && bpExchangeRate.getExchange().compareTo(dbbpExchangeRate.getExchange()) == 0 && (bpExchangeRate.getStandardUnit() == null || bpExchangeRate.getStandardUnit() != null && bpExchangeRate.getStandardUnit().equals(dbbpExchangeRate.getStandardUnit())) && (bpExchangeRate.getExpireTime() == null || bpExchangeRate.getExpireTime() != null && bpExchangeRate.getExpireTime().equals(dbbpExchangeRate.getExpireTime())) && (bpExchangeRate.getEffectiveTime() == null || bpExchangeRate.getEffectiveTime() != null && bpExchangeRate.getEffectiveTime().equals(dbbpExchangeRate.getEffectiveTime())))) {
                BpExchangeRateHis bpExchangeRateHis = new BpExchangeRateHis();
                BeanUtils.copyProperties((Object)((Object)dbbpExchangeRate), (Object)((Object)bpExchangeRateHis));
                bpExchangeRateHis.setId(IdWorker.getIdStr());
                bpExchangeRateHis.setHeadId(dbbpExchangeRate.getId());
                bpExchangeRateHis.setExpireTime(dbbpExchangeRate.getExpireTime());
                bpExchangeRateHis.setEffectiveTime(dbbpExchangeRate.getEffectiveTime());
                this.bpExchangeRateHisMapper.insert((Object)bpExchangeRateHis);
            }
        }
        this.check(bpExchangeRate);
        int count = ((BpExchangeRateMapper)this.baseMapper).updateById((Object)bpExchangeRate);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void delBpExchangeRate(String id) {
        ((BpExchangeRateMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchBpExchangeRate(List<String> idList) {
        ((BpExchangeRateMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getBpExchangeRate", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List bpExchangeRateList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (BpExchangeRate bpExchangeRate : bpExchangeRateList) {
            String elsAccount = TenantContext.getTenant();
            this.interfaceUtil.callInterface(elsAccount, "pushBpExchangeRate", (Object)bpExchangeRate);
        }
    }

    @Override
    public List<BpExchangeRateVO> getRateByCurrencys(List<String> originalCurrencys, String targetCurrency) {
        return ((BpExchangeRateMapper)this.baseMapper).getRateByCurrencys(originalCurrencys, targetCurrency);
    }

    @Override
    public JSONObject erpExchangeRateToSRM(JSONObject param) {
        ArrayList<BpExchangeRate> addList = new ArrayList<BpExchangeRate>();
        ArrayList<BpExchangeRate> updList = new ArrayList<BpExchangeRate>();
        if (!param.containsKey((Object)"headList")) {
            throw new RuntimeException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String account = TenantContext.getTenant();
        Date currentTime = new Date();
        String dataList = String.valueOf(param.get((Object)"headList"));
        List rateList = JSONArray.parseArray((String)dataList, ExchangeRateDTO.class);
        for (ExchangeRateDTO head : rateList) {
            BpExchangeRate rate = new BpExchangeRate();
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)head.getCOMPANY())) {
                throw new RuntimeException("COMPANY[\u516c\u53f8] \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)head.getCURRENCYT_RATE())) {
                throw new RuntimeException("CURRENCYT_RATE[\u6c47\u7387] \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            rate.setExchange(new BigDecimal(head.getCURRENCYT_RATE()));
            rate.setTargetCurrency(head.getCURRENCY_CODE());
            rate.setOriginalCurrency(head.getRefCurrencyCode());
            rate.setCompany(head.getCOMPANY());
            rate.setCompanyName(head.getCOMPANY_NAME());
            rate.setExchangeYear(head.getDateReq());
            List list = this.bpExchangeRateMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BpExchangeRate::getTargetCurrency, (Object)head.getCURRENCY_CODE())).eq(BpExchangeRate::getOriginalCurrency, (Object)head.getRefCurrencyCode())).eq(BpExchangeRate::getExchangeYear, (Object)head.getDateReq()));
            if (list != null && list.size() > 0) {
                rate.setId(((BpExchangeRate)((Object)list.get(0))).getId());
                updList.add(rate);
                continue;
            }
            rate.setElsAccount(account);
            rate.setSourceType("erp");
            rate.setCreateTime(currentTime);
            rate.setCreateBy("interface");
            rate.setUpdateBy(head.getCreateBy());
            rate.setDeleted(CommonConstant.DEL_FLAG_0);
            rate.setId(IdWorker.getIdStr());
            addList.add(rate);
        }
        if (addList != null && addList.size() > 0) {
            this.saveBatch(addList, 200);
        }
        if (updList != null && updList.size() > 0) {
            this.updateBatchById(updList, 200);
        }
        return null;
    }

    @Override
    public void getIFSCurrency() {
        TenantContext.setTenant((String)"3107679");
        IFSRequestBaseDTO requestBaseDTO = new IFSRequestBaseDTO();
        IFSRequestBaseHeadDTO requestBaseHead = IFSInterfaceUtils.getIFSRequestBaseHead((String)RafflesInterfaceEnum.GET_CURRENCY.getThirdInterfaceCode(), (String)"2023-08-03 13:36:30", (String)"20230803133630");
        requestBaseDTO.setHead(requestBaseHead);
        IFSRequestGetCurrencyDTO getCurrencyDTO = new IFSRequestGetCurrencyDTO();
        getCurrencyDTO.setCompany("21");
        String dateReq = DateUtil.format((Date)new Date(), (String)"YYYYMMDD");
        getCurrencyDTO.setDateReq(dateReq);
        JSONObject param = new JSONObject();
        param.put("bus_account", (Object)"3107679");
        param.put("srm_interface_code", (Object)"syncExchangeByIFS");
        List dictDTOList = this.invokeBaseRpcService.queryDictItemsByCode("srmCurrency", "3107679");
        ArrayList<BpExchangeRate> addList = new ArrayList<BpExchangeRate>();
        ArrayList<BpExchangeRateHis> addHisList = new ArrayList<BpExchangeRateHis>();
        ArrayList<BpExchangeRate> updList = new ArrayList<BpExchangeRate>();
        for (int i = 0; i < dictDTOList.size(); ++i) {
            DictDTO dictDTO = (DictDTO)dictDTOList.get(i);
            getCurrencyDTO.setRefCurrencyCode(dictDTO.getValue());
            for (int j = 0; j < dictDTOList.size(); ++j) {
                String errorMsg;
                JSONObject resultObj;
                DictDTO dictDTO1 = (DictDTO)dictDTOList.get(j);
                if (dictDTO.getValue().equals(dictDTO1.getValue())) continue;
                getCurrencyDTO.setCurrencyCode(dictDTO1.getValue());
                requestBaseDTO.setBody((Object)getCurrencyDTO);
                param.put("body", (Object)JSON.parseObject((String)JSONObject.toJSONString((Object)requestBaseDTO)));
                try {
                    resultObj = this.interfaceUtil.callInterface("3107679", null, param, null);
                }
                catch (Exception e) {
                    errorMsg = "SRM\u62c9\u53d6IFS\u6c47\u7387\u4fe1\u606f\u63a5\u53e3\uff1a" + e.getMessage();
                    log.error(errorMsg);
                    this.saveInterfaceFailedMsg(getCurrencyDTO.getRefCurrencyCode(), getCurrencyDTO.getCurrencyCode(), errorMsg);
                    continue;
                }
                String ifsErrorMsg = "Interface Not Exists";
                if (ifsErrorMsg.equals(resultObj.getString("result"))) {
                    errorMsg = "SRM\u62c9\u53d6IFS\u6c47\u7387\u4fe1\u606f\u63a5\u53e3\uff1a" + resultObj.getString("result");
                    log.error(errorMsg);
                    continue;
                }
                IFSResultBaseDTO resultBaseDTO = (IFSResultBaseDTO)JSONObject.toJavaObject((JSON)resultObj.getJSONObject("result"), IFSResultBaseDTO.class);
                if (Objects.isNull(resultBaseDTO)) {
                    errorMsg = "SRM\u62c9\u53d6IFS\u6c47\u7387\u4fe1\u606f\u63a5\u53e3\uff1a\u8fd4\u56deresultBaseDTO\u6570\u636e\u4e3a\u7a7a";
                    log.error(errorMsg);
                    this.saveInterfaceFailedMsg(getCurrencyDTO.getRefCurrencyCode(), getCurrencyDTO.getCurrencyCode(), errorMsg);
                    continue;
                }
                IFSResultBaseHeadDTO resultBaseHead = resultBaseDTO.getHead();
                if (Objects.isNull(resultBaseHead)) {
                    errorMsg = "SRM\u62c9\u53d6IFS\u6c47\u7387\u4fe1\u606f\u63a5\u53e3\uff1a\u8fd4\u56deresultBaseDTO\u7684head\u6570\u636e\u4e3a\u7a7a";
                    log.error(errorMsg);
                    this.saveInterfaceFailedMsg(getCurrencyDTO.getRefCurrencyCode(), getCurrencyDTO.getCurrencyCode(), errorMsg);
                    continue;
                }
                if (!"0".equals(resultBaseHead.getRspCode())) {
                    errorMsg = "SRM\u62c9\u53d6IFS\u6c47\u7387\u4fe1\u606f\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\u4e3a\uff1a\u5931\u8d25\uff01\uff0c\u539f\u56e0\uff1a" + resultBaseHead.getRspMsg();
                    log.error(errorMsg);
                    this.saveInterfaceFailedMsg(getCurrencyDTO.getRefCurrencyCode(), getCurrencyDTO.getCurrencyCode(), errorMsg);
                    continue;
                }
                List resultDTOList = (List)resultBaseDTO.getBody();
                IFSGetCurrencyResultDTO resultDTO = (IFSGetCurrencyResultDTO)JSONObject.toJavaObject((JSON)((JSON)resultDTOList.get(0)), IFSGetCurrencyResultDTO.class);
                BpExchangeRate rate = new BpExchangeRate();
                rate.setExchange(resultDTO.getExchange());
                rate.setCompany(resultDTO.getCompany());
                rate.setCompanyName(resultDTO.getCompanyName());
                rate.setOriginalCurrency(getCurrencyDTO.getRefCurrencyCode());
                rate.setTargetCurrency(getCurrencyDTO.getCurrencyCode());
                rate.setExchangeYear(DateUtil.year((Date)new Date()) + "");
                rate.setReturnState("1");
                rate.setSourceType("IFS");
                rate.setCreateBy("1001");
                rate.setInterfaceMsg("\u64cd\u4f5c\u6210\u529f\uff01");
                rate.setEffectiveTime(new Date());
                rate.setExpireTime((Date)DateUtil.parse((CharSequence)"2099-12-31 00:00:00"));
                List<BpExchangeRate> list = this.getDbCurrency(getCurrencyDTO.getRefCurrencyCode(), getCurrencyDTO.getCurrencyCode());
                if (list != null && list.size() > 0) {
                    rate.setId(list.get(0).getId());
                    updList.add(rate);
                    BpExchangeRateHis bpExchangeRateHis = new BpExchangeRateHis();
                    BeanUtils.copyProperties((Object)((Object)rate), (Object)((Object)bpExchangeRateHis));
                    bpExchangeRateHis.setId(IdWorker.getIdStr());
                    bpExchangeRateHis.setHeadId(rate.getId());
                    bpExchangeRateHis.setExpireTime(rate.getExpireTime());
                    bpExchangeRateHis.setEffectiveTime(rate.getEffectiveTime());
                    addHisList.add(bpExchangeRateHis);
                    continue;
                }
                rate.setElsAccount("3107679");
                rate.setDeleted(CommonConstant.DEL_FLAG_0);
                rate.setId(IdWorker.getIdStr());
                addList.add(rate);
            }
        }
        if (addList != null && addList.size() > 0) {
            this.saveBatch(addList, 200);
        }
        if (updList != null && updList.size() > 0) {
            this.updateBatchById(updList, 200);
        }
        if (addHisList != null && addHisList.size() > 0) {
            BpExchangeRateHisService rateHisService = (BpExchangeRateHisService)SpringContextUtils.getBean(BpExchangeRateHisService.class);
            rateHisService.saveBatch(addHisList, 200);
        }
    }

    private void saveInterfaceFailedMsg(String originalCurrency, String targetCurrency, String errorMsg) {
        List<BpExchangeRate> list = this.getDbCurrency(originalCurrency, targetCurrency);
        if (CollectionUtil.isNotEmpty(list)) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.lambda().eq(BaseEntity::getId, (Object)list.get(0).getId());
            updateWrapper.lambda().set(BpExchangeRate::getReturnState, (Object)"2");
            updateWrapper.lambda().set(BpExchangeRate::getInterfaceMsg, (Object)errorMsg);
            this.update((Wrapper)updateWrapper);
        }
    }

    private List<BpExchangeRate> getDbCurrency(String originalCurrency, String targetCurrency) {
        int year = DateUtil.year((Date)new Date());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BpExchangeRate::getExchangeYear, (Object)(year + ""));
        queryWrapper.lambda().eq(BpExchangeRate::getOriginalCurrency, (Object)originalCurrency);
        queryWrapper.lambda().eq(BpExchangeRate::getTargetCurrency, (Object)targetCurrency);
        queryWrapper.lambda().eq(BaseEntity::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
        List list = this.list((Wrapper)queryWrapper);
        return list;
    }
}

