/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.org.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.api.dto.BaseDTO;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseOpenServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.extend.api.common.enumerate.RafflesInterfaceEnum;
import com.els.modules.extend.api.common.utils.IFSInterfaceUtils;
import com.els.modules.extend.api.dto.ifs.request.IFSRequestBaseDTO;
import com.els.modules.extend.api.dto.ifs.request.IFSRequestBaseHeadDTO;
import com.els.modules.extend.api.dto.ifs.request.item.IFSRequestGetCompanyAndDomainDTO;
import com.els.modules.extend.api.dto.ifs.result.IFSResultBaseDTO;
import com.els.modules.extend.api.dto.ifs.result.item.IFSGetCompanyAndDomainDetailResultDTO;
import com.els.modules.extend.api.dto.ifs.result.item.IFSGetCompanyAndDomainResultDTO;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.org.entity.PurchaseOrganizationInfo;
import com.els.modules.org.entity.TreeOrgNode;
import com.els.modules.org.enumerate.PurchaseOrgCategoryStatus;
import com.els.modules.org.enumerate.PurchaseOrganizationStatus;
import com.els.modules.org.mapper.PurchaseOrganizationInfoMapper;
import com.els.modules.org.service.PurchaseOrganizationInfoService;
import com.els.modules.org.vo.OrganizationInfoDTO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class PurchaseOrganizationInfoServiceImpl
extends BaseOpenServiceImpl<PurchaseOrganizationInfoMapper, PurchaseOrganizationInfo, PurchaseOrganizationInfo>
implements PurchaseOrganizationInfoService {
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private PurchaseOrganizationInfoMapper purchaseOrganizationInfoMapper;
    @Resource
    private InvokeBaseRpcService baseRpcService;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    InterfaceUtil interfaceUtil;
    private static final String CATALOGUE = "sys:dict:";
    private static final String CATALOGUE2 = "sys:cache:dict";
    private static final String CATALOGUE3 = "sys:cache:dict:";
    private static final String CATALOGUE4 = "sys:cache:dict";
    private static final String COLON = ":";

    @Override
    public void savePurchaseOrganizationInfo(PurchaseOrganizationInfo purchaseOrganizationInfo) {
        if (StrUtil.isNotEmpty((CharSequence)purchaseOrganizationInfo.getOrgCode())) {
            this.checkOrgData(purchaseOrganizationInfo);
        }
        purchaseOrganizationInfo.setDataSource(CharSequenceUtil.emptyToDefault((CharSequence)purchaseOrganizationInfo.getDataSource(), (String)"2"));
        ((PurchaseOrganizationInfoMapper)this.baseMapper).insert((Object)purchaseOrganizationInfo);
        this.deleteRedis("purchase_organization_info");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSavePurchaseOrganizationInfo(List<PurchaseOrganizationInfo> purchaseOrganizationInfoList) {
        for (PurchaseOrganizationInfo info : purchaseOrganizationInfoList) {
            this.savePurchaseOrganizationInfo(info);
        }
    }

    @Override
    public JSONObject hrOrganizationToSRM(JSONObject param) {
        ArrayList<PurchaseOrganizationInfo> addList = new ArrayList<PurchaseOrganizationInfo>();
        ArrayList<PurchaseOrganizationInfo> updList = new ArrayList<PurchaseOrganizationInfo>();
        if (!param.containsKey((Object)"headList")) {
            throw new RuntimeException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String account = TenantContext.getTenant();
        Date currentTime = new Date();
        String dataList = String.valueOf(param.get((Object)"headList"));
        List infoList = JSONArray.parseArray((String)dataList, OrganizationInfoDTO.class);
        for (OrganizationInfoDTO dto : infoList) {
            PurchaseOrganizationInfo org = new PurchaseOrganizationInfo();
            if (StringUtils.isEmpty((CharSequence)dto.getOrg_code())) {
                throw new RuntimeException("org_code[\u7ec4\u7ec7\u7f16\u7801] \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((CharSequence)dto.getOrg_name())) {
                throw new RuntimeException("org_name[\u7ec4\u7ec7\u540d\u79f0] \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            org.setOrgName(dto.getOrg_name());
            org.setOrgCode(dto.getOrg_code());
            org.setFbk1(dto.getFbk1());
            org.setBusinessLevel(dto.getBusiness_level());
            org.setFbk1(dto.getFbk1());
            org.setBusinessOrder(dto.getBusiness_order());
            org.setStatus(dto.getStatus());
            List list = this.purchaseOrganizationInfoMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(PurchaseOrganizationInfo::getOrgCode, (Object)org.getOrgCode()));
            if (list != null && list.size() > 0) {
                org.setId(((PurchaseOrganizationInfo)((Object)list.get(0))).getId());
                updList.add(org);
                continue;
            }
            org.setElsAccount(account);
            org.setSourceType("hr");
            org.setCreateTime(currentTime);
            org.setCreateBy("interface");
            org.setUpdateBy(org.getCreateBy());
            org.setDeleted(CommonConstant.DEL_FLAG_0);
            org.setTemplateNumber("TC2023072526");
            org.setTemplateName("\u6807\u51c6\u7c7b\u578b");
            org.setTemplateVersion(1);
            org.setTemplateAccount(account);
            org.setId(IdWorker.getIdStr());
            addList.add(org);
        }
        if (addList != null && addList.size() > 0) {
            this.saveBatch(addList, 200);
        }
        if (updList != null && updList.size() > 0) {
            this.updateBatchById(updList, 200);
        }
        return null;
    }

    @Override
    public void getCompanyAndDomainByIFS() {
        JSONObject resultObj;
        TenantContext.setTenant((String)"3107679");
        IFSRequestBaseDTO requestBaseDTO = new IFSRequestBaseDTO();
        ArrayList<PurchaseOrganizationInfo> addList = new ArrayList<PurchaseOrganizationInfo>();
        ArrayList<PurchaseOrganizationInfo> updList = new ArrayList<PurchaseOrganizationInfo>();
        IFSRequestBaseHeadDTO requestBaseHead = IFSInterfaceUtils.getIFSCompanyAndDomainRequestBaseHead((String)RafflesInterfaceEnum.GET_COMPANY_AND_DOMAIN.getThirdInterfaceCode(), (String)"2023-11-23 14:58:02", (String)"2023111314580237");
        requestBaseDTO.setHead(requestBaseHead);
        IFSRequestGetCompanyAndDomainDTO getCompanyAndDomainDTO = new IFSRequestGetCompanyAndDomainDTO();
        ArrayList<IFSRequestGetCompanyAndDomainDTO> requestList = new ArrayList<IFSRequestGetCompanyAndDomainDTO>();
        requestList.add(getCompanyAndDomainDTO);
        requestBaseDTO.setBody(requestList);
        JSONObject param = new JSONObject();
        param.put("bus_account", (Object)"3107679");
        param.put("srm_interface_code", (Object)"syncCompanyAndDomainByIFS");
        param.put("body", (Object)JSON.parseObject((String)JSONObject.toJSONString((Object)requestBaseDTO)));
        try {
            resultObj = this.interfaceUtil.callInterface("3107679", null, param, null);
        }
        catch (Exception e) {
            String errorMsg = "SRM\u62c9\u53d6IFS\u516c\u53f8\u3001\u57df\u4fe1\u606f\u63a5\u53e3\uff1a" + e.getMessage();
            log.error(errorMsg);
            throw new ELSBootException(errorMsg);
        }
        IFSResultBaseDTO resultBaseDTO = (IFSResultBaseDTO)JSONObject.toJavaObject((JSON)resultObj.getJSONObject("result"), IFSResultBaseDTO.class);
        if (Objects.isNull(resultBaseDTO.getBody())) {
            throw new ELSBootException("SRM\u62c9\u53d6IFS\u516c\u53f8\u3001\u57df\u4fe1\u606f\u63a5\u53e3\uff1a\u8fd4\u56deresultBaseDTO\u6570\u636e\u4e3a\u7a7a");
        }
        List templateList = this.baseRpcService.getDefaultTemplateByType("org");
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"", (String)"\u8bf7\u5148\u914d\u7f6e\u7ec4\u7ec7\u67b6\u6784\u4e1a\u52a1\u6a21\u677f"));
        TemplateHeadDTO templateHeadDTO = (TemplateHeadDTO)templateList.get(0);
        IFSGetCompanyAndDomainResultDTO getCompanyAndDomainResultDTO = (IFSGetCompanyAndDomainResultDTO)JSONObject.toJavaObject((JSON)((JSON)resultBaseDTO.getBody()), IFSGetCompanyAndDomainResultDTO.class);
        List list = getCompanyAndDomainResultDTO.getList();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (IFSGetCompanyAndDomainDetailResultDTO resultDTO : list) {
                PurchaseOrganizationInfo companyInfo = new PurchaseOrganizationInfo();
                companyInfo.setTemplateName(templateHeadDTO.getTemplateName());
                companyInfo.setTemplateNumber(templateHeadDTO.getTemplateNumber());
                companyInfo.setTemplateVersion(templateHeadDTO.getTemplateVersion());
                companyInfo.setTemplateAccount(templateHeadDTO.getElsAccount());
                companyInfo.setStatus(PurchaseOrganizationStatus.NORMAL.getValue());
                companyInfo.setDataSource("1");
                companyInfo.setOrgNature("0");
                companyInfo.setOrgCategoryCode(PurchaseOrgCategoryStatus.COMPANY_CODE.getValue());
                companyInfo.setOrgName(resultDTO.getCompanyDescription());
                companyInfo.setOrgCode(resultDTO.getCompany());
                companyInfo.setChargeCurrency(resultDTO.getCompanyFinance());
                companyInfo.setAssociationFactory(resultDTO.getContract());
                QueryWrapper companyQueryWrapper = new QueryWrapper();
                companyQueryWrapper.lambda().eq(PurchaseOrganizationInfo::getOrgCategoryCode, (Object)PurchaseOrgCategoryStatus.COMPANY_CODE.getValue());
                companyQueryWrapper.lambda().eq(PurchaseOrganizationInfo::getOrgCode, (Object)resultDTO.getCompany());
                List dbOrgList = this.list((Wrapper)companyQueryWrapper);
                if (CollectionUtil.isNotEmpty((Collection)dbOrgList)) {
                    companyInfo.setId(((PurchaseOrganizationInfo)((Object)dbOrgList.get(0))).getId());
                    updList.add(companyInfo);
                } else {
                    addList.add(companyInfo);
                }
                PurchaseOrganizationInfo domainInfo = new PurchaseOrganizationInfo();
                domainInfo.setTemplateName(templateHeadDTO.getTemplateName());
                domainInfo.setTemplateNumber(templateHeadDTO.getTemplateNumber());
                domainInfo.setTemplateVersion(templateHeadDTO.getTemplateVersion());
                domainInfo.setTemplateAccount(templateHeadDTO.getElsAccount());
                domainInfo.setStatus(PurchaseOrganizationStatus.NORMAL.getValue());
                domainInfo.setDataSource("1");
                domainInfo.setOrgNature("0");
                domainInfo.setOrgCategoryCode(PurchaseOrgCategoryStatus.FACTORY.getValue());
                domainInfo.setOrgName(resultDTO.getContractDescription());
                domainInfo.setOrgCode(resultDTO.getContract());
                domainInfo.setChargeCurrency(resultDTO.getCompanyFinance());
                QueryWrapper domainQueryWrapper = new QueryWrapper();
                domainQueryWrapper.lambda().eq(PurchaseOrganizationInfo::getOrgCategoryCode, (Object)PurchaseOrgCategoryStatus.FACTORY.getValue());
                domainQueryWrapper.lambda().eq(PurchaseOrganizationInfo::getOrgCode, (Object)resultDTO.getContract());
                List dbFactoryList = this.list((Wrapper)domainQueryWrapper);
                if (CollectionUtil.isNotEmpty((Collection)dbFactoryList)) {
                    domainInfo.setId(((PurchaseOrganizationInfo)((Object)dbFactoryList.get(0))).getId());
                    updList.add(domainInfo);
                    continue;
                }
                addList.add(domainInfo);
            }
            if (addList != null && addList.size() > 0) {
                this.saveBatch(addList, 200);
            }
            if (updList != null && updList.size() > 0) {
                this.updateBatchById(updList, 200);
            }
        }
    }

    @Override
    public void updatePurchaseOrganizationInfo(PurchaseOrganizationInfo purchaseOrganizationInfo) {
        int count;
        if (StrUtil.isNotEmpty((CharSequence)purchaseOrganizationInfo.getOrgCode())) {
            this.checkOrgData(purchaseOrganizationInfo);
        }
        if ((count = ((PurchaseOrganizationInfoMapper)this.baseMapper).updateById((Object)purchaseOrganizationInfo)) == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.deleteRedis("purchase_organization_info");
    }

    public void checkOrgData(PurchaseOrganizationInfo purchaseOrganizationInfo) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(PurchaseOrganizationInfo::getOrgCategoryCode, (Object)purchaseOrganizationInfo.getOrgCategoryCode())).eq(PurchaseOrganizationInfo::getOrgCode, (Object)purchaseOrganizationInfo.getOrgCode())).ne(null != purchaseOrganizationInfo.getId(), BaseEntity::getId, (Object)purchaseOrganizationInfo.getId());
        Integer count = this.purchaseOrganizationInfoMapper.selectCount((Wrapper)queryWrapper);
        if (count > 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APjVRAonVRAcIOMKWVImW_14a4b4dd", (String)"\u5f53\u524d\u7684\u7ec4\u7ec7\u7f16\u7801\u548c\u7ec4\u7ec7\u7c7b\u578b\u5df2\u7ecf\u5b58\u5728,\u8bf7\u68c0\u67e5!"));
        }
    }

    @Override
    public void delPurchaseOrganizationInfo(String id) {
        ((PurchaseOrganizationInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.deleteRedis("purchase_organization_info");
    }

    @Override
    public void delBatchPurchaseOrganizationInfo(List<String> idList) {
        ((PurchaseOrganizationInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public Map<String, Object> getSuperiorOrganization() {
        List<TreeOrgNode> list = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectByElsAccount(TenantContext.getTenant());
        ArrayList<TreeOrgNode> copyList = new ArrayList<TreeOrgNode>();
        for (TreeOrgNode node : list) {
            node.setKey(node.getId());
            node.setValue(node.getId());
            TreeOrgNode newNode = new TreeOrgNode();
            SysUtil.copyProperties((Object)node, (Object)newNode);
            copyList.add(newNode);
        }
        List superBusinessList = list.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getSuperBusinessId()) && !"1".equals(o.getOrgNature())).collect(Collectors.toList());
        List superExecutiveList = copyList.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getSuperExecutiveId()) && !"0".equals(o.getOrgNature())).collect(Collectors.toList());
        Map<String, List<TreeOrgNode>> businessCollect = list.parallelStream().filter(vo -> vo.getSuperBusinessId() != null).collect(Collectors.groupingBy(TreeOrgNode::getSuperBusinessId));
        Map<String, List<TreeOrgNode>> executiveCollect = copyList.parallelStream().filter(vo -> vo.getSuperExecutiveId() != null).collect(Collectors.groupingBy(TreeOrgNode::getSuperExecutiveId));
        for (TreeOrgNode node : superBusinessList) {
            this.forEach(businessCollect, node, 1);
        }
        for (TreeOrgNode node : superExecutiveList) {
            this.forEach(executiveCollect, node, 1);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("business", superBusinessList);
        resultMap.put("executive", superExecutiveList);
        return resultMap;
    }

    @Override
    public List<TreeOrgNode> getExecutiveOrganization() {
        List<TreeOrgNode> list = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectExecutiveTree(TenantContext.getTenant());
        for (TreeOrgNode node : list) {
            node.setKey(node.getId());
            node.setValue(node.getId());
        }
        List<TreeOrgNode> superExecutiveList = list.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getSuperExecutiveId())).collect(Collectors.toList());
        Map<String, List<TreeOrgNode>> executiveCollect = list.parallelStream().filter(vo -> vo.getSuperExecutiveId() != null).collect(Collectors.groupingBy(TreeOrgNode::getSuperExecutiveId));
        for (TreeOrgNode node : superExecutiveList) {
            this.forEach(executiveCollect, node, 1);
        }
        return superExecutiveList;
    }

    @Override
    public List<TreeOrgNode> getNatureExecutiveOrganization() {
        List<TreeOrgNode> list = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectNatureExecutiveTree(TenantContext.getTenant());
        for (TreeOrgNode node : list) {
            node.setKey(node.getId());
            node.setValue(node.getId());
        }
        List<TreeOrgNode> superExecutiveList = list.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getSuperExecutiveId())).collect(Collectors.toList());
        Map<String, List<TreeOrgNode>> executiveCollect = list.parallelStream().filter(vo -> vo.getSuperExecutiveId() != null).collect(Collectors.groupingBy(TreeOrgNode::getSuperExecutiveId));
        for (TreeOrgNode node : superExecutiveList) {
            this.forEach(executiveCollect, node, 1);
        }
        return superExecutiveList;
    }

    @Override
    public List<TreeOrgNode> getNatureExecutiveOrganizationNew() {
        List<TreeOrgNode> list = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectNatureExecutiveTree(TenantContext.getTenant());
        for (TreeOrgNode node : list) {
            node.setKey(node.getId());
            node.setValue(node.getId());
        }
        List superExecutiveList = list.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getSuperExecutiveId())).collect(Collectors.toList());
        list = this.buildTree(list, "");
        return list;
    }

    private List<TreeOrgNode> buildTree(List<TreeOrgNode> all, String rootId) {
        ArrayList parent = Lists.newArrayList();
        List ids = all.stream().map(TreeOrgNode::getValue).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList());
        for (TreeOrgNode commentNode : all) {
            commentNode.setChildren(this.getChildren(commentNode, all));
            if (!CharSequenceUtil.isEmpty((CharSequence)commentNode.getSuperExecutiveId()) && ids.contains(commentNode.getSuperExecutiveId()) || commentNode.getValue().equals(commentNode.getSuperExecutiveId())) continue;
            parent.add(commentNode);
        }
        return parent;
    }

    private List<TreeOrgNode> getChildren(TreeOrgNode commentNode, List<TreeOrgNode> all) {
        ArrayList<TreeOrgNode> childList = new ArrayList<TreeOrgNode>(8);
        for (TreeOrgNode child : all) {
            if (!commentNode.getValue().equals(child.getSuperExecutiveId()) || commentNode.getId().equals(commentNode.getSuperExecutiveId())) continue;
            child.setChildren(this.getChildren(child, all));
            childList.add(child);
        }
        return childList;
    }

    @Override
    public List<TreeOrgNode> getFactoryOrganization() {
        List<TreeOrgNode> list = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectOrganization(TenantContext.getTenant(), "factory");
        list.forEach(node -> {
            node.setKey(node.getId());
            node.setValue(node.getId());
        });
        return list;
    }

    @Override
    public void frozen(String id, String status) {
        PurchaseOrganizationInfo purchaseOrganizationInfo = (PurchaseOrganizationInfo)((Object)((PurchaseOrganizationInfoMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        PurchaseOrganizationInfo org = new PurchaseOrganizationInfo();
        org.setId(id);
        org.setStatus(status);
        if (PurchaseOrganizationStatus.NORMAL.getValue().equals(status)) {
            org.setEnableTime(new Date());
        } else if (PurchaseOrganizationStatus.FROZEN.getValue().equals(status)) {
            org.setFreezeTime(new Date());
        }
        int count = ((PurchaseOrganizationInfoMapper)this.baseMapper).updateById((Object)org);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        StringBuffer redisKey = new StringBuffer("sys:cache:dict");
        redisKey.append(TenantContext.getTenant()).append(COLON).append("purchase_organization_info");
        StringBuffer redisKeys = new StringBuffer(CATALOGUE3);
        redisKeys.append(TenantContext.getTenant()).append(COLON).append("purchase_organization_info");
        this.redisUtil.deleteByPrex(redisKey.toString());
        this.redisUtil.deleteByPrex(redisKeys.toString());
        if (!ObjectUtils.isEmpty((Object)((Object)purchaseOrganizationInfo))) {
            ArrayList<PurchaseOrganizationInfo> list = new ArrayList<PurchaseOrganizationInfo>();
            list.add(purchaseOrganizationInfo);
            ArrayList purchaseOrganizationInfoDTOS = SysUtil.copyProperties(list, PurchaseOrganizationInfoDTO.class);
            MqUtil.sendOperateEventMsg((String)TenantContext.getTenant(), (String)"PurchaseOrganizationInfo", (String)"delete", (String)"deleteOrgDataToMall", (Object)purchaseOrganizationInfoDTOS);
        }
    }

    private void forEach(Map<String, List<TreeOrgNode>> collect, TreeOrgNode treeOrgNode, Integer level) {
        List<TreeOrgNode> treeOrgNodelist = collect.get(treeOrgNode.getValue());
        treeOrgNode.setLevel(level);
        if (collect.get(treeOrgNode.getValue()) != null) {
            treeOrgNode.setChildren(treeOrgNodelist);
            treeOrgNode.setHasChildren(true);
            Integer n = level;
            Integer n2 = level = Integer.valueOf(level + 1);
            Integer finalLevel = level;
            treeOrgNode.getChildren().forEach(t -> this.forEach(collect, (TreeOrgNode)t, finalLevel));
        }
    }

    @Override
    public List<PurchaseOrganizationInfo> getOrgBySubAccount(String subAccount) {
        String elsAccount = TenantContext.getTenant();
        ElsSubAccountDTO subUser = this.invokeAccountRpcService.getAccount(elsAccount, subAccount);
        List<PurchaseOrganizationInfo> orgList = new ArrayList<PurchaseOrganizationInfo>();
        if (subUser != null && StringUtils.isNotBlank((CharSequence)subUser.getOrgCode())) {
            List<String> userOrgCodeId = Arrays.asList(subUser.getOrgCode().split(","));
            LambdaQueryWrapper orgWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)orgWrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).in(BaseEntity::getId, userOrgCodeId)).eq(PurchaseOrganizationInfo::getStatus, (Object)PurchaseOrganizationStatus.NORMAL.getValue());
            orgList = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectList((Wrapper)orgWrapper);
        }
        return orgList;
    }

    @Override
    public Map<String, String> getOrganizationByCode(String elsAccount, String orgCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(PurchaseOrganizationInfo::getOrgCategoryCode, (Object)orgCode);
        List deptOrg = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)deptOrg)) {
            return deptOrg.stream().collect(Collectors.toMap(PurchaseOrganizationInfo::getOrgCode, purchaseOrganizationInfo -> purchaseOrganizationInfo.getOrgDesc() == null ? "" : purchaseOrganizationInfo.getOrgDesc()));
        }
        return new HashMap<String, String>();
    }

    @Override
    public List<PurchaseOrganizationInfo> getOrgForCalendar(String elsAccount, String orgCategoryCode) {
        return ((PurchaseOrganizationInfoMapper)this.baseMapper).selectOrgCalendar(elsAccount, orgCategoryCode);
    }

    @Override
    public List<TreeOrgNode> getOrgCascader() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(PurchaseOrganizationInfo::getStatus, (Object)PurchaseOrganizationStatus.NORMAL.getValue());
        List orgList = this.list((Wrapper)queryWrapper);
        ArrayList<TreeOrgNode> orgTreeList = new ArrayList<TreeOrgNode>();
        for (PurchaseOrganizationInfo org : orgList) {
            TreeOrgNode tree = new TreeOrgNode();
            tree.setKey(org.getId());
            tree.setTitle(org.getOrgName());
            tree.setValue(org.getOrgCode());
            tree.setOrgType(org.getOrgCategoryCode());
            orgTreeList.add(tree);
        }
        Map<String, List<TreeOrgNode>> orgMap = orgTreeList.stream().filter(vo -> StringUtils.isNotBlank((CharSequence)vo.getValue()) && StringUtils.isNotBlank((CharSequence)vo.getOrgType())).collect(Collectors.groupingBy(TreeOrgNode::getOrgType));
        ArrayList<TreeOrgNode> categoryList = new ArrayList<TreeOrgNode>();
        for (PurchaseOrgCategoryStatus orgCategoryStatus : PurchaseOrgCategoryStatus.values()) {
            if (!orgMap.containsKey(orgCategoryStatus.getValue())) continue;
            TreeOrgNode categoryTree = new TreeOrgNode();
            categoryTree.setValue(orgCategoryStatus.getValue());
            categoryTree.setTitle(orgCategoryStatus.getDesc());
            categoryTree.setChildren(orgMap.get(orgCategoryStatus.getValue()));
            categoryList.add(categoryTree);
        }
        return categoryList;
    }

    @Override
    public Map<String, String> listDeptOrganization(List<String> ids) {
        if (CollUtil.isEmpty(ids)) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select(new SFunction[]{BaseEntity::getId, PurchaseOrganizationInfo::getOrgCode, PurchaseOrganizationInfo::getOrgName});
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).in(BaseEntity::getId, ids);
        List organizationInfoList = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return organizationInfoList.stream().collect(Collectors.toMap(BaseEntity::getId, x -> x.getOrgCode() + "_" + x.getOrgName(), (v1, v2) -> v2));
    }

    private void deleteRedis(String table) {
        StringBuffer redisKey = new StringBuffer(CATALOGUE);
        redisKey.append(TenantContext.getTenant()).append(COLON).append(table);
        this.redisUtil.deleteByPrex(redisKey.toString());
    }

    @Override
    public void deleteRedisCache() {
        StringBuffer redisKey = new StringBuffer(CATALOGUE);
        redisKey.append(TenantContext.getTenant()).append(COLON).append("purchase_organization_info");
        this.redisUtil.deleteByPrex(redisKey.toString());
        redisKey = new StringBuffer("sys:cache:dict");
        redisKey.append(TenantContext.getTenant()).append(COLON).append("purchase_organization_info");
        this.redisUtil.deleteByPrex(redisKey.toString());
        redisKey = new StringBuffer("sys:cache:dict");
        redisKey.append(TenantContext.getTenant()).append(COLON).append("purchase_organization_info");
        this.redisUtil.deleteByPrex(redisKey.toString());
        redisKey = new StringBuffer("sys:cache:dict");
        this.redisUtil.deleteByPrex(redisKey.toString());
    }

    @Override
    public Map<String, String> getDeptOrganization(String elsAccount) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(PurchaseOrganizationInfo::getOrgCategoryCode, (Object)"dept");
        List deptOrg = this.list((Wrapper)queryWrapper);
        return deptOrg.stream().collect(Collectors.toMap(PurchaseOrganizationInfo::getOrgCode, BaseEntity::getId, (v1, v2) -> v2));
    }

    @Override
    public Map<String, String> mapIdsByOrgCodeAndOrgCategoryCode(List<String> all) {
        if (CollUtil.isEmpty(all)) {
            return Maps.newHashMap();
        }
        List<PurchaseOrganizationInfoDTO> list = ((PurchaseOrganizationInfoMapper)this.baseMapper).listOrganizationInfoByTypeAndCode(all, TenantContext.getTenant());
        return list.stream().collect(Collectors.toMap(x -> x.getOrgCategoryCode() + "," + x.getOrgCode(), BaseDTO::getId, (v1, v2) -> v2));
    }

    @Override
    public Map<String, String> mapIdsByOrgCode(List<String> orgCodeList) {
        if (CollUtil.isEmpty(orgCodeList)) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select(new SFunction[]{BaseEntity::getId, PurchaseOrganizationInfo::getOrgCode, PurchaseOrganizationInfo::getOrgName, PurchaseOrganizationInfo::getOrgCategoryCode});
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).in(PurchaseOrganizationInfo::getOrgCode, orgCodeList);
        List organizationInfoList = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return organizationInfoList.stream().collect(Collectors.toMap(PurchaseOrganizationInfo::getOrgCode, BaseEntity::getId, (v1, v2) -> v2));
    }

    @Override
    public int countOrgCode(List<String> codes, String elsAccount) {
        if (CollUtil.isEmpty(codes)) {
            return 0;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.in(PurchaseOrganizationInfo::getOrgCode, codes)).eq(BaseEntity::getElsAccount, (Object)elsAccount);
        return ((PurchaseOrganizationInfoMapper)this.baseMapper).selectCount((Wrapper)queryWrapper);
    }

    @Override
    public boolean checkOrgCode(String orgCode) {
        List<String> orgCodeList = Arrays.asList(orgCode.split(","));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).in(BaseEntity::getId, orgCodeList);
        List organizationInfoList = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return organizationInfoList.stream().anyMatch(a -> "companyCode".equals(a.getOrgCategoryCode()));
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        InterfaceUtil interfaceUtil = (InterfaceUtil)SpringContextUtils.getBean(InterfaceUtil.class);
        interfaceUtil.callInterface(elsAccount, "getDeptData", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List purchaseOrganizationInfoList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchaseOrganizationInfo organizationInfo : purchaseOrganizationInfoList) {
            this.pushDataToErp(organizationInfo);
        }
    }

    private void pushDataToErp(PurchaseOrganizationInfo organizationInfo) {
        String elsAccount = TenantContext.getTenant();
        InterfaceUtil interfaceUtil = (InterfaceUtil)SpringContextUtils.getBean(InterfaceUtil.class);
        interfaceUtil.callInterface(elsAccount, "pushOrgData", (Object)organizationInfo);
    }
}

