/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.extend.api.common.enumerate.RafflesInterfaceEnum;
import com.els.modules.extend.api.common.utils.IFSInterfaceUtils;
import com.els.modules.extend.api.dto.ifs.request.IFSRequestBaseDTO;
import com.els.modules.extend.api.dto.ifs.request.IFSRequestBaseHeadDTO;
import com.els.modules.extend.api.dto.ifs.request.item.IFSRequestGetProjectDTO;
import com.els.modules.extend.api.dto.ifs.result.IFSResultBaseDTO;
import com.els.modules.extend.api.dto.ifs.result.item.IFSGetProjectDetailResultDTO;
import com.els.modules.extend.api.dto.ifs.result.item.IFSGetProjectResultDTO;
import com.els.modules.project.entity.ERPProjectInfo;
import com.els.modules.project.mapper.ERPProjectInfoMapper;
import com.els.modules.project.service.ERPProjectInfoService;
import com.els.modules.project.vo.ProjectInfoDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ERPProjectInfoServiceImpl
extends BaseServiceImpl<ERPProjectInfoMapper, ERPProjectInfo>
implements ERPProjectInfoService {
    @Resource
    private ERPProjectInfoMapper erpProjectInfoMapper;
    @Autowired
    InterfaceUtil interfaceUtil;

    @Override
    public void add(ERPProjectInfo eRPProjectInfo) {
        ((ERPProjectInfoMapper)this.baseMapper).insert((Object)eRPProjectInfo);
    }

    @Override
    public void edit(ERPProjectInfo eRPProjectInfo) {
        int count = ((ERPProjectInfoMapper)this.baseMapper).updateById((Object)eRPProjectInfo);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((ERPProjectInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((ERPProjectInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public JSONObject erpProjectInfoToSRM(JSONObject param) {
        ArrayList<ERPProjectInfo> addList = new ArrayList<ERPProjectInfo>();
        ArrayList<ERPProjectInfo> updList = new ArrayList<ERPProjectInfo>();
        if (!param.containsKey((Object)"headList")) {
            throw new RuntimeException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String account = TenantContext.getTenant();
        Date currentTime = new Date();
        String dataList = String.valueOf(param.get((Object)"headList"));
        List infoList = JSONArray.parseArray((String)dataList, ProjectInfoDTO.class);
        for (ProjectInfoDTO dto : infoList) {
            ERPProjectInfo org = new ERPProjectInfo();
            if (StringUtils.isEmpty((CharSequence)dto.getCompany())) {
                throw new RuntimeException("Company[\u516c\u53f8\u7f16\u53f7] \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((CharSequence)dto.getProject_Id())) {
                throw new RuntimeException("Project_Id[\u9879\u76ee\u4ee3\u7801] \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            org.setCompany(dto.getCompany());
            org.setProjectId(dto.getProject_Id());
            org.setProjectName(dto.getProject_Name());
            org.setPlanStart(dto.getPlan_Start());
            org.setPlanFinish(dto.getPlan_Finish());
            org.setManager(dto.getManager());
            org.setPurMgr(dto.getPUR_MGR());
            org.setBudgOpr(dto.getBUDG_OPR());
            org.setBudgetControlOn(dto.getBUDGET_CONTROL_ON());
            org.setCustomerId(dto.getCustomer_Id());
            org.setCategory1Id(dto.getCATEGORY1_ID());
            org.setState(dto.getState());
            List list = this.erpProjectInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ERPProjectInfo::getCompany, (Object)org.getCompany())).eq(ERPProjectInfo::getProjectId, (Object)org.getProjectId()));
            if (list != null && list.size() > 0) {
                org.setId(((ERPProjectInfo)((Object)list.get(0))).getId());
                updList.add(org);
                continue;
            }
            org.setElsAccount(account);
            org.setCreateTime(currentTime);
            org.setCreateBy("interface");
            org.setUpdateBy(org.getCreateBy());
            org.setDeleted(CommonConstant.DEL_FLAG_0);
            org.setId(IdWorker.getIdStr());
            addList.add(org);
        }
        if (addList != null && addList.size() > 0) {
            this.saveBatch(addList, 200);
        }
        if (updList != null && updList.size() > 0) {
            this.updateBatchById(updList, 200);
        }
        return null;
    }

    @Override
    public void getProjectByIFS() {
        JSONObject resultObj;
        TenantContext.setTenant((String)"3107679");
        IFSRequestBaseDTO requestBaseDTO = new IFSRequestBaseDTO();
        ArrayList<ERPProjectInfo> addList = new ArrayList<ERPProjectInfo>();
        ArrayList<ERPProjectInfo> updList = new ArrayList<ERPProjectInfo>();
        IFSRequestBaseHeadDTO requestBaseHead = IFSInterfaceUtils.getIFSRequestBaseHead((String)RafflesInterfaceEnum.GET_PROJECT.getThirdInterfaceCode(), (String)"2023-08-03 13:36:30", (String)"20230803133630");
        requestBaseDTO.setHead(requestBaseHead);
        IFSRequestGetProjectDTO getProjectDTO = new IFSRequestGetProjectDTO();
        getProjectDTO.setCompany("21");
        DateTime beginDateTime = DateUtil.parse((CharSequence)"2020-01-07", (String)"yyyy-MM-dd");
        DateTime endDateTime = DateUtil.parse((CharSequence)"2021-01-07", (String)"yyyy-MM-dd");
        getProjectDTO.setDateBegin((Date)beginDateTime);
        getProjectDTO.setDateEnd((Date)endDateTime);
        ArrayList<IFSRequestGetProjectDTO> dataList = new ArrayList<IFSRequestGetProjectDTO>();
        dataList.add(getProjectDTO);
        requestBaseDTO.setBody(dataList);
        JSONObject param = new JSONObject();
        param.put("bus_account", (Object)"3107679");
        param.put("srm_interface_code", (Object)"syncProjectByIFS");
        param.put("body", (Object)JSON.parseObject((String)JSONObject.toJSONString((Object)requestBaseDTO)));
        try {
            resultObj = this.interfaceUtil.callInterface("3107679", null, param, null);
        }
        catch (Exception e) {
            String errorMsg = "SRM\u62c9\u53d6IFS\u9879\u76ee\u4fe1\u606f\u63a5\u53e3\uff1a" + e.getMessage();
            this.log.error(errorMsg);
            throw new ELSBootException(errorMsg);
        }
        IFSResultBaseDTO resultBaseDTO = (IFSResultBaseDTO)JSONObject.toJavaObject((JSON)resultObj.getJSONObject("result"), IFSResultBaseDTO.class);
        if (Objects.isNull(resultBaseDTO.getBody())) {
            throw new ELSBootException("SRM\u62c9\u53d6IFS\u9879\u76ee\u4fe1\u606f\u63a5\u53e3\uff1a\u8fd4\u56deresultBaseDTO\u6570\u636e\u4e3a\u7a7a");
        }
        IFSGetProjectResultDTO getProjectResultDTO = (IFSGetProjectResultDTO)JSONObject.toJavaObject((JSON)JSON.parseObject((String)JSONObject.toJSONString((Object)resultBaseDTO.getBody())), IFSGetProjectResultDTO.class);
        List list = getProjectResultDTO.getList();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (IFSGetProjectDetailResultDTO resultDTO : list) {
                ERPProjectInfo data = new ERPProjectInfo();
                BeanUtils.copyProperties((Object)resultDTO, (Object)((Object)data));
                data.setElsAccount("3107679");
                data.setUpdateBy("1001");
                data.setSourceSystem("ifs");
                List<ERPProjectInfo> projectInfoList = this.getDbProject(resultDTO.getProjectId());
                if (CollectionUtil.isNotEmpty(projectInfoList)) {
                    data.setId(projectInfoList.get(0).getId());
                    updList.add(data);
                    continue;
                }
                data.setId(IdWorker.getIdStr());
                data.setCreateBy("1001");
                addList.add(data);
            }
            if (addList != null && addList.size() > 0) {
                this.saveBatch(addList, 200);
            }
            if (updList != null && updList.size() > 0) {
                this.updateBatchById(updList, 200);
            }
        }
    }

    private List<ERPProjectInfo> getDbProject(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ERPProjectInfo::getProjectId, (Object)projectId);
        List dbList = this.list((Wrapper)queryWrapper);
        return dbList;
    }
}

