/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.thirddata.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.thirddata.entity.CustodianInformation;
import com.els.modules.thirddata.mapper.CustodianInformationMapper;
import com.els.modules.thirddata.service.CustodianInformationService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class CustodianInformationServiceImpl
extends BaseServiceImpl<CustodianInformationMapper, CustodianInformation>
implements CustodianInformationService {
    @Override
    public void add(CustodianInformation custodianInformation) {
        ((CustodianInformationMapper)this.baseMapper).insert((Object)custodianInformation);
    }

    @Override
    public void edit(CustodianInformation custodianInformation) {
        int count = ((CustodianInformationMapper)this.baseMapper).updateById((Object)custodianInformation);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((CustodianInformationMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((CustodianInformationMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public JSONObject syncCustodianInformationToSrm(JSONObject param) {
        ArrayList<CustodianInformation> addList = new ArrayList<CustodianInformation>();
        ArrayList<CustodianInformation> updList = new ArrayList<CustodianInformation>();
        if (!param.containsKey((Object)"headList")) {
            throw new RuntimeException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String account = TenantContext.getTenant();
        Date currentTime = new Date();
        String dataList = String.valueOf(param.get((Object)"headList"));
        List infoList = JSONArray.parseArray((String)dataList, CustodianInformation.class);
        for (CustodianInformation dto : infoList) {
            if (StringUtils.isEmpty((CharSequence)dto.getCustodianCode())) {
                throw new RuntimeException("custodianCode[\u63a5\u6536\u4eba] \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((CharSequence)dto.getCategoryCode())) {
                throw new RuntimeException("categoryCode[\u7269\u8d44\u7c7b\u578b\u7f16\u7801] \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((CharSequence)dto.getCompanyName())) {
                throw new RuntimeException("companyName[\u516c\u53f8] \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            List list = ((CustodianInformationMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustodianInformation::getCompanyName, (Object)dto.getCompanyName())).eq(CustodianInformation::getCategoryCode, (Object)dto.getCategoryCode())).eq(CustodianInformation::getCustodianCode, (Object)dto.getCustodianCode()));
            if (list != null && list.size() > 0) {
                dto.setId(((CustodianInformation)((Object)list.get(0))).getId());
                updList.add(dto);
                continue;
            }
            dto.setElsAccount(account);
            dto.setCreateTime(currentTime);
            dto.setCreateBy("interface");
            dto.setUpdateBy(account);
            dto.setDeleted(CommonConstant.DEL_FLAG_0);
            dto.setId(IdWorker.getIdStr());
            addList.add(dto);
        }
        if (addList != null && addList.size() > 0) {
            this.saveBatch(addList, 200);
        }
        if (updList != null && updList.size() > 0) {
            this.updateBatchById(updList, 200);
        }
        return null;
    }
}

