/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.excel;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.entity.PurchaseBomHead;
import com.els.modules.material.mapper.PurchaseBomHeadMapper;
import com.els.modules.material.service.PurchaseBomHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="purchaseBomExcelHandler")
public class PurchaseBomExcelHandler
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseBomHeadService purchaseBomHeadService;
    @Resource
    private PurchaseBomHeadMapper purchaseBomHeadMapper;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("bom");
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"i18n_alert_VWERWWWBtESIrW_b04008e2", (String)"\u8bf7\u5148\u914d\u7f6eBOM\u8868\u5355\u4e1a\u52a1\u6a21\u677f\u3002"));
        ArrayList<PurchaseBomHead> entityList = new ArrayList<PurchaseBomHead>();
        List headList = this.purchaseBomHeadMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant()));
        Map<String, String> headMap = headList.parallelStream().collect(Collectors.toMap(p -> p.getMaterialNumber() + "_" + p.getFactory() + "_" + p.getVersion(), BaseEntity::getId, (k1, k2) -> k1));
        for (Map data : dataList) {
            PurchaseBomHead entity = (PurchaseBomHead)((Object)this.transferEntity(data, PurchaseBomHead.class, excelImportDTO));
            if (null == entity) continue;
            String key = entity.getMaterialNumber() + "_" + entity.getFactory() + "_" + entity.getVersion();
            if (headMap.containsKey(key)) {
                String msg = I18nUtil.translate((String)"", (String)"\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u6570\u636e") + key;
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            entity.setElsAccount(TenantContext.getTenant());
            entity.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            entity.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            entity.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion());
            entity.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
            entityList.add(entity);
        }
        int size = entityList.size();
        List nextCodes = this.invokeBaseRpcService.getNextCodes("bomNumber", entityList.get(0), size);
        int codeIndex = 0;
        for (PurchaseBomHead e : entityList) {
            e.setBomNumber((String)nextCodes.get(codeIndex++));
        }
        if (!entityList.isEmpty()) {
            this.purchaseBomHeadService.saveBatch(entityList);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

