/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.license.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.extend.api.constant.CommonExtConstant;
import com.els.modules.license.entity.PurchaseMaterialLicense;
import com.els.modules.license.entity.SaleMaterialLicense;
import com.els.modules.license.enumerate.MaterialLicenseCreatePortEnum;
import com.els.modules.license.enumerate.MaterialLicenseOptStatusEnum;
import com.els.modules.license.enumerate.MaterialLicenseSourceTypeEnum;
import com.els.modules.license.mapper.PurchaseMaterialLicenseMapper;
import com.els.modules.license.mapper.SaleMaterialLicenseMapper;
import com.els.modules.license.service.PurchaseMaterialLicenseService;
import com.els.modules.license.service.SaleMaterialLicenseService;
import com.els.modules.license.vo.PurchaseMaterialLicenseVo;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PurchaseMaterialLicenseServiceImpl
extends BaseServiceImpl<PurchaseMaterialLicenseMapper, PurchaseMaterialLicense>
implements PurchaseMaterialLicenseService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseMaterialLicenseServiceImpl.class);
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    @Lazy
    private SaleMaterialLicenseService saleMaterialLicenseService;
    @Resource
    private PurchaseMaterialLicenseMapper purchaseMaterialLicenseMapper;
    @Resource
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Resource
    private SaleMaterialLicenseMapper saleMaterialLicenseMapper;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void savePurchaseMaterialLicense(PurchaseMaterialLicense purchaseMaterialLicense) {
        this.baseValueCheck(purchaseMaterialLicense);
        ((PurchaseMaterialLicenseServiceImpl)SpringUtil.getBean(this.getClass())).updateOldDataInvalidByWrapper(Collections.singletonList(purchaseMaterialLicense));
        purchaseMaterialLicense.setCreatePort(MaterialLicenseCreatePortEnum.PURCHASE.getValue());
        purchaseMaterialLicense.setOptStatus(MaterialLicenseOptStatusEnum.PURCHASE_CONFIRMED.getValue());
        String validStatus = this.getValidStatus(purchaseMaterialLicense.getEffectiveDate(), purchaseMaterialLicense.getExpiryDate());
        purchaseMaterialLicense.setValidStatus(validStatus);
        purchaseMaterialLicense.setSourceType(MaterialLicenseSourceTypeEnum.PURCHASE_CREATE.getValue());
        purchaseMaterialLicense.setRequirePort(SysUtil.getUserRealName());
        purchaseMaterialLicense.setBusAccount(SysUtil.getPurchaseAccount());
        ((PurchaseMaterialLicenseMapper)this.baseMapper).insert((Object)purchaseMaterialLicense);
    }

    private void baseValueCheck(PurchaseMaterialLicense purchaseMaterialLicense) {
        Assert.notBlank((CharSequence)purchaseMaterialLicense.getMaterialNumber(), (String)I18nUtil.translate((String)"", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[0]);
        Assert.notBlank((CharSequence)purchaseMaterialLicense.getPurchaseOrg(), (String)I18nUtil.translate((String)"", (String)"\u91c7\u8d2d\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[0]);
        Assert.notBlank((CharSequence)purchaseMaterialLicense.getLicenseType(), (String)I18nUtil.translate((String)"", (String)"\u8bc1\u7167\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[0]);
    }

    @Override
    public void updateOldDataInvalidByWrapper(List<PurchaseMaterialLicense> purchaseMaterialLicenses) {
        UpdateWrapper purchaseUpdateWrapper = new UpdateWrapper();
        UpdateWrapper saleUpdateWrapper = new UpdateWrapper();
        purchaseMaterialLicenses.forEach(purchaseMaterialLicense -> {
            purchaseUpdateWrapper.lambda().or(i -> {
                LambdaUpdateWrapper cfr_ignored_0 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)i.eq(PurchaseMaterialLicense::getValidStatus, (Object)"1")).eq(PurchaseMaterialLicense::getMaterialNumber, (Object)purchaseMaterialLicense.getMaterialNumber())).eq(PurchaseMaterialLicense::getLicenseType, (Object)purchaseMaterialLicense.getLicenseType())).eq(PurchaseMaterialLicense::getPurchaseOrg, (Object)purchaseMaterialLicense.getPurchaseOrg());
            });
            saleUpdateWrapper.lambda().or(i -> {
                LambdaUpdateWrapper cfr_ignored_0 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)i.eq(SaleMaterialLicense::getValidStatus, (Object)"1")).eq(SaleMaterialLicense::getMaterialNumber, (Object)purchaseMaterialLicense.getMaterialNumber())).eq(SaleMaterialLicense::getLicenseType, (Object)purchaseMaterialLicense.getLicenseType())).eq(SaleMaterialLicense::getPurchaseOrg, (Object)purchaseMaterialLicense.getPurchaseOrg());
            });
        });
        this.purchaseMaterialLicenseMapper.updateOldDataInvalid((Wrapper<PurchaseMaterialLicense>)purchaseUpdateWrapper);
        this.saleMaterialLicenseMapper.updateOldDataInvalid((Wrapper<SaleMaterialLicense>)saleUpdateWrapper);
    }

    @Override
    public String getValidStatus(Date effectiveDate, Date expiryDate) {
        String validStatus = "0";
        Date currentDate = new Date();
        if (ObjectUtil.isNotEmpty((Object)effectiveDate) && ObjectUtil.isNotEmpty((Object)expiryDate)) {
            if (effectiveDate.compareTo(currentDate) <= 0 && expiryDate.compareTo(currentDate) >= 0) {
                validStatus = "1";
            }
            if (expiryDate.compareTo(currentDate) < 0) {
                validStatus = "2";
            }
        }
        return validStatus;
    }

    @Override
    public List<PurchaseMaterialLicense> getValidByToElsAndMaterialNumber(Map<String, Set<String>> toElsAccountAndMaterialNumberMap) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(BaseEntity::getDeleted, (Object)CommonExtConstant.DEL_FLAG_0)).eq(PurchaseMaterialLicense::getValidStatus, (Object)"1")).and(ai -> toElsAccountAndMaterialNumberMap.forEach((toEls, materialNumbers) -> ai.or(io -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)io.eq(PurchaseMaterialLicense::getToElsAccount, toEls)).in(PurchaseMaterialLicense::getMaterialNumber, (Collection)materialNumbers);
        })));
        return ((PurchaseMaterialLicenseMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<PurchaseMaterialLicense> getValidByMaterialNumbers(Collection<String> materialNumbers) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(BaseEntity::getDeleted, (Object)CommonExtConstant.DEL_FLAG_0)).eq(PurchaseMaterialLicense::getValidStatus, (Object)"1")).in(PurchaseMaterialLicense::getMaterialNumber, materialNumbers);
        return ((PurchaseMaterialLicenseMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<PurchaseMaterialLicense> getInvalidByToElsAndMaterialNumber(Map<String, Set<String>> toElsAccountAndMaterialNumberMap) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(BaseEntity::getDeleted, (Object)CommonExtConstant.DEL_FLAG_0)).and(ai -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)ai.eq(PurchaseMaterialLicense::getValidStatus, (Object)"2")).or(oi -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)oi.le(PurchaseMaterialLicense::getExpiryDate, (Object)new Date());
            });
        })).and(ai -> toElsAccountAndMaterialNumberMap.forEach((toEls, materialNumbers) -> ai.or(io -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)io.eq(PurchaseMaterialLicense::getToElsAccount, toEls)).in(PurchaseMaterialLicense::getMaterialNumber, (Collection)materialNumbers);
        })));
        return ((PurchaseMaterialLicenseMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<PurchaseMaterialLicense> getInvalidByMaterialNumbers(Collection<String> materialNumbers) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(BaseEntity::getDeleted, (Object)CommonExtConstant.DEL_FLAG_0)).eq(PurchaseMaterialLicense::getValidStatus, (Object)"2")).in(PurchaseMaterialLicense::getMaterialNumber, materialNumbers);
        return ((PurchaseMaterialLicenseMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public void updatePurchaseMaterialLicense(PurchaseMaterialLicenseVo purchaseMaterialLicenseVo) {
        List<PurchaseAttachmentDTO> attachmentList = purchaseMaterialLicenseVo.getAttachmentList();
        PurchaseMaterialLicense purchaseMaterialLicense = new PurchaseMaterialLicense();
        BeanUtil.copyProperties((Object)((Object)purchaseMaterialLicenseVo), (Object)((Object)purchaseMaterialLicense), (String[])new String[0]);
        this.baseValueCheck(purchaseMaterialLicense);
        PurchaseMaterialLicense dbPurchaseMaterialLicense = (PurchaseMaterialLicense)((Object)((PurchaseMaterialLicenseMapper)this.baseMapper).selectById((Serializable)((Object)purchaseMaterialLicense.getId())));
        Assert.notNull((Object)((Object)dbPurchaseMaterialLicense), (String)I18nUtil.translate((String)"", (String)"\u5546\u54c1\u8bc1\u7167\u4e0d\u5b58\u5728"), (Object[])new Object[0]);
        if (MaterialLicenseOptStatusEnum.PURCHASE_CONFIRMED.getValue().equals(dbPurchaseMaterialLicense.getOptStatus())) {
            ((PurchaseMaterialLicenseServiceImpl)SpringUtil.getBean(this.getClass())).updateOldDataInvalidByWrapper(Collections.singletonList(purchaseMaterialLicense));
            String validStatus = this.getValidStatus(purchaseMaterialLicense.getEffectiveDate(), purchaseMaterialLicense.getExpiryDate());
            purchaseMaterialLicense.setValidStatus(validStatus);
        }
        ((PurchaseMaterialLicenseMapper)this.baseMapper).updateById((Object)purchaseMaterialLicense);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseMaterialLicense.getId());
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            for (PurchaseAttachmentDTO entity : attachmentList) {
                entity.setId(null);
                entity.setHeadId(purchaseMaterialLicense.getId());
                entity.setElsAccount(purchaseMaterialLicense.getElsAccount());
                entity.setCreateBy(purchaseMaterialLicense.getCreateBy());
                entity.setCreateTime(purchaseMaterialLicense.getCreateTime());
                entity.setUpdateBy(purchaseMaterialLicense.getUpdateBy());
                entity.setUpdateTime(purchaseMaterialLicense.getUpdateTime());
                entity.setDeleted(CommonConstant.DEL_FLAG_0);
            }
        }
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(attachmentList);
        }
    }

    @Override
    public void delPurchaseMaterialLicense(String id) {
        ((PurchaseMaterialLicenseMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseMaterialLicense(List<String> idList) {
        ((PurchaseMaterialLicenseMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public PurchaseMaterialLicenseVo getCustomById(String id) {
        PurchaseMaterialLicense purchaseMaterialLicense = (PurchaseMaterialLicense)((Object)this.getById((Serializable)((Object)id)));
        PurchaseMaterialLicenseVo purchaseMaterialLicenseVo = (PurchaseMaterialLicenseVo)((Object)SysUtil.copyProperties((Object)((Object)purchaseMaterialLicense), PurchaseMaterialLicenseVo.class));
        List purchaseAttachmentDtos = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseMaterialLicenseVo.setAttachmentList(purchaseAttachmentDtos);
        return purchaseMaterialLicenseVo;
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void confirm(PurchaseMaterialLicense purchaseMaterialLicense) {
        PurchaseMaterialLicense dbPurchaseMaterialLicense = (PurchaseMaterialLicense)((Object)this.getById((Serializable)((Object)purchaseMaterialLicense.getId())));
        Assert.notNull((Object)((Object)dbPurchaseMaterialLicense), (String)I18nUtil.translate((String)"", (String)"\u5546\u54c1\u8bc1\u7167\u4e0d\u5b58\u5728"), (Object[])new Object[0]);
        Assert.isTrue((boolean)StrUtil.equalsAny((CharSequence)dbPurchaseMaterialLicense.getOptStatus(), (CharSequence[])new CharSequence[]{MaterialLicenseOptStatusEnum.WAIT_PURCHASE_CONFIRM.getValue(), I18nUtil.translate((String)"", (String)"\u53ea\u6709\u4f9b\u5e94\u5546\u65b0\u5efa\u3001\u91c7\u8d2d\u9000\u56de\u7684\u5355\u636e\u53ef\u4ee5\u7f16\u8f91")}));
        Assert.notBlank((CharSequence)dbPurchaseMaterialLicense.getMaterialNumber(), (String)I18nUtil.translate((String)"", (String)"\u7269\u6599\u7f16\u7801\u53ca\u76f8\u5173\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[0]);
        ((PurchaseMaterialLicenseServiceImpl)SpringUtil.getBean(this.getClass())).updateOldDataInvalidByWrapper(Collections.singletonList(purchaseMaterialLicense));
        dbPurchaseMaterialLicense.setOptStatus(MaterialLicenseOptStatusEnum.PURCHASE_CONFIRMED.getValue());
        String validStatus = this.getValidStatus(dbPurchaseMaterialLicense.getEffectiveDate(), dbPurchaseMaterialLicense.getExpiryDate());
        dbPurchaseMaterialLicense.setValidStatus(validStatus);
        LoginUser loginUser = SysUtil.getLoginUser();
        dbPurchaseMaterialLicense.setUpdateBy(loginUser.getSubAccount());
        dbPurchaseMaterialLicense.setUpdateTime(new Date());
        dbPurchaseMaterialLicense.setUpdateById(SysUtil.getCurrentId());
        ((PurchaseMaterialLicenseServiceImpl)SpringUtil.getBean(this.getClass())).updateById((Object)dbPurchaseMaterialLicense);
        SaleMaterialLicense saleMaterialLicense = (SaleMaterialLicense)((Object)this.saleMaterialLicenseService.getById((Serializable)((Object)dbPurchaseMaterialLicense.getRelationId())));
        saleMaterialLicense.setOptStatus(MaterialLicenseOptStatusEnum.PURCHASE_CONFIRMED.getValue());
        saleMaterialLicense.setValidStatus(validStatus);
        saleMaterialLicense.setUpdateTime(new Date());
        this.whenConfirmCopyPurchaseLicenseToSale(dbPurchaseMaterialLicense, saleMaterialLicense);
        this.saleMaterialLicenseService.updateById((Object)saleMaterialLicense);
        MsgParamsVO msgParamsVo = this.tidyPurchaseConfirmedMsgParamsVo(dbPurchaseMaterialLicense);
        MqUtil.sendBusMsg((String)purchaseMaterialLicense.getElsAccount(), (String)"materialLicenseManage", (String)MaterialLicenseOptStatusEnum.PURCHASE_CONFIRMED.getValue(), (MsgParamsVO)msgParamsVo);
    }

    private MsgParamsVO tidyPurchaseConfirmedMsgParamsVo(PurchaseMaterialLicense purchaseMaterialLicense) {
        MsgParamsVO msgParamsVo = new MsgParamsVO();
        HashMap<String, ArrayList> receiverMap = new HashMap<String, ArrayList>(16);
        ElsSubAccountDTO subAccountDto = this.invokeAccountRpcService.getAccount(purchaseMaterialLicense.getToElsAccount(), "1001");
        ArrayList subAccountDtos = Lists.newArrayList((Object[])new ElsSubAccountDTO[]{subAccountDto});
        receiverMap.put(purchaseMaterialLicense.getToElsAccount(), subAccountDtos);
        msgParamsVo.setReceiverMap(receiverMap);
        msgParamsVo.setParams((Object)purchaseMaterialLicense);
        return msgParamsVo;
    }

    private void whenConfirmCopyPurchaseLicenseToSale(PurchaseMaterialLicense purchaseMaterialLicense, SaleMaterialLicense saleMaterialLicense) {
        saleMaterialLicense.setMaterialNumber(purchaseMaterialLicense.getMaterialNumber());
        saleMaterialLicense.setMaterialDesc(purchaseMaterialLicense.getMaterialDesc());
        saleMaterialLicense.setMaterialName(purchaseMaterialLicense.getMaterialName());
        saleMaterialLicense.setLicenseType(purchaseMaterialLicense.getLicenseType());
        saleMaterialLicense.setEffectiveDate(purchaseMaterialLicense.getEffectiveDate());
        saleMaterialLicense.setExpiryDate(purchaseMaterialLicense.getExpiryDate());
        saleMaterialLicense.setPurchaseOrg(purchaseMaterialLicense.getPurchaseOrg());
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void returnOne(PurchaseMaterialLicense purchaseMaterialLicense) {
        PurchaseMaterialLicense dbPurchaseMaterialLicense = (PurchaseMaterialLicense)((Object)this.getById((Serializable)((Object)purchaseMaterialLicense.getId())));
        Assert.notNull((Object)((Object)dbPurchaseMaterialLicense), (String)I18nUtil.translate((String)"", (String)"\u5546\u54c1\u8bc1\u7167\u4e0d\u5b58\u5728"), (Object[])new Object[0]);
        Assert.isTrue((boolean)StrUtil.equalsAny((CharSequence)dbPurchaseMaterialLicense.getOptStatus(), (CharSequence[])new CharSequence[]{MaterialLicenseOptStatusEnum.WAIT_PURCHASE_CONFIRM.getValue(), I18nUtil.translate((String)"", (String)"\u53ea\u6709\u5f85\u91c7\u8d2d\u786e\u8ba4\u7684\u5355\u636e\u53ef\u4ee5\u9000\u56de")}));
        dbPurchaseMaterialLicense.setOptStatus(MaterialLicenseOptStatusEnum.WAIT_PURCHASE_CONFIRM.getValue());
        LoginUser loginUser = SysUtil.getLoginUser();
        dbPurchaseMaterialLicense.setUpdateBy(loginUser.getSubAccount());
        dbPurchaseMaterialLicense.setUpdateTime(new Date());
        dbPurchaseMaterialLicense.setUpdateById(SysUtil.getCurrentId());
        ((PurchaseMaterialLicenseServiceImpl)SpringUtil.getBean(this.getClass())).updateById((Object)dbPurchaseMaterialLicense);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseMaterialLicense.getId());
        SaleMaterialLicense saleMaterialLicense = (SaleMaterialLicense)((Object)this.saleMaterialLicenseService.getById((Serializable)((Object)dbPurchaseMaterialLicense.getRelationId())));
        saleMaterialLicense.setOptStatus(MaterialLicenseOptStatusEnum.PURCHASE_RETURN.getValue());
        saleMaterialLicense.setUpdateTime(new Date());
        saleMaterialLicense.setMaterialNumber(dbPurchaseMaterialLicense.getMaterialNumber());
        saleMaterialLicense.setMaterialName(dbPurchaseMaterialLicense.getMaterialName());
        saleMaterialLicense.setPurchaseOrg(dbPurchaseMaterialLicense.getPurchaseOrg());
        this.saleMaterialLicenseService.updateById((Object)saleMaterialLicense);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void returnBatch(List<PurchaseMaterialLicense> purchaseMaterialLicenses) {
        Assert.notEmpty(purchaseMaterialLicenses, (String)I18nUtil.translate((String)"", (String)"\u9000\u56de\u7684\u91c7\u8d2d\u8bc1\u7167\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[0]);
        Map purchaseMaterialLicenseMap = purchaseMaterialLicenses.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        List dbPurchaseMaterialLicenses = this.listByIds(purchaseMaterialLicenseMap.keySet());
        Map dbPurchaseMaterialLicenseMap = dbPurchaseMaterialLicenses.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        LoginUser loginUser = SysUtil.getLoginUser();
        dbPurchaseMaterialLicenseMap.forEach((id, dbPurchaseMaterialLicense) -> {
            dbPurchaseMaterialLicense.setOptStatus(MaterialLicenseOptStatusEnum.PURCHASE_RETURN.getValue());
            dbPurchaseMaterialLicense.setUpdateBy(loginUser.getSubAccount());
            dbPurchaseMaterialLicense.setUpdateTime(new Date());
            dbPurchaseMaterialLicense.setUpdateById(SysUtil.getCurrentId());
        });
        ((PurchaseMaterialLicenseServiceImpl)SpringUtil.getBean(this.getClass())).updateBatchById(dbPurchaseMaterialLicenses);
        this.invokeBaseRpcService.deletePurchaseAttachmentByBatchId(new ArrayList<String>(dbPurchaseMaterialLicenseMap.keySet()));
        List<SaleMaterialLicense> saleMaterialLicenses = this.saleMaterialLicenseService.selectWithoutElsAccountList((Wrapper<SaleMaterialLicense>)((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDeleted, (Object)CommonConstant.DEL_FLAG_0)).in(SaleMaterialLicense::getRelationId, dbPurchaseMaterialLicenseMap.keySet())));
        saleMaterialLicenses.forEach(saleMaterialLicense -> {
            saleMaterialLicense.setOptStatus(MaterialLicenseOptStatusEnum.PURCHASE_RETURN.getValue());
            saleMaterialLicense.setUpdateTime(new Date());
            dbPurchaseMaterialLicenseMap.forEach((id, dbPurchaseMaterialLicense) -> {
                if (id.equals(saleMaterialLicense.getRelationId())) {
                    saleMaterialLicense.setMaterialNumber(dbPurchaseMaterialLicense.getMaterialNumber());
                    saleMaterialLicense.setMaterialDesc(dbPurchaseMaterialLicense.getMaterialDesc());
                    saleMaterialLicense.setPurchaseOrg(dbPurchaseMaterialLicense.getPurchaseOrg());
                }
            });
        });
        this.saleMaterialLicenseService.updateBatchById(saleMaterialLicenses);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public List<PurchaseAttachmentDTO> uploadAndMatch(HttpServletRequest request, List<MultipartFile> files) {
        return null;
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void flushValidStatus() {
        UpdateWrapper purchaseUpdateWrapper = new UpdateWrapper();
        purchaseUpdateWrapper.lambda().eq(PurchaseMaterialLicense::getOptStatus, (Object)MaterialLicenseOptStatusEnum.PURCHASE_CONFIRMED.getValue());
        this.purchaseMaterialLicenseMapper.updateValidStatus((Wrapper<PurchaseMaterialLicense>)purchaseUpdateWrapper);
        UpdateWrapper saleUpdateWrapper = new UpdateWrapper();
        saleUpdateWrapper.lambda().eq(SaleMaterialLicense::getOptStatus, (Object)MaterialLicenseOptStatusEnum.PURCHASE_CONFIRMED.getValue());
        this.saleMaterialLicenseMapper.updateValidStatus((Wrapper<SaleMaterialLicense>)saleUpdateWrapper);
    }
}

