/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.excel;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.api.enumerate.MaterialSourceStatusEnum;
import com.els.modules.material.entity.PurchaseMaterialSource;
import com.els.modules.material.service.PurchaseMaterialSourceService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="materialSourceUpdateExcelHandler")
public class PurchaseMaterialSourceUpdateExcelHandler
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private PurchaseMaterialSourceService purchaseMaterialSourceService;
    private static String SPLIT_CHAR = "_";

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        Assert.notEmpty((Collection)dataList, (String)I18nUtil.translate((String)"i18n_alert_uNWFxOLV_bb53e337", (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        ArrayList<PurchaseMaterialSource> updateList = new ArrayList<PurchaseMaterialSource>();
        ArrayList<String> queryParamList = new ArrayList<String>();
        for (Map data : dataList) {
            PurchaseMaterialSource entity = (PurchaseMaterialSource)((Object)this.transferEntity(data, PurchaseMaterialSource.class, excelImportDTO));
            StringJoiner joiner = new StringJoiner(SPLIT_CHAR);
            joiner.add(Objects.toString(entity.getMaterialNumber(), ""));
            joiner.add(Objects.toString(entity.getPurchaseOrg(), ""));
            joiner.add(Objects.toString(entity.getToElsAccount(), ""));
            String queryParam = joiner.toString();
            queryParamList.add(queryParam);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"concat(material_number,'_',purchase_org,'_',to_els_account)", queryParamList);
        queryWrapper.lambda().in(PurchaseMaterialSource::getStatus, (Collection)Lists.newArrayList((Object[])new String[]{MaterialSourceStatusEnum.NORMAL.getValue(), MaterialSourceStatusEnum.EFFECTIVE.getValue()}));
        List purchaseMaterialSourceList = this.purchaseMaterialSourceService.list((Wrapper)queryWrapper);
        if (CollectionUtil.isEmpty((Collection)purchaseMaterialSourceList)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_error_allDataCanNotMatchMaterialSource", (String)"\u6240\u6709\u6570\u636e\u5747\u65e0\u6cd5\u5339\u914d\u5230\u8d27\u6e90\u6e05\u5355"));
        }
        Map<String, List<PurchaseMaterialSource>> materialSourceGroupMap = purchaseMaterialSourceList.stream().collect(Collectors.groupingBy(source -> source.getMaterialNumber() + SPLIT_CHAR + source.getPurchaseOrg() + SPLIT_CHAR + source.getToElsAccount()));
        for (Map data : dataList) {
            PurchaseMaterialSource entity = (PurchaseMaterialSource)((Object)this.transferEntity(data, PurchaseMaterialSource.class, excelImportDTO));
            String key = entity.getMaterialNumber() + SPLIT_CHAR + entity.getPurchaseOrg() + SPLIT_CHAR + entity.getToElsAccount();
            List<PurchaseMaterialSource> matchData = materialSourceGroupMap.get(key);
            if (CollectionUtil.isEmpty(matchData)) {
                String msg = I18nUtil.translate((String)"i18n_error_UnableToFindMatchingEffectiveData", (String)"\u65e0\u6cd5\u627e\u5230\u5339\u914d\u7684\u751f\u6548\u6570\u636e\u3002");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            matchData.stream().forEach(item -> item.setLeadTime(entity.getLeadTime()));
            updateList.addAll(matchData);
        }
        this.purchaseMaterialSourceService.updateBatchById(updateList);
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

