/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.org.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseOpenServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.org.entity.PurchaseOrganizationInfo;
import com.els.modules.org.entity.TreeOrgNode;
import com.els.modules.org.enumerate.PurchaseOrgCategoryStatus;
import com.els.modules.org.enumerate.PurchaseOrganizationStatus;
import com.els.modules.org.mapper.PurchaseOrganizationInfoMapper;
import com.els.modules.org.service.PurchaseOrganizationInfoService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class PurchaseOrganizationInfoServiceImpl
extends BaseOpenServiceImpl<PurchaseOrganizationInfoMapper, PurchaseOrganizationInfo, PurchaseOrganizationInfo>
implements PurchaseOrganizationInfoService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseOrganizationInfoServiceImpl.class);
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private PurchaseOrganizationInfoMapper purchaseOrganizationInfoMapper;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private InterfaceUtil interfaceUtil;
    @Autowired
    private InvokeBaseRpcService baseRpcService;
    @Value(value="${zhongtai.config.Authorization}")
    private String authorization;
    private static final String CATALOGUE = "sys:dict:";
    private static final String CATALOGUE2 = "sys:cache:dict";
    private static final String CATALOGUE3 = "sys:cache:dict:";
    private static final String CATALOGUE4 = "sys:cache:dict";
    private static final String COLON = ":";

    @Override
    public void savePurchaseOrganizationInfo(PurchaseOrganizationInfo purchaseOrganizationInfo) {
        if (StrUtil.isNotEmpty((CharSequence)purchaseOrganizationInfo.getOrgCode())) {
            this.checkOrgData(purchaseOrganizationInfo);
        }
        purchaseOrganizationInfo.setDataSource(CharSequenceUtil.emptyToDefault((CharSequence)purchaseOrganizationInfo.getDataSource(), (String)"2"));
        ((PurchaseOrganizationInfoMapper)this.baseMapper).insert((Object)purchaseOrganizationInfo);
        this.deleteRedis("purchase_organization_info");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSavePurchaseOrganizationInfo(List<PurchaseOrganizationInfo> purchaseOrganizationInfoList) {
        for (PurchaseOrganizationInfo info : purchaseOrganizationInfoList) {
            this.savePurchaseOrganizationInfo(info);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void srmSynPurchaseOrgJob() {
        String elsAccount = TenantContext.getTenant();
        JSONObject param = new JSONObject();
        param.put("bus_account", (Object)elsAccount);
        param.put("srm_interface_code", (Object)"synPurchaseOrg");
        JSONObject headParam = new JSONObject();
        headParam.put("Authorization", (Object)this.authorization);
        param.put("header_param", (Object)headParam);
        JSONObject body = new JSONObject();
        body.put("pageNum", (Object)1);
        body.put("pageSize", (Object)10000);
        body.put("startCreateTime", (Object)DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd"));
        body.put("endCreateTime", (Object)DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd"));
        body.put("startLastUpdateTime", (Object)DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd"));
        body.put("endLastUpdateTime", (Object)DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd"));
        param.put("body", (Object)body);
        log.info("\u8c03\u7528\u63a5\u53e3\u5e73\u53f0[\u540c\u6b65\u4e2d\u53f0\u7ec4\u7ec7\u4fe1\u606f]\u5f00\u59cb \u5165\u53c2\u4e3a\uff1a" + param);
        JSONObject interfaceResult = this.interfaceUtil.callInterface(elsAccount, null, param, null);
        log.info("\u8c03\u7528\u63a5\u53e3\u5e73\u53f0[\u540c\u6b65\u4e2d\u53f0\u7ec4\u7ec7\u4fe1\u606f]\u7ed3\u675f \u51fa\u53c2\u4e3a\uff1a" + interfaceResult);
        if (!interfaceResult.getBoolean("success").booleanValue()) {
            throw new ELSBootException(interfaceResult.getString("message"));
        }
        String dataResult = this.handlerResultListInfo(interfaceResult);
        JSONArray array = JSONArray.parseArray((String)dataResult);
        ArrayList<PurchaseOrganizationInfo> allList = new ArrayList<PurchaseOrganizationInfo>();
        ArrayList<PurchaseOrganizationInfo> saveBatchList = new ArrayList<PurchaseOrganizationInfo>();
        ArrayList updateBatchList = new ArrayList();
        List templateList = this.baseRpcService.getDefaultTemplateByType("org");
        TemplateHeadDTO templateHeadDTO = (TemplateHeadDTO)templateList.get(0);
        HashSet<String> orgCodeList = new HashSet<String>();
        for (Object json : array) {
            JSONObject jsonObject = JSONObject.parseObject((String)json.toString());
            PurchaseOrganizationInfo info = new PurchaseOrganizationInfo();
            info.setElsAccount(elsAccount);
            info.setTemplateAccount(templateHeadDTO.getElsAccount());
            info.setTemplateName(templateHeadDTO.getTemplateName());
            info.setTemplateNumber(templateHeadDTO.getTemplateNumber());
            info.setTemplateVersion(templateHeadDTO.getTemplateVersion());
            info.setDeleted(CommonConstant.DEL_FLAG_0);
            info.setOrgCode(jsonObject.getString("number"));
            info.setOrgName(jsonObject.getString("nameL2"));
            info.setOrgCategoryCode("1".equals(jsonObject.getString("isCompanyOrgUnit")) ? "companyCode" : "dept");
            info.setChargeCurrency("CNY");
            info.setSuperBusinessId(jsonObject.getString("parentId"));
            info.setCreateTime(new Date());
            info.setDataSource("3");
            orgCodeList.add(jsonObject.getString("number"));
            allList.add(info);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.in((Object)"org_code", orgCodeList);
        List purchaseOrganizationInfos = this.purchaseOrganizationInfoMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)purchaseOrganizationInfos)) {
            Map<String, List<PurchaseOrganizationInfo>> listMap = purchaseOrganizationInfos.stream().collect(Collectors.groupingBy(PurchaseOrganizationInfo::getOrgCode));
            for (PurchaseOrganizationInfo info : allList) {
                List<PurchaseOrganizationInfo> infos = listMap.get(info.getOrgCode());
                if (CollectionUtil.isNotEmpty(infos)) {
                    info.setId(infos.get(0).getId());
                    this.purchaseOrganizationInfoMapper.updateById((Object)info);
                    continue;
                }
                saveBatchList.add(info);
            }
            if (CollectionUtil.isNotEmpty(saveBatchList)) {
                this.purchaseOrganizationInfoMapper.insertBatchSomeColumn(saveBatchList);
            }
        } else {
            this.purchaseOrganizationInfoMapper.insertBatchSomeColumn(allList);
        }
    }

    private String handlerResultListInfo(JSONObject obj) {
        if (!obj.getBoolean("success").booleanValue()) {
            throw new ELSBootException(obj.getString("msg"));
        }
        JSONObject result = obj.getJSONObject("result");
        if (!result.getBoolean("success").booleanValue()) {
            throw new ELSBootException(obj.getString("msg"));
        }
        JSONObject data = result.getJSONObject("data");
        return data.getString("records");
    }

    @Override
    public void updatePurchaseOrganizationInfo(PurchaseOrganizationInfo purchaseOrganizationInfo) {
        int count;
        if (StrUtil.isNotEmpty((CharSequence)purchaseOrganizationInfo.getOrgCode())) {
            this.checkOrgData(purchaseOrganizationInfo);
        }
        if ((count = ((PurchaseOrganizationInfoMapper)this.baseMapper).updateById((Object)purchaseOrganizationInfo)) == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.deleteRedis("purchase_organization_info");
    }

    public void checkOrgData(PurchaseOrganizationInfo purchaseOrganizationInfo) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(PurchaseOrganizationInfo::getOrgCategoryCode, (Object)purchaseOrganizationInfo.getOrgCategoryCode())).eq(PurchaseOrganizationInfo::getOrgCode, (Object)purchaseOrganizationInfo.getOrgCode())).ne(null != purchaseOrganizationInfo.getId(), BaseEntity::getId, (Object)purchaseOrganizationInfo.getId());
        Integer count = this.purchaseOrganizationInfoMapper.selectCount((Wrapper)queryWrapper);
        if (count > 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APjVRAonVRAcIOMKWVImW_14a4b4dd", (String)"\u5f53\u524d\u7684\u7ec4\u7ec7\u7f16\u7801\u548c\u7ec4\u7ec7\u7c7b\u578b\u5df2\u7ecf\u5b58\u5728,\u8bf7\u68c0\u67e5!"));
        }
    }

    @Override
    public void delPurchaseOrganizationInfo(String id) {
        ((PurchaseOrganizationInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.deleteRedis("purchase_organization_info");
    }

    @Override
    public void delBatchPurchaseOrganizationInfo(List<String> idList) {
        ((PurchaseOrganizationInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public Map<String, Object> getSuperiorOrganization() {
        List<TreeOrgNode> list = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectByElsAccount(TenantContext.getTenant());
        ArrayList<TreeOrgNode> copyList = new ArrayList<TreeOrgNode>();
        for (TreeOrgNode node : list) {
            node.setKey(node.getId());
            node.setValue(node.getId());
            TreeOrgNode newNode = new TreeOrgNode();
            SysUtil.copyProperties((Object)node, (Object)newNode);
            copyList.add(newNode);
        }
        List superBusinessList = list.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getSuperBusinessId()) && !"1".equals(o.getOrgNature())).collect(Collectors.toList());
        List superExecutiveList = copyList.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getSuperExecutiveId()) && !"0".equals(o.getOrgNature())).collect(Collectors.toList());
        Map<String, List<TreeOrgNode>> businessCollect = list.parallelStream().filter(vo -> vo.getSuperBusinessId() != null).collect(Collectors.groupingBy(TreeOrgNode::getSuperBusinessId));
        Map<String, List<TreeOrgNode>> executiveCollect = copyList.parallelStream().filter(vo -> vo.getSuperExecutiveId() != null).collect(Collectors.groupingBy(TreeOrgNode::getSuperExecutiveId));
        for (TreeOrgNode node : superBusinessList) {
            this.forEach(businessCollect, node, 1);
        }
        for (TreeOrgNode node : superExecutiveList) {
            this.forEach(executiveCollect, node, 1);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("business", superBusinessList);
        resultMap.put("executive", superExecutiveList);
        return resultMap;
    }

    @Override
    public List<TreeOrgNode> getExecutiveOrganization() {
        List<TreeOrgNode> list = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectExecutiveTree(TenantContext.getTenant());
        for (TreeOrgNode node : list) {
            node.setKey(node.getId());
            node.setValue(node.getId());
        }
        List<TreeOrgNode> superExecutiveList = list.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getSuperExecutiveId())).collect(Collectors.toList());
        Map<String, List<TreeOrgNode>> executiveCollect = list.parallelStream().filter(vo -> vo.getSuperExecutiveId() != null).collect(Collectors.groupingBy(TreeOrgNode::getSuperExecutiveId));
        for (TreeOrgNode node : superExecutiveList) {
            this.forEach(executiveCollect, node, 1);
        }
        return superExecutiveList;
    }

    @Override
    public List<TreeOrgNode> getNatureExecutiveOrganization() {
        List<TreeOrgNode> list = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectNatureExecutiveTree(TenantContext.getTenant());
        for (TreeOrgNode node : list) {
            node.setKey(node.getId());
            node.setValue(node.getId());
        }
        List<TreeOrgNode> superExecutiveList = list.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getSuperExecutiveId())).collect(Collectors.toList());
        Map<String, List<TreeOrgNode>> executiveCollect = list.parallelStream().filter(vo -> vo.getSuperExecutiveId() != null).collect(Collectors.groupingBy(TreeOrgNode::getSuperExecutiveId));
        for (TreeOrgNode node : superExecutiveList) {
            this.forEach(executiveCollect, node, 1);
        }
        return superExecutiveList;
    }

    @Override
    public List<TreeOrgNode> getNatureExecutiveOrganizationNew() {
        List<TreeOrgNode> list = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectNatureExecutiveTree(TenantContext.getTenant());
        for (TreeOrgNode node : list) {
            node.setKey(node.getId());
            node.setValue(node.getId());
        }
        List superExecutiveList = list.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getSuperExecutiveId())).collect(Collectors.toList());
        list = this.buildTree(list, "");
        return list;
    }

    private List<TreeOrgNode> buildTree(List<TreeOrgNode> all, String rootId) {
        ArrayList parent = Lists.newArrayList();
        List ids = all.stream().map(TreeOrgNode::getValue).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList());
        for (TreeOrgNode commentNode : all) {
            commentNode.setChildren(this.getChildren(commentNode, all));
            if (!CharSequenceUtil.isEmpty((CharSequence)commentNode.getSuperExecutiveId()) && ids.contains(commentNode.getSuperExecutiveId()) || commentNode.getValue().equals(commentNode.getSuperExecutiveId())) continue;
            parent.add(commentNode);
        }
        return parent;
    }

    private List<TreeOrgNode> getChildren(TreeOrgNode commentNode, List<TreeOrgNode> all) {
        ArrayList<TreeOrgNode> childList = new ArrayList<TreeOrgNode>(8);
        for (TreeOrgNode child : all) {
            if (!commentNode.getValue().equals(child.getSuperExecutiveId()) || commentNode.getId().equals(commentNode.getSuperExecutiveId())) continue;
            child.setChildren(this.getChildren(child, all));
            childList.add(child);
        }
        return childList;
    }

    @Override
    public List<TreeOrgNode> getFactoryOrganization() {
        List<TreeOrgNode> list = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectOrganization(TenantContext.getTenant(), "factory");
        list.forEach(node -> {
            node.setKey(node.getId());
            node.setValue(node.getId());
        });
        return list;
    }

    @Override
    public void frozen(String id, String status) {
        PurchaseOrganizationInfo purchaseOrganizationInfo = (PurchaseOrganizationInfo)((Object)((PurchaseOrganizationInfoMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        PurchaseOrganizationInfo org = new PurchaseOrganizationInfo();
        org.setId(id);
        org.setStatus(status);
        if (PurchaseOrganizationStatus.NORMAL.getValue().equals(status)) {
            org.setEnableTime(new Date());
        } else if (PurchaseOrganizationStatus.FROZEN.getValue().equals(status)) {
            org.setFreezeTime(new Date());
        }
        int count = ((PurchaseOrganizationInfoMapper)this.baseMapper).updateById((Object)org);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        StringBuffer redisKey = new StringBuffer("sys:cache:dict");
        redisKey.append(TenantContext.getTenant()).append(COLON).append("purchase_organization_info");
        StringBuffer redisKeys = new StringBuffer(CATALOGUE3);
        redisKeys.append(TenantContext.getTenant()).append(COLON).append("purchase_organization_info");
        this.redisUtil.deleteByPrex(redisKey.toString());
        this.redisUtil.deleteByPrex(redisKeys.toString());
        if (!ObjectUtils.isEmpty((Object)((Object)purchaseOrganizationInfo))) {
            ArrayList<PurchaseOrganizationInfo> list = new ArrayList<PurchaseOrganizationInfo>();
            list.add(purchaseOrganizationInfo);
            ArrayList purchaseOrganizationInfoDTOS = SysUtil.copyProperties(list, PurchaseOrganizationInfoDTO.class);
            MqUtil.sendOperateEventMsg((String)TenantContext.getTenant(), (String)"PurchaseOrganizationInfo", (String)"delete", (String)"deleteOrgDataToMall", (Object)purchaseOrganizationInfoDTOS);
        }
    }

    private void forEach(Map<String, List<TreeOrgNode>> collect, TreeOrgNode treeOrgNode, Integer level) {
        List<TreeOrgNode> treeOrgNodelist = collect.get(treeOrgNode.getValue());
        treeOrgNode.setLevel(level);
        if (collect.get(treeOrgNode.getValue()) != null) {
            treeOrgNode.setChildren(treeOrgNodelist);
            treeOrgNode.setHasChildren(true);
            Integer n = level;
            Integer n2 = level = Integer.valueOf(level + 1);
            Integer finalLevel = level;
            treeOrgNode.getChildren().forEach(t -> this.forEach(collect, (TreeOrgNode)t, finalLevel));
        }
    }

    @Override
    public List<PurchaseOrganizationInfo> getOrgBySubAccount(String subAccount) {
        String elsAccount = TenantContext.getTenant();
        ElsSubAccountDTO subUser = this.invokeAccountRpcService.getAccount(elsAccount, subAccount);
        List<PurchaseOrganizationInfo> orgList = new ArrayList<PurchaseOrganizationInfo>();
        if (subUser != null && StringUtils.isNotBlank((CharSequence)subUser.getOrgCode())) {
            List<String> userOrgCodeId = Arrays.asList(subUser.getOrgCode().split(","));
            LambdaQueryWrapper orgWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)orgWrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).in(BaseEntity::getId, userOrgCodeId)).eq(PurchaseOrganizationInfo::getStatus, (Object)PurchaseOrganizationStatus.NORMAL.getValue());
            orgList = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectList((Wrapper)orgWrapper);
        }
        return orgList;
    }

    @Override
    public Map<String, String> getOrganizationByCode(String elsAccount, String orgCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(PurchaseOrganizationInfo::getOrgCategoryCode, (Object)orgCode);
        List deptOrg = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)deptOrg)) {
            return deptOrg.stream().collect(Collectors.toMap(PurchaseOrganizationInfo::getOrgCode, purchaseOrganizationInfo -> purchaseOrganizationInfo.getOrgDesc() == null ? "" : purchaseOrganizationInfo.getOrgDesc()));
        }
        return new HashMap<String, String>();
    }

    @Override
    public List<PurchaseOrganizationInfo> getOrgForCalendar(String elsAccount, String orgCategoryCode) {
        return ((PurchaseOrganizationInfoMapper)this.baseMapper).selectOrgCalendar(elsAccount, orgCategoryCode);
    }

    @Override
    public List<TreeOrgNode> getOrgCascader() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(PurchaseOrganizationInfo::getStatus, (Object)PurchaseOrganizationStatus.NORMAL.getValue());
        List orgList = this.list((Wrapper)queryWrapper);
        ArrayList<TreeOrgNode> orgTreeList = new ArrayList<TreeOrgNode>();
        for (PurchaseOrganizationInfo org : orgList) {
            TreeOrgNode tree = new TreeOrgNode();
            tree.setKey(org.getId());
            tree.setTitle(org.getOrgName());
            tree.setValue(org.getOrgCode());
            tree.setOrgType(org.getOrgCategoryCode());
            orgTreeList.add(tree);
        }
        Map<String, List<TreeOrgNode>> orgMap = orgTreeList.stream().filter(vo -> StringUtils.isNotBlank((CharSequence)vo.getValue()) && StringUtils.isNotBlank((CharSequence)vo.getOrgType())).collect(Collectors.groupingBy(TreeOrgNode::getOrgType));
        ArrayList<TreeOrgNode> categoryList = new ArrayList<TreeOrgNode>();
        for (PurchaseOrgCategoryStatus orgCategoryStatus : PurchaseOrgCategoryStatus.values()) {
            if (!orgMap.containsKey(orgCategoryStatus.getValue())) continue;
            TreeOrgNode categoryTree = new TreeOrgNode();
            categoryTree.setValue(orgCategoryStatus.getValue());
            categoryTree.setTitle(orgCategoryStatus.getDesc());
            categoryTree.setChildren(orgMap.get(orgCategoryStatus.getValue()));
            categoryList.add(categoryTree);
        }
        return categoryList;
    }

    @Override
    public Map<String, String> listDeptOrganization(List<String> ids) {
        if (CollUtil.isEmpty(ids)) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select(new SFunction[]{BaseEntity::getId, PurchaseOrganizationInfo::getOrgCode, PurchaseOrganizationInfo::getOrgName});
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).in(BaseEntity::getId, ids);
        List organizationInfoList = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return organizationInfoList.stream().collect(Collectors.toMap(BaseEntity::getId, x -> x.getOrgCode() + "_" + x.getOrgName(), (v1, v2) -> v2));
    }

    private void deleteRedis(String table) {
        StringBuffer redisKey = new StringBuffer(CATALOGUE);
        redisKey.append(TenantContext.getTenant()).append(COLON).append(table);
        this.redisUtil.deleteByPrex(redisKey.toString());
    }

    @Override
    public void deleteRedisCache() {
        StringBuffer redisKey = new StringBuffer(CATALOGUE);
        redisKey.append(TenantContext.getTenant()).append(COLON).append("purchase_organization_info");
        this.redisUtil.deleteByPrex(redisKey.toString());
        redisKey = new StringBuffer("sys:cache:dict");
        redisKey.append(TenantContext.getTenant()).append(COLON).append("purchase_organization_info");
        this.redisUtil.deleteByPrex(redisKey.toString());
        redisKey = new StringBuffer("sys:cache:dict");
        redisKey.append(TenantContext.getTenant()).append(COLON).append("purchase_organization_info");
        this.redisUtil.deleteByPrex(redisKey.toString());
        redisKey = new StringBuffer("sys:cache:dict");
        this.redisUtil.deleteByPrex(redisKey.toString());
    }

    @Override
    public Map<String, String> getDeptOrganization(String elsAccount) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(PurchaseOrganizationInfo::getOrgCategoryCode, (Object)"dept");
        List deptOrg = this.list((Wrapper)queryWrapper);
        return deptOrg.stream().collect(Collectors.toMap(PurchaseOrganizationInfo::getOrgCode, BaseEntity::getId, (v1, v2) -> v2));
    }

    @Override
    public Map<String, String> mapIdsByOrgCodeAndOrgCategoryCode(List<String> all) {
        if (CollUtil.isEmpty(all)) {
            return Maps.newHashMap();
        }
        List<PurchaseOrganizationInfoDTO> list = ((PurchaseOrganizationInfoMapper)this.baseMapper).listOrganizationInfoByTypeAndCode(all, TenantContext.getTenant());
        return list.stream().collect(Collectors.toMap(x -> x.getOrgCategoryCode() + "," + x.getOrgCode(), BaseDTO::getId, (v1, v2) -> v2));
    }

    @Override
    public Map<String, String> mapIdsByOrgCode(List<String> orgCodeList) {
        if (CollUtil.isEmpty(orgCodeList)) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select(new SFunction[]{BaseEntity::getId, PurchaseOrganizationInfo::getOrgCode, PurchaseOrganizationInfo::getOrgName, PurchaseOrganizationInfo::getOrgCategoryCode});
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).in(PurchaseOrganizationInfo::getOrgCode, orgCodeList);
        List organizationInfoList = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return organizationInfoList.stream().collect(Collectors.toMap(PurchaseOrganizationInfo::getOrgCode, BaseEntity::getId, (v1, v2) -> v2));
    }

    @Override
    public int countOrgCode(List<String> codes, String elsAccount) {
        if (CollUtil.isEmpty(codes)) {
            return 0;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.in(PurchaseOrganizationInfo::getOrgCode, codes)).eq(BaseEntity::getElsAccount, (Object)elsAccount);
        return ((PurchaseOrganizationInfoMapper)this.baseMapper).selectCount((Wrapper)queryWrapper);
    }

    @Override
    public boolean checkOrgCode(String orgCode) {
        List<String> orgCodeList = Arrays.asList(orgCode.split(","));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).in(BaseEntity::getId, orgCodeList);
        List organizationInfoList = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return organizationInfoList.stream().anyMatch(a -> "companyCode".equals(a.getOrgCategoryCode()));
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        InterfaceUtil interfaceUtil = (InterfaceUtil)SpringContextUtils.getBean(InterfaceUtil.class);
        interfaceUtil.callInterface(elsAccount, "getDeptData", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List purchaseOrganizationInfoList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchaseOrganizationInfo organizationInfo : purchaseOrganizationInfoList) {
            this.pushDataToErp(organizationInfo);
        }
    }

    private void pushDataToErp(PurchaseOrganizationInfo organizationInfo) {
        String elsAccount = TenantContext.getTenant();
        InterfaceUtil interfaceUtil = (InterfaceUtil)SpringContextUtils.getBean(InterfaceUtil.class);
        interfaceUtil.callInterface(elsAccount, "pushOrgData", (Object)organizationInfo);
    }
}

