/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.excel;

import cn.hutool.core.collection.CollUtil;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.entity.PurchaseMaterialSource;
import com.els.modules.material.service.PurchaseMaterialSourceService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseMaterialSourceExcelHandler")
public class PurchaseMaterialSourceExcelHandler
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private PurchaseMaterialSourceService purchaseMaterialSourceService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("materialSource");
        ArrayList<PurchaseMaterialSource> entityList = new ArrayList<PurchaseMaterialSource>();
        for (Map data : dataList) {
            PurchaseMaterialSource entity = (PurchaseMaterialSource)((Object)this.transferEntity(data, PurchaseMaterialSource.class, excelImportDTO));
            if (null == entity) continue;
            entity.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            entity.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            entity.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion().toString());
            entity.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
            entity.setElsAccount(TenantContext.getTenant());
            entityList.add(entity);
        }
        if (CollUtil.isEmpty(entityList)) {
            return dataList;
        }
        PurchaseMaterialSource entity = (PurchaseMaterialSource)((Object)entityList.get(0));
        int size = entityList.size();
        List nextCodes = this.invokeBaseRpcService.getNextCodes("materialSourceNumber", (Object)entity, size);
        int codeIndex = 0;
        for (PurchaseMaterialSource e : entityList) {
            e.setSourceId((String)nextCodes.get(codeIndex++));
        }
        this.purchaseMaterialSourceService.saveBatch(entityList);
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

