/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.price.entity.PurchaseInformationRecordsRequestHead;
import com.els.modules.price.entity.PurchaseInformationRecordsRequestItem;
import com.els.modules.price.enumerate.PriceRequestSendStatusEnum;
import com.els.modules.price.enumerate.PriceRequestStatusEnum;
import com.els.modules.price.excel.PurchaseInformationRecordsRequestExportServiceImpl;
import com.els.modules.price.service.PurchaseInformationRecordsRequestHeadService;
import com.els.modules.price.service.PurchaseInformationRecordsRequestItemService;
import com.els.modules.price.vo.PurchaseInformationRecordsRequestHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/price/purchaseInformationRecordsRequest"})
@Api(tags={"\u4ef7\u683c\u7533\u8bf7\u5934"})
@BusinessModule(module="informationRecordsRequest")
public class PurchaseInformationRecordsRequestHeadController
extends BaseController<PurchaseInformationRecordsRequestHead, PurchaseInformationRecordsRequestHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseInformationRecordsRequestHeadController.class);
    private static final String LOCK_PREFIX = "sync_purchaseInformationRecordsRequest_createPrice";
    private static final long EXPIRE_TIME = 30000L;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private PurchaseInformationRecordsRequestHeadService purchaseInformationRecordsRequestHeadService;
    @Autowired
    private PurchaseInformationRecordsRequestItemService purchaseInformationRecordsRequestItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"informationRecordsRequest#PurchaseInformationRecordsRequest:list"})
    public Result<?> queryPageList(PurchaseInformationRecordsRequestHead purchaseInformationRecordsRequestHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseInformationRecordsRequestHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseInformationRecordsRequestHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    private void baseDataBuild(PurchaseInformationRecordsRequestHead head) {
        if ("0".equals(head.getNeedAudit())) {
            head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            head.setNeedAudit("1");
            head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        head.setBusAccount(TenantContext.getTenant());
        head.setAutoPublish(CharSequenceUtil.emptyToDefault((CharSequence)head.getAutoPublish(), (String)"0"));
        head.setNeedSaleConfirm(CharSequenceUtil.emptyToDefault((CharSequence)head.getNeedSaleConfirm(), (String)"0"));
        head.setPartGeneratedPrice(CharSequenceUtil.emptyToDefault((CharSequence)head.getPartGeneratedPrice(), (String)"0"));
        head.setStatus(PriceRequestStatusEnum.NEW.getValue());
        head.setPublishStatus(PriceRequestSendStatusEnum.NO_PUBLISH.getValue());
    }

    @SrmValidated
    @AutoLog(busModule="\u4ef7\u683c\u7533\u8bf7\u5934", value="\u6dfb\u52a0", operateType=2)
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"informationRecordsRequest#PurchaseInformationRecordsRequest:add"})
    public Result<?> add(@RequestBody PurchaseInformationRecordsRequestHeadVO purchaseInformationRecordsRequestHeadPage) {
        List<PurchaseInformationRecordsRequestItem> informationRecordsRequestItemList;
        if (!StringUtils.isEmpty((Object)purchaseInformationRecordsRequestHeadPage.getToElsAccount()) && purchaseInformationRecordsRequestHeadPage.getElsAccount().equals(purchaseInformationRecordsRequestHeadPage.getToElsAccount()) && CollectionUtil.isNotEmpty(informationRecordsRequestItemList = purchaseInformationRecordsRequestHeadPage.getInformationRecordsRequestItemList())) {
            for (PurchaseInformationRecordsRequestItem purchaseInformationRecordsRequestItem : informationRecordsRequestItemList) {
                if (StringUtils.isEmpty((Object)purchaseInformationRecordsRequestItem.getToCompany())) {
                    throw new ELSBootException("\u516c\u53f8\u95f4\u5185\u90e8\u5355\u636e\uff0c\u4ef7\u683c\u7533\u8bf7\u884c\uff0c\u7269\u6599\u7f16\u7801:" + purchaseInformationRecordsRequestItem.getMaterialNumber() + "\u5fc5\u987b\u9009\u62e9\u4f9b\u5e94\u5546\u516c\u53f8\u7f16\u7801");
                }
                if (StringUtils.isEmpty((Object)purchaseInformationRecordsRequestItem.getToCompany()) || StringUtils.isEmpty((Object)purchaseInformationRecordsRequestItem.getCompany()) || !purchaseInformationRecordsRequestItem.getCompany().equals(purchaseInformationRecordsRequestItem.getToCompany())) continue;
                throw new ELSBootException("\u516c\u53f8\u95f4\u5185\u90e8\u5355\u636e\uff0c\u4ef7\u683c\u7533\u8bf7\u884c\uff0c\u7269\u6599\u7f16\u7801:" + purchaseInformationRecordsRequestItem.getMaterialNumber() + "\u516c\u53f8\u4ee3\u7801\u548c\u4f9b\u5e94\u5546\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u76f8\u540c");
            }
        }
        PurchaseInformationRecordsRequestHead purchaseInformationRecordsRequestHead = new PurchaseInformationRecordsRequestHead();
        BeanUtils.copyProperties((Object)((Object)purchaseInformationRecordsRequestHeadPage), (Object)((Object)purchaseInformationRecordsRequestHead));
        this.baseDataBuild(purchaseInformationRecordsRequestHead);
        this.purchaseInformationRecordsRequestHeadService.saveMain(purchaseInformationRecordsRequestHead, purchaseInformationRecordsRequestHeadPage.getInformationRecordsRequestItemList(), purchaseInformationRecordsRequestHeadPage.getAttachmentList());
        return Result.ok((Object)((Object)purchaseInformationRecordsRequestHead));
    }

    @SrmValidated
    @AutoLog(busModule="\u4ef7\u683c\u7533\u8bf7\u5934", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"informationRecordsRequest#PurchaseInformationRecordsRequest:edit"})
    public Result<?> edit(@RequestBody PurchaseInformationRecordsRequestHeadVO head) {
        List<PurchaseInformationRecordsRequestItem> informationRecordsRequestItemList;
        PurchaseInformationRecordsRequestHead byId = (PurchaseInformationRecordsRequestHead)((Object)this.purchaseInformationRecordsRequestHeadService.getById((Serializable)((Object)head.getId())));
        if (PriceRequestStatusEnum.NEW.getValue().equals(byId.getStatus()) && AuditStatusEnum.AUDIT_FINISH.getValue().equals(byId.getAuditStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        if (!StringUtils.isEmpty((Object)head.getToElsAccount()) && head.getElsAccount().equals(head.getToElsAccount()) && CollectionUtil.isNotEmpty(informationRecordsRequestItemList = head.getInformationRecordsRequestItemList())) {
            for (PurchaseInformationRecordsRequestItem purchaseInformationRecordsRequestItem : informationRecordsRequestItemList) {
                if (StringUtils.isEmpty((Object)purchaseInformationRecordsRequestItem.getToCompany())) {
                    throw new ELSBootException("\u516c\u53f8\u95f4\u5185\u90e8\u5355\u636e\uff0c\u4ef7\u683c\u7533\u8bf7\u884c\uff0c\u7269\u6599\u7f16\u7801:" + purchaseInformationRecordsRequestItem.getMaterialNumber() + "\u5fc5\u987b\u9009\u62e9\u4f9b\u5e94\u5546\u516c\u53f8\u7f16\u7801");
                }
                if (StringUtils.isEmpty((Object)purchaseInformationRecordsRequestItem.getToCompany()) || StringUtils.isEmpty((Object)purchaseInformationRecordsRequestItem.getCompany()) || !purchaseInformationRecordsRequestItem.getCompany().equals(purchaseInformationRecordsRequestItem.getToCompany())) continue;
                throw new ELSBootException("\u516c\u53f8\u95f4\u5185\u90e8\u5355\u636e\uff0c\u4ef7\u683c\u7533\u8bf7\u884c\uff0c\u7269\u6599\u7f16\u7801:" + purchaseInformationRecordsRequestItem.getMaterialNumber() + "\u516c\u53f8\u4ee3\u7801\u548c\u4f9b\u5e94\u5546\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u76f8\u540c");
            }
        }
        PurchaseInformationRecordsRequestHead purchaseInformationRecordsRequestHead = new PurchaseInformationRecordsRequestHead();
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)purchaseInformationRecordsRequestHead));
        this.baseDataBuild(purchaseInformationRecordsRequestHead);
        this.purchaseInformationRecordsRequestHeadService.updateMain(purchaseInformationRecordsRequestHead, head.getInformationRecordsRequestItemList(), head.getAttachmentList());
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(busModule="\u4ef7\u683c\u7533\u8bf7\u5934", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"informationRecordsRequest#PurchaseInformationRecordsRequest:publish"})
    public Result<?> publish(@RequestBody PurchaseInformationRecordsRequestHeadVO headVO) {
        if (CollectionUtil.isEmpty(headVO.getInformationRecordsRequestItemList())) {
            PurchaseInformationRecordsRequestHead head = (PurchaseInformationRecordsRequestHead)((Object)this.purchaseInformationRecordsRequestHeadService.getById((Serializable)((Object)headVO.getId())));
            List<PurchaseInformationRecordsRequestItem> itemList = this.purchaseInformationRecordsRequestItemService.selectByMainId(headVO.getId());
            List attachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(headVO.getId());
            this.purchaseInformationRecordsRequestHeadService.publish(head, itemList, attachmentList);
        } else {
            PurchaseInformationRecordsRequestHead purchaseInformationRecordsRequestHead = new PurchaseInformationRecordsRequestHead();
            BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)purchaseInformationRecordsRequestHead));
            this.baseDataBuild(purchaseInformationRecordsRequestHead);
            this.purchaseInformationRecordsRequestHeadService.publish(purchaseInformationRecordsRequestHead, headVO.getInformationRecordsRequestItemList(), headVO.getAttachmentList());
        }
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u4ef7\u683c\u7533\u8bf7\u5934", value="\u751f\u6210\u4ef7\u683c\u4e3b\u6570\u636e")
    @ApiOperation(value="\u751f\u6210\u4ef7\u683c\u4e3b\u6570\u636e", notes="\u751f\u6210\u4ef7\u683c\u4e3b\u6570\u636e")
    @PostMapping(value={"/createPrice/{headId}"})
    @RequiresPermissions(value={"informationRecordsRequest#PurchaseInformationRecordsRequest:createPrice"})
    public Result<?> createPrice(@PathVariable(value="headId") String headId) {
        if (!this.redisUtil.tryGetDistributedLock(LOCK_PREFIX, headId, 30000L)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APtFiKRcsSTVBtk_2ef68e36", (String)"\u5f53\u524d\u5355\u636e\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.purchaseInformationRecordsRequestHeadService.createPriceByHead(headId);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_PREFIX, headId);
        }
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u4ef7\u683c\u7533\u8bf7\u5934", value="\u4ef7\u683c\u7533\u8bf7\u5934")
    @ApiOperation(value="\u4ef7\u683c\u7533\u8bf7\u5934\u4f5c\u5e9f", notes="\u4ef7\u683c\u7533\u8bf7\u5934\u4f5c\u5e9f")
    @PostMapping(value={"/cancel/{headId}"})
    @RequiresPermissions(value={"informationRecordsRequest#PurchaseInformationRecordsRequest:cancel"})
    public Result<?> cancel(@PathVariable(value="headId") String headId) {
        this.purchaseInformationRecordsRequestHeadService.cancel(headId);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u4ef7\u683c\u7533\u8bf7\u5934", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"informationRecordsRequest#PurchaseInformationRecordsRequest:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseInformationRecordsRequestHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u4ef7\u683c\u7533\u8bf7\u5934", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"informationRecordsRequest#PurchaseInformationRecordsRequest:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchaseInformationRecordsRequestHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"informationRecordsRequest#PurchaseInformationRecordsRequest:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseInformationRecordsRequestHead purchaseInformationRecordsRequestHead = (PurchaseInformationRecordsRequestHead)((Object)this.purchaseInformationRecordsRequestHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchaseInformationRecordsRequestHeadVO purchaseInformationRecordsRequestHeadVO = new PurchaseInformationRecordsRequestHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseInformationRecordsRequestHead), (Object)((Object)purchaseInformationRecordsRequestHeadVO));
        List<PurchaseInformationRecordsRequestItem> purchaseInformationRecordsRequestItemList = this.purchaseInformationRecordsRequestItemService.selectByMainId(id);
        purchaseInformationRecordsRequestHeadVO.setInformationRecordsRequestItemList(purchaseInformationRecordsRequestItemList);
        List attachmentDTOList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseInformationRecordsRequestHeadVO.setAttachmentList(attachmentDTOList);
        return Result.ok((Object)((Object)purchaseInformationRecordsRequestHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u4ef7\u683c\u7533\u8bf7\u5934id\u67e5\u8be2\u4ef7\u683c\u7533\u8bf7\u884c", notes="\u901a\u8fc7\u4ef7\u683c\u7533\u8bf7\u5934id\u67e5\u8be2\u4ef7\u683c\u7533\u8bf7\u884c")
    @GetMapping(value={"/queryPurchaseInformationRecordsRequestItemByMainId"})
    @RequiresPermissions(value={"informationRecordsRequest#PurchaseInformationRecordsRequest:queryById"})
    public Result<?> queryPurchaseInformationRecordsRequestItemListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseInformationRecordsRequestItem> purchaseInformationRecordsRequestItemList = this.purchaseInformationRecordsRequestItemService.selectByMainId(id);
        return Result.ok(purchaseInformationRecordsRequestItemList);
    }

    @AutoLog(busModule="\u4ef7\u683c\u7533\u8bf7\u5bfc\u51fa", value="\u4ef7\u683c\u7533\u8bf7\u5bfc\u51fa")
    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"informationRecordsRequest#PurchaseInformationRecordsRequest:export"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseInformationRecordsRequestExportServiceImpl.class);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"informationRecordsRequest#PurchaseInformationRecordsRequest:list"})
    public Result<?> queryTabsCount(PurchaseInformationRecordsRequestHead recordsRequestHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)recordsRequestHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"status");
        List list = ((PurchaseInformationRecordsRequestHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseInformationRecordsRequestHead::getStatus, PurchaseInformationRecordsRequestHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "status", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("priceRequestStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "status", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

