/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.api.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.excel.ExcelExportClassColumnDTO;
import com.els.common.util.ClassTypeBuilder;
import com.els.common.util.ConvertUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.OpenApiRpcService;
import com.els.modules.material.entity.PurchaseBomHead;
import com.els.modules.material.entity.PurchaseBomItem;
import com.els.modules.material.service.PurchaseBomHeadService;
import com.els.modules.material.service.PurchaseBomItemService;
import com.els.modules.material.vo.PurchaseBomHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseBomCreateOpenServiceImpl
implements OpenApiRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseBomCreateOpenServiceImpl.class);
    @Autowired
    private PurchaseBomHeadService purchaseBomHeadService;
    @Autowired
    private PurchaseBomItemService purchaseBomItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    public JSONObject doCreateInvoke(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap) {
        String account = TenantContext.getTenant();
        Date currentTime = new Date();
        ArrayList<PurchaseBomHead> headList = new ArrayList<PurchaseBomHead>();
        ArrayList allItem = new ArrayList();
        for (Object obj : array) {
            JSONObject object = (JSONObject)Convert.convert(JSONObject.class, obj);
            if (object.size() == 0) continue;
            PurchaseBomHead head = (PurchaseBomHead)((Object)ConvertUtils.convertDefault(PurchaseBomHead.class, (JSONObject)object, defaultHeadMap));
            head.setElsAccount(account);
            head.setCreateTime(currentTime);
            head.setUpdateBy(head.getCreateBy());
            head.setDeleted(CommonConstant.DEL_FLAG_0);
            head.setTemplateName(templateHead.getTemplateName());
            head.setTemplateNumber(templateHead.getTemplateNumber());
            head.setTemplateVersion(templateHead.getTemplateVersion());
            head.setTemplateAccount(templateHead.getElsAccount());
            if (CharSequenceUtil.isEmpty((CharSequence)head.getId())) {
                head.setId(SysUtil.getAssignId((Object)((Object)head)));
            }
            if (CharSequenceUtil.isEmpty((CharSequence)head.getNeedAudit())) {
                head.setNeedAudit("0");
            }
            if (!"1".equals(head.getNeedAudit())) {
                head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            } else if (CharSequenceUtil.isEmpty((CharSequence)head.getAuditStatus())) {
                head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            }
            headList.add(head);
            List itemList = null;
            JSONArray itemListJsonArray = null;
            if (object.containsKey((Object)"purchaseBomItemList")) {
                itemListJsonArray = object.getJSONArray("purchaseBomItemList");
            } else if (object.containsKey((Object)"itemList")) {
                itemListJsonArray = object.getJSONArray("itemList");
            }
            try {
                if (null == itemListJsonArray || itemListJsonArray.isEmpty() || null == (itemList = JSON.parseArray((String)itemListJsonArray.toJSONString(), PurchaseBomItem.class))) continue;
                for (PurchaseBomItem item : itemList) {
                    item.setHeadId(head.getId());
                    item.setElsAccount(account);
                    item.setCreateTime(currentTime);
                    item.setHeadId(head.getId());
                    item.setDeleted(CommonConstant.DEL_FLAG_0);
                }
                allItem.addAll(itemList);
            }
            catch (Exception e) {
                log.error("{}==>ItemList\u6570\u636e\u683c\u5f0f\u5f02\u5e38:{}", (Object)this.getBusinessType(), (Object)e.getMessage());
            }
        }
        if (!headList.isEmpty()) {
            PurchaseBomHead entity = (PurchaseBomHead)((Object)headList.get(0));
            long size = headList.stream().filter(x -> CharSequenceUtil.isEmpty((CharSequence)x.getBomNumber())).count();
            if (size > 0L) {
                List nextCodes = this.invokeBaseRpcService.getNextCodes("bomNumber", (Object)entity, (int)size);
                int codeIndex = 0;
                for (PurchaseBomHead e : headList) {
                    if (!CharSequenceUtil.isEmpty((CharSequence)e.getBomNumber())) continue;
                    e.setBomNumber((String)nextCodes.get(codeIndex++));
                }
            }
            this.purchaseBomHeadService.saveBatch(headList, 2000);
        }
        if (!allItem.isEmpty()) {
            this.purchaseBomItemService.saveBatch(allItem, 2000);
        }
        List collect = headList.stream().map(x -> (PurchaseBomHeadVO)((Object)((Object)Convert.convert(PurchaseBomHeadVO.class, (Object)x)))).collect(Collectors.toList());
        Map<String, List<PurchaseBomItem>> itemMap = allItem.stream().collect(Collectors.groupingBy(PurchaseBomItem::getHeadId));
        for (PurchaseBomHeadVO vo : collect) {
            vo.setPurchaseBomItemList(itemMap.get(vo.getId()));
        }
        JSONObject resultObj = new JSONObject();
        resultObj.put("headList", collect);
        return resultObj;
    }

    public void doParamCheck(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap, List<TemplateConfigHeadDTO> configHeadList, List<TemplateConfigItemDTO> configItemList) {
    }

    public String getBusinessType() {
        return "bom";
    }

    public List<ExcelExportClassColumnDTO> getBusinessClass() {
        return ClassTypeBuilder.buildClassTypeList(PurchaseBomHeadVO.class, null, null);
    }

    public List<String> supportItemList() {
        return Lists.newArrayList((Object[])new String[]{"purchaseBomItemList"});
    }
}

