/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.material.entity.PurchaseBomHead;
import com.els.modules.material.entity.PurchaseBomItem;
import com.els.modules.material.enumerate.PurchaseBomStatus;
import com.els.modules.material.service.PurchaseBomHeadService;
import com.els.modules.material.vo.PurchaseBomHeadVO;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseBomAdapter
implements AuditOptCallBackService {
    @Autowired
    PurchaseBomHeadService purchaseBomHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String params = StringUtils.isNotBlank((CharSequence)inputParamVO.getParams()) ? inputParamVO.getParams() : "{}";
        PurchaseBomHeadVO headVO = (PurchaseBomHeadVO)((Object)JSON.parseObject((String)params, PurchaseBomHeadVO.class));
        this.checkParams(headVO);
        PurchaseBomHead purchaseBomHead = new PurchaseBomHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)purchaseBomHead));
        purchaseBomHead.setBomStatus(PurchaseBomStatus.NEW.getValue());
        this.purchaseBomHeadService.updateMain(headVO, headVO.getPurchaseBomItemList());
        this.updateBom(inputParamVO, outputParamVO);
        for (String account : outputParamVO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
            String operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
        }
    }

    private void checkParams(PurchaseBomHeadVO headVO) {
        Assert.hasText((String)headVO.getMaterialNumber(), (String)I18nUtil.translate((String)"i18n_alert_VSMSLAo_a0c7ce40", (String)"\u8bf7\u586b\u5199\u7269\u6599\u7f16\u7801"));
        Assert.hasText((String)headVO.getBomPurpose(), (String)I18nUtil.translate((String)"i18n_alert_VSMWWWjP_ffae1be7", (String)"\u8bf7\u586b\u5199BOM\u7528\u9014"));
        Assert.hasText((String)headVO.getVersion(), (String)I18nUtil.translate((String)"i18n_alert_VSMrv_ddcd9169", (String)"\u8bf7\u586b\u5199\u7248\u672c"));
        Assert.notNull((Object)headVO.getEffectiveDate(), (String)I18nUtil.translate((String)"i18n_title_pleaseEffectiveDate", (String)"\u8bf7\u586b\u5199\u751f\u6548\u65e5\u671f"));
        Assert.notNull((Object)headVO.getExpiryDate(), (String)I18nUtil.translate((String)"i18n_title_pleaseLoseEffectiveDate", (String)"\u8bf7\u586b\u5199\u5931\u6548\u65e5\u671f"));
        List<PurchaseBomItem> itemList = headVO.getPurchaseBomItemList();
        for (PurchaseBomItem item : itemList) {
            Assert.hasText((String)item.getBomLevel(), (String)I18nUtil.translate((String)"i18n_alert_VSMcWFWWWWDt_b7397410", (String)"\u8bf7\u586b\u5199\u884c\u6570\u636e\uff1aBOM\u5c42\u7ea7"));
            Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"i18n_alert_VSMcWFWSLAo_cffdf2d0", (String)"\u8bf7\u586b\u5199\u884c\u6570\u636e\uff1a\u7269\u6599\u7f16\u7801"));
            Assert.hasText((String)item.getVirtualMaterial(), (String)I18nUtil.translate((String)"i18n_alert_VSMcWFWTxSL_d902b5aa", (String)"\u8bf7\u586b\u5199\u884c\u6570\u636e\uff1a\u865a\u62df\u7269\u6599"));
            Assert.hasText((String)item.getMaterialOrder(), (String)I18nUtil.translate((String)"i18n_alert_VSMcWFWAT_da61c952", (String)"\u8bf7\u586b\u5199\u884c\u6570\u636e\uff1a\u6392\u5e8f"));
        }
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseBomHead bomHead = new PurchaseBomHead();
        bomHead.setId(inputParamVO.getBusinessId());
        bomHead.setBomStatus(PurchaseBomStatus.NORMAL.getValue());
        bomHead.setAuditStatus(outputParamVO.getAuditStatus());
        bomHead.setFlowId(outputParamVO.getProcessRootId());
        this.purchaseBomHeadService.updateById((Object)bomHead);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditPass", (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                String operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                    operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateBom(inputParamVO, outputParamVO);
        MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateBom(inputParamVO, outputParamVO);
    }

    public JSONObject getDataById(String id) {
        PurchaseBomHead head = (PurchaseBomHead)((Object)this.purchaseBomHeadService.getById((Serializable)((Object)id)));
        if (head != null) {
            Result result = Result.ok((Object)((Object)head));
            ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
            JSONObject jsonObject = (JSONObject)result.getResult();
            return jsonObject;
        }
        return null;
    }

    private void updateBom(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseBomHead bomHead = new PurchaseBomHead();
        bomHead.setId(inputParamVO.getBusinessId());
        bomHead.setAuditStatus(outputParamVO.getAuditStatus());
        bomHead.setFlowId(outputParamVO.getProcessRootId());
        this.purchaseBomHeadService.updateById((Object)bomHead);
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String outAuditRejectUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String headId = inputParamVO.getBusinessId();
        PurchaseBomHead head = (PurchaseBomHead)((Object)this.purchaseBomHeadService.getById((Serializable)((Object)headId)));
        Result result = Result.ok((Object)((Object)head));
        ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

