/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.entity.PurchaseMaterialCode;
import com.els.modules.material.enumerate.MaterialCateStatusEnum;
import com.els.modules.material.service.PurchaseMaterialCodeService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseMaterialCodeImportImpl")
public class PurchaseMaterialCodeImportImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private PurchaseMaterialCodeService purchaseMaterialCodeService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        String elsAccount = TenantContext.getTenant();
        ArrayList<PurchaseMaterialCode> entityList = new ArrayList<PurchaseMaterialCode>();
        Iterator iterator = dataList.iterator();
        ArrayList<String> codes = new ArrayList<String>();
        String errorTitle = this.getErrorTitle();
        while (iterator.hasNext()) {
            Map data = (Map)iterator.next();
            String cateCode = (String)data.get("cateCode");
            if (!CharSequenceUtil.isNotBlank((CharSequence)cateCode)) continue;
            if (codes.contains(cateCode)) {
                String msg = I18nUtil.translate((String)"i18n_alert_MKdejSLzAAoWWWWWW_cb8a8ba", (String)"\u5b58\u5728\u76f8\u540c\u7684\u7269\u6599\u5206\u7c7b\u7f16\u7801\uff1a") + (String)cateCode;
                this.errorAdd(excelImportDTO, msg, data);
                iterator.remove();
                continue;
            }
            codes.add(cateCode);
        }
        List existList = this.purchaseMaterialCodeService.listByCodeList(codes, elsAccount).stream().map(PurchaseMaterialCode::getCateCode).collect(Collectors.toList());
        for (Map data : dataList) {
            String cateCode = (String)data.get("cateCode");
            if (CharSequenceUtil.isNotBlank((CharSequence)cateCode) && existList.contains(cateCode)) {
                String msg = I18nUtil.translate((String)"i18n_alert_MKdejSLzAAoWWWWWW_cb8a8ba", (String)"\u5b58\u5728\u76f8\u540c\u7684\u7269\u6599\u5206\u7c7b\u7f16\u7801\uff1a") + cateCode;
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            PurchaseMaterialCode entity = (PurchaseMaterialCode)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), PurchaseMaterialCode.class));
            entity.setElsAccount(elsAccount);
            entity.setCateStatus(MaterialCateStatusEnum.NORMAL.getValue());
            entity.setSourceType(StrUtil.emptyToDefault((CharSequence)entity.getSourceType(), (String)"2"));
            entity.setUpCateCode(StrUtil.emptyToDefault((CharSequence)entity.getUpCateCode(), (String)""));
            entityList.add(entity);
        }
        if (CollUtil.isEmpty(entityList)) {
            this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
            return dataList;
        }
        List<String> parentCodeList = entityList.stream().map(PurchaseMaterialCode::getUpCateCode).filter(CharSequenceUtil::isNotEmpty).distinct().collect(Collectors.toList());
        List<PurchaseMaterialCode> parentList = this.purchaseMaterialCodeService.listByCodeList(parentCodeList, elsAccount);
        Map parentMap = parentList.stream().collect(Collectors.toMap(PurchaseMaterialCode::getCateCode, Function.identity(), (v1, v2) -> v2));
        Map currentMap = entityList.stream().collect(Collectors.toMap(PurchaseMaterialCode::getCateCode, Function.identity(), (v1, v2) -> v2));
        for (PurchaseMaterialCode code : entityList) {
            if (!StrUtil.isNotEmpty((CharSequence)code.getUpCateCode())) continue;
            PurchaseMaterialCode tem = (PurchaseMaterialCode)((Object)parentMap.get(code.getUpCateCode()));
            if (null == tem) {
                tem = (PurchaseMaterialCode)((Object)currentMap.get(code.getUpCateCode()));
            }
            if (null != tem) {
                code.setUpCateName(tem.getUpCateName());
                continue;
            }
            code.setUpCateCode("");
            code.setUpCateName(null);
        }
        this.purchaseMaterialCodeService.saveBatch(entityList);
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

