/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.controller;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.enumerate.PriceStatusEnum;
import com.els.modules.price.excel.PurchaseInformationRecordsExportServiceImpl;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import com.els.modules.price.vo.HisQuotePriceTrendVO;
import com.els.modules.price.vo.PurchaseInformationRecordsVO;
import com.els.modules.price.vo.QueryPriceVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u4ef7\u683c\u4e3b\u6570\u636e"})
@RestController
@RequestMapping(value={"/price/purchaseInformationRecords"})
@BusinessModule(module="price")
public class PurchaseInformationRecordsController
extends BaseController<PurchaseInformationRecords, PurchaseInformationRecordsService> {
    @Autowired
    private PurchaseInformationRecordsService purchaseInformationRecordsService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"price#PurchaseInformationRecords:list"})
    @PermissionDataView(businessType="price")
    public Result<?> queryPageList(PurchaseInformationRecords purchaseInformationRecords, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseInformationRecords), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseInformationRecordsService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/itemList"})
    @RequiresPermissions(value={"price#PurchaseInformationRecords:list"})
    @PermissionDataView(businessType="price")
    public Result<?> queryPageItemList(PurchaseInformationRecords purchaseInformationRecords, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseInformationRecords), (Map)req.getParameterMap());
        ((LambdaQueryWrapper)queryWrapper.lambda().in(PurchaseInformationRecords::getRecordStatus, (Collection)Lists.newArrayList((Object[])new String[]{PriceStatusEnum.EFFECTIVE.getValue(), PriceStatusEnum.NORMAL.getValue()}))).in(PurchaseInformationRecords::getAuditStatus, (Collection)Lists.newArrayList((Object[])new String[]{AuditStatusEnum.NO_AUDIT_REQUIRED.getValue(), AuditStatusEnum.AUDIT_FINISH.getValue()}));
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseInformationRecordsService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u5206\u9875\u67e5\u8be2\u6709\u6548\u671f\u5185\u7684\u4ef7\u683c")
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6709\u6548\u671f\u5185\u7684\u4ef7\u683c", notes="\u5206\u9875\u67e5\u8be2\u6709\u6548\u671f\u5185\u7684\u4ef7\u683c")
    @GetMapping(value={"/avliabledPrice"})
    @RequiresPermissions(value={"price#PurchaseInformationRecords:list"})
    public Result<?> queryPageAvliabledPriceList(PurchaseInformationRecords purchaseInformationRecords, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseInformationRecords), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"purchase_org", (Object)purchaseInformationRecords.getPurchaseOrg());
        queryWrapper.eq((Object)"to_els_account", (Object)purchaseInformationRecords.getToElsAccount());
        queryWrapper.eq((Object)"material_number", (Object)purchaseInformationRecords.getMaterialNumber());
        if (StringUtils.isNotEmpty((CharSequence)purchaseInformationRecords.getFactory())) {
            queryWrapper.eq((Object)"factory", (Object)purchaseInformationRecords.getFactory());
        }
        if (StringUtils.isNotEmpty((CharSequence)purchaseInformationRecords.getToCompany())) {
            queryWrapper.eq((Object)"to_company", (Object)purchaseInformationRecords.getToCompany());
        }
        queryWrapper.and(qw -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)qw.eq((Object)"record_status", (Object)PriceStatusEnum.NORMAL.getValue())).or(qw1 -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)qw1.eq((Object)"record_status", (Object)PriceStatusEnum.EFFECTIVE.getValue());
            });
        });
        queryWrapper.le((Object)"effective_date", (Object)DateUtil.beginOfDay((Date)new Date()));
        ((QueryWrapper)((QueryWrapper)queryWrapper.ge((Object)"expiry_date", (Object)DateUtil.beginOfDay((Date)new Date()))).isNotNull((Object)"effective_date")).isNotNull((Object)"expiry_date");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseInformationRecordsService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u89c4\u5212\u6c42\u89e3\u7684\u53c2\u6570\u6c42\u89e3\u67e5\u627e\u4ef7\u683c", notes="\u89c4\u5212\u6c42\u89e3\u7684\u53c2\u6570\u6c42\u89e3\u67e5\u627e\u4ef7\u683c")
    @PostMapping(value={"/lpFindPrice"})
    @RequiresPermissions(value={"price#PurchaseInformationRecords:list"})
    public Result<?> lpFindPrice(@RequestBody PurchaseInformationRecords purchaseInformationRecords) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(PurchaseInformationRecords::getPurchaseOrg, (Object)purchaseInformationRecords.getPurchaseOrg());
        lambdaQueryWrapper.in(PurchaseInformationRecords::getToElsAccount, (Object[])purchaseInformationRecords.getToElsAccount().split(","));
        lambdaQueryWrapper.in(PurchaseInformationRecords::getMaterialNumber, (Object[])purchaseInformationRecords.getMaterialNumber().split(","));
        lambdaQueryWrapper.eq(PurchaseInformationRecords::getRecordStatus, (Object)PriceStatusEnum.EFFECTIVE.getValue());
        lambdaQueryWrapper.le(PurchaseInformationRecords::getEffectiveDate, (Object)new Date());
        lambdaQueryWrapper.ge(PurchaseInformationRecords::getExpiryDate, (Object)new Date());
        lambdaQueryWrapper.isNotNull(PurchaseInformationRecords::getEffectiveDate);
        lambdaQueryWrapper.isNotNull(PurchaseInformationRecords::getExpiryDate);
        List informationRecordsList = this.purchaseInformationRecordsService.list((Wrapper)lambdaQueryWrapper);
        return Result.ok((Object)informationRecordsList);
    }

    @SrmValidated
    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u6dfb\u52a0", operateType=2)
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"price#PurchaseInformationRecords:add"})
    @PermissionDataOpt(businessType="price", beanClass=PurchaseInformationRecordsService.class)
    public Result<?> add(@RequestBody PurchaseInformationRecordsVO purchaseInformationRecords) {
        if (StringUtils.isNotEmpty((CharSequence)purchaseInformationRecords.getToElsAccount()) && purchaseInformationRecords.getToElsAccount().equals(purchaseInformationRecords.getElsAccount()) && StringUtils.isNotEmpty((CharSequence)purchaseInformationRecords.getToCompany()) && StringUtils.isNotEmpty((CharSequence)purchaseInformationRecords.getCompany()) && purchaseInformationRecords.getCompany().equals(purchaseInformationRecords.getToCompany())) {
            throw new ELSBootException("\u516c\u53f8\u95f4\u5355\u636e\uff0c\u516c\u53f8\u4ee3\u7801\u548c\u4f9b\u5e94\u5546\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u76f8\u540c");
        }
        this.purchaseInformationRecordsService.savePurchaseInformationRecords(purchaseInformationRecords, purchaseInformationRecords.getAttachmentList());
        return Result.ok((Object)((Object)purchaseInformationRecords));
    }

    @SrmValidated
    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u5ba1\u6279\u9884\u68c0\u67e5")
    @ApiOperation(value="\u5ba1\u6279\u9884\u68c0\u67e5", notes="\u5ba1\u6279\u9884\u68c0\u67e5")
    @PostMapping(value={"/auditPreCheck"})
    @RequiresPermissions(value={"price#PurchaseInformationRecords:auditPreCheck"})
    public Result<?> auditPreCheck(@RequestBody List<PurchaseInformationRecords> recordsList) {
        this.purchaseInformationRecordsService.auditPreCheck(recordsList);
        return Result.ok();
    }

    @SrmValidated
    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"price#PurchaseInformationRecords:edit"})
    @PermissionDataOpt(businessType="price", beanClass=PurchaseInformationRecordsService.class)
    public Result<?> edit(@RequestBody PurchaseInformationRecordsVO purchaseInformationRecords) {
        if (StringUtils.isNotEmpty((CharSequence)purchaseInformationRecords.getToElsAccount()) && purchaseInformationRecords.getToElsAccount().equals(purchaseInformationRecords.getElsAccount()) && StringUtils.isNotEmpty((CharSequence)purchaseInformationRecords.getToCompany()) && StringUtils.isNotEmpty((CharSequence)purchaseInformationRecords.getCompany()) && purchaseInformationRecords.getCompany().equals(purchaseInformationRecords.getToCompany())) {
            throw new ELSBootException("\u516c\u53f8\u95f4\u5355\u636e\uff0c\u516c\u53f8\u4ee3\u7801\u548c\u4f9b\u5e94\u5546\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u76f8\u540c");
        }
        this.purchaseInformationRecordsService.updatePurchaseInformationRecords(purchaseInformationRecords, purchaseInformationRecords.getAttachmentList());
        return Result.ok((Object)((Object)purchaseInformationRecords));
    }

    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u901a\u8fc7id\u51bb\u7ed3")
    @ApiOperation(value="\u901a\u8fc7id\u51bb\u7ed3", notes="\u901a\u8fc7id\u51bb\u7ed3")
    @GetMapping(value={"/frozen"})
    @RequiresPermissions(value={"price#PurchaseInformationRecords:frozen"})
    @PermissionDataOpt(businessType="price", beanClass=PurchaseInformationRecordsService.class)
    public Result<?> frozen(@RequestParam(name="id") String id) {
        this.purchaseInformationRecordsService.frozenPurchaseInformationRecords(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u901a\u8fc7id\u89e3\u51bb")
    @ApiOperation(value="\u901a\u8fc7id\u89e3\u51bb", notes="\u901a\u8fc7id\u89e3\u51bb")
    @GetMapping(value={"/thaw"})
    @RequiresPermissions(value={"price#PurchaseInformationRecords:thaw"})
    @PermissionDataOpt(businessType="price", beanClass=PurchaseInformationRecordsService.class)
    public Result<?> thaw(@RequestParam(name="id") String id) {
        this.purchaseInformationRecordsService.thawPurchaseInformationRecords(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u901a\u8fc7id\u4f5c\u5e9f")
    @ApiOperation(value="\u901a\u8fc7id\u4f5c\u5e9f", notes="\u901a\u8fc7id\u4f5c\u5e9f")
    @GetMapping(value={"/cancel"})
    @RequiresPermissions(value={"price#PurchaseInformationRecords:cancel"})
    @PermissionDataOpt(businessType="price", beanClass=PurchaseInformationRecordsService.class)
    public Result<?> cancel(@RequestParam(name="id") String id) {
        this.purchaseInformationRecordsService.cancelPurchaseInformationRecords(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"price#PurchaseInformationRecords:delete"})
    @PermissionDataOpt(businessType="price", beanClass=PurchaseInformationRecordsService.class)
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseInformationRecordsService.delPurchaseInformationRecords(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"price#PurchaseInformationRecords:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.purchaseInformationRecordsService.delBatchPurchaseInformationRecords(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"price#PurchaseInformationRecords:queryById"})
    @PermissionDataOpt(businessType="price", beanClass=PurchaseInformationRecordsService.class)
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseInformationRecords purchaseInformationRecords = (PurchaseInformationRecords)((Object)this.purchaseInformationRecordsService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        List attachmentDTOS = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        PurchaseInformationRecordsVO vo = (PurchaseInformationRecordsVO)((Object)Convert.convert(PurchaseInformationRecordsVO.class, (Object)((Object)purchaseInformationRecords)));
        vo.setAttachmentList(attachmentDTOS);
        return Result.ok((Object)((Object)vo));
    }

    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u6839\u636e\u7269\u6599\u7f16\u7801\u67e5\u8be2\u5386\u53f2\u4ef7\u683c")
    @ApiOperation(value="\u6839\u636e\u7269\u6599\u7f16\u7801\u67e5\u8be2\u5386\u53f2\u4ef7\u683c", notes="\u6839\u636e\u7269\u6599\u7f16\u7801\u67e5\u8be2\u5386\u53f2\u4ef7\u683c")
    @PostMapping(value={"/queryPriceByMaterial"})
    @RequiresPermissions(value={"price#PurchaseInformationRecords:list"})
    public Result<?> queryPriceByMaterial(@RequestBody QueryPriceVO queryPriceVO) {
        HisQuotePriceTrendVO trendVO = this.purchaseInformationRecordsService.findTrendByMaterial(queryPriceVO);
        return Result.ok((Object)trendVO);
    }

    @AutoLog(value="\u4ef7\u683c\u4e3b\u6570\u636e-\u521b\u5efa\u8d27\u6e90\u6e05\u5355")
    @ApiOperation(value="\u521b\u5efa\u8d27\u6e90\u6e05\u5355", notes="\u521b\u5efa\u8d27\u6e90\u6e05\u5355")
    @PostMapping(value={"/createMaterialSource"})
    @RequiresPermissions(value={"price#PurchaseInformationRecords:createMaterialSource"})
    @PermissionDataOpt(businessType="price", beanClass=PurchaseInformationRecordsService.class)
    public Result<?> createMaterialSource(@RequestBody PurchaseInformationRecordsVO recordsVO) {
        String sourceNumber = this.purchaseInformationRecordsService.createMaterialSource(recordsVO.getPurchaseInformationRecordsList());
        return Result.ok((String)(I18nUtil.translate((String)"i18n_alert_cILRWSjVttyL_63eb5b21", (String)"\u521b\u5efa\u6210\u529f\uff0c\u8d27\u6e90\u6e05\u5355\u5355\u53f7\u4e3a\uff1a") + sourceNumber));
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @PermissionDataView(businessType="price")
    @RequiresPermissions(value={"price#PurchaseInformationRecords:list"})
    public Result<?> queryTabsCount(PurchaseInformationRecords purchaseInformationRecords, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseInformationRecords), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"record_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"record_status");
        List list = ((PurchaseInformationRecordsService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseInformationRecords::getRecordStatus, PurchaseInformationRecords::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "recordStatus", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("priceStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "recordStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @PostMapping(value={"/exportXls"})
    @PermissionDataView(businessType="price")
    @RequiresPermissions(value={"price#PurchaseInformationRecords:export"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseInformationRecordsExportServiceImpl.class);
    }

    @ApiOperation(value="\u83b7\u53d6ERP\u6570\u636e", notes="\u83b7\u53d6ERP\u6570\u636e")
    @GetMapping(value={"/getDataByErp"})
    @RequiresPermissions(value={"price#purchaseInformationRecords:getDataByErp"})
    public Result<?> getDataByErp() {
        this.purchaseInformationRecordsService.getDataByErp();
        return Result.ok();
    }

    @ApiOperation(value="SRM\u63a8\u9001\u5230ERP", notes="SRM\u63a8\u9001\u5230ERP")
    @GetMapping(value={"/pushDataToErp"})
    @RequiresPermissions(value={"price#PurchaseInformationRecords:pushDataToErp"})
    public Result<?> pushDataToErp(@RequestParam(value="ids") String ids) {
        this.purchaseInformationRecordsService.pushDataToErp(ids);
        return Result.ok();
    }

    @SrmValidated
    @AutoLog(busModule="\u4ef7\u683c\u7533\u8bf7\u5934", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/priceAnalyseByMaterial"})
    @RequiresPermissions(value={"price#PurchaseInformationRecords:priceAnalyseByMaterial"})
    @PermissionDataOpt(businessType="price", beanClass=PurchaseInformationRecordsService.class)
    public Result<?> priceAnalyseByMaterial(@RequestBody PurchaseInformationRecords head) {
        List<JSONObject> jsonObjects = this.purchaseInformationRecordsService.priceAnalyseByMaterial(head);
        return Result.ok(jsonObjects);
    }
}

