/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseOpenServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.material.api.dto.PurchaseMaterialCodeDTO;
import com.els.modules.material.entity.PurchaseMaterialCode;
import com.els.modules.material.enumerate.MaterialCateStatusEnum;
import com.els.modules.material.mapper.PurchaseMaterialCodeMapper;
import com.els.modules.material.service.PurchaseMaterialCodeService;
import com.els.modules.material.vo.TreeMaterialCodeNode;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class PurchaseMaterialCodeServiceImpl
extends BaseOpenServiceImpl<PurchaseMaterialCodeMapper, PurchaseMaterialCode, PurchaseMaterialCode>
implements PurchaseMaterialCodeService {
    @Autowired
    private PurchaseMaterialCodeMapper purchaseMaterialCodeMapper;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private InterfaceUtil interfaceUtil;
    private static final String CATALOGUE = "sys:dict:";
    private static final String COLON = ":";

    @Override
    public void savePurchaseMaterialCode(PurchaseMaterialCode purchaseMaterialCode) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.select(new SFunction[]{BaseEntity::getId});
        queryWrapper.eq(PurchaseMaterialCode::getCateCode, (Object)purchaseMaterialCode.getCateCode());
        List code = ((PurchaseMaterialCodeMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)code) && code.size() >= 1) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_MKdejSLzAAoWWWWWW_cb8a8ba", (String)("\u5b58\u5728\u76f8\u540c\u7684\u7269\u6599\u5206\u7c7b\u7f16\u7801\uff1a" + purchaseMaterialCode.getCateCode()), (String[])new String[]{purchaseMaterialCode.getCateCode()}));
        }
        if (null == purchaseMaterialCode.getUpCateCode()) {
            purchaseMaterialCode.setUpCateCode("");
        }
        purchaseMaterialCode.setCateStatus(MaterialCateStatusEnum.NORMAL.getValue());
        ((PurchaseMaterialCodeMapper)this.baseMapper).insert((Object)purchaseMaterialCode);
    }

    @Override
    public void updatePurchaseMaterialCode(PurchaseMaterialCode purchaseMaterialCode) {
        PurchaseMaterialCode oldCode = (PurchaseMaterialCode)((Object)((PurchaseMaterialCodeMapper)this.baseMapper).selectById((Serializable)((Object)purchaseMaterialCode.getId())));
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.select(new SFunction[]{BaseEntity::getId});
        ((LambdaQueryWrapper)queryWrapper.eq(PurchaseMaterialCode::getCateCode, (Object)purchaseMaterialCode.getCateCode())).ne(BaseEntity::getId, (Object)purchaseMaterialCode.getId());
        List code = ((PurchaseMaterialCodeMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (CollUtil.isNotEmpty((Collection)code)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_MKdejSLzAAoWWWWWW_cb8a8ba", (String)("\u5b58\u5728\u76f8\u540c\u7684\u7269\u6599\u5206\u7c7b\u7f16\u7801\uff1a" + purchaseMaterialCode.getCateCode()), (String[])new String[]{purchaseMaterialCode.getCateCode()}));
        }
        if (null == purchaseMaterialCode.getUpCateCode()) {
            purchaseMaterialCode.setUpCateCode("");
        }
        if (purchaseMaterialCode.getUpCateCode().equals(purchaseMaterialCode.getCateCode())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_xOiFJtkLXtSLzA_94841197", (String)"\u4e0d\u80fd\u9009\u62e9\u81ea\u5df1\u4f5c\u4e3a\u4e0a\u7ea7\u7269\u6599\u5206\u7c7b"));
        }
        int count = ((PurchaseMaterialCodeMapper)this.baseMapper).updateById((Object)purchaseMaterialCode);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        if (!oldCode.getCateCode().equals(purchaseMaterialCode.getCateCode())) {
            LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.eq(PurchaseMaterialCode::getUpCateCode, (Object)oldCode.getCateCode());
            updateWrapper.set(PurchaseMaterialCode::getUpCateCode, (Object)purchaseMaterialCode.getCateCode());
            ((PurchaseMaterialCodeMapper)this.baseMapper).update((Object)new PurchaseMaterialCode(), (Wrapper)updateWrapper);
        }
        this.deleteRedis("purchase_material_code");
    }

    private void deleteRedis(String table) {
        StringBuffer redisKey = new StringBuffer(CATALOGUE);
        redisKey.append(TenantContext.getTenant()).append(COLON).append(table);
        this.redisUtil.deleteByPrex(redisKey.toString());
    }

    @Override
    public void frozenPurchaseMaterialCode(String id) {
        PurchaseMaterialCode materialCode = new PurchaseMaterialCode();
        materialCode.setId(id);
        materialCode.setCateStatus(MaterialCateStatusEnum.FROZEN.getValue());
        PurchaseMaterialCode purchaseMaterialCode = (PurchaseMaterialCode)((Object)this.purchaseMaterialCodeMapper.selectById((Serializable)((Object)id)));
        int count = this.purchaseMaterialCodeMapper.updateById((Object)materialCode);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        if (!ObjectUtils.isEmpty((Object)((Object)purchaseMaterialCode))) {
            ArrayList<PurchaseMaterialCode> list = new ArrayList<PurchaseMaterialCode>();
            list.add(purchaseMaterialCode);
            ArrayList purchaseMaterialCodeDTOS = SysUtil.copyProperties(list, PurchaseMaterialCodeDTO.class);
            MqUtil.sendOperateEventMsg((String)TenantContext.getTenant(), (String)"MaterialCode", (String)"delete", (String)"deleteMaterialCodeDataToMall", (Object)purchaseMaterialCodeDTOS);
        }
    }

    @Override
    public void thawPurchaseMaterialCode(String id) {
        PurchaseMaterialCode materialCode = new PurchaseMaterialCode();
        materialCode.setId(id);
        materialCode.setCateStatus(MaterialCateStatusEnum.NORMAL.getValue());
        int count = this.purchaseMaterialCodeMapper.updateById((Object)materialCode);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void cancelPurchaseMaterialCode(String id) {
        PurchaseMaterialCode materialCode = new PurchaseMaterialCode();
        materialCode.setId(id);
        materialCode.setCateStatus(MaterialCateStatusEnum.CANCEL.getValue());
        int count = this.purchaseMaterialCodeMapper.updateById((Object)materialCode);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void delPurchaseMaterialCode(String id) {
        ((PurchaseMaterialCodeMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseMaterialCode(List<String> idList) {
        ((PurchaseMaterialCodeMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<TreeMaterialCodeNode> getMaterialCodeTree(QueryWrapper<PurchaseMaterialCode> queryWrapper) {
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).in(PurchaseMaterialCode::getCateStatus, (Collection)Lists.newArrayList((Object[])new String[]{"1", "2"}));
        List<TreeMaterialCodeNode> list = ((PurchaseMaterialCodeMapper)this.getBaseMapper()).selectByElsAccount((Wrapper)queryWrapper);
        for (TreeMaterialCodeNode node2 : list) {
            node2.setKey(node2.getCateCode());
            node2.setValue(node2.getCateLevelCode());
        }
        List<TreeMaterialCodeNode> rootNodeList = list.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getUpCateCode())).collect(Collectors.toList());
        if (rootNodeList.isEmpty()) {
            return list;
        }
        Map<String, List<TreeMaterialCodeNode>> groupMap = list.parallelStream().filter(node -> StringUtils.isNotBlank((CharSequence)node.getUpCateCode())).collect(Collectors.groupingBy(TreeMaterialCodeNode::getUpCateCode));
        for (TreeMaterialCodeNode node3 : rootNodeList) {
            this.forEach(groupMap, node3);
        }
        return rootNodeList;
    }

    @Override
    public List<PurchaseMaterialCode> listByCodeList(List<String> parentCodeList, String elsAccount) {
        if (CollUtil.isEmpty(parentCodeList)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).in(PurchaseMaterialCode::getCateCode, parentCodeList);
        return ((PurchaseMaterialCodeMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    private void forEach(Map<String, List<TreeMaterialCodeNode>> collect, TreeMaterialCodeNode treeNode) {
        List<TreeMaterialCodeNode> treeNodelist = collect.get(treeNode.getKey());
        if (collect.get(treeNode.getKey()) != null) {
            treeNode.setChildren(treeNodelist);
            treeNode.setHasChildren(true);
            treeNode.getChildren().forEach(t -> this.forEach(collect, (TreeMaterialCodeNode)t));
        }
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getMaterialClass", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List materialCodeList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchaseMaterialCode head2 : materialCodeList) {
            this.pushDataToErp(head2);
        }
    }

    private void pushDataToErp(PurchaseMaterialCode head) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "pushMaterialCodeToERP", (Object)head);
    }

    @Override
    public List<PurchaseMaterialCode> listByElsAccount(String elsAccount) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(PurchaseMaterialCode::getCateStatus, (Object)"1");
        return ((PurchaseMaterialCodeMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public List<PurchaseMaterialCode> listMaterialCodeBySale(List<String> codes, String elsAccount) {
        return ((PurchaseMaterialCodeMapper)this.baseMapper).listMaterialCodeBySale(codes, elsAccount);
    }

    @Override
    public void batchSaveMain(List<PurchaseMaterialCode> purchaseMaterialHeadVOList, List<String> saveColumn, Integer saveLeven, String sourceType) {
        String elsAccount = TenantContext.getTenant();
        Map<String, PurchaseMaterialCode> dbMap = this.getPurchaseMaterialCode(elsAccount, purchaseMaterialHeadVOList);
        HashMap<String, PurchaseMaterialCode> allMap = new HashMap<String, PurchaseMaterialCode>(dbMap);
        ArrayList<PurchaseMaterialCode> insertList = new ArrayList<PurchaseMaterialCode>();
        ArrayList<PurchaseMaterialCode> updateList = new ArrayList<PurchaseMaterialCode>();
        for (PurchaseMaterialCode materialCode : purchaseMaterialHeadVOList) {
            allMap.put(materialCode.getSourceId(), materialCode);
            if (dbMap.containsKey(materialCode.getSourceId())) {
                PurchaseMaterialCode purchaseMaterialCode = dbMap.get(materialCode.getSourceId());
                materialCode.setId(purchaseMaterialCode.getId());
                updateList.add(materialCode);
                continue;
            }
            insertList.add(materialCode);
        }
        if (!CollUtil.isEmpty(insertList)) {
            this.saveBatch(insertList, 200);
        }
        if (!CollUtil.isEmpty(updateList)) {
            this.updateBatchById(updateList, 200);
        }
    }

    private Map<String, PurchaseMaterialCode> getPurchaseMaterialCode(String elsAccount, List<PurchaseMaterialCode> resultData) {
        List sourceIds = resultData.stream().map(PurchaseMaterialCode::getSourceId).collect(Collectors.toList());
        List dbList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(PurchaseMaterialCode::getSourceId, sourceIds)).eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(BaseEntity::getDeleted, (Object)0));
        if (CollectionUtil.isEmpty((Collection)dbList)) {
            return new HashMap<String, PurchaseMaterialCode>();
        }
        return dbList.stream().collect(Collectors.toMap(PurchaseMaterialCode::getSourceId, Function.identity()));
    }

    public int insertBatchSomeColumn(List<PurchaseMaterialCode> entityList) {
        return ((PurchaseMaterialCodeMapper)this.baseMapper).insertBatchSomeColumn(entityList);
    }
}

