/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.thirddata.website;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.thirddata.entity.BulkMaterialPrice;
import com.els.modules.thirddata.website.PriceResultPipeline;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.Selectable;

public class ZhaoSuLiaoProcessor
implements PageProcessor {
    private static final Logger log = LoggerFactory.getLogger(ZhaoSuLiaoProcessor.class);
    private Site site = Site.me().setRetryTimes(3).setSleepTime(100);

    public void process(Page page) {
        List selectableList = page.getHtml().xpath("//div[@class='xhzy_list_content']/table[@class='xhzy_table']/tbody/tr").nodes();
        ArrayList<BulkMaterialPrice> list = new ArrayList<BulkMaterialPrice>();
        Date date = new Date();
        for (Selectable selectable : selectableList) {
            String category = selectable.xpath("//td[@class='td_w80']/span/text()").toString();
            if (StrUtil.isBlank((CharSequence)category)) continue;
            try {
                String trademark = selectable.xpath("//td[@class='td_w120']/span/text()").toString();
                String vender = selectable.xpath("//td[@class='td_w130']/text()").toString();
                String price = selectable.xpath("//td[@class='td_w100 fcolor_8']/text()").toString();
                BulkMaterialPrice materialPrice = new BulkMaterialPrice();
                materialPrice.setMaterialListType("\u5851\u6599");
                materialPrice.setClassification("\u901a\u7528\u5851\u6599");
                materialPrice.setCategoryName(category);
                materialPrice.setMaterialSpec(trademark);
                materialPrice.setMakeCompany(vender);
                materialPrice.setPriceUnit("\u5428");
                materialPrice.setCurrency("\u4eba\u6c11\u5e01");
                materialPrice.setPriceType("\u4f01\u4e1a\u62a5\u4ef7");
                materialPrice.setPriceCondition("\u5355\u65e5\u4ef7\u683c");
                materialPrice.setPriceDate(date);
                materialPrice.setPriceSource("\u627e\u5851\u6599");
                String priceStr = price.substring(1, price.length());
                materialPrice.setPrice(new BigDecimal(priceStr));
                materialPrice.setId(IdWorker.getIdStr());
                materialPrice.setElsAccount(TenantContext.getTenant());
                materialPrice.setCreateTime(date);
                materialPrice.setUpdateTime(date);
                materialPrice.setCreateBy(SysUtil.getUserRealName());
                materialPrice.setUpdateBy(SysUtil.getUserRealName());
                materialPrice.setDeleted(CommonConstant.DEL_FLAG_0);
                list.add(materialPrice);
            }
            catch (Exception e) {
                log.error("process_failed:", (Throwable)e);
            }
        }
        page.putField("priceList", list);
    }

    public Site getSite() {
        return this.site;
    }

    public static void main(String[] args) {
        Spider.create((PageProcessor)new ZhaoSuLiaoProcessor()).addUrl(new String[]{"http://www.zhaosuliao.com/product?cate=&material=&manufacturer=&company=&city=%E4%B8%9C%E8%8E%9E&defaultSort=&priceFrom=&priceTo=&dayCon=30&pageNo=1&pageSize=200"}).addPipeline((Pipeline)new PriceResultPipeline()).thread(1).run();
    }
}

