/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.price.api.enumerate.PriceRecordTypeEnum;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.entity.PurchaseInformationRecordsRequestHead;
import com.els.modules.price.entity.PurchaseInformationRecordsRequestItem;
import com.els.modules.price.entity.SaleInformationRecordsRequestHead;
import com.els.modules.price.entity.SaleInformationRecordsRequestItem;
import com.els.modules.price.enumerate.PriceRequestCreatePriceTypeEnum;
import com.els.modules.price.enumerate.PriceRequestOptTypeEnum;
import com.els.modules.price.enumerate.PriceRequestSendStatusEnum;
import com.els.modules.price.enumerate.PriceRequestStatusEnum;
import com.els.modules.price.enumerate.PriceSourceTypeEnum;
import com.els.modules.price.enumerate.PriceStatusEnum;
import com.els.modules.price.mapper.PurchaseInformationRecordsRequestHeadMapper;
import com.els.modules.price.mapper.PurchaseInformationRecordsRequestItemMapper;
import com.els.modules.price.mapper.SaleInformationRecordsRequestHeadMapper;
import com.els.modules.price.mapper.SaleInformationRecordsRequestItemMapper;
import com.els.modules.price.service.PurchaseInformationRecordsRequestHeadService;
import com.els.modules.price.service.PurchaseInformationRecordsRequestItemService;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import com.els.modules.price.service.SaleInformationRecordsRequestItemService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseInformationRecordsRequestHeadServiceImpl
extends BaseServiceImpl<PurchaseInformationRecordsRequestHeadMapper, PurchaseInformationRecordsRequestHead>
implements PurchaseInformationRecordsRequestHeadService {
    @Autowired
    private PurchaseInformationRecordsRequestHeadMapper purchaseInformationRecordsRequestHeadMapper;
    @Autowired
    private PurchaseInformationRecordsRequestItemMapper purchaseInformationRecordsRequestItemMapper;
    @Autowired
    private SaleInformationRecordsRequestHeadMapper saleInformationRecordsRequestHeadMapper;
    @Autowired
    private SaleInformationRecordsRequestItemMapper saleInformationRecordsRequestItemMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseInformationRecordsRequestHead head, List<PurchaseInformationRecordsRequestItem> itemList, List<PurchaseAttachmentDTO> attachmentDTOList) {
        head.setRequestNumber(this.invokeBaseRpcService.getNextCode("informationRecordsRequest", (Object)head));
        this.purchaseInformationRecordsRequestHeadMapper.insert((Object)head);
        super.setHeadDefaultValue((BaseEntity)head);
        this.insertData(head, itemList, attachmentDTOList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseInformationRecordsRequestHead head, List<PurchaseInformationRecordsRequestItem> itemList, List<PurchaseAttachmentDTO> attachmentDTOList) {
        int count = this.purchaseInformationRecordsRequestHeadMapper.updateById((Object)head);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        this.purchaseInformationRecordsRequestItemMapper.deleteByMainId(head.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(head.getId());
        this.insertData(head, itemList, attachmentDTOList);
    }

    private Map<String, PurchaseInformationRecords> loadOldPriceRecords(List<String> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{BaseEntity::getId, PurchaseInformationRecords::getTemplateAccount, PurchaseInformationRecords::getTemplateName, PurchaseInformationRecords::getBusAccount, PurchaseInformationRecords::getTemplateVersion, PurchaseInformationRecords::getTemplateNumber});
        wrapper.in(BaseEntity::getId, ids);
        List list = ((PurchaseInformationRecordsService)SpringContextUtils.getBean(PurchaseInformationRecordsService.class)).list((Wrapper)wrapper);
        return list.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
    }

    @Override
    public List<PurchaseInformationRecords> checkPrice(PurchaseInformationRecordsRequestHead head, List<PurchaseInformationRecordsRequestItem> itemList, boolean onCheck) {
        if (CollectionUtils.isEmpty(itemList)) {
            return Lists.newArrayList();
        }
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("price");
        com.els.common.util.Assert.isNotNull((Object)templateList, (String)I18nUtil.translate((String)"", (String)"\u8bf7\u5148\u914d\u7f6e\u4ef7\u683c\u4e3b\u6570\u636e\u4e1a\u52a1\u6a21\u677f"));
        TemplateHeadDTO templateHeadDTO = (TemplateHeadDTO)templateList.get(0);
        List<String> oldRecordIds = itemList.stream().filter(x -> CharSequenceUtil.isNotEmpty((CharSequence)x.getInfoRecordId())).map(BaseEntity::getId).distinct().collect(Collectors.toList());
        Map<String, PurchaseInformationRecords> recordsMap = this.loadOldPriceRecords(oldRecordIds);
        PurchaseInformationRecordsService service = (PurchaseInformationRecordsService)SpringContextUtils.getBean(PurchaseInformationRecordsService.class);
        ArrayList<PurchaseInformationRecords> recordsList = new ArrayList<PurchaseInformationRecords>(itemList.size());
        for (int index = 0; index < itemList.size(); ++index) {
            PurchaseInformationRecords oldRecord;
            PurchaseInformationRecordsRequestItem item = itemList.get(index);
            PurchaseInformationRecords records = (PurchaseInformationRecords)((Object)Convert.convert(PurchaseInformationRecords.class, (Object)((Object)item)));
            records.setSourceType(PriceSourceTypeEnum.PRICE_REQUEST.getValue());
            records.setRequestPriceId(item.getId());
            records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
            records.setId(null);
            records.setCreateTime(null);
            records.setCreateBy(null);
            records.setUpdateBy(null);
            records.setUpdateTime(null);
            records.setToCompany(item.getToCompany());
            records.setTemplateAccount(CharSequenceUtil.emptyToDefault((CharSequence)templateHeadDTO.getElsAccount(), (String)TenantContext.getTenant()));
            records.setTemplateNumber(templateHeadDTO.getTemplateNumber());
            records.setTemplateName(templateHeadDTO.getTemplateName());
            records.setTemplateVersion(templateHeadDTO.getTemplateVersion());
            records.setSourceItemNumber(item.getItemNumber());
            records.setSourceNumber(head.getRequestNumber());
            records.setSourceType(PriceSourceTypeEnum.PRICE_REQUEST.getValue());
            records.setMaterialId(item.getMaterialId());
            records.setSourceItemId(item.getId());
            records.setSourceId(head.getId());
            records.setRecordType(CharSequenceUtil.emptyToDefault((CharSequence)records.getRecordType(), (String)PriceRecordTypeEnum.STANDARD.getValue()));
            if (CharSequenceUtil.isNotEmpty((CharSequence)item.getInfoRecordId()) && null != (oldRecord = recordsMap.get(item.getInfoRecordId()))) {
                records.setTemplateAccount(oldRecord.getTemplateAccount());
                records.setTemplateNumber(oldRecord.getTemplateNumber());
                records.setTemplateName(oldRecord.getTemplateName());
                records.setTemplateVersion(oldRecord.getTemplateVersion());
            }
            records.setBusAccount(CharSequenceUtil.emptyToDefault((CharSequence)head.getBusAccount(), (String)TenantContext.getTenant()));
            if (PriceRequestOptTypeEnum.CHANGE.getValue().equals(item.getRequestOptType())) {
                records.setEffectiveDate(item.getRequestEffectiveDate());
                records.setExpiryDate(item.getRequestExpiryDate());
                records.setNetPrice(item.getRequestNetPrice());
                records.setPrice(item.getRequestPrice());
                records.setLadderPriceJson(CharSequenceUtil.emptyToDefault((CharSequence)item.getRequestLadderPriceJson(), (String)item.getLadderPriceJson()));
            } else if (PriceRequestOptTypeEnum.EXTENSION.getValue().equals(item.getRequestOptType())) {
                records.setPurchaseOrg(item.getRequestPurchaseOrg());
                records.setFactory(CharSequenceUtil.emptyToDefault((CharSequence)item.getRequestPurchaseFactory(), (String)item.getFactory()));
            }
            if (null != records.getPrice() && records.getPrice().compareTo(BigDecimal.ZERO) < 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVc_483a8da2", (String)("\u91c7\u8d2d\u7533\u8bf7\u884c[" + (index + 1) + "]")) + I18nUtil.translate((String)"i18n_alert_xfuxOXU0_feacb714", (String)"\u542b\u7a0e\u4ef7\u4e0d\u80fd\u5c0f\u4e8e0\uff01"));
            }
            if (null != records.getExpiryDate() && null != records.getEffectiveDate() && records.getExpiryDate().before(records.getEffectiveDate())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVc_483a8da2", (String)("\u91c7\u8d2d\u7533\u8bf7\u884c[" + (index + 1) + "]")) + I18nUtil.translate((String)"i18n_alert_umtHjXyRBAxOQUumtHjXAKBA_95550107", (String)"\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u8d77\u59cb\u65e5\u671f"));
            }
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)records.getPriceType()), (String)(I18nUtil.translate((String)"", (String)("\u91c7\u8d2d\u7533\u8bf7\u884c[" + (index + 1) + "]")) + I18nUtil.translate((String)"i18n_alert_umAclS_b641dd5b", (String)"\u4ef7\u683c\u7c7b\u578b\u5fc5\u586b")));
            if ("1".equals(records.getRecordType()) && CharSequenceUtil.isEmpty((CharSequence)records.getMaterialNumber())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVc_483a8da2", (String)("\u91c7\u8d2d\u7533\u8bf7\u884c[" + (index + 1) + "]")) + I18nUtil.translate((String)"i18n_alert_umAcLSLKWSLAylS_a87995e2", (String)"\u4ef7\u683c\u7c7b\u578b\u4e3a\u7269\u6599\u65f6\uff0c\u7269\u6599\u7f16\u53f7\u5fc5\u586b"));
            }
            if ("2".equals(records.getRecordType()) && CharSequenceUtil.isEmpty((CharSequence)records.getMaterialGroup())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVc_483a8da2", (String)("\u91c7\u8d2d\u7533\u8bf7\u884c[" + (index + 1) + "]")) + I18nUtil.translate((String)"i18n_alert_umAcLSLVKWSLVlS_dce240f5", (String)"\u4ef7\u683c\u7c7b\u578b\u4e3a\u7269\u6599\u7ec4\u65f6\uff0c\u7269\u6599\u7ec4\u5fc5\u586b"));
            }
            if (CharSequenceUtil.isEmpty((CharSequence)records.getFactory()) && CharSequenceUtil.isEmpty((CharSequence)records.getPurchaseOrg())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVc_483a8da2", (String)("\u91c7\u8d2d\u7533\u8bf7\u884c[" + (index + 1) + "]")) + I18nUtil.translate((String)"i18n_alert_RHnnRVRlTSMIm_f3c63546", (String)"\u5de5\u5382\u548c\u91c7\u8d2d\u7ec4\u7ec7\u5fc5\u987b\u586b\u5199\u4e00\u4e2a"));
            }
            service.calculatePrice(records);
            records.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
            service.checkStatus(records);
            recordsList.add(records);
        }
        ArrayList<PurchaseInformationRecords> unSubmitList = new ArrayList<PurchaseInformationRecords>();
        for (PurchaseInformationRecords records : recordsList) {
            try {
                service.cutOffPriceDate(records, unSubmitList, onCheck);
                if (onCheck) continue;
                records.setId(IdWorker.getIdStr());
                records.setInsertData(true);
                unSubmitList.add(records);
            }
            catch (Exception e) {
                if (onCheck || !"1".equals(head.getPartGeneratedPrice())) {
                    throw e;
                }
                if (e.getCause() instanceof ELSBootException) {
                    this.log.warn(e.getMessage());
                    records.setId(null);
                    records.setRequestPriceErrorMsg(e.getMessage());
                    continue;
                }
                throw e;
            }
        }
        List insertList = unSubmitList.stream().filter(PurchaseInformationRecords::isInsertData).collect(Collectors.toList());
        List updateList = unSubmitList.stream().filter(x -> !x.isInsertData()).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(insertList)) {
            service.saveBatch(insertList);
        }
        if (CollectionUtil.isNotEmpty(updateList)) {
            service.updateBatchById(updateList);
        }
        return recordsList;
    }

    @Override
    public void cancel(String headId) {
        PurchaseInformationRecordsRequestHead head = (PurchaseInformationRecordsRequestHead)((Object)((PurchaseInformationRecordsRequestHeadMapper)this.baseMapper).selectById((Serializable)((Object)headId)));
        if (null == head) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WFxMK_c3d350df", (String)"\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        if (PriceRequestStatusEnum.TO_BE_CONFIRMED.getValue().equals(head.getStatus()) || PriceRequestStatusEnum.CREATE_PRICE_OVER.getValue().equals(head.getStatus()) || PriceRequestStatusEnum.CANNEL.getValue().equals(head.getStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APtFzExqku_68bcdfa3", (String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u4e0d\u53ef\u4f5c\u5e9f"));
        }
        head.setStatus(PriceRequestStatusEnum.CANNEL.getValue());
        this.purchaseInformationRecordsRequestHeadMapper.updateById((Object)head);
        SaleInformationRecordsRequestHead requestHead = new SaleInformationRecordsRequestHead();
        requestHead.setId(head.getRelationId());
        requestHead.setStatus(PriceRequestStatusEnum.CANNEL.getValue());
        this.saleInformationRecordsRequestHeadMapper.updateById((Object)requestHead);
    }

    @Override
    public JSONObject getInformationRecordsRequestDataById(String id) {
        PurchaseInformationRecordsRequestHead purchaseInformationRecordsRequestHead = (PurchaseInformationRecordsRequestHead)((Object)this.getById((Serializable)((Object)id)));
        Result result = Result.ok((Object)((Object)purchaseInformationRecordsRequestHead));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean(DictAspect.class);
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }

    private void insertData(PurchaseInformationRecordsRequestHead head, List<PurchaseInformationRecordsRequestItem> purchaseInformationRecordsRequestItemList, List<PurchaseAttachmentDTO> attachmentDTOList) {
        if (!CollectionUtils.isEmpty(purchaseInformationRecordsRequestItemList)) {
            Integer index = 1;
            for (PurchaseInformationRecordsRequestItem entity : purchaseInformationRecordsRequestItemList) {
                entity.setHeadId(head.getId());
                entity.setChangeToPrice("0");
                entity.setItemNumber(index.toString());
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)head);
            }
            if (!purchaseInformationRecordsRequestItemList.isEmpty()) {
                ((PurchaseInformationRecordsRequestItemService)SpringContextUtils.getBean(PurchaseInformationRecordsRequestItemService.class)).saveBatch(purchaseInformationRecordsRequestItemList);
            }
        }
        if (CollectionUtil.isNotEmpty(attachmentDTOList)) {
            for (PurchaseAttachmentDTO entity : attachmentDTOList) {
                entity.setId(null);
                entity.setHeadId(head.getId());
                entity.setElsAccount(head.getElsAccount());
                entity.setCreateBy(head.getCreateBy());
                entity.setCreateTime(head.getCreateTime());
                entity.setUpdateBy(head.getUpdateBy());
                entity.setUpdateTime(head.getUpdateTime());
                entity.setDeleted(CommonConstant.DEL_FLAG_0);
            }
        }
        if (CollectionUtil.isNotEmpty(attachmentDTOList)) {
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(attachmentDTOList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        PurchaseInformationRecordsRequestHead dbHead = (PurchaseInformationRecordsRequestHead)((Object)this.getById((Serializable)((Object)id)));
        if (!PriceRequestStatusEnum.NEW.getValue().equals(dbHead.getStatus()) && !PriceRequestStatusEnum.CANNEL.getValue().equals(dbHead.getStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_APtFzEShQG_73ef57d7", (String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u65e0\u6cd5\u5220\u9664"));
        }
        if (AuditStatusEnum.AUDIT_DOING.getValue().equals(dbHead.getAuditStatus()) || AuditStatusEnum.AUDIT_FINISH.getValue().equals(dbHead.getAuditStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UzsSUzeRjtFqQG_908d607c", (String)"\u5ba1\u6279\u4e2d\u6216\u5ba1\u6279\u901a\u8fc7\u7684\u5355\u636e\u4e0d\u53ef\u5220\u9664"));
        }
        this.purchaseInformationRecordsRequestItemMapper.deleteByMainId(id);
        this.purchaseInformationRecordsRequestHeadMapper.deleteById((Serializable)((Object)id));
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseInformationRecordsRequestItemMapper.deleteByMainId(serializable.toString());
            this.purchaseInformationRecordsRequestHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void publish(PurchaseInformationRecordsRequestHead head, List<PurchaseInformationRecordsRequestItem> itemList, List<PurchaseAttachmentDTO> attachmentDTOList) {
        if (!"1".equals(head.getNeedSaleConfirm())) {
            this.checkPrice(head, itemList, true);
            head.setStatus(PriceRequestStatusEnum.WAIT_TO_CREATE_PRICE.getValue());
            head.setPublishStatus(PriceRequestSendStatusEnum.HAD_PUBLISH.getValue());
            ((PurchaseInformationRecordsRequestHeadMapper)this.baseMapper).updateById((Object)head);
            return;
        }
        if (CollectionUtil.isEmpty(itemList)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_umUVtRRcWF_a82b50e7", (String)"\u4ef7\u683c\u7533\u8bf7\u5355\u7f3a\u5c11\u884c\u6570\u636e"));
        }
        for (int i = 0; i < itemList.size(); ++i) {
            if (CharSequenceUtil.equals((CharSequence)head.getToElsAccount(), (CharSequence)itemList.get(i).getToElsAccount())) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_umUVc_89ed4963", (String)"\u4ef7\u683c\u7533\u8bf7\u884c") + (i + 1) + I18nUtil.translate((String)"i18n_alert_ICWWWeynumUVesnxIR_24a0bf2e", (String)"\u5bf9\u65b9ELS\u8d26\u53f7\u548c\u4ef7\u683c\u7533\u8bf7\u5934\u4e2d\u7684\u4e0d\u4e00\u81f4"));
        }
        this.checkPrice(head, itemList, true);
        if ("1".equals(head.getNeedSaleConfirm())) {
            head.setStatus(PriceRequestStatusEnum.TO_BE_CONFIRMED.getValue());
        } else {
            head.setStatus(PriceRequestStatusEnum.WAIT_TO_CREATE_PRICE.getValue());
        }
        head.setPublishStatus(PriceRequestSendStatusEnum.HAD_PUBLISH.getValue());
        SaleInformationRecordsRequestHead saleRequestHead = (SaleInformationRecordsRequestHead)((Object)Convert.convert(SaleInformationRecordsRequestHead.class, (Object)((Object)head)));
        saleRequestHead.setElsAccount(head.getToElsAccount());
        saleRequestHead.setToElsAccount(saleRequestHead.getElsAccount());
        this.purchaseInformationRecordsRequestItemMapper.deleteByMainId(head.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(head.getId());
        this.insertData(head, itemList, attachmentDTOList);
        SaleInformationRecordsRequestHead dbSaleRequestHead = this.saleInformationRecordsRequestHeadMapper.selectWithoutElsAccountToRelationId(head.getId());
        if (dbSaleRequestHead == null) {
            saleRequestHead.setId(IdWorker.getIdStr());
            saleRequestHead.setRelationId(head.getId());
            head.setRelationId(saleRequestHead.getId());
        } else {
            saleRequestHead.setRelationId(head.getId());
            saleRequestHead.setId(dbSaleRequestHead.getId());
            saleRequestHead.setDataVersion(dbSaleRequestHead.getDataVersion());
            head.setRelationId(dbSaleRequestHead.getId());
        }
        head.setConfirmRemark("");
        int count = ((PurchaseInformationRecordsRequestHeadMapper)this.baseMapper).updateById((Object)head);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        if (null == dbSaleRequestHead) {
            this.saleInformationRecordsRequestHeadMapper.insert((Object)saleRequestHead);
        } else {
            count = this.saleInformationRecordsRequestHeadMapper.updateById((Object)saleRequestHead);
            if (count == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
            }
        }
        this.saleInformationRecordsRequestItemMapper.deleteByMainId(saleRequestHead.getId());
        if (CollectionUtil.isNotEmpty(itemList)) {
            ArrayList<SaleInformationRecordsRequestItem> saleItemList = new ArrayList<SaleInformationRecordsRequestItem>();
            for (PurchaseInformationRecordsRequestItem item : itemList) {
                SaleInformationRecordsRequestItem saleItem = (SaleInformationRecordsRequestItem)((Object)Convert.convert(SaleInformationRecordsRequestItem.class, (Object)((Object)item)));
                saleItem.setId(IdWorker.getIdStr());
                saleItem.setRelationId(item.getId());
                saleItem.setElsAccount(head.getToElsAccount());
                saleItem.setHeadId(saleRequestHead.getId());
                item.setRelationId(saleItem.getId());
                saleItemList.add(saleItem);
            }
            if (CollectionUtil.isNotEmpty(saleItemList)) {
                ((SaleInformationRecordsRequestItemService)SpringContextUtils.getBean(SaleInformationRecordsRequestItemService.class)).saveBatch(saleItemList);
            }
            if (CollectionUtil.isNotEmpty(itemList)) {
                ((PurchaseInformationRecordsRequestItemService)SpringContextUtils.getBean(PurchaseInformationRecordsRequestItemService.class)).updateBatchById(itemList);
            }
        }
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleRequestHead.getId());
        if (CollectionUtil.isNotEmpty(attachmentDTOList)) {
            ArrayList<SaleAttachmentDTO> saleAttachmentArrayList = new ArrayList<SaleAttachmentDTO>();
            for (PurchaseAttachmentDTO purchaseAttachment : attachmentDTOList) {
                purchaseAttachment.setRelationId(IdWorker.getIdStr());
                SaleAttachmentDTO saleAttachment = new SaleAttachmentDTO();
                BeanUtils.copyProperties((Object)purchaseAttachment, (Object)saleAttachment);
                saleAttachment.setId(purchaseAttachment.getRelationId());
                saleAttachment.setRelationId(purchaseAttachment.getId());
                saleAttachment.setElsAccount(head.getToElsAccount());
                saleAttachment.setSendStatus("1");
                saleAttachment.setHeadId(saleRequestHead.getId());
                purchaseAttachment.setSendStatus("1");
                saleAttachmentArrayList.add(saleAttachment);
            }
            if (CollectionUtil.isNotEmpty(attachmentDTOList)) {
                this.invokeBaseRpcService.updateAttachmentBatchById(attachmentDTOList);
            }
            if (CollectionUtil.isNotEmpty(saleAttachmentArrayList)) {
                this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentArrayList);
            }
        }
        super.sendMessage(head.getBusAccount(), "informationRecordsRequest", "publish", head.getId(), "purchaseInformationRecordsRequestBusDataServiceImpl", (List)Lists.newArrayList((Object[])new String[]{head.getToElsAccount()}));
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void createPriceByHead(String headId) {
        PurchaseInformationRecordsRequestHead head = (PurchaseInformationRecordsRequestHead)((Object)((PurchaseInformationRecordsRequestHeadMapper)this.baseMapper).selectById((Serializable)((Object)headId)));
        if (!PriceRequestStatusEnum.WAIT_TO_CREATE_PRICE.getValue().equals(head.getStatus())) {
            throw new RuntimeException(I18nUtil.translate((String)"i18n__APtFIObLumdWF_78317d13", (String)"\u5f53\u524d\u5355\u636e\u5df2\u7ecf\u751f\u6210\u4ef7\u683c\u4e3b\u6570\u636e"));
        }
        List<PurchaseInformationRecordsRequestItem> requestItems = this.purchaseInformationRecordsRequestItemMapper.selectByMainId(headId);
        if (CollectionUtil.isEmpty(requestItems)) {
            return;
        }
        List<PurchaseInformationRecords> recordsList = this.checkPrice(head, requestItems, false);
        long createSize = recordsList.stream().filter(s -> CharSequenceUtil.isNotEmpty((CharSequence)s.getId())).count();
        List nextCodes = this.invokeBaseRpcService.getNextCodes("srmPriceNumber", (Object)recordsList.get(0), (int)createSize);
        int codeIndex = 0;
        ArrayList<PurchaseInformationRecordsRequestItem> newItem = new ArrayList<PurchaseInformationRecordsRequestItem>(requestItems.size());
        for (PurchaseInformationRecords e : recordsList) {
            if (null == e.getRequestPriceId()) continue;
            PurchaseInformationRecordsRequestItem item = new PurchaseInformationRecordsRequestItem();
            item.setId(e.getRequestPriceId());
            if (null == e.getId()) {
                item.setChangeToPrice("0");
                item.setPriceCreateErrorMsg(e.getRequestPriceErrorMsg());
                newItem.add(item);
                continue;
            }
            String requestNumber = (String)nextCodes.get(codeIndex++);
            e.setInfoRecordNumber(requestNumber);
            item.setRequestInfoRecordNumber(requestNumber);
            item.setChangeToPrice("1");
            newItem.add(item);
        }
        if (createSize == 0L) {
            head.setCreatePriceType(PriceRequestCreatePriceTypeEnum.NO.getValue());
        } else if ((long)recordsList.size() > createSize) {
            head.setCreatePriceType(PriceRequestCreatePriceTypeEnum.PART.getValue());
        } else {
            head.setCreatePriceType(PriceRequestCreatePriceTypeEnum.ALL.getValue());
        }
        head.setStatus(PriceRequestStatusEnum.CREATE_PRICE_OVER.getValue());
        ((PurchaseInformationRecordsRequestHeadMapper)this.baseMapper).updateById((Object)head);
        List records = recordsList.stream().filter(x -> CharSequenceUtil.isNotEmpty((CharSequence)x.getId())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(records)) {
            ((PurchaseInformationRecordsService)SpringContextUtils.getBean(PurchaseInformationRecordsService.class)).updateBatchById(records);
        }
        SaleInformationRecordsRequestHead saleHead = new SaleInformationRecordsRequestHead();
        saleHead.setId(head.getRelationId());
        saleHead.setCreatePriceType(head.getCreatePriceType());
        saleHead.setStatus(head.getStatus());
        this.saleInformationRecordsRequestHeadMapper.updateById((Object)saleHead);
        ArrayList<SaleInformationRecordsRequestItem> newSaleItemList = new ArrayList<SaleInformationRecordsRequestItem>();
        for (PurchaseInformationRecordsRequestItem item : newItem) {
            SaleInformationRecordsRequestItem saleItem = new SaleInformationRecordsRequestItem();
            saleItem.setId(item.getRelationId());
            saleItem.setRequestInfoRecordNumber(item.getRequestInfoRecordNumber());
            saleItem.setChangeToPrice(item.getChangeToPrice());
            saleItem.setPriceCreateErrorMsg(item.getPriceCreateErrorMsg());
            newSaleItemList.add(saleItem);
        }
        if (CollectionUtil.isNotEmpty(newItem)) {
            ((PurchaseInformationRecordsRequestItemService)SpringContextUtils.getBean(PurchaseInformationRecordsRequestItemService.class)).updateBatchById(newItem);
        }
        if (CollectionUtil.isNotEmpty(newSaleItemList)) {
            ((SaleInformationRecordsRequestItemService)SpringContextUtils.getBean(SaleInformationRecordsRequestItemService.class)).updateBatchById(newSaleItemList);
        }
    }

    @Override
    public void createPriceByItem(String itemId) {
    }

    public int insertBatchSomeColumn(List<PurchaseInformationRecordsRequestHead> entityList) {
        return ((PurchaseInformationRecordsRequestHeadMapper)this.baseMapper).insertBatchSomeColumn(entityList);
    }
}

