/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.api.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.excel.ExcelExportClassColumnDTO;
import com.els.common.exception.ELSBootException;
import com.els.common.util.ClassTypeBuilder;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.OpenApiRpcService;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.enumerate.PriceSourceTypeEnum;
import com.els.modules.price.enumerate.PriceStatusEnum;
import com.els.modules.price.rpc.service.PriceInvokeSupplierRpcService;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchasePriceCreateServiceImpl")
public class PurchasePriceCreateServiceImpl
implements OpenApiRpcService {
    @Autowired
    private PurchaseInformationRecordsService purchaseInformationRecordsService;
    @Autowired
    private PriceInvokeSupplierRpcService priceInvokeSupplierRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseMaterialHeadService purchaseMaterialHeadService;

    public JSONObject doCreateInvoke(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap) {
        String account = TenantContext.getTenant();
        Date currentTime = new Date();
        ArrayList<PurchaseInformationRecords> headList = new ArrayList<PurchaseInformationRecords>();
        ArrayList<String> code = new ArrayList<String>();
        ArrayList<String> toElsAccountList = new ArrayList<String>();
        for (Object obj : array) {
            JSONObject object = (JSONObject)Convert.convert(JSONObject.class, obj);
            if (object.size() == 0) continue;
            PurchaseInformationRecords head = (PurchaseInformationRecords)((Object)ConvertUtils.convertDefault(PurchaseInformationRecords.class, (JSONObject)object, defaultHeadMap));
            if (null != head.getExpiryDate() && null != head.getEffectiveDate() && head.getExpiryDate().before(head.getEffectiveDate())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_umtHjXyRBAxOQUumtHjXAKBA_95550107", (String)"\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u8d77\u59cb\u65e5\u671f"));
            }
            String materialNumber = head.getMaterialNumber();
            String toElsAccount = head.getToElsAccount();
            if (CharSequenceUtil.isNotEmpty((CharSequence)materialNumber) && !code.contains(materialNumber)) {
                code.add(materialNumber);
            }
            if (CharSequenceUtil.isNotEmpty((CharSequence)toElsAccount) && !toElsAccountList.contains(toElsAccount)) {
                toElsAccountList.add(toElsAccount);
            }
            head.setElsAccount(account);
            head.setCreateTime(currentTime);
            head.setDeleted(CommonConstant.DEL_FLAG_0);
            head.setBusAccount(account);
            head.setTemplateName(templateHead.getTemplateName());
            head.setTemplateNumber(templateHead.getTemplateNumber());
            head.setTemplateVersion(templateHead.getTemplateVersion());
            head.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
            head.setRecordStatus(PriceStatusEnum.EFFECTIVE.getValue());
            head.setSourceType(PriceSourceTypeEnum.SAP.getValue());
            headList.add(head);
        }
        this.dealData(headList);
        if (!headList.isEmpty()) {
            PurchaseInformationRecords entity = (PurchaseInformationRecords)((Object)headList.get(0));
            int size = (int)headList.stream().filter(x -> CharSequenceUtil.isEmpty((CharSequence)x.getInfoRecordNumber())).count();
            List nextCodes = this.invokeBaseRpcService.getNextCodes("srmPriceNumber", (Object)entity, size);
            int codeIndex = 0;
            for (PurchaseInformationRecords e : headList) {
                if (!CharSequenceUtil.isEmpty((CharSequence)e.getInfoRecordNumber())) continue;
                e.setInfoRecordNumber((String)nextCodes.get(codeIndex++));
            }
            this.purchaseInformationRecordsService.saveBatch(headList);
        }
        return null;
    }

    public void doParamCheck(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap, List<TemplateConfigHeadDTO> configHeadList, List<TemplateConfigItemDTO> configItemList) {
    }

    public String getBusinessType() {
        return "price";
    }

    public List<ExcelExportClassColumnDTO> getBusinessClass() {
        return ClassTypeBuilder.buildClassTypeList(PurchaseInformationRecords.class, null, null);
    }

    public List<String> supportItemList() {
        return Lists.newArrayList((Object[])new String[]{"itemList"});
    }

    private void dealData(List<PurchaseInformationRecords> headList) {
        List<String> supplierCodeList = headList.stream().map(PurchaseInformationRecords::getSupplierCode).collect(Collectors.toList());
        List<String> materialNumber = headList.stream().map(PurchaseInformationRecords::getMaterialNumber).collect(Collectors.toList());
        List<SupplierMasterDataDTO> supplierMasterDataBySupplierCodeList = this.priceInvokeSupplierRpcService.getSupplierMasterDataBySupplierCode(supplierCodeList);
        Map<String, SupplierMasterDataDTO> supplierCodeMap = supplierMasterDataBySupplierCodeList.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getSupplierCode, o -> o));
        List<PurchaseMaterialHead> materialHeadByNumberList = this.purchaseMaterialHeadService.getMaterialHeadByNumbers(materialNumber);
        Map<String, PurchaseMaterialHead> materialNumberMap = materialHeadByNumberList.stream().collect(Collectors.toMap(PurchaseMaterialHead::getMaterialNumber, o -> o));
        Map allTaxMap = this.invokeBaseRpcService.getAllTax(SysUtil.getPurchaseAccount());
        headList.forEach(o -> {
            PurchaseMaterialHead purchaseMaterialHead;
            SupplierMasterDataDTO supplierMasterDataDTO = (SupplierMasterDataDTO)supplierCodeMap.get(o.getSupplierCode());
            if (supplierMasterDataDTO != null) {
                o.setToElsAccount(supplierMasterDataDTO.getToElsAccount());
                o.setSupplierName(supplierMasterDataDTO.getSupplierName());
            }
            if ((purchaseMaterialHead = (PurchaseMaterialHead)((Object)((Object)materialNumberMap.get(o.getMaterialNumber())))) != null) {
                o.setMaterialName(purchaseMaterialHead.getMaterialName());
                o.setMaterialDesc(purchaseMaterialHead.getMaterialDesc());
                o.setMaterialId(purchaseMaterialHead.getId());
                if (StrUtil.isBlank((CharSequence)o.getPurchaseUnit())) {
                    o.setPurchaseUnit(purchaseMaterialHead.getPurchaseUnit());
                }
            }
            BigDecimal taxRate = (BigDecimal)allTaxMap.get(o.getTaxCode());
            o.setTaxRate(String.valueOf(taxRate));
        });
    }
}

