/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.api.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.excel.ExcelExportClassColumnDTO;
import com.els.common.exception.ELSBootException;
import com.els.common.util.ClassTypeBuilder;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.OpenApiRpcService;
import com.els.modules.material.entity.PurchaseMaterialCode;
import com.els.modules.material.service.PurchaseMaterialCodeService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseMaterialCodeOpenServiceImpl")
public class PurchaseMaterialCodeOpenServiceImpl
implements OpenApiRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseMaterialCodeOpenServiceImpl.class);
    @Autowired
    private PurchaseMaterialCodeService purchaseMaterialCodeService;

    public JSONObject doCreateInvoke(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap) {
        String account = TenantContext.getTenant();
        ArrayList purchaseMaterialCodeList = Lists.newArrayList();
        for (Object obj : array) {
            JSONObject object = (JSONObject)Convert.convert(JSONObject.class, obj);
            if (object.size() == 0) continue;
            String cateCode = object.getString("cateCode");
            if (CharSequenceUtil.isEmpty((CharSequence)cateCode)) {
                String msg = I18nUtil.translate((String)"", (String)"\u7269\u6599\u5206\u7c7b\u7f16\u7801[cateCode]\u4e0d\u80fd\u4e3a\u7a7a");
                throw new ELSBootException(msg);
            }
            String cateName = object.getString("cateName");
            if (CharSequenceUtil.isEmpty((CharSequence)cateName)) {
                String msg = I18nUtil.translate((String)"", (String)"\u7269\u6599\u5206\u7c7b\u540d\u79f0[cateName]\u4e0d\u80fd\u4e3a\u7a7a");
                throw new ELSBootException(msg);
            }
            String cateStatus = object.getString("cateStatus");
            if (CharSequenceUtil.isEmpty((CharSequence)cateStatus)) {
                String msg = I18nUtil.translate((String)"", (String)"\u7269\u6599\u5206\u7c7b\u72b6\u6001[cateStatus]\u4e0d\u80fd\u4e3a\u7a7a");
                throw new ELSBootException(msg);
            }
            PurchaseMaterialCode purchaseMaterialCode = (PurchaseMaterialCode)((Object)ConvertUtils.convertDefault(PurchaseMaterialCode.class, (JSONObject)object, defaultHeadMap));
            purchaseMaterialCode.setSourceType(CharSequenceUtil.emptyToDefault((CharSequence)purchaseMaterialCode.getSourceType(), (String)"1"));
            purchaseMaterialCode.setSourceSystem(CharSequenceUtil.emptyToDefault((CharSequence)purchaseMaterialCode.getSourceSystem(), (String)"ERP"));
            purchaseMaterialCodeList.add(purchaseMaterialCode);
        }
        this.purchaseMaterialCodeService.saveBatch(purchaseMaterialCodeList);
        JSONObject resultObj = new JSONObject();
        resultObj.put("headList", (Object)purchaseMaterialCodeList);
        return resultObj;
    }

    public void doParamCheck(JSONArray jsonArray, TemplateHeadDTO templateHeadDTO, Map<String, String> map, Map<String, String> map1, List<TemplateConfigHeadDTO> list, List<TemplateConfigItemDTO> list1) {
    }

    public String getBusinessType() {
        return "materialCode";
    }

    public List<ExcelExportClassColumnDTO> getBusinessClass() {
        return ClassTypeBuilder.buildClassTypeList(PurchaseMaterialCode.class, null, null);
    }

    public List<String> supportItemList() {
        return Lists.newArrayList((Object[])new String[]{"itemList"});
    }
}

