/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.excel;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="purchaseMaterialExcelHandler")
public class PurchaseMaterialExcelHandler
implements ExcelImportRpcService {
    @Autowired
    PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @SrmTransaction(rollbackFor={Exception.class})
    public List<Map<String, Object>> importExcel(List<Map<String, Object>> dataList) {
        List stringList;
        long count;
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("material");
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"i18n_alert_VWERSLdWFESIrW_6a8566c6", (String)"\u8bf7\u5148\u914d\u7f6e\u7269\u6599\u4e3b\u6570\u636e\u4e1a\u52a1\u6a21\u677f\u3002"));
        ArrayList<PurchaseMaterialHead> entityList = new ArrayList<PurchaseMaterialHead>();
        for (Map<String, Object> data : dataList) {
            PurchaseMaterialHead entity = (PurchaseMaterialHead)((Object)JSON.parseObject((String)JSON.toJSONString(data), PurchaseMaterialHead.class));
            entity.setElsAccount(TenantContext.getTenant());
            entity.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            entity.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            entity.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion());
            entity.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
            entity.setBlocDel("0");
            entity.setNeedAudit(CharSequenceUtil.emptyToDefault((CharSequence)entity.getNeedAudit(), (String)"1"));
            if ("0".equals(entity.getNeedAudit())) {
                entity.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            } else {
                entity.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            }
            entity.setFreeze(CharSequenceUtil.emptyToDefault((CharSequence)entity.getFreeze(), (String)"0"));
            entityList.add(entity);
        }
        Assert.notEmpty(entityList, (String)I18nUtil.translate((String)"i18n_alert_uNSLdWFLVW_507736a2", (String)"\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636e\u4e3a\u7a7a\u3002"));
        PurchaseMaterialHead entity = (PurchaseMaterialHead)((Object)entityList.get(0));
        long size = entityList.stream().filter(x -> StringUtils.isEmpty((Object)x.getMaterialNumber()) || "1".equals(x.getAutoCreateCode())).count();
        if (size > 0L) {
            List nextCodes = this.invokeBaseRpcService.getNextCodes("srmMaterialNumber", (Object)entity, (int)size);
            Assert.notEmpty((Collection)nextCodes, (String)I18nUtil.translate((String)"i18n_alert_uNSLdWFAobLIH_329f2e81", (String)"\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636e\u7f16\u7801\u58f0\u79f0\u5f02\u5e38"));
            int codeIndex = 0;
            for (PurchaseMaterialHead e : entityList) {
                if (!StringUtils.isEmpty((Object)e.getMaterialNumber()) && !"1".equals(e.getAutoCreateCode())) continue;
                e.setMaterialNumber((String)nextCodes.get(codeIndex++));
            }
        }
        Assert.isTrue(((count = (stringList = entityList.stream().map(PurchaseMaterialHead::getMaterialNumber).collect(Collectors.toList())).stream().distinct().count()) == (long)stringList.size() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_uNWFsjVBjSLAy_f67be2d2", (String)"\u5bfc\u5165\u6570\u636e\u4e2d\u6709\u91cd\u590d\u7684\u7269\u6599\u7f16\u53f7"));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.select(new SFunction[]{PurchaseMaterialHead::getMaterialNumber});
        wrapper.in(PurchaseMaterialHead::getMaterialNumber, stringList);
        List materialHeadList = this.purchaseMaterialHeadService.list((Wrapper)wrapper);
        Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)materialHeadList), (String)I18nUtil.translate((String)"i18n_alert_HesMKdejSLAy_bdd4e8c8", (String)("\u7cfb\u7edf\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u7269\u6599\u7f16\u53f7: " + materialHeadList.stream().map(PurchaseMaterialHead::getMaterialNumber).collect(Collectors.toList()).toString())));
        this.purchaseMaterialHeadService.saveBatch(entityList);
        return dataList;
    }
}

