/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.price.entity.PurchaseInformationRecordsRequestHead;
import com.els.modules.price.enumerate.PriceRequestSendStatusEnum;
import com.els.modules.price.enumerate.PriceRequestStatusEnum;
import com.els.modules.price.rpc.service.PriceInvokeSupplierRpcService;
import com.els.modules.price.service.PurchaseInformationRecordsRequestHeadService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseInformationRecordsRequestImportImpl")
public class PurchaseInformationRecordsRequestExcelHandler
implements ExcelImportRpcService {
    @Autowired
    private PurchaseInformationRecordsRequestHeadService purchaseInformationRecordsRequestHeadService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PriceInvokeSupplierRpcService priceInvokeSupplierRpcService;

    public List<Map<String, Object>> importExcel(List<Map<String, Object>> dataList) {
        List<SupplierMasterDataDTO> headList;
        Map collect;
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("informationRecordsRequest");
        Assert.isNotNull((Object)templateList, (String)I18nUtil.translate((String)"i18n_alert_VWERumUVtESIr_6cec267f", (String)"\u8bf7\u5148\u914d\u7f6e\u4ef7\u683c\u7533\u8bf7\u5355\u4e1a\u52a1\u6a21\u677f"));
        ArrayList<PurchaseInformationRecordsRequestHead> entityList = new ArrayList<PurchaseInformationRecordsRequestHead>();
        for (Map<String, Object> data : dataList) {
            PurchaseInformationRecordsRequestHead entity = (PurchaseInformationRecordsRequestHead)((Object)JSON.parseObject((String)JSON.toJSONString(data), PurchaseInformationRecordsRequestHead.class));
            entity.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            entity.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            entity.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion());
            entity.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
            entity.setElsAccount(TenantContext.getTenant());
            entity.setStatus(PriceRequestStatusEnum.NEW.getValue());
            entity.setNeedAudit(CharSequenceUtil.emptyToDefault((CharSequence)entity.getNeedAudit(), (String)"1"));
            entity.setNeedSaleConfirm(CharSequenceUtil.emptyToDefault((CharSequence)entity.getNeedSaleConfirm(), (String)"1"));
            if ("1".equals(entity.getNeedAudit())) {
                entity.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            } else {
                entity.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            }
            entity.setPublishStatus(PriceRequestSendStatusEnum.NO_PUBLISH.getValue());
            entity.setCreatePriceType(null);
            entity.setPartGeneratedPrice(CharSequenceUtil.emptyToDefault((CharSequence)entity.getPartGeneratedPrice(), (String)"0"));
            entityList.add(entity);
        }
        if (CollUtil.isEmpty(entityList)) {
            return dataList;
        }
        int size = entityList.size();
        List nextCodes = this.invokeBaseRpcService.getNextCodes("informationRecordsRequest", entityList.get(0), size);
        if (CollUtil.isNotEmpty((Collection)nextCodes)) {
            return dataList;
        }
        int codeIndex = 0;
        for (PurchaseInformationRecordsRequestHead e : entityList) {
            e.setRequestNumber((String)nextCodes.get(codeIndex++));
        }
        List<String> supplierCode = entityList.stream().map(PurchaseInformationRecordsRequestHead::getToElsAccount).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList());
        if (CollUtil.isNotEmpty(supplierCode) && CollUtil.isNotEmpty(collect = (headList = this.priceInvokeSupplierRpcService.listByElsAccount(supplierCode)).stream().collect(Collectors.toMap(SupplierMasterDataDTO::getToElsAccount, Function.identity(), (v1, v2) -> v1)))) {
            for (PurchaseInformationRecordsRequestHead r : entityList) {
                SupplierMasterDataDTO head = (SupplierMasterDataDTO)collect.get(r.getSupplierCode());
                if (null == head) continue;
                r.setSupplierCode(head.getSupplierCode());
                r.setSupplierName(head.getSupplierName());
                r.setToElsAccount(head.getToElsAccount());
            }
        }
        this.purchaseInformationRecordsRequestHeadService.saveBatch(entityList);
        return dataList;
    }
}

