/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.excel;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelItemByConfigRpcService;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.entity.PurchaseInformationRecordsRequestHead;
import com.els.modules.price.entity.PurchaseInformationRecordsRequestItem;
import com.els.modules.price.enumerate.PriceRequestOptTypeEnum;
import com.els.modules.price.rpc.service.PriceInvokeSupplierRpcService;
import com.els.modules.price.service.PurchaseInformationRecordsRequestHeadService;
import com.els.modules.price.service.PurchaseInformationRecordsRequestItemService;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.system.dto.ExcelByConfigDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseInformationRecordsRequestItemImportImpl")
public class PurchaseInformationRecordsRequestItemExcelHandler
implements ExcelItemByConfigRpcService {
    @Autowired
    private PurchaseInformationRecordsRequestHeadService purchaseInformationRecordsRequestHeadService;
    @Autowired
    private PurchaseInformationRecordsRequestItemService purchaseInformationRecordsRequestItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Resource
    private PurchaseInformationRecordsService purchaseInformationRecordsService;
    @Autowired
    private PriceInvokeSupplierRpcService priceInvokeSupplierRpcService;
    private String headId;
    private List<String> ingoredList = Lists.newArrayList((Object[])new String[]{"id", "createBy", "createTime", "updateBy", "updateTime"});

    public TemplateHeadDTO getTemplate(ExcelByConfigDTO excelByConfigDTO) {
        String templateAccount = excelByConfigDTO.getTemplateAccount();
        String templateVersion = excelByConfigDTO.getTemplateVersion();
        String templateNumber = excelByConfigDTO.getTemplateNumber();
        if (StrUtil.isNotBlank((CharSequence)excelByConfigDTO.getHeadId()) && !"undefined".equals(excelByConfigDTO.getHeadId())) {
            this.headId = excelByConfigDTO.getHeadId();
            PurchaseInformationRecordsRequestHead dbHead = (PurchaseInformationRecordsRequestHead)((Object)this.purchaseInformationRecordsRequestHeadService.getById((Serializable)((Object)excelByConfigDTO.getHeadId())));
            templateAccount = StringUtils.isNotBlank((CharSequence)dbHead.getTemplateAccount()) ? dbHead.getTemplateAccount() : dbHead.getElsAccount();
            templateVersion = String.valueOf(dbHead.getTemplateVersion());
            templateNumber = String.valueOf(dbHead.getTemplateNumber());
        }
        return this.invokeBaseRpcService.getTemplateConfig(templateAccount, templateNumber, templateVersion);
    }

    public List<Object> getExportData(ExcelByConfigDTO excelByConfigDTO) {
        List<PurchaseInformationRecordsRequestItem> itemList = this.purchaseInformationRecordsRequestItemService.selectByMainId(excelByConfigDTO.getHeadId());
        return Lists.newArrayList(itemList);
    }

    private void throwNull(String val, int index, String msg1, String msg2) {
        if (CharSequenceUtil.isEmpty((CharSequence)val)) {
            throw new ELSBootException(msg1 + index + msg2);
        }
    }

    public List<Map<String, Object>> importExcel(List<Map<String, Object>> dataList) {
        ExcelByConfigDTO dto = new ExcelByConfigDTO();
        dto.setHeadId(this.headId);
        List configItemList = this.getTemplate(dto).getTemplateConfigItemList();
        List editColumn = configItemList.stream().filter(item -> "1".equals(item.getPurchaseEdit())).map(TemplateConfigItemDTO::getFieldName).collect(Collectors.toList());
        ArrayList materialNumberList = Lists.newArrayList();
        ArrayList infoRecordNumberList = Lists.newArrayList();
        ArrayList elsAccountList = Lists.newArrayList();
        String translateItem = I18nUtil.translate((String)"i18n_field_umUVc_89ed4963", (String)"\u4ef7\u683c\u7533\u8bf7\u884c");
        for (int index = 0; index < dataList.size(); ++index) {
            Map<String, Object> data = dataList.get(index);
            for (String field : data.keySet()) {
                if (editColumn.contains(field) || data.get(field) != null) continue;
                data.put(field, null);
            }
            data.put("changeToPrice", "0");
            String requestOptType = (String)data.get("requestOptType");
            String infoRecordNumber = (String)data.get("infoRecordNumber");
            if (PriceRequestOptTypeEnum.ADD.getValue().equals(requestOptType)) {
                data.put("requestInfoRecordNumber", null);
                String materialNumber = (String)data.get("materialNumber");
                this.throwNull(materialNumber, index + 1, translateItem, I18nUtil.translate((String)"i18n_field_SLAoxOLV_f1cdd68b", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                materialNumberList.add(materialNumber);
                String toElsAccount = (String)data.get("toElsAccount");
                if (!CharSequenceUtil.isNotEmpty((CharSequence)toElsAccount)) continue;
                elsAccountList.add(toElsAccount);
                continue;
            }
            if (PriceRequestOptTypeEnum.CHANGE.getValue().equals(requestOptType)) {
                this.throwNull(infoRecordNumber, index + 1, translateItem, I18nUtil.translate((String)"i18n_alert_jumtHyxOLV_8549f1ad", (String)"\u6e90\u4ef7\u683c\u8bb0\u5f55\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
                this.throwNull((String)data.get("requestEffectiveDate"), index + 1, translateItem, I18nUtil.translate((String)"i18n_alert_TiSjXAKBAxOLV_a7dbd9a", (String)"\u8c03\u6574\u540e\u6709\u6548\u8d77\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a"));
                this.throwNull((String)data.get("requestExpiryDate"), index + 1, translateItem, I18nUtil.translate((String)"i18n_alert_TiSjXyRBAxOLV_76f60dde", (String)"\u8c03\u6574\u540e\u6709\u6548\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a"));
                data.put("requestPurchaseOrg", null);
                data.put("requestPurchaseFactory", null);
                data.put("requestInfoRecordNumber", null);
                infoRecordNumberList.add(infoRecordNumber);
                continue;
            }
            if (PriceRequestOptTypeEnum.EXTENSION.getValue().equals(requestOptType)) {
                this.throwNull(infoRecordNumber, index + 1, translateItem, I18nUtil.translate((String)"i18n_alert_jumtHyxOLV_8549f1ad", (String)"\u6e90\u4ef7\u683c\u8bb0\u5f55\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
                this.throwNull((String)data.get("requestPurchaseOrg"), index + 1, translateItem, I18nUtil.translate((String)"i18n_alert_VVnRVRxOLV_c390cad5", (String)"\u6269\u5145\u91c7\u8d2d\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a"));
                data.put("requestPurchaseOrg", null);
                data.put("requestPurchaseFactory", null);
                data.put("requestEffectiveDate", null);
                data.put("requestExpiryDate", null);
                data.put("requestInfoRecordNumber", null);
                data.put("requestNetPrice", null);
                data.put("requestLadderPriceJson", null);
                data.put("requestPrice", null);
                infoRecordNumberList.add(infoRecordNumber);
                continue;
            }
            this.throwNull(null, index + 1, translateItem, I18nUtil.translate((String)"i18n_alert_AHAcxOLV_30743f9c", (String)"\u53d8\u66f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        List<PurchaseMaterialHead> masterialList = this.purchaseMaterialHeadService.getMaterialHeadByNumbers(materialNumberList);
        Map materialHeadMap = masterialList.stream().collect(Collectors.toMap(PurchaseMaterialHead::getMaterialNumber, Function.identity(), (v1, v2) -> v2));
        ArrayList oldMasterNumber = Lists.newArrayList((Iterable)materialNumberList);
        oldMasterNumber.removeAll(materialHeadMap.keySet());
        if (!oldMasterNumber.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SLAoxMK_cdf9d7c2", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u5b58\u5728") + ":" + String.join((CharSequence)",", oldMasterNumber));
        }
        List<PurchaseInformationRecords> recordsList = this.purchaseInformationRecordsService.listRecordsByNumber(infoRecordNumberList);
        Map recordsMap = recordsList.stream().collect(Collectors.toMap(PurchaseInformationRecords::getInfoRecordNumber, Function.identity(), (v1, v2) -> v2));
        ArrayList oldRecordsNumber = Lists.newArrayList((Iterable)infoRecordNumberList);
        oldRecordsNumber.removeAll(recordsMap.keySet());
        if (!oldRecordsNumber.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jumtHyxqj_56dc08a9", (String)"\u6e90\u4ef7\u683c\u8bb0\u5f55\u53f7\u4e0d\u53ef\u7528") + ":" + String.join((CharSequence)",", oldRecordsNumber));
        }
        List<SupplierMasterDataDTO> headList = this.priceInvokeSupplierRpcService.listByElsAccount(elsAccountList);
        Map collect = headList.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getToElsAccount, Function.identity(), (v1, v2) -> v1));
        for (Map<String, Object> data : dataList) {
            Object o;
            Set<String> dataKeys;
            JSONObject jsonObject;
            String requestOptType = (String)data.get("requestOptType");
            String infoRecordNumber = (String)data.get("infoRecordNumber");
            String materialNumber = (String)data.get("materialNumber");
            if (PriceRequestOptTypeEnum.ADD.getValue().equals(requestOptType)) {
                String toElsAccount;
                SupplierMasterDataDTO supplierMasterDataDTO;
                PurchaseMaterialHead head = (PurchaseMaterialHead)((Object)materialHeadMap.get(materialNumber));
                if (null != head) {
                    jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)head)));
                    dataKeys = data.keySet();
                    for (String field : jsonObject.keySet()) {
                        if (this.ingoredList.contains(field) || !dataKeys.contains(field) || null == (o = jsonObject.get((Object)field))) continue;
                        data.put(field, o);
                    }
                }
                if (null == (supplierMasterDataDTO = (SupplierMasterDataDTO)collect.get(toElsAccount = (String)data.get("toElsAccount")))) continue;
                data.put("toElsAccount", supplierMasterDataDTO.getToElsAccount());
                data.put("supplierName", supplierMasterDataDTO.getSupplierName());
                data.put("supplierCode", supplierMasterDataDTO.getSupplierCode());
                continue;
            }
            PurchaseInformationRecords records = (PurchaseInformationRecords)((Object)recordsMap.get(infoRecordNumber));
            if (null == records) continue;
            jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)records)));
            dataKeys = data.keySet();
            for (String field : jsonObject.keySet()) {
                if (this.ingoredList.contains(field) || dataKeys.contains(field) || null == (o = jsonObject.get((Object)field))) continue;
                data.put(field, o);
            }
        }
        return dataList;
    }
}

