/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.entity.PurchaseBomHead;
import com.els.modules.material.entity.PurchaseBomItem;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.enumerate.PurchaseBomStatus;
import com.els.modules.material.service.PurchaseBomHeadService;
import com.els.modules.material.service.PurchaseBomItemService;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseBomListItemImportImpl")
public class PurchaseBomListItemImportImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseBomListItemImportImpl.class);
    @Autowired
    private PurchaseBomHeadService purchaseBomHeadService;
    @Autowired
    private PurchaseBomItemService purchaseBomItemService;
    @Resource
    private PurchaseMaterialHeadService purchaseMaterialHeadService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = dataList.size();
        ArrayList<String> bomNumberList = new ArrayList<String>();
        ArrayList<String> materialNumberList = new ArrayList<String>();
        Iterator iterator = dataList.iterator();
        while (iterator.hasNext()) {
            String bomNumber;
            Map data = (Map)iterator.next();
            String materialNumber = (String)data.get("materialNumber");
            if (CharSequenceUtil.isNotBlank((CharSequence)materialNumber) && !materialNumberList.contains(materialNumber)) {
                materialNumberList.add(materialNumber);
            }
            if (CharSequenceUtil.isEmpty((CharSequence)(bomNumber = (String)data.get("bomNumber")))) {
                String msg = I18nUtil.translate((String)"", (String)"BOM\u8868\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg, data);
                iterator.remove();
                continue;
            }
            if (bomNumberList.contains(bomNumber)) continue;
            bomNumberList.add(bomNumber);
        }
        Map<String, PurchaseMaterialHead> materialIdMap = this.purchaseMaterialHeadService.listMaterialHeadByNumbers(materialNumberList, TenantContext.getTenant());
        Map<String, PurchaseBomHead> bomIdMap = this.purchaseBomHeadService.listBomByBomNumber(bomNumberList, TenantContext.getTenant());
        ArrayList<PurchaseBomItem> itemList = new ArrayList<PurchaseBomItem>();
        List<String> headIds = bomIdMap.values().stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
        Map<String, Integer> countMap = this.purchaseBomItemService.countByHeadIds(headIds);
        for (Map data : dataList) {
            String msg;
            String bomNumber = (String)data.get("bomNumber");
            PurchaseBomHead bomHead = bomIdMap.get(bomNumber);
            if (null == bomHead) {
                msg = I18nUtil.translate((String)"", (String)"BOM\u8868\u5355\u5355\u53f7\u4e0d\u5b58\u5728") + bomNumber;
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            if (AuditStatusEnum.AUDIT_DOING.getValue().equals(bomHead.getAuditStatus()) || AuditStatusEnum.AUDIT_FINISH.getValue().equals(bomHead.getAuditStatus())) {
                msg = I18nUtil.translate((String)"", (String)"BOM\u8868\u5355\u5ba1\u6279\u4e2d/\u5ba1\u6279\u901a\u8fc7\uff0c\u4e0d\u53ef\u5bfc\u5165\u884c\u6570\u636e") + bomNumber;
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            if (PurchaseBomStatus.CANCEL.getValue().equals(bomHead.getBomStatus()) || PurchaseBomStatus.FROZEN.getValue().equals(bomHead.getBomStatus())) {
                msg = I18nUtil.translate((String)"", (String)"BOM\u8868\u5355\u5df2\u51bb\u7ed3/\u5df2\u4f5c\u5e9f\u7f16\u8f91\uff0c\u4e0d\u53ef\u5bfc\u5165\u884c\u6570\u636e") + bomNumber;
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            String materialNumber = (String)data.get("materialNumber");
            PurchaseMaterialHead head = materialIdMap.get(materialNumber);
            PurchaseBomItem entity = (PurchaseBomItem)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), PurchaseBomItem.class));
            if (CharSequenceUtil.isNotBlank((CharSequence)materialNumber)) {
                if (null == head) {
                    String msg2 = I18nUtil.translate((String)"", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u5b58\u5728");
                    this.errorAdd(excelImportDTO, msg2, data);
                    continue;
                }
                entity.setMaterialDesc(head.getMaterialDesc());
                entity.setMaterialSpec(head.getMaterialSpec());
                entity.setMaterialId(head.getId());
            } else {
                entity.setMaterialDesc(null);
                entity.setMaterialSpec(null);
                entity.setMaterialId(null);
            }
            entity.setHeadId(bomHead.getId());
            entity.setElsAccount(bomHead.getElsAccount());
            if (CharSequenceUtil.isBlank((CharSequence)entity.getItemNumber())) {
                Integer count = countMap.get(bomHead.getId());
                if (null == count || count == 0) {
                    count = 1;
                } else {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                entity.setItemNumber(count.toString());
                countMap.put(bomHead.getId(), count);
            }
            itemList.add(entity);
        }
        if (CollUtil.isNotEmpty(itemList)) {
            this.purchaseBomItemService.saveBatch(itemList);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

