/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.material.entity.PurchaseMaterialInventory;
import com.els.modules.material.entity.SaleMaterialInventory;
import com.els.modules.material.entity.SaleMaterialRelation;
import com.els.modules.material.mapper.PurchaseMaterialInventoryMapper;
import com.els.modules.material.mapper.SaleMaterialInventoryMapper;
import com.els.modules.material.mapper.SaleMaterialRelationMapper;
import com.els.modules.material.service.PurchaseMaterialInventoryService;
import com.els.modules.material.service.SaleMaterialInventoryService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleMaterialInventoryServiceImpl
extends BaseServiceImpl<SaleMaterialInventoryMapper, SaleMaterialInventory>
implements SaleMaterialInventoryService {
    @Autowired
    private PurchaseMaterialInventoryMapper purchaseMaterialInventoryMapper;
    @Autowired
    private SaleMaterialRelationMapper saleMaterialRelationMapper;

    @Override
    public List<String> loadPurchaseElsAccount(List<String> purchaseElsAccountList, String status) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{SaleMaterialInventory::getPurchaseElsAccount});
        ((LambdaQueryWrapper)wrapper.in(SaleMaterialInventory::getPurchaseElsAccount, purchaseElsAccountList)).eq(SaleMaterialInventory::getStatus, (Object)status);
        return ((SaleMaterialInventoryMapper)this.baseMapper).selectList((Wrapper)wrapper).stream().map(SaleMaterialInventory::getPurchaseElsAccount).distinct().collect(Collectors.toList());
    }

    @Override
    public void deleteInPurchaseElsAccount(String elsAccount, List<String> purchaseElsAccountList, String status) {
        ((SaleMaterialInventoryMapper)this.baseMapper).deleteInPurchaseElsAccount(elsAccount, purchaseElsAccountList, status);
    }

    @Override
    public void send(List<String> ids) {
        this.refresh();
        List list = ((SaleMaterialInventoryMapper)this.baseMapper).selectBatchIds(ids);
        list = list.stream().filter(d -> "0".equals(d.getStatus())).collect(Collectors.toList());
        ArrayList<PurchaseMaterialInventory> purchaseMaterialInventoryList = new ArrayList<PurchaseMaterialInventory>();
        for (SaleMaterialInventory inventory : list) {
            PurchaseMaterialInventory materialInventory = (PurchaseMaterialInventory)((Object)Convert.convert(PurchaseMaterialInventory.class, (Object)((Object)inventory)));
            materialInventory.setId(IdWorker.getIdStr());
            materialInventory.setRelationId(inventory.getId());
            materialInventory.setElsAccount(inventory.getPurchaseElsAccount());
            materialInventory.setStatus("1");
            inventory.setRelationId(materialInventory.getId());
            inventory.setStatus("1");
            purchaseMaterialInventoryList.add(materialInventory);
        }
        if (CollectionUtil.isNotEmpty(list)) {
            List<String> purchaseAccountList = list.stream().map(SaleMaterialInventory::getPurchaseElsAccount).distinct().collect(Collectors.toList());
            this.purchaseMaterialInventoryMapper.updateSupplierInvalidStatus(TenantContext.getTenant(), purchaseAccountList, "2");
            this.updateBatchById(list);
            ((PurchaseMaterialInventoryService)SpringContextUtils.getBean(PurchaseMaterialInventoryService.class)).saveBatch(purchaseMaterialInventoryList);
        }
    }

    @Override
    public void refresh() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SaleMaterialInventory::getStatus, (Object)"0");
        List list = ((SaleMaterialInventoryMapper)this.baseMapper).selectList((Wrapper)wrapper);
        List toMaterialNumber = list.stream().map(SaleMaterialInventory::getToMaterialNumber).distinct().collect(Collectors.toList());
        if (CollectionUtil.isEmpty(toMaterialNumber)) {
            return;
        }
        LambdaQueryWrapper wrapperRelation = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapperRelation.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).in(SaleMaterialRelation::getSaleMaterialNumber, toMaterialNumber);
        List saleMaterialRelations = this.saleMaterialRelationMapper.selectList((Wrapper)wrapperRelation);
        Map relationMap = saleMaterialRelations.stream().collect(Collectors.toMap(SaleMaterialRelation::getSaleMaterialNumber, Function.identity(), (v1, v2) -> v2));
        if (relationMap.size() == 0) {
            return;
        }
        ArrayList<SaleMaterialInventory> updateList = new ArrayList<SaleMaterialInventory>();
        for (SaleMaterialInventory inventory : list) {
            SaleMaterialRelation relation = (SaleMaterialRelation)((Object)relationMap.get(inventory.getToMaterialNumber()));
            if (null == relation) continue;
            inventory.setMaterialName(CharSequenceUtil.emptyToDefault((CharSequence)relation.getMaterialName(), (String)relation.getMaterialDesc()));
            inventory.setMaterialNumber(relation.getMaterialNumber());
            inventory.setMaterialDesc(relation.getMaterialDesc());
            inventory.setMaterialId(relation.getMaterialId());
            inventory.setToMaterialName(relation.getSaleMaterialDesc());
            updateList.add(inventory);
        }
        if (CollectionUtil.isNotEmpty(updateList)) {
            this.updateBatchById(updateList);
        }
    }

    @Override
    public void deleteInIds(List<String> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)wrapper.eq(SaleMaterialInventory::getStatus, (Object)"0")).in(BaseEntity::getId, ids);
        ((SaleMaterialInventoryMapper)this.baseMapper).delete((Wrapper)wrapper);
    }
}

