/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.config.mybatis.TenantContext;
import com.els.modules.material.entity.PurchaseMaterialInventory;
import com.els.modules.material.entity.PurchaseMaterialRelation;
import com.els.modules.material.mapper.PurchaseMaterialInventoryMapper;
import com.els.modules.material.mapper.PurchaseMaterialRelationMapper;
import com.els.modules.material.service.PurchaseMaterialInventoryService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseMaterialInventoryServiceImpl
extends BaseServiceImpl<PurchaseMaterialInventoryMapper, PurchaseMaterialInventory>
implements PurchaseMaterialInventoryService {
    @Autowired
    private PurchaseMaterialRelationMapper purchaseMaterialRelationMapper;

    @Override
    public void updateSupplierInvalidStatus(String toElsAccount, List<String> purchaseElsAccountList, String status) {
        ((PurchaseMaterialInventoryMapper)this.baseMapper).updateSupplierInvalidStatus(toElsAccount, purchaseElsAccountList, status);
    }

    @Override
    public void refresh() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(PurchaseMaterialInventory::getStatus, (Object)"1");
        List list = ((PurchaseMaterialInventoryMapper)this.baseMapper).selectList((Wrapper)wrapper);
        List materialNumberList = list.stream().map(PurchaseMaterialInventory::getMaterialNumber).distinct().collect(Collectors.toList());
        if (CollectionUtil.isEmpty(materialNumberList)) {
            return;
        }
        LambdaQueryWrapper wrapperRelation = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapperRelation.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).in(PurchaseMaterialRelation::getMaterialNumber, materialNumberList)).eq(PurchaseMaterialRelation::getBlocked, (Object)"0");
        wrapperRelation.orderByDesc(BaseEntity::getId);
        List purchaseMaterialRelationList = this.purchaseMaterialRelationMapper.selectList((Wrapper)wrapperRelation);
        Map relationMap = purchaseMaterialRelationList.stream().collect(Collectors.toMap(PurchaseMaterialRelation::getMaterialNumber, Function.identity(), (v1, v2) -> v1));
        if (relationMap.size() == 0) {
            for (PurchaseMaterialInventory inventory : list) {
                inventory.setToMaterialName(null);
                inventory.setToMaterialNumber(null);
                inventory.setToMaterialId(null);
            }
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                this.updateBatchById(list);
            }
            return;
        }
        ArrayList<PurchaseMaterialInventory> updateList = new ArrayList<PurchaseMaterialInventory>();
        for (PurchaseMaterialInventory inventory : list) {
            PurchaseMaterialRelation relation = (PurchaseMaterialRelation)((Object)relationMap.get(inventory.getToMaterialNumber()));
            if (null == relation) continue;
            inventory.setToMaterialName(CharSequenceUtil.emptyToDefault((CharSequence)relation.getSaleMaterialName(), (String)relation.getSaleMaterialDesc()));
            inventory.setToMaterialNumber(relation.getSaleMaterialNumber());
            inventory.setToMaterialId(relation.getSaleMaterialId());
            updateList.add(inventory);
        }
        if (CollectionUtil.isNotEmpty(updateList)) {
            this.updateBatchById(updateList);
        }
    }

    @Override
    public void deleteInIds(List<String> ids) {
    }
}

