/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.thirddata.excel;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.constant.CommonConstant;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.thirddata.entity.BulkMaterialRelation;
import com.els.modules.thirddata.service.BulkMaterialRelationService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BulkMaterialRelationImportImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private BulkMaterialRelationService bulkMaterialRelationService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        String elsAccount = TenantContext.getTenant();
        ArrayList<BulkMaterialRelation> list = new ArrayList<BulkMaterialRelation>();
        for (Map data : dataList) {
            BulkMaterialRelation bulkMaterialRelation = (BulkMaterialRelation)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), BulkMaterialRelation.class));
            bulkMaterialRelation.setElsAccount(elsAccount);
            bulkMaterialRelation.setDeleted(CommonConstant.DEL_FLAG_0);
            bulkMaterialRelation.setCreateTime(new Date());
            bulkMaterialRelation.setMaterialDesc(CharSequenceUtil.emptyToDefault((CharSequence)bulkMaterialRelation.getMaterialDesc(), (String)""));
            list.add(bulkMaterialRelation);
        }
        if (!list.isEmpty()) {
            this.bulkMaterialRelationService.saveBatch(list, 2000);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

