/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.BooleanUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.constant.CommonConstant;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportCheckDTO;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.entity.SaleMaterialInventory;
import com.els.modules.material.rpc.service.MaterialInvokeSupplierRpcService;
import com.els.modules.material.service.PurchaseMaterialInventoryService;
import com.els.modules.material.service.SaleMaterialInventoryService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.google.common.collect.Lists;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="saleMaterialInventoryIncrementImportRpcServiceImpl")
public class SaleMaterialInventoryIncrementImportImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private SaleMaterialInventoryService saleMaterialInventoryService;
    @Autowired
    private PurchaseMaterialInventoryService purchaseMaterialInventoryService;
    @Resource
    private MaterialInvokeSupplierRpcService materialInvokeSupplierRpcService;
    private static final String OVERWRITE_INVALID_DATA = "overwriteInvalidData";

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        String elsAccount = TenantContext.getTenant();
        ArrayList<SaleMaterialInventory> list = new ArrayList<SaleMaterialInventory>();
        List<Object> purchaseElsAccountToMaterialNumberList = Lists.newArrayList();
        List<Object> purchaseElsAccountList = Lists.newArrayList();
        Iterator iterator = dataList.iterator();
        while (iterator.hasNext()) {
            Map data = (Map)iterator.next();
            String purchaseElsAccount = (String)data.get("purchaseElsAccount");
            if (CharSequenceUtil.isEmpty((CharSequence)purchaseElsAccount)) {
                String msg = I18nUtil.translate((String)"i18n_alert_nRCELSeyxOLV_d3d6c1da", (String)"\u91c7\u8d2d\u65b9ELS\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg, data);
                iterator.remove();
                continue;
            }
            String toMaterialNumber = (String)data.get("toMaterialNumber");
            if (CharSequenceUtil.isEmpty((CharSequence)toMaterialNumber)) {
                String msg = I18nUtil.translate((String)"i18n_alert_RdXSLAoxOLV_21001798", (String)"\u4f9b\u5e94\u5546\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg, data);
                iterator.remove();
            }
            purchaseElsAccountToMaterialNumberList.add(purchaseElsAccount + "_" + toMaterialNumber);
            purchaseElsAccountList.add(purchaseElsAccount);
        }
        purchaseElsAccountToMaterialNumberList = purchaseElsAccountToMaterialNumberList.stream().filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList());
        purchaseElsAccountList = purchaseElsAccountList.stream().filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList());
        List<String> supplierElsAccountList = purchaseElsAccountList.stream().map(x -> x + "_" + TenantContext.getTenant()).collect(Collectors.toList());
        List<SupplierMasterDataDTO> supplierMasterDataDTOList = this.materialInvokeSupplierRpcService.listByElsAndToElsAccount(supplierElsAccountList);
        Map supplierMap = supplierMasterDataDTOList.stream().collect(Collectors.toMap(BaseDTO::getElsAccount, Function.identity(), (v1, v2) -> v1));
        SupplierMasterDataDTO toElsAccount = this.materialInvokeSupplierRpcService.getToELsAccount(SysUtil.getLoginUser().getElsAccount());
        Date current = new Date();
        for (Map data : dataList) {
            SaleMaterialInventory inventory = (SaleMaterialInventory)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), SaleMaterialInventory.class));
            inventory.setId(IdWorker.getIdStr());
            inventory.setRelationId(IdWorker.getIdStr());
            inventory.setElsAccount(elsAccount);
            inventory.setDeleted(CommonConstant.DEL_FLAG_0);
            inventory.setStatus("0");
            String purchaseElsAccount = inventory.getPurchaseElsAccount();
            SupplierMasterDataDTO masterData = (SupplierMasterDataDTO)supplierMap.get(purchaseElsAccount);
            if (null == masterData) {
                String msg = I18nUtil.translate((String)"i18n_alert_nRey0xMKVnIWF_fdba92d3", (String)"\u91c7\u8d2d\u8d26\u53f7\uff1a${0} \u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u6570\u636e\uff01", (String[])new String[]{purchaseElsAccount});
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            inventory.setPurchaseName(masterData.getPurchaseName());
            inventory.setToElsAccount(toElsAccount.getToElsAccount());
            inventory.setSupplierName(toElsAccount.getSupplierName());
            inventory.setSupplierCode(toElsAccount.getSupplierCode());
            inventory.setImportDate(current);
            list.add(inventory);
        }
        if (CollectionUtil.isEmpty(list)) {
            this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
            return dataList;
        }
        Map otherRequestParam = excelImportDTO.getOtherRequestParam();
        Boolean overwriteInvalidData = (Boolean)otherRequestParam.get(OVERWRITE_INVALID_DATA);
        if (BooleanUtil.isTrue((Boolean)overwriteInvalidData) && CollectionUtil.isNotEmpty(purchaseElsAccountToMaterialNumberList)) {
            this.saleMaterialInventoryService.deleteInPurchaseElsAccountToMaterialNumber(TenantContext.getTenant(), purchaseElsAccountToMaterialNumberList, "0");
            UpdateWrapper wrapper = Wrappers.update((Object)((Object)new SaleMaterialInventory()));
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((UpdateWrapper)wrapper.in((Object)"purchase_els_account+'_'+to_material_number", purchaseElsAccountToMaterialNumberList)).lambda().set(SaleMaterialInventory::getStatus, (Object)"2")).eq(SaleMaterialInventory::getStatus, (Object)"1")).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
            this.saleMaterialInventoryService.update((Object)new SaleMaterialInventory(), (Wrapper)wrapper);
            this.purchaseMaterialInventoryService.updateSupplierInvalidStatusByPurchaseElsAccountToMaterialNumber(TenantContext.getTenant(), purchaseElsAccountToMaterialNumberList, "2");
        }
        if (CollectionUtil.isNotEmpty(list)) {
            this.saleMaterialInventoryService.saveBatch(list);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }

    public ExcelImportCheckDTO interactiveCheck(ExcelImportDTO excelImportDTO) {
        ExcelImportCheckDTO checkDTO = new ExcelImportCheckDTO();
        List dataList = excelImportDTO.getDataList();
        List<Object> purchaseElsAccountToMaterialNumberList = Lists.newArrayList();
        for (Map data : dataList) {
            String purchaseElsAccount = (String)data.get("purchaseElsAccount");
            String toMaterialNumber = (String)data.get("toMaterialNumber");
            purchaseElsAccountToMaterialNumberList.add(purchaseElsAccount + "_" + toMaterialNumber);
        }
        purchaseElsAccountToMaterialNumberList = purchaseElsAccountToMaterialNumberList.stream().filter(CharSequenceUtil::isNotEmpty).distinct().collect(Collectors.toList());
        checkDTO.setNeedInteraction(false);
        if (CollectionUtil.isEmpty((Collection)purchaseElsAccountToMaterialNumberList)) {
            return checkDTO;
        }
        List<String> ineffectivePurchaseElsAccountToMaterialNumberList = this.saleMaterialInventoryService.loadPurchaseElsAccountToMaterialNumber(purchaseElsAccountToMaterialNumberList, "0");
        List<String> executedPurchaseElsAccountToMaterialNumberList = this.saleMaterialInventoryService.loadPurchaseElsAccountToMaterialNumber(purchaseElsAccountToMaterialNumberList, "1");
        HashMap<String, CallSite> errorMsgMap = new HashMap<String, CallSite>();
        HashSet<String> account = new HashSet<String>();
        account.addAll(ineffectivePurchaseElsAccountToMaterialNumberList);
        account.addAll(executedPurchaseElsAccountToMaterialNumberList);
        if (CollectionUtil.isNotEmpty(account)) {
            String msg = I18nUtil.translate((String)"i18n_alert_AP_bdd5a", (String)"\u5f53\u524d") + String.join((CharSequence)",", account) + I18nUtil.translate((String)"i18n_alert_MKLbXIbXWFKQBruNHcHV_4f4e014", (String)"\u5b58\u5728(\u672a\u751f\u6548/\u5df2\u751f\u6548)\u6570\u636e\uff0c\u662f\u5426(\u8986\u76d6\u5bfc\u5165/\u8fdb\u884c\u66f4\u65b0)?");
            errorMsgMap.put(OVERWRITE_INVALID_DATA, (CallSite)((Object)msg));
        }
        if (errorMsgMap.size() > 0) {
            checkDTO.setNeedInteraction(true);
            checkDTO.setErrorMsgMap(errorMsgMap);
        }
        return checkDTO;
    }
}

