/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.api.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.util.SpringContextUtils;
import com.els.modules.ai.dto.AgentLlmRequestDto;
import com.els.modules.ai.dto.LlmResponseDto;
import com.els.modules.ai.service.AiFlowAgentEnhanceRpcService;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@RpcService(value="priceAgentEnhanceServiceImpl")
public class PriceAgentEnhanceServiceImpl
implements AiFlowAgentEnhanceRpcService {
    public String runCollect(AgentLlmRequestDto llmRequest, JSONObject preStepParam, String ... args) {
        String materialNumber = preStepParam.getString("materialNumber");
        if (CharSequenceUtil.isEmpty((CharSequence)materialNumber)) {
            return "";
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(PurchaseInformationRecords::getMaterialNumber, new Object[]{materialNumber});
        List list = ((PurchaseInformationRecordsService)SpringContextUtils.getBean(PurchaseInformationRecordsService.class)).list((Wrapper)wrapper);
        ArrayList<JSONObject> historyPriceList = new ArrayList<JSONObject>();
        for (PurchaseInformationRecords records : list) {
            String supplierName = records.getSupplierName();
            BigDecimal price = records.getPrice();
            BigDecimal netPrice = records.getNetPrice();
            Date quoteDate = records.getQuoteDate();
            if (null == quoteDate) {
                quoteDate = records.getEffectiveDate();
            }
            JSONObject item = new JSONObject();
            item.put("\u516c\u53f8\u540d\u79f0", (Object)supplierName);
            item.put("\u7269\u6599\u7f16\u7801", (Object)records.getMaterialNumber());
            item.put("\u542b\u7a0e\u5355\u4ef7", (Object)price);
            item.put("\u4e0d\u542b\u7a0e\u5355\u4ef7", (Object)netPrice);
            String dateFormat = quoteDate == null ? "" : DateUtil.format((Date)quoteDate, (String)"yyyy-MM-dd");
            item.put("\u4ef7\u683c\u65e5\u671f", (Object)dateFormat);
            historyPriceList.add(item);
        }
        return JSON.toJSONString(historyPriceList);
    }

    public String runCollectResult(String body, String ... args) {
        return body;
    }

    public JSONObject runClean(AgentLlmRequestDto llmRequest, JSONObject preStepParam, String ... args) {
        if (null == preStepParam) {
            preStepParam = new JSONObject();
            preStepParam.put("historyPriceSchema", (Object)"");
        } else {
            String priceStr = preStepParam.getString("historyPriceSchema");
            preStepParam.put("historyPriceSchema", (Object)priceStr);
        }
        return preStepParam;
    }

    public Map<String, LlmResponseDto> runVoted(AgentLlmRequestDto llmRequest, Map<String, LlmResponseDto> responsePojoMap, String ... args) {
        return responsePojoMap;
    }
}

