/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.job;

import com.els.common.api.service.JobRpcService;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;

@RpcService(value="purchaseInformationRecordsRpcStatusChangeJob")
public class SrmPriceStatusChangeJob
implements JobRpcService {
    private static final Logger logger = LoggerFactory.getLogger(SrmPriceStatusChangeJob.class);
    private final String LOCK_PREFIX = "purchaseInformationRecords_schedule_srmPriceStatusChangeJob";
    private final long EXPIRE_TIME = 600009L;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private PurchaseInformationRecordsService purchaseInformationRecordsService;

    public void execute(String parameter) {
        String requestId = "100000";
        if (!this.redisUtil.tryGetDistributedLock("purchaseInformationRecords_schedule_srmPriceStatusChangeJob", requestId, 600009L)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_umdWFzEHrLSiKRcWVxPVBRc_268e90d8", (String)" \u4ef7\u683c\u4e3b\u6570\u636e\u72b6\u6001\u66f4\u6539\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6267\u884c"));
        }
        try {
            logger.info("SrmPriceStatusChangeJob start");
            this.purchaseInformationRecordsService.changePriceStatusForJob();
            logger.info("SrmPriceStatusChangeJob end");
        }
        catch (Exception e) {
            logger.info(Thread.currentThread().getName() + "\u4ef7\u683c\u4e3b\u6570\u636e\u72b6\u6001\u66f4\u6539\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
            throw e;
        }
        finally {
            this.redisUtil.releaseDistributedLock("purchaseInformationRecords_schedule_srmPriceStatusChangeJob", requestId);
        }
    }

    @Scheduled(cron="0 20 0 ? * *")
    public void doScheduled() {
        this.execute(null);
    }
}

