/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.vo.PurchaseMaterialHeadVO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchaseMaterialHeadAuditAdapter")
public class PurchaseMaterialHeadAdapter
implements WorkflowAuditOptCallBackService {
    @Autowired
    PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        PurchaseMaterialHeadVO headVO = (PurchaseMaterialHeadVO)((Object)JSON.parseObject((String)JSONObject.toJSONString(this.getById(flowCallbackDTO.getBusinessId())), PurchaseMaterialHeadVO.class));
        PurchaseMaterialHead purchaseMaterialHead = new PurchaseMaterialHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)purchaseMaterialHead));
        headVO.setAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue());
        headVO.setFlowId(flowCallbackDTO.getProcessInstanceId());
        headVO.setSubmitStatus("1");
        headVO.setFromEditPage(false);
        this.purchaseMaterialHeadService.updateMain(headVO, headVO.getPurchaseMaterialItemList(), headVO.getPurchaseMaterialMeterUnitList(), headVO.getAttachmentList());
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        PurchaseMaterialHead head = new PurchaseMaterialHead();
        head.setId(flowCallbackDTO.getBusinessId());
        head.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        head.setFlowId(flowCallbackDTO.getProcessInstanceId());
        this.purchaseMaterialHeadService.updateById((Object)head);
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseMaterialHead head = (PurchaseMaterialHead)((Object)this.purchaseMaterialHeadService.getById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseMaterialHead head = new PurchaseMaterialHead();
        head.setId(flowCallbackDTO.getBusinessId());
        head.setAuditStatus(auditStatus);
        head.setFlowId(flowCallbackDTO.getProcessInstanceId());
        this.purchaseMaterialHeadService.updateById((Object)head);
    }
}

