/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmUtil;
import com.els.modules.material.entity.PurchaseMaterialSource;
import com.els.modules.material.mapper.PurchaseMaterialSourceMapper;
import com.els.modules.material.service.PurchaseMaterialSourceService;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Map;

@RpcService(value="purchaseMaterialSourceAuditAdapter")
public class PurchaseMaterialSourceAdapter
implements WorkflowAuditOptCallBackService {
    @Resource
    PurchaseMaterialSourceMapper purchaseMaterialSourceMapper;
    @Resource
    PurchaseMaterialSourceService purchaseMaterialSourceService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        PurchaseMaterialSource source = new PurchaseMaterialSource();
        source.setId(flowCallbackDTO.getBusinessId());
        source.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        source.setFlowId(flowCallbackDTO.getProcessInstanceId());
        int count = this.purchaseMaterialSourceMapper.updateById((Object)source);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseMaterialSource head = (PurchaseMaterialSource)((Object)this.purchaseMaterialSourceService.getById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseMaterialSource source = new PurchaseMaterialSource();
        source.setId(flowCallbackDTO.getBusinessId());
        source.setAuditStatus(auditStatus);
        source.setFlowId(flowCallbackDTO.getProcessInstanceId());
        int count = this.purchaseMaterialSourceMapper.updateById((Object)source);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }
}

