/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.org.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.org.entity.PurchaseOrganizationInfo;
import com.els.modules.org.service.PurchaseOrganizationInfoService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@RpcService(value="purchaseOrganizationInfoImportRpcServiceImpl")
public class PurchaseOrganizationInfoExcelHandler
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    PurchaseOrganizationInfoService purchaseOrganizationInfoService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        String msg;
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("org");
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"i18n_alert_VWERVRuRESIrW_79c971fa", (String)"\u8bf7\u5148\u914d\u7f6e\u7ec4\u7ec7\u67b6\u6784\u4e1a\u52a1\u6a21\u677f\u3002"));
        ArrayList<PurchaseOrganizationInfo> entityList = new ArrayList<PurchaseOrganizationInfo>();
        ArrayList<String> codeList = new ArrayList<String>();
        Iterator iterator = dataList.iterator();
        while (iterator.hasNext()) {
            Map data = (Map)iterator.next();
            String orgCode = (String)data.get("orgCode");
            if (CharSequenceUtil.isEmpty((CharSequence)orgCode)) {
                String msg2 = I18nUtil.translate((String)"i18n_field_nRVRAoxOLV_a96fcac4", (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg2, data);
                iterator.remove();
                continue;
            }
            String orgCategoryCode = (String)data.get("orgCategoryCode");
            if (CharSequenceUtil.isEmpty((CharSequence)orgCategoryCode)) {
                String msg3 = I18nUtil.translate((String)"i18n_alert_VRAcxOLV_a101369e", (String)"\u7ec4\u7ec7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.errorAdd(excelImportDTO, msg3, data);
                iterator.remove();
                continue;
            }
            String code = orgCategoryCode + "_" + (String)orgCode;
            if (codeList.contains(code)) {
                msg = I18nUtil.translate((String)"i18n_alert_APjVRAonVRAcIOMKWVImW_14a4b4dd", (String)"\u5f53\u524d\u7684\u7ec4\u7ec7\u7f16\u7801\u548c\u7ec4\u7ec7\u7c7b\u578b\u5df2\u7ecf\u5b58\u5728,\u8bf7\u68c0\u67e5!\uff01");
                this.errorAdd(excelImportDTO, msg, data);
                iterator.remove();
                continue;
            }
            codeList.add(code);
        }
        Map<String, String> orgMap = this.purchaseOrganizationInfoService.mapIdsByOrgCodeAndOrgCategoryCode(codeList);
        for (Map data : dataList) {
            String orgCode = (String)data.get("orgCategoryCode") + "," + (String)data.get("orgCode");
            if (orgMap.containsKey(orgCode)) {
                msg = I18nUtil.translate((String)"i18n_alert_APjVRAonVRAcIOMKWVImW_14a4b4dd", (String)"\u5f53\u524d\u7684\u7ec4\u7ec7\u7f16\u7801\u548c\u7ec4\u7ec7\u7c7b\u578b\u5df2\u7ecf\u5b58\u5728,\u8bf7\u68c0\u67e5!\uff01");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            PurchaseOrganizationInfo entity = (PurchaseOrganizationInfo)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), PurchaseOrganizationInfo.class));
            entity.setElsAccount(TenantContext.getTenant());
            entity.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            entity.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            entity.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion());
            entity.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
            entity.setId(IdWorker.getIdStr());
            entityList.add(entity);
        }
        List<String> superBusinessList = entityList.stream().filter(x -> StrUtil.isNotEmpty((CharSequence)x.getSuperBusinessId())).map(x -> x.getOrgCategoryCode() + "_" + x.getSuperBusinessId().split("_")[0]).distinct().collect(Collectors.toList());
        List superExecutiveList = entityList.stream().filter(x -> StrUtil.isNotEmpty((CharSequence)x.getSuperExecutiveId())).map(x -> x.getOrgCategoryCode() + "_" + x.getSuperExecutiveId().split("_")[0]).distinct().collect(Collectors.toList());
        superBusinessList.addAll(superExecutiveList);
        Map<String, String> newIdsMap = entityList.stream().collect(Collectors.toMap(x -> x.getOrgCategoryCode() + "_" + x.getOrgCode(), BaseEntity::getId, (v1, v2) -> v2));
        Map<String, String> idsMap = this.purchaseOrganizationInfoService.mapIdsByOrgCodeAndOrgCategoryCode(superBusinessList);
        for (PurchaseOrganizationInfo info : entityList) {
            String supperId;
            String code;
            if (StrUtil.isEmpty((CharSequence)info.getSuperBusinessId())) {
                info.setSuperBusinessId(null);
            } else {
                code = info.getOrgCategoryCode() + "," + info.getSuperBusinessId().split("_")[0];
                supperId = idsMap.get(code);
                if (null == supperId) {
                    supperId = newIdsMap.get(code);
                }
                info.setSuperBusinessId(supperId);
            }
            if (StrUtil.isEmpty((CharSequence)info.getSuperExecutiveId())) {
                info.setSuperExecutiveId(null);
            } else {
                code = info.getOrgCategoryCode() + "," + info.getSuperExecutiveId().split("_")[0];
                supperId = idsMap.get(code);
                if (null == supperId) {
                    supperId = newIdsMap.get(code);
                }
                info.setSuperExecutiveId(supperId);
            }
            info.setDataSource(CharSequenceUtil.emptyToDefault((CharSequence)info.getDataSource(), (String)"1"));
        }
        this.purchaseOrganizationInfoService.saveBatch(entityList);
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

