/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.api.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.service.AlertRpcService;
import com.els.common.aspect.annotation.RpcService;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RpcService(value="purchaseInformationRecordsAlertServiceImpl")
public class PurchaseInformationRecordsAlertSingleServiceImpl
implements AlertRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseInformationRecordsAlertSingleServiceImpl.class);
    @Resource
    private PurchaseInformationRecordsService purchaseInformationRecordsServiceImpl;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public List<?> getAlertList(JSONObject config) {
        int alertDays = config.getInteger("alertDays");
        Date currentDate = new Date();
        DateTime checkDate = DateUtil.offsetDay((Date)currentDate, (int)alertDays);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.lt(PurchaseInformationRecords::getExpiryDate, (Object)checkDate);
        queryWrapper.gt(PurchaseInformationRecords::getExpiryDate, (Object)currentDate);
        List rs = this.purchaseInformationRecordsServiceImpl.list((Wrapper)queryWrapper);
        if (CollUtil.isNotEmpty((Collection)rs)) {
            rs.forEach(r -> {
                if (ObjectUtil.isNotEmpty((Object)r.getEffectiveDate())) {
                    r.setEffectiveDateStr(DateUtil.formatDate((Date)r.getEffectiveDate()));
                }
                if (ObjectUtil.isNotEmpty((Object)r.getExpiryDate())) {
                    r.setExpiryDateStr(DateUtil.formatDate((Date)r.getExpiryDate()));
                }
            });
        }
        return rs;
    }

    public List<ElsSubAccountDTO> getPrincipalList(Object obj, JSONObject config) {
        ArrayList<ElsSubAccountDTO> list = new ArrayList<ElsSubAccountDTO>();
        String json = JSON.toJSONString((Object)obj);
        log.info("getPrincipalList:" + json);
        JSON.parseObject((String)json, PurchaseInformationRecords.class);
        PurchaseInformationRecords informationRecords = (PurchaseInformationRecords)((Object)JSON.parseObject((String)json, PurchaseInformationRecords.class));
        return list;
    }

    public String buildUrlParamTemplate(Object obj) {
        if (obj == null) {
            return "";
        }
        JSONObject param = JSON.parseObject((String)JSON.toJSONString((Object)obj));
        return "id=" + param.get((Object)"id") + "&templateName=" + param.get((Object)"templateName") + "&templateNumber=" + param.get((Object)"templateNumber") + "&templateAccount=" + param.get((Object)"templateAccount") + "&templateVersion=" + param.get((Object)"templateVersion");
    }
}

