/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.entity.PurchaseBomHead;
import com.els.modules.material.entity.PurchaseBomItem;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.enumerate.PurchaseBomStatus;
import com.els.modules.material.service.PurchaseBomHeadService;
import com.els.modules.material.service.PurchaseBomItemService;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchaseBomListItemRpcImportImpl")
public class PurchaseBomListItemImportImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseBomListItemImportImpl.class);
    @Autowired
    private PurchaseBomHeadService purchaseBomHeadService;
    @Autowired
    private PurchaseBomItemService purchaseBomItemService;
    @Resource
    private PurchaseMaterialHeadService purchaseMaterialHeadService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        Object msg;
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        ArrayList<String> bomNumberList = new ArrayList<String>();
        ArrayList<String> materialNumberList = new ArrayList<String>();
        HashMap<String, Object> bomMaterialMap = new HashMap<String, Object>();
        Iterator iterator = dataList.iterator();
        while (iterator.hasNext()) {
            String bomNumber;
            Map data = (Map)iterator.next();
            String materialNumber = (String)data.get("materialNumber");
            if (CharSequenceUtil.isEmpty((CharSequence)materialNumber)) {
                String msg2 = I18nUtil.translate((String)"i18n_field_SLAoxOLV_f1cdd68b", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg2, data);
                iterator.remove();
                continue;
            }
            if (!materialNumberList.contains(materialNumber)) {
                materialNumberList.add(materialNumber);
            }
            if (CharSequenceUtil.isEmpty((CharSequence)(bomNumber = (String)data.get("bomNumber")))) {
                String msg3 = I18nUtil.translate((String)"i18n_alert_BOMBttyxOLV_5f15d21f", (String)"BOM\u8868\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg3, data);
                iterator.remove();
                continue;
            }
            if (!bomNumberList.contains(bomNumber)) {
                bomNumberList.add(bomNumber);
            }
            if (!bomMaterialMap.containsKey(bomNumber)) {
                HashSet list2 = new HashSet();
                bomMaterialMap.put(bomNumber, list2);
            }
            ((Set)bomMaterialMap.get(bomNumber)).add(materialNumber);
            String bomLevel = (String)data.get("bomLevel");
            if (CharSequenceUtil.isEmpty((CharSequence)bomLevel)) {
                String msg4 = I18nUtil.translate((String)"i18n_alert_DtxOLV_8ca4d435", (String)"\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg4, data);
                iterator.remove();
                continue;
            }
            int level = 1;
            try {
                level = Integer.parseInt(bomLevel);
                if (level >= 0) continue;
                String msg5 = I18nUtil.translate((String)"i18n_alert_DtROKfUEU1jiiW_d77b02c9", (String)"\u5c42\u7ea7\u53ea\u80fd\u662f\u5927\u4e8e\u7b49\u4e8e1\u7684\u6b63\u6574\u6570");
                this.errorAdd(excelImportDTO, msg5, data);
                iterator.remove();
            }
            catch (Exception e) {
                msg = I18nUtil.translate((String)"i18n_alert_DtROKfUEU1jiiW_d77b02c9", (String)"\u5c42\u7ea7\u53ea\u80fd\u662f\u5927\u4e8e\u7b49\u4e8e1\u7684\u6b63\u6574\u6570");
                this.errorAdd(excelImportDTO, (String)msg, data);
                iterator.remove();
            }
        }
        Map<String, PurchaseMaterialHead> materialIdMap = this.purchaseMaterialHeadService.listMaterialHeadByNumbers(materialNumberList, TenantContext.getTenant());
        Map<String, PurchaseBomHead> bomIdMap = this.purchaseBomHeadService.listBomByBomNumber(bomNumberList, TenantContext.getTenant());
        ArrayList<PurchaseBomItem> itemList = new ArrayList<PurchaseBomItem>();
        for (Map data : dataList) {
            String bomNumber = (String)data.get("bomNumber");
            PurchaseBomHead bomHead = bomIdMap.get(bomNumber);
            if (null == bomHead) {
                msg = I18nUtil.translate((String)"i18n_alert_BOMBttyxMK_b8ba19ae", (String)"BOM\u8868\u5355\u5355\u53f7\u4e0d\u5b58\u5728") + bomNumber;
                this.errorAdd(excelImportDTO, (String)msg, data);
                bomMaterialMap.remove(bomNumber);
                continue;
            }
            if (AuditStatusEnum.AUDIT_DOING.getValue().equals(bomHead.getAuditStatus()) || AuditStatusEnum.AUDIT_FINISH.getValue().equals(bomHead.getAuditStatus())) {
                msg = I18nUtil.translate((String)"i18n_alert_BOMBtUzsUzeRxquNcWF_1853cff", (String)"BOM\u8868\u5355\u5ba1\u6279\u4e2d/\u5ba1\u6279\u901a\u8fc7\uff0c\u4e0d\u53ef\u5bfc\u5165\u884c\u6570\u636e") + bomNumber;
                this.errorAdd(excelImportDTO, (String)msg, data);
                bomMaterialMap.remove(bomNumber);
                continue;
            }
            if (PurchaseBomStatus.CANCEL.getValue().equals(bomHead.getBomStatus()) || PurchaseBomStatus.FROZEN.getValue().equals(bomHead.getBomStatus())) {
                msg = I18nUtil.translate((String)"i18n_alert_BOMBtIOyIkuAtxquNcWF_766975d1", (String)"BOM\u8868\u5355\u5df2\u51bb\u7ed3/\u5df2\u4f5c\u5e9f\u7f16\u8f91\uff0c\u4e0d\u53ef\u5bfc\u5165\u884c\u6570\u636e") + bomNumber;
                this.errorAdd(excelImportDTO, (String)msg, data);
                bomMaterialMap.remove(bomNumber);
                continue;
            }
            String materialNumber = (String)data.get("materialNumber");
            PurchaseMaterialHead head = materialIdMap.get(materialNumber);
            if (null == head) {
                String msg6 = I18nUtil.translate((String)"i18n_alert_SLAoxMK_cdf9d7c2", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u5b58\u5728");
                this.errorAdd(excelImportDTO, msg6, data);
                continue;
            }
            String parentMaterialNumber = (String)data.get("parentMaterialNumber");
            if (CharSequenceUtil.isEmpty((CharSequence)parentMaterialNumber)) {
                data.put("bomLevel", "1");
                data.put("parentMaterialDesc", "");
                data.put("parentMaterialNumber", "");
            } else {
                String msg7;
                PurchaseMaterialHead phead = materialIdMap.get(parentMaterialNumber);
                if (null == phead) {
                    msg7 = I18nUtil.translate((String)"i18n_alert_BdSLAoxMK_59ea515f", (String)"\u7236\u9879\u7269\u6599\u7f16\u7801\u4e0d\u5b58\u5728");
                    this.errorAdd(excelImportDTO, msg7, data);
                    continue;
                }
                if (parentMaterialNumber.equals(materialNumber)) {
                    msg7 = I18nUtil.translate((String)"i18n_alert_SLAoxOnBdSLAode_ba940333", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u548c\u7236\u9879\u7269\u6599\u7f16\u7801\u76f8\u540c");
                    this.errorAdd(excelImportDTO, msg7, data);
                    continue;
                }
                String itemBomNumber = (String)data.get("bomNumber");
                Set parentMaterialList = (Set)bomMaterialMap.get(itemBomNumber);
                if (!parentMaterialList.contains(parentMaterialNumber)) {
                    String msg8 = I18nUtil.translate((String)"i18n_alert_BdSLAolTMKUBOMBt0SLAos_122e7a2b", (String)"\u7236\u9879\u7269\u6599\u7f16\u7801\u5fc5\u987b\u5b58\u5728\u4e8eBOM\u8868\u5355${0}\u7269\u6599\u7f16\u7801\u4e2d");
                    this.errorAdd(excelImportDTO, msg8, data);
                    continue;
                }
                data.put("parentMaterialDesc", phead.getMaterialDesc());
            }
            PurchaseBomItem entity = (PurchaseBomItem)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), PurchaseBomItem.class));
            if (CharSequenceUtil.isNotBlank((CharSequence)materialNumber)) {
                entity.setMaterialDesc(head.getMaterialDesc());
                entity.setMaterialSpec(head.getMaterialSpec());
                entity.setMaterialId(head.getId());
            } else {
                entity.setMaterialDesc(null);
                entity.setMaterialSpec(null);
                entity.setMaterialId(null);
            }
            if (CharSequenceUtil.isEmpty((CharSequence)entity.getMaterialOrder())) {
                entity.setMaterialOrder("1");
            }
            entity.setHeadId(bomHead.getId());
            entity.setElsAccount(bomHead.getElsAccount());
            itemList.add(entity);
        }
        if (CollUtil.isEmpty(itemList)) {
            this.errorHandle(true, excelImportDTO, SysUtil.getLoginUser().getElsAccount(), totalCount);
            return dataList;
        }
        this.purchaseBomItemService.deleteByHeadIds(bomIdMap.values().stream().map(BaseEntity::getId).collect(Collectors.toList()));
        Map<String, List<PurchaseBomItem>> listMap = itemList.stream().collect(Collectors.groupingBy(PurchaseBomItem::getHeadId));
        ArrayList finalItemList = new ArrayList();
        listMap.forEach((headId, list) -> {
            List<PurchaseBomItem> itemsTree = this.buildTree((List<PurchaseBomItem>)list, "");
            this.sort(itemsTree);
            List<PurchaseBomItem> resultList = this.recursionTreeToList(itemsTree, null);
            int i = 1;
            for (PurchaseBomItem item : resultList) {
                item.setItemNumber(Integer.toString(i));
                ++i;
            }
            finalItemList.addAll(resultList);
        });
        if (CollUtil.isNotEmpty(finalItemList)) {
            this.purchaseBomItemService.saveBatch(finalItemList);
        }
        this.errorHandle(true, excelImportDTO, SysUtil.getLoginUser().getElsAccount(), totalCount);
        return dataList;
    }

    private List<PurchaseBomItem> buildTree(List<PurchaseBomItem> all, String rootId) {
        ArrayList parent = Lists.newArrayList();
        for (PurchaseBomItem item : all) {
            item.setChildren(this.getChildren(item, all));
            if (!rootId.equals(item.getParentMaterialNumber()) || item.getMaterialNumber().equals(item.getParentMaterialNumber())) continue;
            parent.add(item);
        }
        return parent;
    }

    private List<PurchaseBomItem> getChildren(PurchaseBomItem bom, List<PurchaseBomItem> all) {
        ArrayList<PurchaseBomItem> childList = new ArrayList<PurchaseBomItem>(8);
        for (PurchaseBomItem child : all) {
            if (!bom.getMaterialNumber().equals(child.getParentMaterialNumber()) || bom.getMaterialNumber().equals(bom.getParentMaterialNumber())) continue;
            child.setChildren(this.getChildren(child, all));
            childList.add(child);
        }
        return childList;
    }

    public List<PurchaseBomItem> recursionTreeToList(List<PurchaseBomItem> tree, List<PurchaseBomItem> result) {
        if (null == result) {
            result = new ArrayList<PurchaseBomItem>();
        }
        for (PurchaseBomItem item : tree) {
            result.add(item);
            if (!CollUtil.isNotEmpty(item.getChildren())) continue;
            this.recursionTreeToList(item.getChildren(), result);
        }
        return result;
    }

    private void sort(List<PurchaseBomItem> itemsTree) {
        if (CollUtil.isNotEmpty(itemsTree)) {
            itemsTree.sort(Comparator.comparingDouble(x -> Double.parseDouble(x.getMaterialOrder())));
        }
        for (PurchaseBomItem item : itemsTree) {
            if (!CollUtil.isNotEmpty(item.getChildren())) continue;
            this.sort(item.getChildren());
        }
    }
}

