/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.api.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.excel.ExcelExportClassColumnDTO;
import com.els.common.util.ClassTypeBuilder;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.OpenApiRpcService;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialItem;
import com.els.modules.material.entity.PurchaseMaterialUnit;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialItemService;
import com.els.modules.material.service.PurchaseMaterialUnitService;
import com.els.modules.material.vo.PurchaseMaterialHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@RpcService(value="createMaterial")
public class PurchaseMaterialCreateOpenServiceImpl
implements OpenApiRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseMaterialCreateOpenServiceImpl.class);
    @Autowired
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Autowired
    private PurchaseMaterialItemService purchaseMaterialItemService;
    @Autowired
    private PurchaseMaterialUnitService purchaseMaterialUnitService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    public JSONObject doCreateInvoke(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap) {
        String account = TenantContext.getTenant();
        Date currentTime = new Date();
        ArrayList<PurchaseMaterialHead> headList = new ArrayList<PurchaseMaterialHead>();
        ArrayList allItem = new ArrayList();
        ArrayList allUnitItem = new ArrayList();
        for (Object obj : array) {
            JSONObject object = (JSONObject)Convert.convert(JSONObject.class, obj);
            if (object.size() == 0) continue;
            PurchaseMaterialHead head = (PurchaseMaterialHead)((Object)ConvertUtils.convertDefault(PurchaseMaterialHead.class, (JSONObject)object, defaultHeadMap));
            head.setElsAccount(account);
            head.setCreateTime(currentTime);
            head.setDeleted(CommonConstant.DEL_FLAG_0);
            head.setTemplateName(templateHead.getTemplateName());
            head.setTemplateNumber(templateHead.getTemplateNumber());
            head.setTemplateVersion(templateHead.getTemplateVersion());
            head.setTemplateAccount(templateHead.getElsAccount());
            if (CharSequenceUtil.isEmpty((CharSequence)head.getId())) {
                head.setId(IdWorker.getIdStr());
            }
            if (CharSequenceUtil.isEmpty((CharSequence)head.getNeedAudit())) {
                head.setNeedAudit("0");
            }
            if (!"1".equals(head.getNeedAudit())) {
                head.setNeedAudit("0");
                head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            } else if (CharSequenceUtil.isEmpty((CharSequence)head.getAuditStatus())) {
                head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            }
            if (CharSequenceUtil.isEmpty((CharSequence)head.getSubmitStatus())) {
                head.setSubmitStatus("0");
            }
            headList.add(head);
            JSONObject headObj = SysUtil.objectToJSON((Object)((Object)head));
            JSONArray itemListJsonArray = null;
            if (object.containsKey((Object)"purchaseMaterialItemList")) {
                itemListJsonArray = object.getJSONArray("purchaseMaterialItemList");
            } else if (object.containsKey((Object)"itemList")) {
                itemListJsonArray = object.getJSONArray("itemList");
            }
            try {
                List itemList;
                if (null == itemListJsonArray || itemListJsonArray.isEmpty() || null == (itemList = JSON.parseArray((String)itemListJsonArray.toJSONString(), PurchaseMaterialItem.class))) continue;
                for (PurchaseMaterialItem item : itemList) {
                    item.setId(IdWorker.getIdStr());
                    item.setHeadId(head.getId());
                    item.setElsAccount(account);
                    item.setCreateTime(currentTime);
                    item.setDeleted(CommonConstant.DEL_FLAG_0);
                    BeanUtil.copyProperties(defaultItemMap, (Object)((Object)item), (String[])new String[0]);
                }
                this.checkMaterialItem(itemList);
                allItem.addAll(itemList);
            }
            catch (Exception e) {
                log.error("{}==>ItemList\u6570\u636e\u683c\u5f0f\u5f02\u5e38:{}", (Object)this.getBusinessType(), (Object)e.getMessage());
                throw e;
            }
            JSONArray fileListJsonArray = null;
            if (object.containsKey((Object)"purchaseMaterialMeterUnitList")) {
                fileListJsonArray = object.getJSONArray("purchaseMaterialMeterUnitList");
            }
            try {
                List unitList;
                if (null == fileListJsonArray || fileListJsonArray.isEmpty() || null == (unitList = JSON.parseArray((String)fileListJsonArray.toJSONString(), PurchaseMaterialUnit.class))) continue;
                for (PurchaseMaterialUnit item : unitList) {
                    item.setId(IdWorker.getIdStr());
                    item.setHeadId(head.getId());
                    item.setElsAccount(account);
                    item.setCreateTime(currentTime);
                    item.setDeleted(CommonConstant.DEL_FLAG_0);
                }
                allUnitItem.addAll(unitList);
            }
            catch (Exception e) {
                log.error("{}==>unitList\u6570\u636e\u683c\u5f0f\u5f02\u5e38:{}", (Object)this.getBusinessType(), (Object)e.getMessage());
                throw e;
            }
        }
        if (!headList.isEmpty()) {
            PurchaseMaterialHead entity = (PurchaseMaterialHead)((Object)headList.get(0));
            long size = headList.stream().filter(x -> CharSequenceUtil.isEmpty((CharSequence)x.getMaterialNumber())).count();
            if (size > 0L) {
                List nextCodes = this.invokeBaseRpcService.getNextCodes("srmMaterialNumber", (Object)entity, (int)size);
                Assert.notEmpty((Collection)nextCodes, (String)I18nUtil.translate((String)"i18n_alert_uNSLdWFAobLIH_3f155012", (String)"\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636e\u7f16\u7801\u751f\u6210\u5f02\u5e38"));
                int codeIndex = 0;
                for (PurchaseMaterialHead e : headList) {
                    if (!CharSequenceUtil.isEmpty((CharSequence)e.getMaterialNumber())) continue;
                    e.setMaterialNumber((String)nextCodes.get(codeIndex++));
                }
            }
            this.purchaseMaterialHeadService.saveBatch(headList, 2000);
        }
        if (!allItem.isEmpty()) {
            this.purchaseMaterialItemService.saveBatch(allItem, 2000);
        }
        if (!allUnitItem.isEmpty()) {
            this.purchaseMaterialUnitService.saveBatch(allUnitItem, 2000);
        }
        Map<String, List<PurchaseMaterialItem>> itemMap = allItem.stream().collect(Collectors.groupingBy(PurchaseMaterialItem::getHeadId));
        Map<String, List<PurchaseMaterialUnit>> unitMap = allUnitItem.stream().collect(Collectors.groupingBy(PurchaseMaterialUnit::getHeadId));
        List collect = headList.stream().map(x -> (PurchaseMaterialHeadVO)((Object)((Object)Convert.convert(PurchaseMaterialHeadVO.class, (Object)x)))).collect(Collectors.toList());
        for (PurchaseMaterialHeadVO vo : collect) {
            vo.setPurchaseMaterialItemList(itemMap.get(vo.getId()));
            vo.setPurchaseMaterialMeterUnitList(unitMap.get(vo.getId()));
        }
        JSONObject resultObj = new JSONObject();
        resultObj.put("headList", collect);
        return resultObj;
    }

    private void checkMaterialItem(List<PurchaseMaterialItem> purchaseMaterialItemList) {
        List stringList = purchaseMaterialItemList.stream().map(PurchaseMaterialItem::getFactory).collect(Collectors.toList());
        long count = stringList.stream().distinct().count();
        if ((long)stringList.size() != count) {
            throw new IllegalArgumentException(I18nUtil.translate((String)"i18n_alert_SLcsMKdejRHW_ba2f6f5", (String)"\u7269\u6599\u884c\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u5de5\u5382\uff01"));
        }
    }

    public void doParamCheck(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap, List<TemplateConfigHeadDTO> configHeadList, List<TemplateConfigItemDTO> configItemList) {
    }

    public String getBusinessType() {
        return "material";
    }

    public List<ExcelExportClassColumnDTO> getBusinessClass() {
        return ClassTypeBuilder.buildClassTypeList(PurchaseMaterialHeadVO.class, null, null);
    }

    public List<String> supportItemList() {
        return Lists.newArrayList((Object[])new String[]{"purchaseMaterialItemList"});
    }
}

