/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.thirddata.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.DateUtils;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.SrmToIPaasRpcService;
import com.els.modules.material.enumerate.AsianMetalTypeEnum;
import com.els.modules.thirddata.entity.BulkMaterialPrice;
import com.els.modules.thirddata.mapper.BulkMaterialPriceMapper;
import com.els.modules.thirddata.service.BulkMaterialPriceService;
import com.els.modules.thirddata.vo.ScanWebSiteVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BulkMaterialPriceServiceImpl
extends BaseServiceImpl<BulkMaterialPriceMapper, BulkMaterialPrice>
implements BulkMaterialPriceService {
    @Resource
    private BulkMaterialPriceMapper bulkMaterialPriceMapper;
    @Resource
    private SrmToIPaasRpcService srmToIPaasRpcService;
    @Resource
    private InterfaceUtil interfaceUtil;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public void saveBulkMaterialPrice(BulkMaterialPrice bulkMaterialPrice) {
        ((BulkMaterialPriceMapper)this.baseMapper).insert((Object)bulkMaterialPrice);
    }

    @Override
    public void updateBulkMaterialPrice(BulkMaterialPrice bulkMaterialPrice) {
        ((BulkMaterialPriceMapper)this.baseMapper).updateById((Object)bulkMaterialPrice);
    }

    @Override
    public void delBulkMaterialPrice(String id) {
        ((BulkMaterialPriceMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchBulkMaterialPrice(List<String> idList) {
        ((BulkMaterialPriceMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public Integer insertBatch(List<BulkMaterialPrice> BulkMaterialPriceList) {
        boolean b = this.saveBatch(BulkMaterialPriceList);
        return 1;
    }

    @Override
    public JSONObject callIPaasInterface(JSONObject data, String service, String interfaceCode) {
        return this.srmToIPaasRpcService.callIPaasInterface(data, service, interfaceCode);
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getBulkMaterialPrice", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List bulkMaterialPriceList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (BulkMaterialPrice bulkMaterialPrice : bulkMaterialPriceList) {
            String elsAccount = TenantContext.getTenant();
            this.interfaceUtil.callInterface(elsAccount, "pushBulkMaterialPrice", (Object)bulkMaterialPrice);
        }
    }

    @Override
    public void scanFromIPass(ScanWebSiteVO scanWebSiteVO) {
        String picSourceText = this.invokeBaseRpcService.queryDictTextByKey("bulkMaterialPriceSourceType", scanWebSiteVO.getPriceSource(), TenantContext.getTenant());
        JSONObject request = new JSONObject();
        request.put("language", (Object)scanWebSiteVO.getLanguage());
        request.put("time", (Object)DateUtils.formatDate((Date)scanWebSiteVO.getTime(), (String)"yyyyMMdd"));
        request.put("priceSource", (Object)scanWebSiteVO.getPriceSource());
        JSONObject response = this.srmToIPaasRpcService.callIPaasInterface(request, "valueAddedApplication", this.invokeBaseRpcService.getIpaasInterfaceCode("getAsianmetalPrice"));
        JSONArray detailArray = this.judugeResult(response);
        if (CollectionUtil.isEmpty((Collection)detailArray)) {
            return;
        }
        ArrayList<BulkMaterialPrice> bulkMaterialPriceList = new ArrayList<BulkMaterialPrice>(detailArray.size());
        for (Object detail : detailArray) {
            BulkMaterialPrice price;
            block13: {
                JSONObject detailObject = JSONObject.parseObject((String)detail.toString());
                price = new BulkMaterialPrice();
                price.setCategoryName(detailObject.getString("priceName"));
                price.setMaterialSpec(detailObject.getString("priceSpec"));
                price.setPriceUnit(detailObject.getString("priceUnit"));
                Date priceShowDateTime = detailObject.getDate("priceShowDateTime");
                if (null != priceShowDateTime) {
                    price.setPriceDate(priceShowDateTime);
                } else {
                    price.setPriceDate(new Date());
                }
                price.setPriceRange(detailObject.getString("priceNumber"));
                price.setElsAccount(TenantContext.getTenant());
                price.setId(null);
                price.setClassification(AsianMetalTypeEnum.getByValue(detailObject.getString("priceType")));
                price.setMaterialListType(price.getClassification());
                price.setPriceSource(scanWebSiteVO.getPriceSource());
                price.setSourceSystem(picSourceText);
                price.setSourceId(detailObject.getString("priceId"));
                String nameRegion = detailObject.getString("nameRegion");
                if (CharSequenceUtil.isEmpty((CharSequence)nameRegion)) {
                    nameRegion = detailObject.getString("market");
                }
                price.setRegion(nameRegion);
                String priceNumber = detailObject.getString("priceNumber");
                try {
                    BigDecimal bigDecimal = BigDecimal.valueOf(Double.parseDouble(priceNumber));
                    price.setPrice(bigDecimal);
                    price.setMaxPrice(bigDecimal);
                }
                catch (Exception e) {
                    if (!CharSequenceUtil.isNotEmpty((CharSequence)priceNumber)) break block13;
                    boolean flag = false;
                    int index = 0;
                    for (int i = 0; i < priceNumber.length(); ++i) {
                        if (priceNumber.charAt(i) < '0' || priceNumber.charAt(i) > '9') {
                            flag = true;
                            index = i;
                        }
                        if (flag) break;
                    }
                    try {
                        String startPrice = priceNumber.substring(0, index);
                        String endPrice = priceNumber.substring(index).replaceAll("[^\\w\\s.]+", "");
                        price.setPrice(BigDecimal.valueOf(Double.parseDouble(startPrice)));
                        price.setMaxPrice(BigDecimal.valueOf(Double.parseDouble(endPrice)));
                    }
                    catch (Exception ee) {
                        this.log.warn("\u65e0\u4ef7\u683c\u6570\u5b57");
                        price.setPrice(BigDecimal.ZERO);
                        price.setMaxPrice(BigDecimal.ZERO);
                    }
                }
            }
            bulkMaterialPriceList.add(price);
        }
        if (CollectionUtil.isNotEmpty(bulkMaterialPriceList)) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            if (null != scanWebSiteVO.getTime()) {
                wrapper.between(BulkMaterialPrice::getPriceDate, (Object)DateUtil.beginOfDay((Date)scanWebSiteVO.getTime()), (Object)DateUtil.endOfDay((Date)scanWebSiteVO.getTime()));
            }
            wrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
            wrapper.eq(BulkMaterialPrice::getPriceSource, (Object)scanWebSiteVO.getPriceSource());
            ((BulkMaterialPriceMapper)this.baseMapper).delete((Wrapper)wrapper);
            ((BulkMaterialPriceService)SpringContextUtils.getBean(BulkMaterialPriceService.class)).saveBatch(bulkMaterialPriceList);
        }
    }

    public JSONArray judugeResult(JSONObject object) {
        if (CommonConstant.SC_OK_200.equals(object.getInteger("code"))) {
            JSONObject data = object.getJSONObject("data");
            if ("200".equals(data.getString("code")) && StrUtil.isNotBlank((CharSequence)data.getString("result"))) {
                return data.getJSONArray("result");
            }
            return null;
        }
        throw new ELSBootException(object.getString("message"));
    }
}

