/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.exchange.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseOpenServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.exchange.entity.BpExchangeRate;
import com.els.modules.exchange.entity.BpExchangeRateHis;
import com.els.modules.exchange.mapper.BpExchangeRateHisMapper;
import com.els.modules.exchange.mapper.BpExchangeRateMapper;
import com.els.modules.exchange.service.BpExchangeRateService;
import com.els.modules.exchange.vo.BpExchangeRateVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BpExchangeRateServiceImpl
extends BaseOpenServiceImpl<BpExchangeRateMapper, BpExchangeRate, BpExchangeRate>
implements BpExchangeRateService {
    @Autowired
    private BpExchangeRateHisMapper bpExchangeRateHisMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    InterfaceUtil interfaceUtil;

    @Override
    public void saveBpExchangeRate(BpExchangeRate bpExchangeRate) {
        if (bpExchangeRate.getTargetCurrency().equals(bpExchangeRate.getOriginalCurrency())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_trSlnIBSlxOde_3f38e8fd", (String)"\u57fa\u51c6\u8d27\u5e01\u548c\u76ee\u6807\u8d27\u5e01\u4e0d\u80fd\u76f8\u540c"));
        }
        this.check(bpExchangeRate);
        bpExchangeRate.setExchangeNumber(this.invokeBaseRpcService.getNextCode("srmExchangeRate", (Object)bpExchangeRate));
        bpExchangeRate.setExchangeSource("0");
        ((BpExchangeRateMapper)this.baseMapper).insert((Object)bpExchangeRate);
    }

    private void check(BpExchangeRate bpExchangeRate) {
        if (null == bpExchangeRate.getExpireTime()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_bXBAxOLVW_f027d72e", (String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (null == bpExchangeRate.getEffectiveTime()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_KXBAxOLVW_e0d38940", (String)"\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (null != bpExchangeRate.getExpireTime() && null != bpExchangeRate.getEffectiveTime() && bpExchangeRate.getExpireTime().before(bpExchangeRate.getEffectiveTime())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_KXBAxOQUbXBA_ab254c9", (String)"\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u751f\u6548\u65e5\u671f"));
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(BpExchangeRate::getExchangeUse, (Object)bpExchangeRate.getExchangeUse());
        queryWrapper.eq(BpExchangeRate::getOriginalCurrency, (Object)bpExchangeRate.getOriginalCurrency());
        queryWrapper.eq(BpExchangeRate::getTargetCurrency, (Object)bpExchangeRate.getTargetCurrency());
        queryWrapper.eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.and(i -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.or(a -> ((LambdaQueryWrapper)a.le(BpExchangeRate::getEffectiveTime, (Object)bpExchangeRate.getEffectiveTime())).ge(BpExchangeRate::getExpireTime, (Object)bpExchangeRate.getExpireTime()))).or(b -> ((LambdaQueryWrapper)b.ge(BpExchangeRate::getEffectiveTime, (Object)bpExchangeRate.getEffectiveTime())).le(BpExchangeRate::getExpireTime, (Object)bpExchangeRate.getExpireTime()))).or(b -> ((LambdaQueryWrapper)((LambdaQueryWrapper)b.le(BpExchangeRate::getEffectiveTime, (Object)bpExchangeRate.getEffectiveTime())).le(BpExchangeRate::getExpireTime, (Object)bpExchangeRate.getExpireTime())).ge(BpExchangeRate::getExpireTime, (Object)bpExchangeRate.getEffectiveTime()))).or(b -> ((LambdaQueryWrapper)((LambdaQueryWrapper)b.ge(BpExchangeRate::getEffectiveTime, (Object)bpExchangeRate.getEffectiveTime())).ge(BpExchangeRate::getExpireTime, (Object)bpExchangeRate.getExpireTime())).le(BpExchangeRate::getEffectiveTime, (Object)bpExchangeRate.getExpireTime())));
        queryWrapper.ne(ObjectUtil.isNotNull((Object)bpExchangeRate.getId()), ParentEntity::getId, (Object)bpExchangeRate.getId());
        List list = this.list((Wrapper)queryWrapper);
        if (!list.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jXKICIMKdeMIjPWtrSlWIBSljWFWShKmSu_3c13edbf", (String)"\u6709\u6548\u65f6\u95f4\u5185\u5df2\u5b58\u5728\u76f8\u540c\u6c47\u7387\u7528\u9014\u3001\u57fa\u51c6\u8d27\u5e01\u3001\u76ee\u6807\u8d27\u5e01\u7684\u6570\u636e\uff0c\u65e0\u6cd5\u518d\u6b21\u6dfb\u52a0"));
        }
    }

    @Override
    public void updateBpExchangeRate(BpExchangeRate bpExchangeRate) {
        if (bpExchangeRate.getTargetCurrency().equals(bpExchangeRate.getOriginalCurrency())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_trSlnIBSlxOde_3f38e8fd", (String)"\u57fa\u51c6\u8d27\u5e01\u548c\u76ee\u6807\u8d27\u5e01\u4e0d\u80fd\u76f8\u540c"));
        }
        BpExchangeRate dbbpExchangeRate = (BpExchangeRate)((Object)((BpExchangeRateMapper)this.baseMapper).selectById((Serializable)((Object)bpExchangeRate.getId())));
        if (dbbpExchangeRate != null) {
            if (StrUtil.isBlank((CharSequence)bpExchangeRate.getExchangeUse())) {
                bpExchangeRate.setExchangeUse("0");
            }
            if (StrUtil.isBlank((CharSequence)bpExchangeRate.getExchangeSource())) {
                bpExchangeRate.setExchangeSource("0");
            }
            if (StrUtil.isBlank((CharSequence)bpExchangeRate.getExchangeNumber())) {
                bpExchangeRate.setExchangeNumber(this.invokeBaseRpcService.getNextCode("srmExchangeRate", (Object)bpExchangeRate));
            }
            if (!(bpExchangeRate.equals((Object)dbbpExchangeRate) && bpExchangeRate.getExchanged().compareTo(dbbpExchangeRate.getExchanged()) == 0 && (bpExchangeRate.getStandardUnit() == null || bpExchangeRate.getStandardUnit() != null && bpExchangeRate.getStandardUnit().equals(dbbpExchangeRate.getStandardUnit())) && (bpExchangeRate.getExpireTime() == null || bpExchangeRate.getExpireTime() != null && bpExchangeRate.getExpireTime().equals(dbbpExchangeRate.getExpireTime())) && (bpExchangeRate.getEffectiveTime() == null || bpExchangeRate.getEffectiveTime() != null && bpExchangeRate.getEffectiveTime().equals(dbbpExchangeRate.getEffectiveTime())))) {
                BpExchangeRateHis bpExchangeRateHis = new BpExchangeRateHis();
                BeanUtils.copyProperties((Object)((Object)dbbpExchangeRate), (Object)((Object)bpExchangeRateHis));
                bpExchangeRateHis.setId(IdWorker.getIdStr());
                bpExchangeRateHis.setHeadId(dbbpExchangeRate.getId());
                bpExchangeRateHis.setExpireTime(dbbpExchangeRate.getExpireTime());
                bpExchangeRateHis.setEffectiveTime(dbbpExchangeRate.getEffectiveTime());
                this.bpExchangeRateHisMapper.insert((Object)bpExchangeRateHis);
            }
        }
        this.check(bpExchangeRate);
        int count = ((BpExchangeRateMapper)this.baseMapper).updateById((Object)bpExchangeRate);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void delBpExchangeRate(String id) {
        ((BpExchangeRateMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchBpExchangeRate(List<String> idList) {
        ((BpExchangeRateMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getBpExchangeRate", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List bpExchangeRateList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (BpExchangeRate bpExchangeRate : bpExchangeRateList) {
            String elsAccount = TenantContext.getTenant();
            this.interfaceUtil.callInterface(elsAccount, "pushBpExchangeRate", (Object)bpExchangeRate);
        }
    }

    @Override
    public List<BpExchangeRateVO> getRateByCurrencys(List<String> originalCurrencys, String targetCurrency) {
        return ((BpExchangeRateMapper)this.baseMapper).getRateByCurrencys(originalCurrencys, targetCurrency);
    }
}

