/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.constant.CommonConstant;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialRelation;
import com.els.modules.material.entity.SaleMaterialRelation;
import com.els.modules.material.rpc.service.MaterialInvokeSupplierRpcService;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialRelationService;
import com.els.modules.material.service.SaleMaterialRelationService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.google.common.collect.Lists;
import jakarta.annotation.Resource;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="materialRelationImportRpcServiceImpl")
public class MaterialRelationImportImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Resource
    private MaterialInvokeSupplierRpcService materialInvokeSupplierRpcService;
    @Autowired
    private PurchaseMaterialRelationService purchaseMaterialRelationService;
    @Autowired
    private SaleMaterialRelationService saleMaterialRelationService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        String elsAccount = TenantContext.getTenant();
        ArrayList<PurchaseMaterialRelation> list = new ArrayList<PurchaseMaterialRelation>();
        Date currentTime = new Date();
        ArrayList elsToElsAccountList = Lists.newArrayList();
        ArrayList materialNumberDataList = Lists.newArrayList();
        for (Map data : dataList) {
            elsToElsAccountList.add(elsAccount + "_" + (String)data.get("toElsAccount"));
            materialNumberDataList.add((String)data.get("materialNumber"));
        }
        List<SupplierMasterDataDTO> supplierMasterDataDTOList = this.materialInvokeSupplierRpcService.listByElsAndToElsAccount(elsToElsAccountList);
        Map supplierMap = supplierMasterDataDTOList.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getToElsAccount, Function.identity(), (v1, v2) -> v1));
        List<PurchaseMaterialHead> materialHeadList = this.purchaseMaterialHeadService.getMaterialHeadByNumbers(materialNumberDataList);
        Map materialMap = materialHeadList.stream().collect(Collectors.toMap(PurchaseMaterialHead::getMaterialNumber, Function.identity(), (v1, v2) -> v1));
        ArrayList<CallSite> toElsMaterialNumber = new ArrayList<CallSite>();
        for (Map data : dataList) {
            PurchaseMaterialRelation materialRelation = (PurchaseMaterialRelation)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), PurchaseMaterialRelation.class));
            materialRelation.setId(IdWorker.getIdStr());
            materialRelation.setRelationId(IdWorker.getIdStr());
            materialRelation.setElsAccount(elsAccount);
            materialRelation.setCreateAccount(elsAccount);
            materialRelation.setDeleted(CommonConstant.DEL_FLAG_0);
            if (StrUtil.isBlank((CharSequence)materialRelation.getBlocked())) {
                materialRelation.setBlocked("0");
            }
            materialRelation.setPurchaseName(SysUtil.getLoginUser().getCompanyName());
            String toElsAccount = materialRelation.getToElsAccount();
            SupplierMasterDataDTO masterData = (SupplierMasterDataDTO)supplierMap.get(toElsAccount);
            if (null == masterData) {
                String msg = I18nUtil.translate((String)"i18n_alert_RdXWWWeyWWWWWWxMKWVnIWFW_77bcc1ac", (String)("\u4f9b\u5e94\u5546ELS\u8d26\u53f7\uff1a" + toElsAccount + " \u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u6570\u636e\uff01"), (String[])new String[]{toElsAccount});
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            materialRelation.setSupplierCode(masterData.getSupplierCode());
            materialRelation.setSupplierName(masterData.getSupplierName());
            String materialNumber = materialRelation.getMaterialNumber();
            PurchaseMaterialHead materialHead = (PurchaseMaterialHead)((Object)materialMap.get(materialNumber));
            if (null == materialHead) {
                String msg = I18nUtil.translate((String)"i18n_alert_nRCSLAyWWWWWWxMKWVnIWFW_bd843f20", (String)("\u91c7\u8d2d\u65b9\u7269\u6599\u7f16\u53f7\uff1a" + materialNumber + " \u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u6570\u636e\uff01"), (String[])new String[]{materialNumber});
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            materialRelation.setMaterialDesc(materialHead.getMaterialDesc());
            materialRelation.setMaterialName(materialHead.getMaterialName());
            materialRelation.setMaterialSpec(materialHead.getMaterialSpec());
            materialRelation.setMaterialId(materialHead.getId());
            list.add(materialRelation);
            String key = materialRelation.getToElsAccount() + materialRelation.getMaterialNumber();
            if (excelImportDTO.getOldDataMap().containsKey(key)) {
                ((List)excelImportDTO.getOldDataMap().get(key)).add(data);
            } else {
                excelImportDTO.getOldDataMap().put(key, Lists.newArrayList((Object[])new Map[]{data}));
            }
            toElsMaterialNumber.add((CallSite)((Object)(materialRelation.getToElsAccount() + "_" + materialRelation.getMaterialNumber())));
        }
        if (CollectionUtil.isEmpty(toElsMaterialNumber)) {
            this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
            return dataList;
        }
        List materialRelationList = this.purchaseMaterialRelationService.list((Wrapper)new QueryWrapper().in((Object)"to_els_account+'_'+material_number", toElsMaterialNumber));
        Map relationMap = materialRelationList.stream().collect(Collectors.toMap(k -> k.getToElsAccount() + k.getMaterialNumber(), Function.identity(), (v1, v2) -> v2));
        ArrayList<PurchaseMaterialRelation> insertList = new ArrayList<PurchaseMaterialRelation>();
        ArrayList<SaleMaterialRelation> insertSaleList = new ArrayList<SaleMaterialRelation>();
        ArrayList<PurchaseMaterialRelation> updateList = new ArrayList<PurchaseMaterialRelation>();
        ArrayList<SaleMaterialRelation> updateSaleList = new ArrayList<SaleMaterialRelation>();
        for (PurchaseMaterialRelation relation : list) {
            if (relationMap.containsKey(relation.getToElsAccount() + relation.getMaterialNumber())) {
                PurchaseMaterialRelation materialRelation = (PurchaseMaterialRelation)((Object)relationMap.get(relation.getToElsAccount() + relation.getMaterialNumber()));
                relation.setId(materialRelation.getId());
                relation.setRelationId(materialRelation.getRelationId());
                if (!elsAccount.equals(materialRelation.getCreateAccount())) {
                    String msg = I18nUtil.translate((String)"i18n_alert_RdXWWWWWWWWSLAyWWWWWWjtHRdXIOcIWxqKmcIW_d533eb7", (String)("\u4f9b\u5e94\u5546\uff1a" + materialRelation.getToElsAccount() + " , \u7269\u6599\u7f16\u53f7\uff1a" + materialRelation.getMaterialNumber() + " \u7684\u8bb0\u5f55\u4f9b\u5e94\u5546\u5df2\u7ecf\u521b\u5efa\uff0c\u4e0d\u53ef\u518d\u6b21\u521b\u5efa\uff01"), (String[])new String[]{materialRelation.getToElsAccount(), materialRelation.getMaterialNumber()});
                    List objectList = (List)excelImportDTO.getOldDataMap().get(relation.getToElsAccount() + relation.getMaterialNumber());
                    objectList.forEach(d -> {
                        d.put(this.getErrorTitle(), msg);
                        excelImportDTO.getErrorDataList().add(d);
                    });
                    continue;
                }
                updateList.add(relation);
                SaleMaterialRelation saleMaterialRelation = new SaleMaterialRelation();
                BeanUtils.copyProperties((Object)((Object)relation), (Object)((Object)saleMaterialRelation));
                saleMaterialRelation.setId(relation.getRelationId());
                saleMaterialRelation.setRelationId(relation.getId());
                saleMaterialRelation.setElsAccount(relation.getToElsAccount());
                saleMaterialRelation.setToElsAccount(relation.getElsAccount());
                updateSaleList.add(saleMaterialRelation);
                continue;
            }
            insertList.add(relation);
            SaleMaterialRelation saleMaterialRelation = new SaleMaterialRelation();
            BeanUtils.copyProperties((Object)((Object)relation), (Object)((Object)saleMaterialRelation));
            saleMaterialRelation.setId(relation.getRelationId());
            saleMaterialRelation.setRelationId(relation.getId());
            saleMaterialRelation.setElsAccount(relation.getToElsAccount());
            saleMaterialRelation.setToElsAccount(relation.getElsAccount());
            insertSaleList.add(saleMaterialRelation);
        }
        if (!insertList.isEmpty()) {
            this.purchaseMaterialRelationService.saveBatch(insertList);
            this.saleMaterialRelationService.saveBatch(insertSaleList);
        }
        if (!updateList.isEmpty()) {
            this.purchaseMaterialRelationService.updateBatchById(updateList, 2000);
            this.saleMaterialRelationService.updateBatchById(updateSaleList, 2000);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

