/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.excel;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelItemByConfigRpcService;
import com.els.modules.material.entity.PurchaseBomHead;
import com.els.modules.material.entity.PurchaseBomItem;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.service.PurchaseBomHeadService;
import com.els.modules.material.service.PurchaseBomItemService;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.system.dto.ExcelByConfigDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchaseBomItemRpcImportImpl")
public class PurchaseBomItemImportImpl
extends ErrorExcelHandlerService
implements ExcelItemByConfigRpcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PurchaseBomItemImportImpl.class);
    @Autowired
    private PurchaseBomHeadService purchaseBomHeadService;
    @Autowired
    private PurchaseBomItemService purchaseBomItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    private String headId;
    private static final List<String> MATER_STRING = Lists.newArrayList((Object[])new String[]{"materialNumber", "materialName", "materialDesc", "materialSpec", "materialGroup", "materialGroupName", "cateCode", "cateName"});

    public TemplateHeadDTO getTemplate(ExcelByConfigDTO excelByConfigDTO) {
        String templateAccount = excelByConfigDTO.getTemplateAccount();
        String templateVersion = excelByConfigDTO.getTemplateVersion();
        String templateNumber = excelByConfigDTO.getTemplateNumber();
        if (StrUtil.isNotBlank((CharSequence)excelByConfigDTO.getHeadId()) && !"undefined".equals(excelByConfigDTO.getHeadId())) {
            this.headId = excelByConfigDTO.getHeadId();
            PurchaseBomHead dbHead = (PurchaseBomHead)((Object)this.purchaseBomHeadService.getById((Serializable)((Object)excelByConfigDTO.getHeadId())));
            templateAccount = StrUtil.isNotBlank((CharSequence)dbHead.getTemplateAccount()) ? dbHead.getTemplateAccount() : dbHead.getElsAccount();
            templateVersion = String.valueOf(dbHead.getTemplateVersion());
            templateNumber = String.valueOf(dbHead.getTemplateNumber());
        }
        return this.invokeBaseRpcService.getTemplateConfig(templateAccount, templateNumber, templateVersion);
    }

    public List<Object> getExportData(ExcelByConfigDTO excelByConfigDTO) {
        List<PurchaseBomItem> itemList = this.purchaseBomItemService.selectByMainId(excelByConfigDTO.getHeadId());
        return Lists.newArrayList(itemList);
    }

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        List configItemList = this.getTemplate(excelImportDTO.getExcelByConfigDTO()).getTemplateConfigItemList();
        String[] excludeColumn = new String[]{"materialNumber", "bomLevel"};
        List editColumn = configItemList.stream().filter(item -> "1".equals(item.getPurchaseEdit())).map(TemplateConfigItemDTO::getFieldName).collect(Collectors.toList());
        editColumn.addAll(Arrays.asList(excludeColumn));
        ArrayList mastrialNumbers = Lists.newArrayList();
        ArrayList parentMastrialNumbers = Lists.newArrayList();
        for (Map data : dataList) {
            String parentMaterialNumber;
            for (String field : data.keySet()) {
                if (editColumn.contains(field)) continue;
                data.put(field, null);
            }
            String materialNumber = (String)data.get("materialNumber");
            if (CharSequenceUtil.isNotEmpty((CharSequence)materialNumber)) {
                mastrialNumbers.add(materialNumber);
            }
            if (CharSequenceUtil.isNotEmpty((CharSequence)(parentMaterialNumber = (String)data.get("parentMaterialNumber")))) {
                parentMastrialNumbers.add(parentMaterialNumber);
            }
            if (!CharSequenceUtil.isEmpty((CharSequence)parentMaterialNumber)) continue;
            data.put("parentMaterialNumber", "");
            data.put("parentMaterialDesc", "");
            data.put("bomLevel", "1");
        }
        List<PurchaseMaterialHead> masterialList = this.purchaseMaterialHeadService.getMaterialHeadByNumbers(mastrialNumbers);
        Map materialHeadMap = masterialList.stream().collect(Collectors.toMap(PurchaseMaterialHead::getMaterialNumber, Function.identity(), (v1, v2) -> v2));
        List<PurchaseMaterialHead> parentMasterialList = this.purchaseMaterialHeadService.getMaterialHeadByNumbers(parentMastrialNumbers);
        Map parentMaterialHeadMap = parentMasterialList.stream().collect(Collectors.toMap(PurchaseMaterialHead::getMaterialNumber, Function.identity(), (v1, v2) -> v2));
        Field[] fields = ConvertUtils.getAllFields(PurchaseMaterialHead.class);
        Iterator iterator = dataList.iterator();
        while (iterator.hasNext()) {
            String materialNumber;
            Map data = (Map)iterator.next();
            String parentMaterialNumber = (String)data.get("parentMaterialNumber");
            if (CharSequenceUtil.isNotEmpty((CharSequence)parentMaterialNumber)) {
                PurchaseMaterialHead parentHead = (PurchaseMaterialHead)((Object)parentMaterialHeadMap.get(parentMaterialNumber));
                if (null == parentHead) {
                    String msg = I18nUtil.translate((String)"i18n_alert_BdSLAoxMK_59ea515f", (String)"\u7236\u9879\u7269\u6599\u7f16\u7801\u4e0d\u5b58\u5728");
                    this.errorAdd(excelImportDTO, msg, data);
                    iterator.remove();
                    continue;
                }
                data.put("parentMaterialDesc", parentHead.getMaterialDesc());
            }
            if (!CharSequenceUtil.isNotEmpty((CharSequence)(materialNumber = (String)data.get("materialNumber")))) continue;
            PurchaseMaterialHead head = (PurchaseMaterialHead)((Object)materialHeadMap.get(materialNumber));
            if (null == head) {
                String msg = I18nUtil.translate((String)"i18n_alert_SLAoxMK_cdf9d7c2", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u5b58\u5728");
                this.errorAdd(excelImportDTO, msg, data);
                iterator.remove();
                continue;
            }
            data.put("materialId", head.getId());
            data.put("materialDesc", head.getMaterialDesc());
            for (Field field : fields) {
                if (!data.containsKey(field.getName()) || !MATER_STRING.contains(field.getName())) continue;
                try {
                    field.setAccessible(true);
                    data.put(field.getName(), field.get((Object)head));
                }
                catch (IllegalAccessException e) {
                    log.error("\u53cd\u5c04\u83b7\u53d6\u503c\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

