/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.entity.PurchaseBomHead;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.enumerate.PurchaseBomStatus;
import com.els.modules.material.mapper.PurchaseBomHeadMapper;
import com.els.modules.material.service.PurchaseBomHeadService;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@RpcService(value="purchaseBomImportRpcServiceImpl")
public class PurchaseBomExcelHandler
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseBomHeadService purchaseBomHeadService;
    @Resource
    private PurchaseBomHeadMapper purchaseBomHeadMapper;
    @Autowired
    private PurchaseMaterialHeadService purchaseMaterialHeadService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("bom");
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"i18n_alert_VWERWWWBtESIrW_b04008e2", (String)"\u8bf7\u5148\u914d\u7f6eBOM\u8868\u5355\u4e1a\u52a1\u6a21\u677f\u3002"));
        ArrayList<PurchaseBomHead> entityList = new ArrayList<PurchaseBomHead>();
        ArrayList<String> code = new ArrayList<String>();
        for (Map data : dataList) {
            String materialNumber = (String)data.get("materialNumber");
            if (!CharSequenceUtil.isNotEmpty((CharSequence)materialNumber) || code.contains(materialNumber)) continue;
            code.add(materialNumber);
        }
        Map<Object, Object> collectMaterialMap = new HashMap();
        if (CollUtil.isNotEmpty(code)) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{PurchaseMaterialHead::getMaterialNumber, PurchaseMaterialHead::getMaterialName, PurchaseMaterialHead::getMaterialDesc, PurchaseMaterialHead::getMaterialGroup, ParentEntity::getId, PurchaseMaterialHead::getBaseUnit});
            wrapper.in(PurchaseMaterialHead::getMaterialNumber, code);
            List headList = this.purchaseMaterialHeadService.list((Wrapper)wrapper);
            collectMaterialMap = headList.stream().collect(Collectors.toMap(PurchaseMaterialHead::getMaterialNumber, Function.identity(), (v1, v2) -> v1));
        }
        List headList = this.purchaseBomHeadMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant()));
        Map<String, String> headMap = headList.parallelStream().collect(Collectors.toMap(p -> p.getMaterialNumber() + "_" + p.getFactory() + "_" + p.getVersion(), ParentEntity::getId, (k1, k2) -> k1));
        for (Map data : dataList) {
            PurchaseBomHead entity = (PurchaseBomHead)((Object)this.transferEntity(data, PurchaseBomHead.class, excelImportDTO));
            if (null == entity) continue;
            String key = entity.getMaterialNumber() + "_" + entity.getFactory() + "_" + entity.getVersion();
            if (headMap.containsKey(key)) {
                String msg = I18nUtil.translate((String)"i18n_alert_HesIMKWF_ebad7f7", (String)"\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u6570\u636e") + key;
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            if (collectMaterialMap.containsKey(entity.getMaterialNumber())) {
                PurchaseMaterialHead head = (PurchaseMaterialHead)((Object)collectMaterialMap.get(entity.getMaterialNumber()));
                entity.setMaterialId(head.getId());
                entity.setMaterialDesc(head.getMaterialDesc());
            }
            entity.setElsAccount(TenantContext.getTenant());
            entity.setBomStatus(PurchaseBomStatus.NEW.getValue());
            entity.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            entity.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            entity.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion());
            entity.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
            entityList.add(entity);
        }
        if (CollUtil.isEmpty(entityList)) {
            this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
            return dataList;
        }
        int size = entityList.size();
        List nextCodes = this.invokeBaseRpcService.getNextCodes("bomNumber", entityList.get(0), size);
        int codeIndex = 0;
        for (PurchaseBomHead e : entityList) {
            e.setBomNumber((String)nextCodes.get(codeIndex++));
        }
        if (!entityList.isEmpty()) {
            this.purchaseBomHeadService.saveBatch(entityList);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

