/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.api.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.excel.ExcelExportClassColumnDTO;
import com.els.common.util.ClassTypeBuilder;
import com.els.common.util.ConvertUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.OpenApiRpcService;
import com.els.modules.material.api.enumerate.MaterialSourceStatusEnum;
import com.els.modules.material.entity.PurchaseMaterialSource;
import com.els.modules.material.service.PurchaseMaterialSourceService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseMaterialSourceCreateOpenServiceImpl
implements OpenApiRpcService {
    @Autowired
    private PurchaseMaterialSourceService purchaseMaterialSourceService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    public JSONObject doCreateInvoke(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap) {
        String account = TenantContext.getTenant();
        Date currentTime = new Date();
        ArrayList<PurchaseMaterialSource> headList = new ArrayList<PurchaseMaterialSource>();
        for (Object obj : array) {
            JSONObject object = (JSONObject)Convert.convert(JSONObject.class, obj);
            if (object.size() == 0) continue;
            PurchaseMaterialSource head = (PurchaseMaterialSource)((Object)ConvertUtils.convertDefault(PurchaseMaterialSource.class, (JSONObject)object, defaultHeadMap));
            head.setElsAccount(account);
            head.setBusAccount(account);
            head.setCreateTime(currentTime);
            head.setDeleted(CommonConstant.DEL_FLAG_0);
            head.setTemplateName(templateHead.getTemplateName());
            head.setTemplateNumber(templateHead.getTemplateNumber());
            head.setTemplateVersion(templateHead.getTemplateVersion().toString());
            if (CharSequenceUtil.isEmpty((CharSequence)head.getStatus())) {
                head.setStatus(MaterialSourceStatusEnum.NEW.getValue());
            }
            if (CharSequenceUtil.isEmpty((CharSequence)head.getNeedAudit())) {
                head.setNeedAudit("0");
            }
            if (CharSequenceUtil.isEmpty((CharSequence)head.getAuditStatus())) {
                if ("1".equals(head.getNeedAudit())) {
                    head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
                } else {
                    head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
                }
            }
            headList.add(head);
        }
        if (!headList.isEmpty()) {
            PurchaseMaterialSource entity = (PurchaseMaterialSource)((Object)headList.get(0));
            int size = (int)headList.stream().filter(x -> CharSequenceUtil.isEmpty((CharSequence)x.getSourceId())).count();
            List nextCodes = this.invokeBaseRpcService.getNextCodes("materialSourceNumber", (Object)entity, size);
            int codeIndex = 0;
            for (PurchaseMaterialSource e : headList) {
                if (!CharSequenceUtil.isEmpty((CharSequence)e.getSourceId())) continue;
                e.setSourceId((String)nextCodes.get(codeIndex++));
            }
            this.purchaseMaterialSourceService.saveBatch(headList, 2000);
        }
        JSONObject resultObj = new JSONObject();
        resultObj.put("headList", headList);
        return resultObj;
    }

    public void doParamCheck(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap, List<TemplateConfigHeadDTO> configHeadList, List<TemplateConfigItemDTO> configItemList) {
    }

    public String getBusinessType() {
        return "materialSource";
    }

    public List<ExcelExportClassColumnDTO> getBusinessClass() {
        return ClassTypeBuilder.buildClassTypeList(PurchaseMaterialSource.class, null, null);
    }

    public List<String> supportItemList() {
        return Lists.newArrayList((Object[])new String[]{"itemList"});
    }
}

