/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.api.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.SimpleOpenApiRpcService;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialItem;
import com.els.modules.material.entity.PurchaseMaterialUnit;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialItemService;
import com.els.modules.material.service.PurchaseMaterialUnitService;
import com.els.modules.material.vo.PurchaseMaterialHeadVO;
import com.els.modules.utils.InterfaceDatasUtils;
import com.els.rpc.service.InvokeBaseRpcService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class GetMaterialDatasFromErpServiceImpl
implements SimpleOpenApiRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetMaterialDatasFromErpServiceImpl.class);
    @Autowired
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Autowired
    private PurchaseMaterialItemService purchaseMaterialItemService;
    @Autowired
    private PurchaseMaterialUnitService purchaseMaterialUnitService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @SrmTransaction
    public JSONObject invoke(JSONObject param) {
        log.info("getMaterialDatasFromErpServiceImpl_start");
        JSONObject data = (JSONObject)Convert.convert(JSONObject.class, (Object)param);
        Assert.isTrue((data != null ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!");
        JSONArray materialListArray = data.getJSONArray("materialList");
        List<PurchaseMaterialHead> existDatas = InterfaceDatasUtils.checkData(materialListArray);
        List purchaseMaterialHeadVOS = JSON.parseArray((String)materialListArray.toJSONString(), PurchaseMaterialHeadVO.class);
        this.dealDatas(existDatas, purchaseMaterialHeadVOS);
        log.info("getMaterialDatasFromErpServiceImpl_end");
        return JSONObject.parseObject((String)JSONObject.toJSONString((Object)Result.ok()));
    }

    private void dealDatas(List<PurchaseMaterialHead> existDatas, List<PurchaseMaterialHeadVO> purchaseMaterialHeadVOS) {
        TemplateHeadDTO template = this.getTemplate();
        Map<String, PurchaseMaterialHead> existDatasMap = existDatas.stream().collect(Collectors.toMap(PurchaseMaterialHead::getMaterialNumber, Function.identity()));
        ArrayList<PurchaseMaterialHead> insertMaterialHeadDatas = new ArrayList<PurchaseMaterialHead>();
        ArrayList<PurchaseMaterialHead> updateMaterialHeadDatas = new ArrayList<PurchaseMaterialHead>();
        ArrayList<PurchaseMaterialItem> purchaseMaterialItemList = new ArrayList<PurchaseMaterialItem>();
        ArrayList<PurchaseMaterialUnit> purchaseMaterialUnitList = new ArrayList<PurchaseMaterialUnit>();
        ArrayList<String> ids = new ArrayList<String>();
        for (PurchaseMaterialHeadVO materialHeadVo : purchaseMaterialHeadVOS) {
            PurchaseMaterialHead materialHead = this.setMaterialHeadDefaultValue(template, materialHeadVo, existDatasMap);
            PurchaseMaterialHead purchaseMaterialHead = existDatasMap.get(materialHeadVo.getMaterialNumber());
            if (purchaseMaterialHead != null) {
                ids.add(purchaseMaterialHead.getId());
                materialHead.setId(purchaseMaterialHead.getId());
                updateMaterialHeadDatas.add(materialHead);
            } else {
                materialHead.setId(IdWorker.getIdStr());
                insertMaterialHeadDatas.add(materialHead);
            }
            if (CollectionUtil.isNotEmpty(materialHeadVo.getPurchaseMaterialItemList())) {
                List<PurchaseMaterialItem> itemList = this.dealItems(materialHead, materialHeadVo.getPurchaseMaterialItemList());
                purchaseMaterialItemList.addAll(itemList);
            }
            List<PurchaseMaterialUnit> unitList = this.dealUnits(materialHead);
            purchaseMaterialUnitList.addAll(unitList);
        }
        if (CollectionUtil.isNotEmpty(insertMaterialHeadDatas)) {
            this.purchaseMaterialHeadService.saveBatch(insertMaterialHeadDatas);
        }
        if (CollectionUtil.isNotEmpty(updateMaterialHeadDatas)) {
            this.purchaseMaterialHeadService.updateBatchById(updateMaterialHeadDatas);
        }
        if (CollectionUtil.isNotEmpty(ids)) {
            this.purchaseMaterialItemService.deleteBatchByMainIds(ids);
            this.purchaseMaterialUnitService.deleteByMainIdList(ids);
        }
        if (CollectionUtil.isNotEmpty(purchaseMaterialItemList)) {
            this.purchaseMaterialItemService.saveBatch(purchaseMaterialItemList);
        }
        if (CollectionUtil.isNotEmpty(purchaseMaterialUnitList)) {
            this.purchaseMaterialUnitService.saveBatch(purchaseMaterialUnitList);
        }
    }

    private PurchaseMaterialHead setMaterialHeadDefaultValue(TemplateHeadDTO template, PurchaseMaterialHeadVO purchaseMaterialHeadVO, Map<String, PurchaseMaterialHead> existDatasMap) {
        PurchaseMaterialHead purchaseMaterialHead = new PurchaseMaterialHead();
        BeanUtils.copyProperties((Object)((Object)purchaseMaterialHeadVO), (Object)((Object)purchaseMaterialHead));
        purchaseMaterialHead.setTemplateAccount(template.getElsAccount());
        purchaseMaterialHead.setTemplateName(template.getTemplateName());
        purchaseMaterialHead.setTemplateNumber(template.getTemplateNumber());
        purchaseMaterialHead.setTemplateVersion(template.getTemplateVersion());
        purchaseMaterialHead.setDeleted(CommonConstant.DEL_FLAG_0);
        purchaseMaterialHead.setElsAccount(TenantContext.getTenant());
        purchaseMaterialHead.setMaterialName(purchaseMaterialHead.getMaterialDesc());
        purchaseMaterialHead.setSourceSystem("1");
        purchaseMaterialHead.setNeedAudit("0");
        purchaseMaterialHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        purchaseMaterialHead.setSubmitStatus("0");
        purchaseMaterialHead.setBlocDel((String)ObjectUtil.defaultIfBlank((CharSequence)purchaseMaterialHead.getBlocDel(), (CharSequence)"0"));
        purchaseMaterialHead.setFreeze((String)ObjectUtil.defaultIfBlank((CharSequence)purchaseMaterialHead.getFreeze(), (CharSequence)"0"));
        purchaseMaterialHead.setCheckQuality((String)ObjectUtil.defaultIfBlank((CharSequence)purchaseMaterialHead.getCheckQuality(), (CharSequence)"0"));
        purchaseMaterialHead.setLocked((String)ObjectUtil.defaultIfBlank((CharSequence)purchaseMaterialHead.getLocked(), (CharSequence)"0"));
        purchaseMaterialHead.setBatch((String)ObjectUtil.defaultIfBlank((CharSequence)purchaseMaterialHead.getBatch(), (CharSequence)"0"));
        purchaseMaterialHead.setCatalog((String)ObjectUtil.defaultIfBlank((CharSequence)purchaseMaterialHead.getCatalog(), (CharSequence)"0"));
        purchaseMaterialHead.setAsset((String)ObjectUtil.defaultIfBlank((CharSequence)purchaseMaterialHead.getAsset(), (CharSequence)"0"));
        List<String> strings = Arrays.asList("z002", "z003", "z004");
        if (StringUtils.isNotBlank((CharSequence)purchaseMaterialHead.getCateCode()) && strings.contains(purchaseMaterialHead.getCateCode())) {
            purchaseMaterialHead.setSource("1");
            purchaseMaterialHead.setQuotaStrategy("1");
            purchaseMaterialHead.setQuotaWay("1");
        } else {
            purchaseMaterialHead.setSource("0");
            purchaseMaterialHead.setQuotaStrategy("0");
            purchaseMaterialHead.setQuotaWay("0");
        }
        purchaseMaterialHead.setDeliveryArrange(StringUtils.isNotBlank((CharSequence)purchaseMaterialHead.getCateCode()) && purchaseMaterialHead.getCateCode().equals("Z004") ? "1" : "4");
        purchaseMaterialHead.setSource((String)ObjectUtil.defaultIfBlank((CharSequence)purchaseMaterialHead.getSource(), (CharSequence)"0"));
        purchaseMaterialHead.setFactoryDel((String)ObjectUtil.defaultIfBlank((CharSequence)purchaseMaterialHead.getFactoryDel(), (CharSequence)"0"));
        purchaseMaterialHead.setJit((String)ObjectUtil.defaultIfBlank((CharSequence)purchaseMaterialHead.getJit(), (CharSequence)"0"));
        purchaseMaterialHead.setIfLeadTime((String)ObjectUtil.defaultIfBlank((CharSequence)purchaseMaterialHead.getIfLeadTime(), (CharSequence)"0"));
        purchaseMaterialHead.setPurchaseUnit((String)ObjectUtil.defaultIfBlank((CharSequence)purchaseMaterialHead.getBaseUnit(), (CharSequence)""));
        return purchaseMaterialHead;
    }

    List<PurchaseMaterialItem> dealItems(PurchaseMaterialHead materialHead, List<PurchaseMaterialItem> purchaseMaterialItems) {
        for (PurchaseMaterialItem materialItem : purchaseMaterialItems) {
            materialItem.setMaterialNumber(materialHead.getMaterialNumber());
            materialItem.setHeadId(materialHead.getId());
            materialItem.setElsAccount(TenantContext.getTenant());
            materialItem.setDeleted(CommonConstant.DEL_FLAG_0);
            materialItem.setFactoryDel((String)ObjectUtil.defaultIfBlank((CharSequence)materialItem.getFactoryDel(), (CharSequence)"0"));
            materialItem.setBatch((String)ObjectUtil.defaultIfBlank((CharSequence)materialItem.getBatch(), (CharSequence)"0"));
        }
        return purchaseMaterialItems;
    }

    List<PurchaseMaterialUnit> dealUnits(PurchaseMaterialHead materialHead) {
        ArrayList<PurchaseMaterialUnit> purchaseMaterialUnitList = new ArrayList<PurchaseMaterialUnit>();
        PurchaseMaterialUnit unit1 = new PurchaseMaterialUnit();
        PurchaseMaterialUnit unit2 = new PurchaseMaterialUnit();
        unit1.setHeadId(materialHead.getId());
        unit1.setElsAccount(TenantContext.getTenant());
        unit1.setDeleted(CommonConstant.DEL_FLAG_0);
        unit1.setChangeUnit("=");
        unit1.setIsDefault("1");
        unit1.setBasicUnit(materialHead.getBaseUnit());
        unit1.setObjectUnit(materialHead.getBaseUnit());
        unit1.setObjectAmount(BigDecimal.ONE);
        unit1.setBasicAmount(BigDecimal.ONE);
        BeanUtils.copyProperties((Object)((Object)unit1), (Object)((Object)unit2));
        unit1.setType("0");
        unit2.setType("1");
        purchaseMaterialUnitList.add(unit1);
        purchaseMaterialUnitList.add(unit2);
        return purchaseMaterialUnitList;
    }

    private TemplateHeadDTO getTemplate() {
        List templateList = this.invokeBaseRpcService.getTemplateByType("material");
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"", (String)"\u8bf7\u5148\u914d\u7f6e\u7269\u6599\u4e3b\u6570\u636e\u4e1a\u52a1\u6a21\u677f!"));
        Map<String, List<TemplateHeadDTO>> templateMap = templateList.stream().filter(a -> a.getElsAccount() != null).collect(Collectors.groupingBy(o -> o.getElsAccount()));
        TemplateHeadDTO template = CollectionUtil.isNotEmpty((Collection)templateMap.get(TenantContext.getTenant())) ? templateMap.get(TenantContext.getTenant()).get(0) : templateMap.get("100000").get(0);
        return template;
    }
}

