/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseOpenServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.ListColumnQueryBuilder;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.extend.api.sap.dto.ExCtrlDTO;
import com.els.modules.extend.api.sap.dto.ExDataResultDTO;
import com.els.modules.extend.api.sap.enumerate.SapInterfaceEnum;
import com.els.modules.extend.api.sap.service.SapInterfaceService;
import com.els.modules.material.api.enumerate.MaterialSourceStatusEnum;
import com.els.modules.material.entity.PurchaseMaterialSource;
import com.els.modules.material.mapper.PurchaseMaterialSourceMapper;
import com.els.modules.material.service.PurchaseMaterialSourceService;
import com.els.modules.materialSourceApply.entity.PurchaseMaterialSourceApply;
import com.els.modules.materialSourceApply.enumerate.MaterialSourceOperationEnum;
import com.els.modules.materialSourceApply.service.PurchaseMaterialSourceApplyService;
import com.els.modules.price.enumerate.MaterialCreateSourceTypeEnum;
import com.els.modules.workflow.api.service.WorkflowAuditRpcService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseMaterialSourceServiceImpl
extends BaseOpenServiceImpl<PurchaseMaterialSourceMapper, PurchaseMaterialSource, PurchaseMaterialSource>
implements PurchaseMaterialSourceService {
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private PurchaseMaterialSourceMapper purchaseMaterialSourceMapper;
    @Autowired
    private InterfaceUtil interfaceUtil;
    @Autowired
    private PurchaseMaterialSourceApplyService applyService;
    @Autowired
    @Lazy
    private WorkflowAuditRpcService workflowAuditRpcService;
    @Autowired
    @Lazy
    private SapInterfaceService sapInterfaceService;

    @Override
    public void savePurchaseMaterialSource(PurchaseMaterialSource purchaseMaterialSource) {
        if (StringUtils.isBlank((CharSequence)purchaseMaterialSource.getSourceId())) {
            purchaseMaterialSource.setSourceId(this.invokeBaseRpcService.getNextCode("materialSourceNumber", (Object)purchaseMaterialSource));
        }
        if (null != purchaseMaterialSource.getExpiryDate() && null != purchaseMaterialSource.getEffectiveDate() && purchaseMaterialSource.getEffectiveDate().after(purchaseMaterialSource.getExpiryDate())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jXvKKIxOMUjXyWKI_d6139835", (String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5931\u6548\u65e5\u671f"));
        }
        purchaseMaterialSource.setSourceType(MaterialCreateSourceTypeEnum.SRM.getValue());
        if (CharSequenceUtil.isEmpty((CharSequence)purchaseMaterialSource.getNeedAudit())) {
            purchaseMaterialSource.setNeedAudit("1");
        }
        purchaseMaterialSource.setStatus(MaterialSourceStatusEnum.NEW.getValue());
        if ("1".equals(purchaseMaterialSource.getNeedAudit())) {
            purchaseMaterialSource.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseMaterialSource.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        if (null != purchaseMaterialSource.getEffectiveDate() && null != purchaseMaterialSource.getExpiryDate()) {
            this.check(purchaseMaterialSource);
        }
        ((PurchaseMaterialSourceMapper)this.baseMapper).insert((Object)purchaseMaterialSource);
    }

    private void check(PurchaseMaterialSource materialSource) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{PurchaseMaterialSource::getSourceId, PurchaseMaterialSource::getEffectiveDate, PurchaseMaterialSource::getExpiryDate});
        ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getMaterialNumber, (Object)materialSource.getMaterialNumber());
        ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getFactory, (Object)materialSource.getFactory());
        ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getCompany, (Object)materialSource.getCompany());
        ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getPurchaseOrg, (Object)materialSource.getPurchaseOrg());
        ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getToElsAccount, (Object)materialSource.getToElsAccount());
        wrapper.and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.or(a -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)a.le(PurchaseMaterialSource::getEffectiveDate, (Object)materialSource.getEffectiveDate())).ge(PurchaseMaterialSource::getExpiryDate, (Object)materialSource.getExpiryDate());
            })).or(b -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)b.ge(PurchaseMaterialSource::getEffectiveDate, (Object)materialSource.getEffectiveDate())).le(PurchaseMaterialSource::getExpiryDate, (Object)materialSource.getExpiryDate());
            })).or(b -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)b.le(PurchaseMaterialSource::getEffectiveDate, (Object)materialSource.getEffectiveDate())).le(PurchaseMaterialSource::getExpiryDate, (Object)materialSource.getExpiryDate())).ge(PurchaseMaterialSource::getExpiryDate, (Object)materialSource.getEffectiveDate());
            })).or(b -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)b.ge(PurchaseMaterialSource::getEffectiveDate, (Object)materialSource.getEffectiveDate())).ge(PurchaseMaterialSource::getExpiryDate, (Object)materialSource.getExpiryDate())).le(PurchaseMaterialSource::getEffectiveDate, (Object)materialSource.getExpiryDate());
            });
        });
        wrapper.ne(ObjectUtil.isNotNull((Object)materialSource.getId()), BaseEntity::getId, (Object)materialSource.getId());
        wrapper.in(PurchaseMaterialSource::getStatus, (Collection)Lists.newArrayList((Object[])new String[]{MaterialSourceStatusEnum.NORMAL.getValue(), MaterialSourceStatusEnum.FROZEN.getValue(), MaterialSourceStatusEnum.EFFECTIVE.getValue()}));
        List list = this.list((Wrapper)wrapper);
        if (!list.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5b58\u5728\u6709\u6548\u65f6\u95f4\u6bb5\u91cd\u53e0\u7684\u8d27\u6e90\u6e05\u5355:") + list.stream().map(PurchaseMaterialSource::getSourceId).collect(Collectors.joining(",")));
        }
    }

    @Override
    public void updatePurchaseMaterialSource(PurchaseMaterialSource purchaseMaterialSource) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialSource.getMaterialSourceType()), (String)I18nUtil.translate((String)"i18n_alert_SjAclS_2dcdb97f", (String)"\u8d27\u6e90\u7c7b\u578b\u5fc5\u586b"));
        if ("1".equals(purchaseMaterialSource.getMaterialSourceType())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialSource.getMaterialNumber()), (String)I18nUtil.translate((String)"i18n_alert_SjAcLSLKWVSMSLAy_89390dcf", (String)"\u8d27\u6e90\u7c7b\u578b\u4e3a\u7269\u6599\u65f6\uff0c\u8bf7\u586b\u5199\u7269\u6599\u7f16\u53f7"));
        } else if ("2".equals(purchaseMaterialSource.getMaterialSourceType())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialSource.getMaterialGroup()), (String)I18nUtil.translate((String)"i18n_alert_SjAcLSLVKWVSMSLVlS_857af31e", (String)"\u8d27\u6e90\u7c7b\u578b\u4e3a\u7269\u6599\u7ec4\u65f6\uff0c\u8bf7\u586b\u5199\u7269\u6599\u7ec4\u5fc5\u586b"));
        }
        if ("1".equals(purchaseMaterialSource.getExclusionMark())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialSource.getMaterialNumber()), (String)I18nUtil.translate((String)"i18n_alert_VSMTPAGjSLAy_bf5095dd", (String)"\u8bf7\u586b\u5199\u9700\u8981\u6392\u9664\u7684\u7269\u6599\u7f16\u53f7"));
        }
        if (null != purchaseMaterialSource.getExpiryDate() && null != purchaseMaterialSource.getEffectiveDate() && purchaseMaterialSource.getEffectiveDate().after(purchaseMaterialSource.getExpiryDate())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jXvKKIxOMUjXyWKI_d6139835", (String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5931\u6548\u65e5\u671f"));
        }
        if (CharSequenceUtil.isEmpty((CharSequence)purchaseMaterialSource.getNeedAudit())) {
            purchaseMaterialSource.setNeedAudit("1");
        }
        purchaseMaterialSource.setStatus(MaterialSourceStatusEnum.NEW.getValue());
        if ("1".equals(purchaseMaterialSource.getNeedAudit())) {
            purchaseMaterialSource.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseMaterialSource.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.check(purchaseMaterialSource);
        int count = ((PurchaseMaterialSourceMapper)this.baseMapper).updateById((Object)purchaseMaterialSource);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void publishPurchaseMaterialSource(PurchaseMaterialSource purchaseMaterialSource) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialSource.getMaterialSourceType()), (String)I18nUtil.translate((String)"i18n_alert_SjAclS_2dcdb97f", (String)"\u8d27\u6e90\u7c7b\u578b\u5fc5\u586b"));
        if ("1".equals(purchaseMaterialSource.getMaterialSourceType())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialSource.getMaterialNumber()), (String)I18nUtil.translate((String)"i18n_alert_SjAcLSLKWVSMSLAy_89390dcf", (String)"\u8d27\u6e90\u7c7b\u578b\u4e3a\u7269\u6599\u65f6\uff0c\u8bf7\u586b\u5199\u7269\u6599\u7f16\u53f7"));
        } else if ("2".equals(purchaseMaterialSource.getMaterialSourceType())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialSource.getMaterialGroup()), (String)I18nUtil.translate((String)"i18n_alert_SjAcLSLVKWVSMSLVlS_857af31e", (String)"\u8d27\u6e90\u7c7b\u578b\u4e3a\u7269\u6599\u7ec4\u65f6\uff0c\u8bf7\u586b\u5199\u7269\u6599\u7ec4\u5fc5\u586b"));
        }
        if ("1".equals(purchaseMaterialSource.getExclusionMark())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialSource.getMaterialNumber()), (String)I18nUtil.translate((String)"i18n_alert_VSMTPAGjSLAy_bf5095dd", (String)"\u8bf7\u586b\u5199\u9700\u8981\u6392\u9664\u7684\u7269\u6599\u7f16\u53f7"));
        }
        if (null != purchaseMaterialSource.getExpiryDate() && null != purchaseMaterialSource.getEffectiveDate() && purchaseMaterialSource.getEffectiveDate().after(purchaseMaterialSource.getExpiryDate())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jXvKKIxOMUjXyWKI_d6139835", (String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5931\u6548\u65e5\u671f"));
        }
        if ("1".equals(purchaseMaterialSource.getNeedAudit())) {
            if (CharSequenceUtil.isEmpty((CharSequence)purchaseMaterialSource.getFlowId()) || !AuditStatusEnum.AUDIT_FINISH.getValue().equals(purchaseMaterialSource.getAuditStatus())) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5ba1\u6279\u901a\u8fc7\u4e4b\u540e\u624d\u80fd\u53d1\u5e03"));
            }
        } else {
            purchaseMaterialSource.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.checkStatus(purchaseMaterialSource);
        this.check(purchaseMaterialSource);
        int count = ((PurchaseMaterialSourceMapper)this.baseMapper).updateById((Object)purchaseMaterialSource);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void publishPurchaseMaterialSourceById(String id) {
        PurchaseMaterialSource purchaseMaterialSource = (PurchaseMaterialSource)((Object)this.getById((Serializable)((Object)id)));
        if ("1".equals(purchaseMaterialSource.getNeedAudit())) {
            if (CharSequenceUtil.isEmpty((CharSequence)purchaseMaterialSource.getFlowId()) || !AuditStatusEnum.AUDIT_FINISH.getValue().equals(purchaseMaterialSource.getAuditStatus())) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5ba1\u6279\u901a\u8fc7\u4e4b\u540e\u624d\u80fd\u53d1\u5e03"));
            }
        } else {
            purchaseMaterialSource.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.checkStatus(purchaseMaterialSource);
        this.check(purchaseMaterialSource);
        int count = ((PurchaseMaterialSourceMapper)this.baseMapper).updateById((Object)purchaseMaterialSource);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void checkStatus(PurchaseMaterialSource purchaseMaterialSource) {
        purchaseMaterialSource.setStatus(MaterialSourceStatusEnum.NORMAL.getValue());
        DateTime date = DateUtil.date();
        if (null != purchaseMaterialSource.getEffectiveDate() && purchaseMaterialSource.getEffectiveDate().before((Date)date)) {
            purchaseMaterialSource.setStatus(MaterialSourceStatusEnum.EFFECTIVE.getValue());
        }
        if (null != purchaseMaterialSource.getExpiryDate() && purchaseMaterialSource.getExpiryDate().before((Date)date)) {
            purchaseMaterialSource.setStatus(MaterialSourceStatusEnum.INVALID.getValue());
        }
    }

    @Override
    public void changeSourceStatusForJob() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        DateTime date = DateUtil.date();
        param.put("nowDate", date);
        List<PurchaseMaterialSource> records = ((PurchaseMaterialSourceMapper)this.baseMapper).selectWithoutElsAccountToChangeStatus(param);
        ArrayList<PurchaseMaterialSource> updateRecords = new ArrayList<PurchaseMaterialSource>(records.size() / 2);
        for (PurchaseMaterialSource item : records) {
            if (null != item.getEffectiveDate() && item.getEffectiveDate().before((Date)date)) {
                item.setStatus(MaterialSourceStatusEnum.EFFECTIVE.getValue());
            }
            if (null != item.getExpiryDate() && item.getExpiryDate().before((Date)date)) {
                item.setStatus(MaterialSourceStatusEnum.INVALID.getValue());
            }
            updateRecords.add(item);
        }
        this.updateBatchById(updateRecords);
    }

    @Override
    public void frozenPurchaseMaterialSource(String id) {
        PurchaseMaterialSource purchaseMaterialSource = (PurchaseMaterialSource)((Object)this.purchaseMaterialSourceMapper.selectById((Serializable)((Object)id)));
        purchaseMaterialSource.setStatus(MaterialSourceStatusEnum.FROZEN.getValue());
        int count = this.purchaseMaterialSourceMapper.updateById((Object)purchaseMaterialSource);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void thawPurchaseMaterialSource(String id) {
        PurchaseMaterialSource purchaseMaterialSource = (PurchaseMaterialSource)((Object)this.purchaseMaterialSourceMapper.selectById((Serializable)((Object)id)));
        this.checkStatus(purchaseMaterialSource);
        int count = this.purchaseMaterialSourceMapper.updateById((Object)purchaseMaterialSource);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void cancelPurchaseMaterialSource(String id) {
        PurchaseMaterialSource purchaseMaterialSource = (PurchaseMaterialSource)((Object)this.purchaseMaterialSourceMapper.selectById((Serializable)((Object)id)));
        purchaseMaterialSource.setStatus(MaterialSourceStatusEnum.CANCEL.getValue());
        purchaseMaterialSource.setExpiryDate(Calendar.getInstance().getTime());
        int count = this.purchaseMaterialSourceMapper.updateById((Object)purchaseMaterialSource);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void delPurchaseMaterialSource(String id) {
        ((PurchaseMaterialSourceMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseMaterialSource(List<String> idList) {
        ((PurchaseMaterialSourceMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void addBatch(List<PurchaseMaterialSource> sourceList) {
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("materialSource");
        for (PurchaseMaterialSource source : sourceList) {
            source.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            source.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            source.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion().toString());
            source.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
        }
        this.saveBatch(sourceList);
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getMaterialSource", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List materialSourceList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchaseMaterialSource source : materialSourceList) {
            this.pushDataToErp(source);
        }
    }

    @Override
    @SrmTransaction
    public void frozen(String id, String reason) {
        LoginUser loginUser = SysUtil.getLoginUser();
        List<PurchaseMaterialSource> materialSources = this.judgeData(Arrays.asList(id), reason, MaterialSourceOperationEnum.FROZEN.getValue());
        this.dealApply(materialSources, reason, MaterialSourceOperationEnum.FROZEN.getValue(), loginUser);
    }

    @Override
    @SrmTransaction
    public void thaw(String id, String reason) {
        LoginUser loginUser = SysUtil.getLoginUser();
        List<PurchaseMaterialSource> materialSources = this.judgeData(Arrays.asList(id), reason, MaterialSourceOperationEnum.THAW.getValue());
        this.dealApply(materialSources, reason, MaterialSourceOperationEnum.THAW.getValue(), loginUser);
    }

    @Override
    @SrmTransaction
    public void batchFrozen(String ids, String reason) {
        LoginUser loginUser = SysUtil.getLoginUser();
        List<String> idList = Arrays.asList(ids.split(","));
        List<PurchaseMaterialSource> materialSources = this.judgeData(idList, reason, MaterialSourceOperationEnum.FROZEN.getValue());
        this.dealApply(materialSources, reason, MaterialSourceOperationEnum.FROZEN.getValue(), loginUser);
    }

    @Override
    @SrmTransaction
    public void batchThaw(String ids, String reason) {
        LoginUser loginUser = SysUtil.getLoginUser();
        List<String> idList = Arrays.asList(ids.split(","));
        List<PurchaseMaterialSource> materialSources = this.judgeData(idList, reason, MaterialSourceOperationEnum.THAW.getValue());
        this.dealApply(materialSources, reason, MaterialSourceOperationEnum.THAW.getValue(), loginUser);
    }

    @Override
    public void pushMatrialSourceToSap(List<PurchaseMaterialSource> materialSources, String isFrozen) {
        ExCtrlDTO exCtrlDTO = new ExCtrlDTO();
        exCtrlDTO.setZextr_seq("SEQ000001");
        exCtrlDTO.setZsyst_logi("SRM600");
        exCtrlDTO.setZintr_oo("SRM003");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        JSONArray data = new JSONArray();
        for (PurchaseMaterialSource materialSource : materialSources) {
            JSONObject object = new JSONObject();
            object.put("MATNR", (Object)materialSource.getMaterialNumber());
            object.put("MATKL", (Object)materialSource.getMaterialGroup());
            object.put("BUKRS", (Object)materialSource.getCompany());
            object.put("WERKS", (Object)materialSource.getFactory());
            object.put("WERKS", (Object)materialSource.getFactory());
            object.put("EKORG", (Object)materialSource.getPurchaseOrg());
            object.put("LIFNR", (Object)materialSource.getAgentSupplierCode());
            object.put("Z001", (Object)materialSource.getSupplierCode());
            object.put("MTART", (Object)materialSource.getMaterialType());
            object.put("Z003", (Object)(StringUtils.isNotBlank((CharSequence)isFrozen) && isFrozen.equals("1") ? "X" : ""));
            object.put("Z004", (Object)(StringUtils.isNotBlank((CharSequence)isFrozen) && isFrozen.equals("1") ? "X" : ""));
            object.put("DATAB", (Object)(materialSource.getEffectiveDate() != null ? simpleDateFormat.format(materialSource.getEffectiveDate()) : ""));
            object.put("DATBI", (Object)(materialSource.getExpiryDate() != null ? simpleDateFormat.format(materialSource.getExpiryDate()) : ""));
            object.put("ZSRMID", (Object)materialSource.getSourceId());
            data.add((Object)object);
        }
        JSONObject result = this.sapInterfaceService.useSapInterface(SapInterfaceEnum.PUSH_MATERIAL_SOURCE.getValue(), data, exCtrlDTO);
        this.dealResult(materialSources, result, SapInterfaceEnum.PUSH_MATERIAL_SOURCE.getValue(), "1");
    }

    void dealResult(List<PurchaseMaterialSource> materialSources, JSONObject result, String interfaceCode, String throwErrorFlag) {
        StringBuilder errMsg = new StringBuilder();
        errMsg.append("");
        ArrayList<String> errorSourceIds = new ArrayList<String>();
        Assert.isTrue((result.getIntValue("code") == 200 ? 1 : 0) != 0, (String)(SapInterfaceEnum.getDescByValue((String)interfaceCode) + "\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff0c\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u4e3a\u300b\u300b\u300b" + result.getString("message") + "\u3010\u8bf7\u8054\u7cfb" + SapInterfaceEnum.getSourceSystemByValue((String)interfaceCode) + "\u7ba1\u7406\u5458!!!\u3011"));
        String xmlText = result.getString("result");
        JSONObject json = JSON.parseObject((String)xmlText);
        if (json.getJSONObject("EX_DATA").getJSONObject("data1").getJSONArray("data") == null) {
            return;
        }
        String data = json.getJSONObject("EX_DATA").getJSONObject("data1").getString("data");
        List exDataResultDTOS = JSONObject.parseArray((String)data, ExDataResultDTO.class);
        if (CollectionUtil.isEmpty((Collection)exDataResultDTOS)) {
            return;
        }
        Map<String, List<ExDataResultDTO>> listMap = exDataResultDTOS.stream().collect(Collectors.groupingBy(ExDataResultDTO::getMsgty));
        List<ExDataResultDTO> errors = listMap.get("E");
        List<ExDataResultDTO> success = listMap.get("Y");
        if (CollectionUtil.isNotEmpty(errors)) {
            for (ExDataResultDTO error : errors) {
                errMsg.append("\u3010");
                errMsg.append("\u7269\u6599\u5173\u7cfb\u8868\u5355\u636e\u53f7" + error.getZsrmid() + "\u63a8\u9001\u5f02\u5e38\uff0c\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u4e3a\u300b\u300b\u300b" + error.getMsgtx() + "\u3010\u8bf7\u8054\u7cfb" + SapInterfaceEnum.getSourceSystemByValue((String)interfaceCode) + "\u7ba1\u7406\u5458!!!\u3011");
                errorSourceIds.add(error.getZsrmid());
                errMsg.append("\u3011");
            }
        }
        for (PurchaseMaterialSource materialSource : materialSources) {
            if (CollectionUtil.isNotEmpty(errorSourceIds) && errorSourceIds.contains((Object)materialSource)) continue;
            materialSource.setReturnState("1");
        }
        this.updateBatchById(materialSources);
        if (StringUtils.isNotBlank((CharSequence)errMsg) && throwErrorFlag.equals("1")) {
            throw new ELSBootException(errMsg.toString());
        }
    }

    @SrmTransaction
    List<PurchaseMaterialSource> judgeData(List<String> ids, String reason, String operation) {
        if (CollectionUtil.isEmpty(ids)) {
            return null;
        }
        Assert.isTrue((ids.size() <= 10 ? 1 : 0) != 0, (String)"\u52fe\u9009\u6570\u91cf\u6700\u5927\u4e3a10\uff0c\u8bf7\u68c0\u67e5");
        List materialSources = this.listByIds(ids);
        List status = materialSources.stream().map(PurchaseMaterialSource::getStatus).collect(Collectors.toList());
        if (operation.equals(MaterialSourceOperationEnum.FROZEN.getValue())) {
            status.removeAll(Arrays.asList("5"));
            Assert.isTrue((boolean)CollectionUtil.isEmpty(status), (String)"\u53ea\u80fd\u51bb\u7ed3\u72b6\u6001\u4e3a\u751f\u6548\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (operation.equals(MaterialSourceOperationEnum.THAW.getValue())) {
            status.removeAll(Arrays.asList("2"));
            Assert.isTrue((boolean)CollectionUtil.isEmpty(status), (String)"\u53ea\u80fd\u89e3\u51bb\u72b6\u6001\u4e3a\u51bb\u7ed3\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        List sourceIds = materialSources.stream().map(PurchaseMaterialSource::getSourceId).collect(Collectors.toList());
        QueryWrapper sourceApplyQueryWrapper = new QueryWrapper();
        sourceApplyQueryWrapper.lambda().in(PurchaseMaterialSourceApply::getSourceId, sourceIds);
        sourceApplyQueryWrapper.lambda().in(PurchaseMaterialSourceApply::getAuditStatus, new Object[]{AuditStatusEnum.AUDIT_DOING.getValue(), AuditStatusEnum.AUDIT_NEW.getValue()});
        sourceApplyQueryWrapper.lambda().eq(BaseEntity::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
        sourceApplyQueryWrapper.lambda().eq(PurchaseMaterialSourceApply::getOperation, (Object)operation);
        List list = this.applyService.list((Wrapper)sourceApplyQueryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            List numbers = list.stream().map(PurchaseMaterialSourceApply::getSourceId).collect(Collectors.toList());
            throw new ELSBootException(numbers + "\u5df2\u5b58\u5728" + MaterialSourceOperationEnum.getDescByValue(operation) + "\u7533\u8bf7\u5355!");
        }
        return materialSources;
    }

    @SrmTransaction
    void dealApply(List<PurchaseMaterialSource> materialSources, String reason, String operation, LoginUser loginUser) {
        TemplateHeadDTO template = this.getTemplate();
        Set rolesSet = this.invokeAccountRpcService.getUserRolesSet(TenantContext.getTenant(), loginUser.getSubAccount());
        ArrayList<PurchaseMaterialSourceApply> applyList = new ArrayList<PurchaseMaterialSourceApply>();
        for (PurchaseMaterialSource materialSource : materialSources) {
            PurchaseMaterialSourceApply sourceApply = new PurchaseMaterialSourceApply();
            BeanUtils.copyProperties((Object)((Object)materialSource), (Object)((Object)sourceApply));
            if (CollectionUtil.isNotEmpty((Collection)rolesSet)) {
                sourceApply.setCurrentStage(rolesSet.toString());
            }
            sourceApply.setCurrentProcessor(loginUser.getSubAccount() + "_" + loginUser.getRealname());
            sourceApply.setApplicant(loginUser.getSubAccount() + "_" + loginUser.getRealname());
            sourceApply.setReason(reason + "");
            sourceApply.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            sourceApply.setOperation(operation);
            String nextCode = this.invokeBaseRpcService.getNextCode("materialSourceApplyNumber", (Object)sourceApply);
            sourceApply.setSourceApplyNumber(nextCode);
            sourceApply.setId(IdWorker.getIdStr());
            sourceApply.setDeleted(CommonConstant.DEL_FLAG_0);
            sourceApply.setTemplateAccount(template.getElsAccount());
            sourceApply.setTemplateName(template.getTemplateName());
            sourceApply.setTemplateNumber(template.getTemplateNumber());
            sourceApply.setTemplateVersion(template.getTemplateVersion().toString());
            applyList.add(sourceApply);
        }
        this.applyService.saveBatch(applyList);
        for (PurchaseMaterialSourceApply sourceApply : applyList) {
            AuditInputParamDTO dto = new AuditInputParamDTO();
            String businessId = sourceApply.getId();
            dto.setBusinessId(businessId);
            dto.setBusinessType("materialSourceApply");
            dto.setAuditSubject("\u8d27\u6e90\u6e05\u5355" + MaterialSourceOperationEnum.getDescByValue(operation) + "\u5ba1\u6279\uff0c\u5355\u53f7: " + sourceApply.getSourceApplyNumber());
            dto.setParams(JSONObject.toJSONString((Object)((Object)sourceApply)));
            this.workflowAuditRpcService.submit(dto);
        }
    }

    private TemplateHeadDTO getTemplate() {
        List templateList = this.invokeBaseRpcService.getTemplateByType("materialSourceApply");
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"", (String)"\u8bf7\u5148\u914d\u7f6e\u8d27\u6e90\u6e05\u5355\u4e1a\u52a1\u6a21\u677f!"));
        Map<String, List<TemplateHeadDTO>> templateMap = templateList.stream().filter(a -> a.getElsAccount() != null).collect(Collectors.groupingBy(o -> o.getElsAccount()));
        TemplateHeadDTO template = CollectionUtil.isNotEmpty((Collection)templateMap.get(TenantContext.getTenant())) ? templateMap.get(TenantContext.getTenant()).get(0) : templateMap.get("100000").get(0);
        return template;
    }

    private void pushDataToErp(PurchaseMaterialSource source) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "pushMaterialSource", (Object)source);
    }

    public int insertBatchSomeColumn(List<PurchaseMaterialSource> entityList) {
        return ((PurchaseMaterialSourceMapper)this.baseMapper).insertBatchSomeColumn(entityList);
    }
}

