/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.materialSourceApply.adapter;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.extend.api.enumerate.GipParamEnum;
import com.els.modules.extend.api.util.SrmInterfaceUtil;
import com.els.modules.material.entity.PurchaseMaterialSource;
import com.els.modules.material.mapper.PurchaseMaterialSourceMapper;
import com.els.modules.material.service.PurchaseMaterialSourceService;
import com.els.modules.materialSourceApply.entity.PurchaseMaterialSourceApply;
import com.els.modules.materialSourceApply.enumerate.MaterialSourceOperationEnum;
import com.els.modules.materialSourceApply.service.PurchaseMaterialSourceApplyService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseMaterialSourceApplyAdapt
implements AuditOptCallBackService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseMaterialSourceApplyAdapt.class);
    @Resource
    PurchaseMaterialSourceMapper purchaseMaterialSourceMapper;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    PurchaseMaterialSourceService purchaseMaterialSourceService;
    @Autowired
    PurchaseMaterialSourceApplyService purchaseMaterialSourceApplyService;
    @Autowired
    private SrmInterfaceUtil srmInterfaceUtil;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateSourceApply(inputParamVO, outputParamVO);
        this.synGip(inputParamVO, outputParamVO, "startCallBack");
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateSourceApply(inputParamVO, outputParamVO);
        this.synGipDone(inputParamVO, outputParamVO);
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateSourceApply(inputParamVO, outputParamVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateSourceApply(inputParamVO, outputParamVO);
    }

    public JSONObject getDataById(String id) {
        PurchaseMaterialSourceApply head = (PurchaseMaterialSourceApply)((Object)this.purchaseMaterialSourceApplyService.getById((Serializable)((Object)id)));
        if (head != null) {
            Result result = Result.ok((Object)((Object)head));
            ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
            JSONObject jsonObject = (JSONObject)result.getResult();
            return jsonObject;
        }
        return null;
    }

    private void updateSourceApply(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        LoginUser loginUser = SysUtil.getLoginUser();
        Set rolesSet = this.invokeAccountRpcService.getUserRolesSet(TenantContext.getTenant(), loginUser.getSubAccount());
        PurchaseMaterialSourceApply sourceApply = (PurchaseMaterialSourceApply)((Object)this.purchaseMaterialSourceApplyService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        log.info("purchaseMaterialSourceApplyAdapt audit" + sourceApply.getSourceApplyNumber());
        sourceApply.setAuditStatus(outputParamVO.getAuditStatus());
        sourceApply.setFlowId(outputParamVO.getProcessRootId());
        if (CollectionUtil.isNotEmpty((Collection)rolesSet)) {
            sourceApply.setCurrentStage(rolesSet.toString());
        }
        sourceApply.setCurrentProcessor(loginUser.getSubAccount() + "_" + loginUser.getRealname());
        this.purchaseMaterialSourceApplyService.updateById((Object)sourceApply);
        if (sourceApply.getAuditStatus().equals(AuditStatusEnum.AUDIT_FINISH.getValue())) {
            String status = StringUtils.isNotBlank((CharSequence)sourceApply.getOperation()) && sourceApply.getOperation().equals(MaterialSourceOperationEnum.FROZEN.getValue()) ? "4" : "5";
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.lambda().eq(PurchaseMaterialSource::getSourceId, (Object)sourceApply.getSourceId());
            updateWrapper.lambda().set(PurchaseMaterialSource::getStatus, (Object)status);
            this.purchaseMaterialSourceService.update((Wrapper)updateWrapper);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(PurchaseMaterialSource::getSourceId, (Object)sourceApply.getSourceId());
            List list = this.purchaseMaterialSourceService.list((Wrapper)queryWrapper);
            if (CollectionUtil.isEmpty((Collection)list)) {
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)sourceApply.getOperation()) && sourceApply.getOperation().equals(MaterialSourceOperationEnum.FROZEN.getValue())) {
                this.purchaseMaterialSourceService.pushMatrialSourceToSap(list, "1");
            } else {
                this.purchaseMaterialSourceService.pushMatrialSourceToSap(list, "0");
            }
        }
    }

    private void synGip(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String step) {
        if (CollectionUtil.isEmpty((Collection)outputParamVO.getNextAuditUserList())) {
            return;
        }
        String targetAccoount = (String)outputParamVO.getNextAuditUserList().get(0);
        ElsSubAccountDTO targetsDto = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), targetAccoount.split("_").length > 1 ? targetAccoount.split("_")[1] : targetAccoount.split("_")[0]);
        String modelId = inputParamVO.getBusinessId();
        String targetId = targetsDto.getId();
        String creatorId = outputParamVO.getSubmitUser();
        String processRootId = outputParamVO.getProcessRootId();
        String auditStatus = outputParamVO.getAuditStatus();
        String jsonString = JSONObject.toJSONString((Object)inputParamVO);
        this.srmInterfaceUtil.oaSendTodo(GipParamEnum.BIZ_5, modelId, creatorId, targetId, jsonString, processRootId, auditStatus, step);
    }

    private void synGipDone(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        ElsSubAccountDTO targetsDto = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), SysUtil.getLoginUser().getSubAccount());
        String modelId = inputParamVO.getBusinessId();
        String targetId = targetsDto.getId();
        String processRootId = outputParamVO.getProcessRootId();
        this.srmInterfaceUtil.oaSendTodoDone(GipParamEnum.BIZ_5, processRootId, targetId);
    }
}

